/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.schema.io;

import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import java.net.URI;
import java.util.Collections;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.JsonSchemaReader;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.SpecVersion;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.schema.io.AbstractJsonSchemaReader;

abstract class AbstractProbeSchemaReader
extends AbstractJsonSchemaReader {
    private final JsonParser parser;
    private final SpecVersion defaultSpecVersion;

    protected AbstractProbeSchemaReader(JsonParser parser, SpecVersion defaultSpecVersion) {
        super(Collections.emptyMap());
        this.parser = parser;
        this.defaultSpecVersion = defaultSpecVersion;
    }

    @Override
    protected JsonSchema readSchema() {
        SpecVersion version = this.probe(this.parser);
        return this.createSchemaReader(version).read();
    }

    @Override
    protected JsonLocation getLocation() {
        return this.parser.getLocation();
    }

    @Override
    protected void closeParser() {
        this.parser.close();
    }

    protected abstract JsonSchemaReader createSchemaReader(SpecVersion var1);

    private SpecVersion probe(JsonParser parser) {
        SpecVersion version = this.doProbe(parser);
        return version != null ? version : this.defaultSpecVersion;
    }

    private SpecVersion doProbe(JsonParser parser) {
        if (parser.hasNext() && parser.next() == JsonParser.Event.START_OBJECT) {
            block11: while (parser.hasNext()) {
                switch (parser.next()) {
                    case KEY_NAME: {
                        if (!parser.getString().equals("$schema")) continue block11;
                        switch (parser.next()) {
                            case VALUE_STRING: {
                                return this.getSpecVersion(parser.getString());
                            }
                            case START_ARRAY: {
                                parser.skipArray();
                                continue block11;
                            }
                            case START_OBJECT: {
                                parser.skipObject();
                                continue block11;
                            }
                        }
                        continue block11;
                    }
                    case START_ARRAY: {
                        parser.skipArray();
                        continue block11;
                    }
                    case START_OBJECT: {
                        parser.skipObject();
                        continue block11;
                    }
                    case END_OBJECT: {
                        return null;
                    }
                }
            }
        }
        return null;
    }

    private SpecVersion getSpecVersion(String value) {
        try {
            URI id = URI.create(value);
            if (id.getFragment() == null) {
                id = id.resolve("#");
            }
            return SpecVersion.getById(id);
        }
        catch (IllegalArgumentException e) {
            Problem p = this.createProblemBuilder(this.parser.getLocation(), "/$schema").withMessage(Message.SCHEMA_PROBLEM_VERSION_UNSUPPORTED).withParameter("schema", value).build();
            this.addProblem(p);
            this.dispatchProblems();
            return null;
        }
    }
}

