/*
 * Decompiled with CFR 0.152.
 */
package org.leadpony.justify.internal.schema.io;

import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParser;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.leadpony.justify.api.JsonSchema;
import org.leadpony.justify.api.JsonSchemaResolver;
import org.leadpony.justify.api.Problem;
import org.leadpony.justify.api.ProblemHandler;
import org.leadpony.justify.internal.base.Message;
import org.leadpony.justify.internal.base.Sets;
import org.leadpony.justify.internal.base.URIs;
import org.leadpony.justify.internal.base.json.JsonService;
import org.leadpony.justify.internal.base.json.PointerAwareJsonParser;
import org.leadpony.justify.internal.keyword.KeywordFactory;
import org.leadpony.justify.internal.keyword.SchemaKeyword;
import org.leadpony.justify.internal.keyword.Unknown;
import org.leadpony.justify.internal.keyword.applicator.Referenceable;
import org.leadpony.justify.internal.keyword.core.Id;
import org.leadpony.justify.internal.keyword.core.Ref;
import org.leadpony.justify.internal.problem.ProblemBuilder;
import org.leadpony.justify.internal.schema.BasicJsonSchema;
import org.leadpony.justify.internal.schema.Resolvable;
import org.leadpony.justify.internal.schema.SchemaReference;
import org.leadpony.justify.internal.schema.SchemaSpec;
import org.leadpony.justify.internal.schema.io.AbstractJsonSchemaReader;
import org.leadpony.justify.internal.schema.io.InfiniteLoopDetector;
import org.leadpony.justify.internal.validator.JsonValidator;
import org.leadpony.justify.spi.ContentEncodingScheme;
import org.leadpony.justify.spi.ContentMimeType;
import org.leadpony.justify.spi.FormatAttribute;

public class JsonSchemaReaderImpl
extends AbstractJsonSchemaReader
implements ProblemHandler,
KeywordFactory.CreationContext {
    private final PointerAwareJsonParser parser;
    private final JsonService jsonService;
    private final SchemaSpec spec;
    private final KeywordFactory keywordFactory;
    private final Map<JsonObject, Reference> referencingObjects = new IdentityHashMap<JsonObject, Reference>();
    private final Set<JsonSchema> identifiedSchemas = Sets.newIdentitySet();
    private final List<Reference> references = new ArrayList<Reference>();
    private URI initialBaseUri = DEFAULT_INITIAL_BASE_URI;

    public JsonSchemaReaderImpl(PointerAwareJsonParser parser, JsonService jsonService, SchemaSpec spec, Map<String, Object> config) {
        super(config);
        this.parser = parser;
        this.jsonService = jsonService;
        this.spec = spec;
        this.keywordFactory = spec.getKeywordFactory();
        if (parser instanceof JsonValidator) {
            ((JsonValidator)parser).withHandler(this);
        }
    }

    @Override
    protected JsonSchema readSchema() {
        JsonSchema schema = this.readRootSchema();
        if (schema != null) {
            this.postprocess(schema);
        }
        this.dispatchProblems();
        return schema;
    }

    @Override
    protected JsonLocation getLocation() {
        return this.parser.getLocation();
    }

    @Override
    protected void closeParser() {
        this.parser.close();
    }

    @Override
    public void handleProblems(List<Problem> problems) {
        this.addProblems(problems);
    }

    @Override
    public JsonSchema asJsonSchema(JsonValue value) {
        JsonSchema schema = this.parseSchema(value, false);
        if (schema == null) {
            throw new IllegalArgumentException();
        }
        return schema;
    }

    @Override
    public FormatAttribute getFormateAttribute(String name) {
        FormatAttribute attribute = this.spec.getFormatAttribute(name);
        if (attribute == null && this.isStrictWithFormats()) {
            this.addProblem(this.createProblemBuilder(Message.SCHEMA_PROBLEM_FORMAT_UNKNOWN).withParameter("attribute", name));
        }
        return attribute;
    }

    @Override
    public ContentEncodingScheme getEncodingScheme(String name) {
        return this.spec.getEncodingScheme(name);
    }

    @Override
    public ContentMimeType getMimeType(String value) {
        return this.spec.getMimeType(value);
    }

    private JsonSchema readRootSchema() {
        if (this.parser.hasNext()) {
            JsonValue value = this.parseValue(this.parser.next());
            return this.parseSchema(value, false);
        }
        this.addProblem(Message.SCHEMA_PROBLEM_EMPTY);
        return null;
    }

    private JsonValue parseValue(JsonParser.Event event) {
        switch (event) {
            case START_ARRAY: {
                return this.parseArray();
            }
            case START_OBJECT: {
                return this.parseObject();
            }
            case VALUE_STRING: 
            case VALUE_NUMBER: {
                return this.parser.getValue();
            }
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
        }
        throw new IllegalStateException();
    }

    private JsonArray parseArray() {
        JsonArrayBuilder builder = this.jsonService.createArrayBuilder();
        while (this.parser.hasNext()) {
            JsonParser.Event event = this.parser.next();
            if (event == JsonParser.Event.END_ARRAY) {
                return builder.build();
            }
            builder.add(this.parseValue(event));
        }
        throw this.newUnexpectedEndException();
    }

    private JsonObject parseObject() {
        JsonObjectBuilder builder = this.jsonService.createObjectBuilder();
        Reference reference = null;
        while (this.parser.hasNext()) {
            if (this.parser.next() == JsonParser.Event.END_OBJECT) {
                JsonObject object = builder.build();
                if (reference != null) {
                    this.addReferencingObject(object, reference);
                }
                return object;
            }
            String name = this.parser.getString();
            if (!this.parser.hasNext()) break;
            builder.add(name, this.parseValue(this.parser.next()));
            if (!name.equals("$ref")) continue;
            reference = this.createReference();
        }
        throw this.newUnexpectedEndException();
    }

    private Reference createReference() {
        return new Reference(this.parser.getLocation(), this.parser.getPointer());
    }

    private void addReferencingObject(JsonObject object, Reference reference) {
        this.referencingObjects.put(object, reference);
    }

    private JsonSchema parseSchema(JsonValue value, boolean lax) {
        switch (value.getValueType()) {
            case TRUE: {
                return JsonSchema.TRUE;
            }
            case FALSE: {
                return JsonSchema.FALSE;
            }
            case OBJECT: {
                return this.parseSchema(value.asJsonObject(), lax);
            }
        }
        return null;
    }

    private JsonSchema parseSchema(JsonObject value, boolean lax) {
        SchemaBuilder builder = new SchemaBuilder();
        for (Map.Entry entry : value.entrySet()) {
            String name = (String)entry.getKey();
            SchemaKeyword keyword = this.createKeyword(name, (JsonValue)entry.getValue(), lax);
            builder.add(name, keyword);
        }
        JsonSchema schema = builder.build(value);
        if (schema.hasId()) {
            this.identifiedSchemas.add(schema);
        }
        if (schema instanceof SchemaReference) {
            this.addReference(value, (SchemaReference)schema);
        }
        return schema;
    }

    private SchemaKeyword createKeyword(String name, JsonValue value, boolean lax) {
        SchemaKeyword keyword = this.keywordFactory.createKeyword(name, value, this);
        if (keyword == null) {
            keyword = this.createUnknownKeyword(name, value, lax);
        }
        return keyword;
    }

    private SchemaKeyword createUnknownKeyword(String name, JsonValue value, boolean lax) {
        if (this.isStrictWithKeywords() && !lax) {
            ProblemBuilder builder = this.createProblemBuilder(Message.SCHEMA_PROBLEM_KEYWORD_UNKNOWN).withParameter("keyword", name);
            this.addProblem(builder);
        }
        switch (value.getValueType()) {
            case TRUE: 
            case FALSE: 
            case OBJECT: {
                return new Referenceable(name, this.parseSchema(value, true));
            }
        }
        return new Unknown(name, value);
    }

    private void addReference(JsonObject value, SchemaReference schema) {
        Reference reference = this.referencingObjects.get(value);
        if (reference != null) {
            reference.setSchema(schema);
            this.references.add(reference);
        }
    }

    private ProblemBuilder createProblemBuilder(Message message) {
        JsonLocation location = this.parser.getLocation();
        String pointer = this.parser.getPointer();
        return this.createProblemBuilder(location, pointer).withMessage(message);
    }

    private void addProblem(Message message) {
        this.addProblem(this.createProblemBuilder(message));
    }

    private void postprocess(JsonSchema schema) {
        Map<URI, JsonSchema> schemaMap = this.generateSchemaMap(schema, this.initialBaseUri);
        this.resolveAllReferences(schemaMap);
        this.checkInfiniteRecursiveLoop();
    }

    private Map<URI, JsonSchema> generateSchemaMap(JsonSchema root, URI baseUri) {
        HashMap<URI, JsonSchema> schemaMap = new HashMap<URI, JsonSchema>();
        if (root instanceof Resolvable) {
            ((Resolvable)((Object)root)).resolve(baseUri);
        }
        for (JsonSchema schema : this.identifiedSchemas) {
            schemaMap.put(URIs.withFragment(schema.id()), schema);
        }
        if (!this.identifiedSchemas.contains(root)) {
            schemaMap.put(URIs.withFragment(baseUri), root);
        }
        return schemaMap;
    }

    private void resolveAllReferences(Map<URI, JsonSchema> schemaMap) {
        for (Reference context : this.references) {
            SchemaReference reference = context.reference;
            URI targetId = reference.getTargetId();
            JsonSchema schema = this.dereferenceSchema(targetId, schemaMap);
            if (schema != null) {
                reference.setReferencedSchema(schema);
                continue;
            }
            this.addProblem(this.createProblemBuilder(context.location, context.pointer).withMessage(Message.SCHEMA_PROBLEM_REFERENCE).withParameter("ref", reference.ref()).withParameter("targetId", targetId));
        }
    }

    private JsonSchema dereferenceSchema(URI ref, Map<URI, JsonSchema> schemaMap) {
        String fragment = (ref = URIs.withFragment(ref)).getFragment();
        if (fragment.startsWith("/")) {
            JsonSchema schema = this.resolveSchema(URIs.withEmptyFragment(ref), schemaMap);
            if (schema != null) {
                return schema.getSubschemaAt(fragment);
            }
            return null;
        }
        return this.resolveSchema(ref, schemaMap);
    }

    private JsonSchema resolveSchema(URI id, Map<URI, JsonSchema> schemaMap) {
        JsonSchema schema = schemaMap.get(id);
        if (schema != null) {
            return schema;
        }
        for (JsonSchemaResolver resolver : this.getResolvers()) {
            schema = resolver.resolveSchema(id);
            if (schema == null) continue;
            return schema;
        }
        return null;
    }

    private void checkInfiniteRecursiveLoop() {
        InfiniteLoopDetector detector = new InfiniteLoopDetector();
        for (Reference context : this.references) {
            SchemaReference reference = context.reference;
            if (!detector.detectInfiniteLoop(reference)) continue;
            this.addProblem(this.createProblemBuilder(context.location, context.pointer).withMessage(Message.SCHEMA_PROBLEM_REFERENCE_LOOP));
        }
    }

    private static class Reference {
        final JsonLocation location;
        final String pointer;
        SchemaReference reference;

        Reference(JsonLocation location, String pointer) {
            this.location = location;
            this.pointer = pointer;
        }

        void setSchema(SchemaReference reference) {
            this.reference = reference;
        }
    }

    class SchemaBuilder
    extends LinkedHashMap<String, SchemaKeyword> {
        private URI id;
        private boolean referencing;

        SchemaBuilder() {
        }

        void add(String name, SchemaKeyword keyword) {
            if (keyword instanceof Id) {
                this.id = (URI)((Id)keyword).value();
            } else if (keyword instanceof Ref) {
                this.referencing = true;
            }
            super.put(name, keyword);
        }

        JsonSchema build(JsonObject json) {
            if (this.isEmpty()) {
                return JsonSchema.EMPTY;
            }
            if (this.referencing) {
                return new SchemaReference(this.id, json, (Map<String, SchemaKeyword>)this);
            }
            return BasicJsonSchema.of(this.id, json, this);
        }
    }
}

