/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.actions;

import ambience.module.UserDB;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.repository.AccessChecker;
import ambience.repository.AccessChecker$;
import ambience.repository.Metadata;
import ambience.repository.Metadata$;
import ambience.repository.PanelExtras;
import ambience.repository.PanelExtras$;
import ambience.repository.RepositoryModel;
import ambience.repository.actions.ActionHelper$;
import ambience.repository.actions.CopyFolder;
import ambience.repository.actions.CopyFolder$Info$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.mongodb.client.result.InsertOneResult;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonString;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class CopyFolder$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(CopyFolder$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final CopyFolder$Info$ Info;
    public static final CopyFolder$ MODULE$;

    private CopyFolder$() {
    }

    static {
        MODULE$ = new CopyFolder$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CopyFolder$.class);
    }

    public Panel panel(Path path) {
        PanelExtras.FolderChooserSetup folderChooserSetup = (PanelExtras.FolderChooserSetup)io.circe.syntax.package$.MODULE$.EncoderOps((Object)PanelExtras.FolderChooserSetup$.MODULE$.apply(path.parent().toString()));
        String string = "value";
        Json setup = package.EncoderOps$.MODULE$.asJson$extension((Object)folderChooserSetup, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(CopyFolder$::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)Panel.Item$.MODULE$.apply(PanelExtras$.MODULE$.FolderChooser(), "newParent", "Target Folder", setup), (List)Nil$.MODULE$));
    }

    public Task<RepositoryModel.ActionResult> apply(UserDB.User user, Json json) {
        String string = "path";
        String string2 = "newParent";
        int size = 2;
        Either either = json.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", CopyFolder$::apply$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), CopyFolder$::apply$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(CopyFolder$::apply$$anonfun$3)))));
        if (either instanceof Right) {
            CopyFolder.Info info = (CopyFolder.Info)((Right)either).value();
            return this.auditRun(user, info);
        }
        if (either instanceof Left) {
            DecodingFailure err = (DecodingFailure)((Left)either).value();
            this.log().warn(() -> CopyFolder$.apply$$anonfun$4(json, err), Line$.MODULE$.apply(30), FullName$.MODULE$.apply("ambience.repository.actions.CopyFolder.apply"));
            return Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Invalid request", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), false));
        }
        throw new MatchError((Object)either);
    }

    public Task<RepositoryModel.ActionResult> auditRun(UserDB.User user, CopyFolder.Info info) {
        return this.run(user, info).map((Function1 & Serializable)reply -> {
            CopyFolder.Info info = (CopyFolder.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)info);
            String string = "path";
            String string2 = "newParent";
            ActionHelper$.MODULE$.audit(user, ActionHelper$.MODULE$.buildAction((RepositoryModel.ActionResult)reply, info.path(), "copy-folder", (Option<Json>)Some$.MODULE$.apply((Object)package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(CopyFolder$::auditRun$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))))));
            return reply;
        });
    }

    public Task<RepositoryModel.ActionResult> run(UserDB.User user, CopyFolder.Info info) {
        Path newParentPath;
        Path oldPath = Path$.MODULE$.apply(info.path());
        Path path = newParentPath = Path$.MODULE$.apply(info.newParent());
        Path path2 = oldPath;
        if (!(path != null ? !path.equals(path2) : path2 != null)) {
            return Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("warn", "Target folder cannot be the same as the source", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
        }
        if (newParentPath.toString().startsWith(oldPath.toString() + "/")) {
            return Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("warn", "Target folder cannot be a descendent of the source", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
        }
        return Task$.MODULE$.now((Object)AccessChecker$.MODULE$.apply(user)).flatMap((Function1 & Serializable)checker -> Metadata$.MODULE$.apply(oldPath).flatMap((Function1 & Serializable)oldItem -> Metadata$.MODULE$.apply(newParentPath).flatMap((Function1 & Serializable)newParentFolder -> MODULE$.canCopy((AccessChecker)checker, (Option<Metadata.Item>)oldItem, (Option<Metadata.Item>)newParentFolder).flatMap((Function1 & Serializable)eReply -> {
            Task task;
            Either either = eReply;
            if (either instanceof Right) {
                Metadata.Folder newParent = (Metadata.Folder)((Right)either).value();
                task = MODULE$.doRun(info, newParent);
            } else if (either instanceof Left) {
                RepositoryModel.ActionResult reply2 = (RepositoryModel.ActionResult)((Left)either).value();
                task = Task$.MODULE$.now((Object)reply2);
            } else {
                throw new MatchError((Object)either);
            }
            return task.map((Function1 & Serializable)reply -> reply);
        }))));
    }

    public Task<Either<RepositoryModel.ActionResult, Metadata.Folder>> canCopy(AccessChecker checker, Option<Metadata.Item> oldItem, Option<Metadata.Item> newParentFolder) {
        Metadata.Item item;
        Option<Metadata.Item> option = oldItem;
        if (option instanceof Some && (item = (Metadata.Item)((Some)option).value()) instanceof Metadata.Folder) {
            Metadata.Item item2;
            Metadata.Folder f = (Metadata.Folder)item;
            Option<Metadata.Item> option2 = newParentFolder;
            if (option2 instanceof Some && (item2 = (Metadata.Item)((Some)option2).value()) instanceof Metadata.Folder) {
                Metadata.Folder newParent = (Metadata.Folder)item2;
                return checker.canWrite(newParent.path()).map((Function1 & Serializable)ok -> CopyFolder$.canCopy$$anonfun$1(newParent, BoxesRunTime.unboxToBoolean((Object)ok)));
            }
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Target is not a folder", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
        }
        return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Path is not a folder", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
    }

    public Task<RepositoryModel.ActionResult> doRun(CopyFolder.Info info, Metadata.Folder newParent) {
        Path oldPath = Path$.MODULE$.apply(info.path());
        Bson childFilter = ActionHelper$.MODULE$.childFilter(Path$.MODULE$.apply(info.newParent()));
        Task result = Metadata$.MODULE$.repository().findO(childFilter).toListL().flatMap((Function1 & Serializable)children -> Task$.MODULE$.apply(() -> CopyFolder$.$anonfun$2$$anonfun$1(info, children, oldPath)).flatMap((Function1 & Serializable)newPath -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
            CopyFolder$.$anonfun$2$$anonfun$2$$anonfun$1(oldPath, newPath);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return MODULE$.copyFolder(oldPath, (Path)newPath, newParent).flatMap((Function1 & Serializable)reply -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
                CopyFolder$.$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(oldPath, newPath);
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return (reply.close() ? MODULE$.copyFolderChildren(oldPath, (Path)newPath, newParent) : Task$.MODULE$.now((Object)BoxesRunTime.boxToInteger((int)0))).flatMap((Function1 & Serializable)count -> Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    CopyFolder$.$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(count);
                    return BoxedUnit.UNIT;
                }).map((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return reply;
                }));
            }));
        })));
        return result.onErrorHandle((Function1 & Serializable)x$1 -> {
            Throwable throwable;
            Throwable ex = throwable = x$1;
            MODULE$.log().error(() -> CopyFolder$.doRun$$anonfun$1$$anonfun$1(ex), ex, Line$.MODULE$.apply(92), FullName$.MODULE$.apply("ambience.repository.actions.CopyFolder.doRun"));
            return RepositoryModel.ActionResult$.MODULE$.apply("error", "Database error", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4());
        });
    }

    public Path getUniqueName(Path newParent, List<Document> children, String name) {
        Set pathSet = children.flatMap((Function1 & Serializable)_$1 -> _$1.get("path", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class))).map((Function1 & Serializable)_$2 -> _$2.getValue()).toSet();
        return newParent.$div(this.getNewName((Set<String>)pathSet, newParent, name));
    }

    public String getNewName(Set<String> pathSet, Path newParent, String name) {
        Object workingName = name;
        if (pathSet.contains((Object)newParent.$div((String)workingName).toString())) {
            String newname = (String)workingName + " (Copy)";
            int i = 1;
            while (pathSet.contains((Object)newParent.$div(newname).toString())) {
                newname = (String)workingName + " (Copy " + ++i + ")";
            }
            workingName = newname;
        }
        return workingName;
    }

    public Task<RepositoryModel.ActionResult> copyFolder(Path oldPath, Path newPath, Metadata.Folder newParent) {
        return Metadata$.MODULE$.repository().findO(Filters$.MODULE$.eq("path", (Object)BsonString$.MODULE$.apply(oldPath.toString()))).firstOptionL().flatMap((Function1 & Serializable)optDoc -> {
            Task task;
            Option option = optDoc;
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                task = Metadata$.MODULE$.repository().insertOneT(MODULE$.update(doc, oldPath, newPath, newParent)).map((Function1 & Serializable)_$3 -> RepositoryModel.ActionResult$.MODULE$.apply("info", "Folder copied successfully", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), true));
            } else if (None$.MODULE$.equals(option)) {
                MODULE$.log().warn(() -> CopyFolder$.copyFolder$$anonfun$1$$anonfun$2(oldPath), Line$.MODULE$.apply(125), FullName$.MODULE$.apply("ambience.repository.actions.CopyFolder.copyFolder"));
                task = Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("warn", "Folder copy failed - folder no longer available", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
            } else {
                throw new MatchError((Object)option);
            }
            return task.map((Function1 & Serializable)reply -> reply);
        });
    }

    public Task<Object> copyFolderChildren(Path oldPath, Path newPath, Metadata.Folder newParent) {
        Observable all = Metadata$.MODULE$.repository().findO(ActionHelper$.MODULE$.descendantsFilter(oldPath)).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromTask(Metadata$.MODULE$.repository().insertOneT(MODULE$.update((Document)doc, oldPath, newPath, newParent))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            InsertOneResult insertOneResult = x$1;
        }));
        return all.countL();
    }

    public Document update(Document doc, Path oldBase, Path newBase, Metadata.Folder newParent) {
        Document reply = (Document)doc.get("path", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)oldPath -> {
            Path newPath = newBase.$div(StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(oldPath.getValue()), oldBase.toString()));
            MODULE$.log().info(() -> CopyFolder$.$anonfun$6$$anonfun$1(oldPath, newPath), Line$.MODULE$.apply(144), FullName$.MODULE$.apply("ambience.repository.actions.CopyFolder.reply"));
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"path");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(newPath.toString())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            return (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }).getOrElse(() -> CopyFolder$.$anonfun$7(doc));
        return (Document)reply.$minus((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id"}));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        return package$.MODULE$.Nil().$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List apply$$anonfun$1() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 apply$$anonfun$2() {
        CopyFolder$Info$ copyFolder$Info$ = CopyFolder$Info$.MODULE$;
        return (Function1 & Serializable)p -> (CopyFolder.Info)copyFolder$Info$.fromProduct((Product)p);
    }

    private static final Product apply$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Object apply$$anonfun$4(Json json$1, DecodingFailure err$1) {
        return "Can't process " + json$1.noSpaces() + ": " + err$1;
    }

    /*
     * WARNING - void declaration
     */
    private static final List auditRun$$anonfun$1$$anonfun$1() {
        void var3_2;
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final /* synthetic */ Either canCopy$$anonfun$1(Metadata.Folder newParent$1, boolean ok) {
        if (ok) {
            return package$.MODULE$.Right().apply((Object)newParent$1);
        }
        return package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Target folder is not writable", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
    }

    private static final Path $anonfun$2$$anonfun$1(CopyFolder.Info info$7, List children$1, Path oldPath$3) {
        return MODULE$.getUniqueName(Path$.MODULE$.apply(info$7.newParent()), (List<Document>)children$1, oldPath$3.name());
    }

    private static final Object $anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(Path oldPath$6, Path newPath$2) {
        return "Copying " + oldPath$6.toString() + " to " + newPath$2.toString();
    }

    private static final void $anonfun$2$$anonfun$2$$anonfun$1(Path oldPath$5, Path newPath$1) {
        MODULE$.log().info(() -> CopyFolder$.$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(oldPath$5, newPath$1), Line$.MODULE$.apply(85), FullName$.MODULE$.apply("ambience.repository.actions.CopyFolder.result"));
    }

    private static final Object $anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Path oldPath$10, Path newPath$6) {
        return "Copying children of " + oldPath$10.toString() + " to " + newPath$6.toString();
    }

    private static final void $anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(Path oldPath$9, Path newPath$5) {
        MODULE$.log().info(() -> CopyFolder$.$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(oldPath$9, newPath$5), Line$.MODULE$.apply(87), FullName$.MODULE$.apply("ambience.repository.actions.CopyFolder.result"));
    }

    private static final Object $anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Object count$2) {
        return "Copy complete (" + count$2 + " children copied)";
    }

    private static final void $anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(Object count$1) {
        MODULE$.log().info(() -> CopyFolder$.$anonfun$2$$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(count$1), Line$.MODULE$.apply(89), FullName$.MODULE$.apply("ambience.repository.actions.CopyFolder.result"));
    }

    private static final Object doRun$$anonfun$1$$anonfun$1(Throwable ex$1) {
        return "Database error: " + ex$1;
    }

    private static final Object copyFolder$$anonfun$1$$anonfun$2(Path oldPath$13) {
        return "Folder copy failed " + oldPath$13 + " no longer available";
    }

    private static final Object $anonfun$6$$anonfun$1(BsonString oldPath$15, Path newPath$10) {
        return "Copying " + oldPath$15.getValue() + " to " + newPath$10.toString();
    }

    private static final Document $anonfun$7(Document doc$2) {
        return doc$2;
    }
}

