/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.actions;

import ambience.module.UserDB;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.repository.AccessChecker;
import ambience.repository.AccessChecker$;
import ambience.repository.FileActions$;
import ambience.repository.Metadata;
import ambience.repository.Metadata$;
import ambience.repository.RepositoryModel;
import ambience.repository.actions.ActionHelper$;
import ambience.repository.actions.RenameFile;
import ambience.repository.actions.RenameFile$Info$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Updates$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class RenameFile$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RenameFile$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final RenameFile$Info$ Info;
    public static final RenameFile$ MODULE$;

    private RenameFile$() {
    }

    static {
        MODULE$ = new RenameFile$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RenameFile$.class);
    }

    public Panel panel(String name) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)Panel.Item$.MODULE$.apply(Panel$.MODULE$.Text(), "name", "File Name", FileActions$.MODULE$.text(name)), (List)Nil$.MODULE$));
    }

    public Task<RepositoryModel.ActionResult> apply(UserDB.User user, Json json) {
        String string = "path";
        String string2 = "name";
        int size = 2;
        Either either = json.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", RenameFile$::apply$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), RenameFile$::apply$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(RenameFile$::apply$$anonfun$3)))));
        if (either instanceof Right) {
            RenameFile.Info info = (RenameFile.Info)((Right)either).value();
            return this.auditRun(user, info);
        }
        if (either instanceof Left) {
            DecodingFailure err = (DecodingFailure)((Left)either).value();
            this.log().warn(() -> RenameFile$.apply$$anonfun$4(json, err), Line$.MODULE$.apply(25), FullName$.MODULE$.apply("ambience.repository.actions.RenameFile.apply"));
            return Task$.MODULE$.now((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Invalid request", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), false));
        }
        throw new MatchError((Object)either);
    }

    public Task<RepositoryModel.ActionResult> auditRun(UserDB.User user, RenameFile.Info info) {
        return this.run(user, info).map((Function1 & Serializable)reply -> {
            RenameFile.Info info = (RenameFile.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)info);
            String string = "path";
            String string2 = "name";
            ActionHelper$.MODULE$.audit(user, ActionHelper$.MODULE$.buildAction((RepositoryModel.ActionResult)reply, info.path(), "rename-file", (Option<Json>)Some$.MODULE$.apply((Object)package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(RenameFile$::auditRun$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))))));
            return reply;
        });
    }

    public Task<RepositoryModel.ActionResult> run(UserDB.User user, RenameFile.Info info) {
        if (info.name().contains("/")) {
            return ActionHelper$.MODULE$.warnReply("File name cannot contain /");
        }
        if (info.name().contains("\\")) {
            return ActionHelper$.MODULE$.warnReply("File name cannot contain \\");
        }
        if (info.name().trim().isEmpty()) {
            return ActionHelper$.MODULE$.warnReply("File name required");
        }
        String string = info.name().trim();
        String string2 = ".";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return ActionHelper$.MODULE$.warnReply("File name '.' not allowed");
        }
        String string3 = info.name().trim();
        String string4 = "..";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            return ActionHelper$.MODULE$.warnReply("File name '..' not allowed");
        }
        Path oldPath = Path$.MODULE$.apply(info.path());
        Path newPath = oldPath.parent().$div(info.name());
        return Task$.MODULE$.now((Object)AccessChecker$.MODULE$.apply(user)).flatMap((Function1 & Serializable)checker -> Metadata$.MODULE$.apply(oldPath).flatMap((Function1 & Serializable)oldItem -> Metadata$.MODULE$.apply(newPath).flatMap((Function1 & Serializable)newItem -> MODULE$.canRename((AccessChecker)checker, (Option<Metadata.Item>)oldItem, (Option<Metadata.Item>)newItem).flatMap((Function1 & Serializable)eReply -> {
            Task task;
            Either either = eReply;
            if (either instanceof Right) {
                task = MODULE$.doRun(user, info);
            } else if (either instanceof Left) {
                RepositoryModel.ActionResult reply2 = (RepositoryModel.ActionResult)((Left)either).value();
                task = Task$.MODULE$.now((Object)reply2);
            } else {
                throw new MatchError((Object)either);
            }
            return task.map((Function1 & Serializable)reply -> reply);
        }))));
    }

    public Task<Either<RepositoryModel.ActionResult, Metadata.File>> canRename(AccessChecker checker, Option<Metadata.Item> oldItem, Option<Metadata.Item> newItem) {
        Metadata.Item item;
        Option<Metadata.Item> option = oldItem;
        if (option instanceof Some && (item = (Metadata.Item)((Some)option).value()) instanceof Metadata.File) {
            Metadata.File f = (Metadata.File)item;
            if (newItem.isDefined()) {
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "New path already exists", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
            }
            return checker.canWrite(f.path()).map((Function1 & Serializable)ok -> RenameFile$.canRename$$anonfun$1(f, BoxesRunTime.unboxToBoolean((Object)ok)));
        }
        return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Path is not a file", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4())));
    }

    public Task<RepositoryModel.ActionResult> doRun(UserDB.User user, RenameFile.Info info) {
        Path oldPath = Path$.MODULE$.apply(info.path());
        Path newPath = oldPath.parent().$div(info.name());
        Bson withId = Filters$.MODULE$.eq("path", (Object)BsonString$.MODULE$.apply(oldPath.toString()));
        Bson setId = Updates$.MODULE$.set("path", (Object)BsonString$.MODULE$.apply(newPath.toString()));
        Task result = Task$.MODULE$.apply((Function0 & Serializable)() -> {
            RenameFile$.$anonfun$1(oldPath, newPath);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Metadata$.MODULE$.repository().findOneAndUpdateT(withId, setId).map((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                return RepositoryModel.ActionResult$.MODULE$.apply("info", "File renamed successfully", (Option)Some$.MODULE$.apply((Object)newPath.toString()), true);
            });
        });
        return result.onErrorHandle((Function1 & Serializable)x$1 -> {
            Throwable throwable;
            Throwable ex = throwable = x$1;
            MODULE$.log().error(() -> RenameFile$.doRun$$anonfun$1$$anonfun$1(ex), ex, Line$.MODULE$.apply(82), FullName$.MODULE$.apply("ambience.repository.actions.RenameFile.doRun"));
            return RepositoryModel.ActionResult$.MODULE$.apply("error", "Database error", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4());
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final List apply$$anonfun$1() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 apply$$anonfun$2() {
        RenameFile$Info$ renameFile$Info$ = RenameFile$Info$.MODULE$;
        return (Function1 & Serializable)p -> (RenameFile.Info)renameFile$Info$.fromProduct((Product)p);
    }

    private static final Product apply$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Object apply$$anonfun$4(Json json$1, DecodingFailure err$1) {
        return "Can't process " + json$1.noSpaces() + ": " + err$1;
    }

    /*
     * WARNING - void declaration
     */
    private static final List auditRun$$anonfun$1$$anonfun$1() {
        void var3_2;
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final /* synthetic */ Either canRename$$anonfun$1(Metadata.File f$1, boolean ok) {
        if (ok) {
            return package$.MODULE$.Right().apply((Object)f$1);
        }
        return package$.MODULE$.Left().apply((Object)RepositoryModel.ActionResult$.MODULE$.apply("error", "Path is not writable", RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$3(), RepositoryModel.ActionResult$.MODULE$.$lessinit$greater$default$4()));
    }

    private static final Object $anonfun$1$$anonfun$1(Path oldPath$3, Path newPath$4) {
        return "Renaming " + oldPath$3.toString() + " to " + newPath$4.toString();
    }

    private static final void $anonfun$1(Path oldPath$2, Path newPath$3) {
        MODULE$.log().info(() -> RenameFile$.$anonfun$1$$anonfun$1(oldPath$2, newPath$3), Line$.MODULE$.apply(78), FullName$.MODULE$.apply("ambience.repository.actions.RenameFile.result"));
    }

    private static final Object doRun$$anonfun$1$$anonfun$1(Throwable ex$1) {
        return "Database error: " + ex$1;
    }
}

