/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.archive;

import ambience.repository.archive.ArchiveExtractor;
import ambience.repository.archive.ArchiveExtractor$ArchiveFile$;
import ambience.repository.archive.ArchiveExtractor$ArchiveFolder$;
import ambience.repository.archive.ArchiveType;
import ambience.repository.archive.SafeName$;
import com.elixirtech.arch.ARM;
import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler$;
import monix.execution.schedulers.CanBlock$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class ArchiveExtractor$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(ArchiveExtractor$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final ArchiveExtractor$ArchiveFolder$ ArchiveFolder;
    public static final ArchiveExtractor$ArchiveFile$ ArchiveFile;
    public static final ArchiveExtractor$ MODULE$;

    private ArchiveExtractor$() {
    }

    static {
        MODULE$ = new ArchiveExtractor$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ArchiveExtractor$.class);
    }

    public Either<String, File> expand(File file, ArchiveType archiveType) {
        File tmpDir = Files.createTempDirectory("repository-archive-", new FileAttribute[0]).toFile();
        return (Either)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
            BufferedInputStream fis = (BufferedInputStream)arm.manage((Object)com.elixirtech.arch.package$.MODULE$.enrichInputStream((InputStream)com.elixirtech.arch.package$.MODULE$.enrichFile(file).input()).buffered());
            Either<String, Observable<ArchiveExtractor.ArchiveContent>> either = MODULE$.unArchive(archiveType, fis);
            if (either instanceof Right) {
                Observable contents = (Observable)((Right)either).value();
                Task<File> task = MODULE$.buildOutput(tmpDir, (Observable<ArchiveExtractor.ArchiveContent>)contents);
                return package$.MODULE$.Right().apply(task.runSyncUnsafe(task.runSyncUnsafe$default$1(), Scheduler$.MODULE$.global(), CanBlock$.MODULE$.permit()));
            }
            if (either instanceof Left) {
                String err = (String)((Left)either).value();
                return package$.MODULE$.Left().apply((Object)err);
            }
            throw new MatchError(either);
        });
    }

    public Either<String, Observable<ArchiveExtractor.ArchiveContent>> unArchive(ArchiveType archType, InputStream input) {
        Either either;
        try {
            either = (Either)ARM$.MODULE$.run((Function1 & Serializable)outerArm -> {
                ArchiveExtractor.TempFile uncompressedFile = MODULE$.tempFile((ARM)outerArm, "archival-uncompressed-extract", archType.storeFormat());
                ARM$.MODULE$.run((Function1)(JProcedure1 & Serializable)arm -> {
                    BufferedOutputStream outStream = (BufferedOutputStream)arm.manage((Object)com.elixirtech.arch.package$.MODULE$.enrichOutputStream((OutputStream)com.elixirtech.arch.package$.MODULE$.enrichFile(uncompressedFile.file()).output()).buffered());
                    InputStream in = (InputStream)arm.manage((Object)archType.decompressor(input));
                    com.elixirtech.arch.package$.MODULE$.enrichInputStream(in).copyTo((OutputStream)outStream);
                });
                return package$.MODULE$.Right().apply(MODULE$.entries(archType, uncompressedFile));
            });
        }
        catch (Exception ex) {
            String msg = "Unable to unarchive stream using " + archType.storeFormat() + ": " + ex.getMessage();
            this.log().error(() -> ArchiveExtractor$.unArchive$$anonfun$2(msg), (Throwable)ex, Line$.MODULE$.apply(45), FullName$.MODULE$.apply("ambience.repository.archive.ArchiveExtractor.unArchive"));
            either = package$.MODULE$.Left().apply((Object)msg);
        }
        return either;
    }

    public Task<File> buildOutput(File path, Observable<ArchiveExtractor.ArchiveContent> contents) {
        return contents.map((Function1 & Serializable)x$1 -> {
            ArchiveExtractor.ArchiveContent archiveContent = x$1;
            if (archiveContent instanceof ArchiveExtractor.ArchiveFile) {
                ArchiveExtractor.ArchiveFile f = (ArchiveExtractor.ArchiveFile)archiveContent;
                File file = new File(path, SafeName$.MODULE$.safe(f.name()));
                file.getParentFile().mkdirs();
                return Files.write(file.toPath(), f.bytes(), new OpenOption[0]);
            }
            if (archiveContent instanceof ArchiveExtractor.ArchiveFolder) {
                ArchiveExtractor.ArchiveFolder f = (ArchiveExtractor.ArchiveFolder)archiveContent;
                return BoxesRunTime.boxToBoolean((boolean)new File(path, f.name()).mkdirs());
            }
            ArchiveExtractor.ArchiveContent other = archiveContent;
            throw new MatchError((Object)("Unexpected match option: " + other));
        }).completedL().map((Function1 & Serializable)_$1 -> path);
    }

    public Observable<ArchiveExtractor.ArchiveContent> entries(ArchiveType archType, ArchiveExtractor.TempFile file) {
        ArchiveInputStream<? extends ArchiveEntry> archiveInput = archType.archiveStream(com.elixirtech.arch.package$.MODULE$.enrichInputStream((InputStream)com.elixirtech.arch.package$.MODULE$.enrichFile(file.file()).input()).buffered());
        return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ArchiveInputStream[]{archiveInput})).bracket((Function1 & Serializable)in -> MODULE$.entries((ArchiveInputStream<? extends ArchiveEntry>)in), (Function1 & Serializable)ais -> this.release$1((ArchiveInputStream)ais));
    }

    private Observable<ArchiveExtractor.ArchiveContent> entries(ArchiveInputStream<? extends ArchiveEntry> in) {
        Option option = Option$.MODULE$.apply((Object)in.getNextEntry());
        if (option instanceof Some) {
            ArchiveEntry entry = (ArchiveEntry)((Some)option).value();
            ArchiveExtractor.ArchiveFolder content = entry.isDirectory() ? ArchiveExtractor$ArchiveFolder$.MODULE$.apply(entry.getName()) : ArchiveExtractor$ArchiveFile$.MODULE$.apply(entry.getName(), com.elixirtech.arch.package$.MODULE$.enrichInputStream(in).contents());
            return Observable$.MODULE$.cons((Object)content, Observable$.MODULE$.defer(() -> ArchiveExtractor$.entries$$anonfun$3(in)));
        }
        return Observable$.MODULE$.empty();
    }

    public ArchiveExtractor.TempFile tempFile(ARM arm, String prefix, String suffix) {
        return (ArchiveExtractor.TempFile)arm.manage((Object)new ArchiveExtractor.MyTempFile(File.createTempFile(prefix, suffix)));
    }

    private static final Object unArchive$$anonfun$2(String msg$1) {
        return msg$1;
    }

    private static final void release$1$$anonfun$1(ArchiveInputStream ais$1) {
        ais$1.close();
    }

    private final Task release$1(ArchiveInputStream ais) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            ArchiveExtractor$.release$1$$anonfun$1(ais);
            return BoxedUnit.UNIT;
        });
    }

    private static final Observable entries$$anonfun$3(ArchiveInputStream in$1) {
        return MODULE$.entries((ArchiveInputStream<? extends ArchiveEntry>)in$1);
    }
}

