/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.etl;

import ambience.arch.EitherTELM;
import ambience.arch.EitherTELM$;
import ambience.bson.BsonETL$;
import ambience.chunk.ChunkAPI;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.framework.SecretsUtil$;
import ambience.module.UserDB;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.repository.Metadata;
import ambience.repository.Metadata$;
import ambience.repository.Metadata$Access$;
import ambience.repository.actions.ActionHelper$;
import ambience.repository.actions.WriteFile$;
import ambience.repository.etl.GitPull;
import ambience.repository.etl.GitPull$Info$;
import ambience.repository.etl.GitPull$MDEntry$;
import ambience.repository.etl.GitPull$Request$;
import ambience.repository.etl.GitPush$;
import ambience.repository.git.Branch;
import ambience.repository.git.Branch$;
import ambience.repository.git.GitLogic$;
import ambience.repository.git.LocalStorage$;
import ambience.repository.git.RepoBranch;
import ambience.repository.git.RepoBranch$;
import ambience.repository.git.Repository;
import ambience.repository.git.Repository$;
import cats.implicits$;
import cats.kernel.Order;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.elixirtech.arch.Tags;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Error;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.parser.package$;
import io.circe.syntax.package;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonBoolean$;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2$;
import scala.Tuple4$;
import scala.collection.ArrayOps$;
import scala.collection.Factory$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class GitPull$
implements Builder,
PanelBuilder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(GitPull$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(GitPull$.class.getDeclaredField("repositoryAPI$lzy1"));
    private volatile Object log$lzy1;
    private volatile Object repositoryAPI$lzy1;
    public static final GitPull$Info$ Info;
    private static final Json InfoJson;
    public static final GitPull$MDEntry$ MDEntry;
    public static final GitPull$Request$ Request;
    private static final String stepType;
    public static final GitPull$ MODULE$;

    private GitPull$() {
    }

    static {
        MODULE$ = new GitPull$();
        GitPull.Info info = (GitPull.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)GitPull$Info$.MODULE$.apply(GitPull$Info$.MODULE$.$lessinit$greater$default$1(), GitPull$Info$.MODULE$.$lessinit$greater$default$2()));
        String string = "repoField";
        String string2 = "branchField";
        InfoJson = package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        stepType = ETLStepType$.MODULE$.apply("repository.GitPull");
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GitPull$.class);
    }

    public ambience.api.Repository repositoryAPI() {
        Object object = this.repositoryAPI$lzy1;
        if (object instanceof ambience.api.Repository) {
            return (ambience.api.Repository)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (ambience.api.Repository)this.repositoryAPI$lzyINIT1();
    }

    private Object repositoryAPI$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.repositoryAPI$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    ambience.api.Repository repository = null;
                    try {
                        repository = (ambience.api.Repository)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(ambience.api.Repository.class));
                        object2 = repository == null ? LazyVals.NullValue$.MODULE$ : repository;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.repositoryAPI$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return repository;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Json InfoJson() {
        return InfoJson;
    }

    public String stepType() {
        return stepType;
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "repoField";
        String string2 = "branchField";
        int size = 2;
        Either either = implicits$.MODULE$.catsSyntaxEither(this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", GitPull$::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), GitPull$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(GitPull$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> MODULE$.run(cxt, (GitPull.Info)info, (Observable<Document>)from));
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "repoField";
        String string2 = "branchField";
        int size = 2;
        GitPull.Info info = (GitPull.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", GitPull$::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), GitPull$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(GitPull$::$anonfun$3))))).toOption().getOrElse(GitPull$::$anonfun$4);
        Panel.Item repoField = PanelItem$.MODULE$.text("repoField", "Git Repository Field", info.repoField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item branchField = PanelItem$.MODULE$.text("branchField", "Git Branch Field", info.branchField(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.apply(() -> GitPull$.buildPanel$$anonfun$1(repoField, branchField));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> GitPull$.savePanel$$anonfun$1(results, step));
    }

    public Observable<Document> run(Builder.Context cxt, GitPull.Info info, Observable<Document> from) {
        if (cxt.user().privileges().contains((Object)"mod-repository-admin")) {
            return from.mapEval((Function1 & Serializable)doc -> MODULE$.run(cxt, info, (Document)doc));
        }
        return cxt.logStart(from, (LogMessage)LogMessage.Error$.MODULE$.apply("User must have mod-repository-admin"));
    }

    public Task<Document> run(Builder.Context cxt, GitPull.Info info, Document doc) {
        EitherTELM request = EitherTELM$.MODULE$.apply(this.getRepo(cxt.user(), doc, info.repoField())).flatMap((Function1 & Serializable)repo -> GitPull$.$anonfun$6(doc, info, repo == null ? null : ((Repository)repo).value()));
        return request.value().flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                RepoBranch rb = (RepoBranch)((Right)either).value();
                return MODULE$.run(cxt, doc, rb);
            }
            if (either instanceof Left) {
                LogMessage lm = (LogMessage)((Left)either).value();
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"Git Pull failed"), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
                return cxt.logRecord((Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), lm);
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Document> run(Builder.Context cxt, Document in, RepoBranch rb) {
        GitLogic$.MODULE$.updateIfNecessary(rb);
        Either<LogMessage, List<GitPull.MDEntry>> either = this.loadMetadata(rb);
        if (either instanceof Right) {
            List md = (List)((Right)either).value();
            return this.copyFromGit(cxt, (List<GitPull.MDEntry>)md, rb).as((Object)in);
        }
        if (either instanceof Left) {
            LogMessage msg = (LogMessage)((Left)either).value();
            return cxt.logRecord(in, (LogMessage)LogMessage.Error$.MODULE$.apply("Git Pull failed: " + msg));
        }
        throw new MatchError(either);
    }

    public Task<Either<LogMessage, Repository>> getRepo(UserDB.User user, Document doc, String field) {
        Option option = BsonETL$.MODULE$.getString(doc, field).map((Function1 & Serializable)_$1 -> _$1.getValue());
        if (option instanceof Some) {
            String repo = (String)((Some)option).value();
            return SecretsUtil$.MODULE$.prefixDecrypt(user, repo, true).map((Function1 & Serializable)s -> scala.package$.MODULE$.Right().apply((Object)new Repository(Repository$.MODULE$.apply((String)s))));
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Missing repository field " + field)));
        }
        throw new MatchError((Object)option);
    }

    public Task<Either<LogMessage, Branch>> getBranch(Document doc, String field) {
        return Task$.MODULE$.apply(() -> GitPull$.getBranch$$anonfun$1(doc, field));
    }

    public Either<LogMessage, List<GitPull.MDEntry>> loadMetadata(RepoBranch rb) {
        LazyRef lazyRef = new LazyRef();
        better.files.File root = better.files.package$.MODULE$.FileExtensions(LocalStorage$.MODULE$.getRepositoryRoot(rb)).toScala();
        String content = root.$div(GitPush$.MODULE$.MetadataFilename()).contentAsString(this.utf8$1(lazyRef));
        String string = "path";
        String string2 = "tags";
        String string3 = "acl";
        String string4 = "lastModified";
        int size = 4;
        Either either = package$.MODULE$.decode(content, Decoder$.MODULE$.decodeList(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("MDEntry", GitPull$::loadMetadata$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), GitPull$::loadMetadata$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(GitPull$::loadMetadata$$anonfun$3))))));
        if (either instanceof Right) {
            List value = (List)((Right)either).value();
            return scala.package$.MODULE$.Right().apply((Object)value);
        }
        if (either instanceof Left) {
            Error value = (Error)((Left)either).value();
            return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Can't parse metadata: " + value));
        }
        throw new MatchError((Object)either);
    }

    public Task<BoxedUnit> copyFromGit(Builder.Context cxt, List<GitPull.MDEntry> md, RepoBranch rb) {
        return (Task)md.headOption().map((Function1 & Serializable)top -> {
            better.files.File root = better.files.package$.MODULE$.FileExtensions(LocalStorage$.MODULE$.getRepositoryRoot(rb)).toScala();
            return MODULE$.deletePath(cxt.user(), Path$.MODULE$.apply(top.path())).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return MODULE$.createItems(cxt, root, (GitPull.MDEntry)top, md).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        }).getOrElse(GitPull$::copyFromGit$$anonfun$2);
    }

    public Task<BoxedUnit> createItems(Builder.Context cxt, better.files.File root, GitPull.MDEntry top, List<GitPull.MDEntry> md) {
        List<GitPull.MDEntry> list = md;
        Nil$ nil$ = scala.package$.MODULE$.Nil();
        List<GitPull.MDEntry> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return Task$.MODULE$.unit();
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list3 = colon2.next$access$1();
            GitPull.MDEntry head = (GitPull.MDEntry)colon2.head();
            List tail = list3;
            return this.createItem(cxt, root, top, head).flatMap((Function1 & Serializable)_$3 -> MODULE$.createItems(cxt, root, top, (List<GitPull.MDEntry>)tail));
        }
        throw new MatchError(list);
    }

    public Task<BoxedUnit> createItem(Builder.Context cxt, better.files.File root, GitPull.MDEntry top, GitPull.MDEntry md) {
        Option<Object> option = md.lastModified();
        if (option instanceof Some) {
            long lastModified = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            return this.createFile(cxt, root, top, md, lastModified);
        }
        if (None$.MODULE$.equals(option)) {
            return this.createFolder(md);
        }
        throw new MatchError(option);
    }

    public Task<BoxedUnit> createFile(Builder.Context cxt, better.files.File root, GitPull.MDEntry top, GitPull.MDEntry md, long lastModified) {
        File bytes = new File(root.toJava(), StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(md.path()), top.path()));
        if (bytes.exists() && bytes.isFile()) {
            return WriteFile$.MODULE$.addChunks((Observable<byte[]>)DataBytes$.MODULE$.apply(bytes).observable()).flatMap((Function1 & Serializable)chunkInfo -> {
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[8];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"path");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(Path$.MODULE$.apply(md.path()).toString())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"type");
                objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply("file")), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"acl");
                objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)MODULE$.buildAcl(md)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"tags");
                Object object = Predef$.MODULE$.refArrayOps((Object[])md.tags());
                objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BsonArray$.MODULE$.fromIterable((Iterable)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)value -> BsonString$.MODULE$.apply(value), ClassTag$.MODULE$.apply(BsonString.class))))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
                objectArray[4] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)BsonInt64$.MODULE$.apply(chunkInfo.length())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"lastModified");
                objectArray[5] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)BsonDateTime$.MODULE$.apply(lastModified)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"lastModifiedBy");
                objectArray[6] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)BsonString$.MODULE$.apply(cxt.user().id())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"chunkIds");
                objectArray[7] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)BsonArray$.MODULE$.fromIterable((Iterable)chunkInfo.chunkIds().map((Function1 & Serializable)c -> BsonString$.MODULE$.apply(c == null ? null : ((ChunkAPI.ChunkId)c).value())))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                Document newFile = Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                return Metadata$.MODULE$.repository().insertOneT(newFile).void().map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        }
        return cxt.logT((LogMessage)LogMessage.Error$.MODULE$.apply("Metadata file " + md.path() + " (" + StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(md.path()), top.path()) + ") not found"));
    }

    public Task<BoxedUnit> createFolder(GitPull.MDEntry md) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[4];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"path");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(Path$.MODULE$.apply(md.path()).toString())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"type");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply("folder")), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"acl");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)this.buildAcl(md)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"tags");
        Object object = Predef$.MODULE$.refArrayOps((Object[])md.tags());
        objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BsonArray$.MODULE$.fromIterable((Iterable)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)value -> BsonString$.MODULE$.apply(value), ClassTag$.MODULE$.apply(BsonString.class))))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        Document newFolder = Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return Metadata$.MODULE$.repository().insertOneT(newFolder).void();
    }

    public BsonArray buildAcl(GitPull.MDEntry md) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])md.acl());
        return BsonArray$.MODULE$.fromIterable((Iterable)Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)rule -> MODULE$.buildAccess((Metadata.Access)rule), ClassTag$.MODULE$.apply(BsonDocument.class))));
    }

    public BsonDocument buildAccess(Metadata.Access rule) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"by");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(rule.by())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"write");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonBoolean$.MODULE$.apply(rule.write())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public Task<BoxedUnit> deletePath(UserDB.User user, Path path) {
        Bson withPrefix = ActionHelper$.MODULE$.thisOrDescendantsFilter(path);
        return Metadata$.MODULE$.repository().deleteManyT(withPrefix).void();
    }

    public BsonArray tagArray(Tags tags) {
        return BsonArray$.MODULE$.fromIterable((Iterable)((List)tags.values().toList().map((Function1 & Serializable)_$4 -> _$4.toString()).sorted(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForString()))).map((Function1 & Serializable)_$5 -> BsonString$.MODULE$.apply(_$5)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean ignore(better.files.File f) {
        String string = f.name();
        String string2 = ".git";
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = f.name();
        String string4 = GitPush$.MODULE$.MetadataFilename();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List $init$$$anonfun$1() {
        Encoder encodeA;
        void var2_1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List build$$anonfun$1() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 build$$anonfun$2() {
        GitPull$Info$ gitPull$Info$ = GitPull$Info$.MODULE$;
        return (Function1 & Serializable)p -> (GitPull.Info)gitPull$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)GitPull$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)GitPull$Info$.MODULE$.$lessinit$greater$default$2()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$2() {
        GitPull$Info$ gitPull$Info$ = GitPull$Info$.MODULE$;
        return (Function1 & Serializable)p -> (GitPull.Info)gitPull$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)GitPull$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)GitPull$Info$.MODULE$.$lessinit$greater$default$2()));
    }

    private static final GitPull.Info $anonfun$4() {
        return GitPull$Info$.MODULE$.apply(GitPull$Info$.MODULE$.$lessinit$greater$default$1(), GitPull$Info$.MODULE$.$lessinit$greater$default$2());
    }

    private static final Panel buildPanel$$anonfun$1(Panel.Item repoField$1, Panel.Item branchField$1) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)repoField$1, (List)new .colon.colon((Object)branchField$1, (List)Nil$.MODULE$)));
    }

    /*
     * WARNING - void declaration
     */
    private static final List savePanel$$anonfun$1$$anonfun$1() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        GitPull$Info$ gitPull$Info$ = GitPull$Info$.MODULE$;
        return (Function1 & Serializable)p -> (GitPull.Info)gitPull$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)GitPull$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)GitPull$Info$.MODULE$.$lessinit$greater$default$2()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$5() {
        void var3_2;
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$2) {
        String string = "repoField";
        String string2 = "branchField";
        int size = 2;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", GitPull$::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), GitPull$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(GitPull$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            GitPull.Info info2 = (GitPull.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "repoField";
            String string2 = "branchField";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(GitPull$::$anonfun$5, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string3 = step$2.copy$default$1();
            String string4 = step$2.copy$default$2();
            String string5 = step$2.copy$default$3();
            String string6 = step$2.copy$default$4();
            String string7 = step$2.copy$default$5();
            boolean bl = step$2.copy$default$7();
            boolean bl2 = step$2.copy$default$8();
            return step$2.copy(string3, string4, string5, string6, string7, json, bl, bl2);
        });
    }

    private static final /* synthetic */ EitherTELM $anonfun$6(Document doc$1, GitPull.Info info$3, String repo) {
        return EitherTELM$.MODULE$.apply(MODULE$.getBranch(doc$1, info$3.branchField())).map((Function1 & Serializable)branch -> RepoBranch$.MODULE$.apply(repo, branch == null ? null : ((Branch)branch).value()));
    }

    private static final Either getBranch$$anonfun$1(Document doc$3, String field$1) {
        Option option = BsonETL$.MODULE$.getString(doc$3, field$1).map((Function1 & Serializable)_$2 -> _$2.getValue());
        if (option instanceof Some) {
            String branch = (String)((Some)option).value();
            return scala.package$.MODULE$.Right().apply((Object)new Branch(Branch$.MODULE$.apply(branch)));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Missing branch field " + field$1));
        }
        throw new MatchError((Object)option);
    }

    private final Charset utf8$lzyINIT1$1(LazyRef utf8$lzy1$1) {
        Charset charset;
        LazyRef lazyRef = utf8$lzy1$1;
        synchronized (lazyRef) {
            charset = (Charset)(utf8$lzy1$1.initialized() ? utf8$lzy1$1.value() : utf8$lzy1$1.initialize((Object)StandardCharsets.UTF_8));
        }
        return charset;
    }

    private final Charset utf8$1(LazyRef utf8$lzy1$2) {
        return (Charset)(utf8$lzy1$2.initialized() ? utf8$lzy1$2.value() : this.utf8$lzyINIT1$1(utf8$lzy1$2));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$7() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeBoolean();
        void var2_3 = var3_2;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$8() {
        Metadata$Access$ metadata$Access$ = Metadata$Access$.MODULE$;
        return (Function1 & Serializable)p -> (Metadata.Access)metadata$Access$.fromProduct((Product)p);
    }

    private static final Product $anonfun$9() {
        return Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List loadMetadata$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        void var3_2;
        void var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeArray(Decoder$.MODULE$.decodeString(), Factory$.MODULE$.arrayFactory(ClassTag$.MODULE$.apply(String.class)));
        void var2_3 = var3_2;
        String string = "by";
        String string2 = "write";
        int size = 2;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeArray(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Access", GitPull$::$anonfun$7, scala.package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), GitPull$::$anonfun$8, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(GitPull$::$anonfun$9)))), Factory$.MODULE$.arrayFactory(ClassTag$.MODULE$.apply(Metadata.Access.class)));
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeOption(Decoder$.MODULE$.decodeLong());
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 loadMetadata$$anonfun$2() {
        GitPull$MDEntry$ gitPull$MDEntry$ = GitPull$MDEntry$.MODULE$;
        return (Function1 & Serializable)p -> (GitPull.MDEntry)gitPull$MDEntry$.fromProduct((Product)p);
    }

    private static final Product loadMetadata$$anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Task copyFromGit$$anonfun$2() {
        return Task$.MODULE$.unit();
    }
}

