/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.etl;

import ambience.arch.EitherTELM;
import ambience.arch.EitherTELM$;
import ambience.bson.BsonETL$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.framework.SecretsUtil$;
import ambience.module.UserDB;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import ambience.repository.Metadata;
import ambience.repository.Metadata$;
import ambience.repository.actions.ActionHelper$;
import ambience.repository.etl.GitPush;
import ambience.repository.etl.GitPush$Info$;
import ambience.repository.etl.GitPush$Request$;
import ambience.repository.git.Branch;
import ambience.repository.git.Branch$;
import ambience.repository.git.GitLogic$;
import ambience.repository.git.LocalStorage$;
import ambience.repository.git.RepoBranch$;
import ambience.repository.git.Repository;
import ambience.repository.git.Repository$;
import better.files.File;
import better.files.package$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import com.elixirtech.arch.Tag;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple3$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class GitPush$
implements Builder,
PanelBuilder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(GitPush$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final String MetadataFilename;
    public static final GitPush$Info$ Info;
    private static final Json InfoJson;
    public static final GitPush$Request$ Request;
    private static final String stepType;
    public static final GitPush$ MODULE$;

    private GitPush$() {
    }

    static {
        MODULE$ = new GitPush$();
        MetadataFilename = ".elx-repository-metadata";
        GitPush.Info info = (GitPush.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)GitPush$Info$.MODULE$.apply(GitPush$Info$.MODULE$.$lessinit$greater$default$1(), GitPush$Info$.MODULE$.$lessinit$greater$default$2(), GitPush$Info$.MODULE$.$lessinit$greater$default$3()));
        String string = "pathField";
        String string2 = "repoField";
        String string3 = "branchField";
        InfoJson = package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        stepType = ETLStepType$.MODULE$.apply("repository.GitPush");
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GitPush$.class);
    }

    public String MetadataFilename() {
        return MetadataFilename;
    }

    public Json InfoJson() {
        return InfoJson;
    }

    public String stepType() {
        return stepType;
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "pathField";
        String string2 = "repoField";
        String string3 = "branchField";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", GitPush$::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), GitPush$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(GitPush$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> MODULE$.run(cxt, (GitPush.Info)info, (Observable<Document>)from));
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "pathField";
        String string2 = "repoField";
        String string3 = "branchField";
        int size = 3;
        GitPush.Info info = (GitPush.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", GitPush$::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), GitPush$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(GitPush$::$anonfun$3))))).toOption().getOrElse(GitPush$::$anonfun$4);
        Panel.Item pathField = PanelItem$.MODULE$.text("pathField", "Path Field", info.pathField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item repoField = PanelItem$.MODULE$.text("repoField", "Git Repository Field", info.repoField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item branchField = PanelItem$.MODULE$.text("branchField", "Git Branch Field", info.branchField(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.apply(() -> GitPush$.buildPanel$$anonfun$1(pathField, repoField, branchField));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> GitPush$.savePanel$$anonfun$1(results, step));
    }

    public Observable<Document> run(Builder.Context cxt, GitPush.Info info, Observable<Document> from) {
        if (cxt.user().privileges().contains((Object)"mod-repository-admin")) {
            return from.mapEval((Function1 & Serializable)doc -> MODULE$.run(cxt, info, (Document)doc));
        }
        return cxt.logStart(from, (LogMessage)LogMessage.Error$.MODULE$.apply("User must have mod-repository-admin"));
    }

    public Task<Document> run(Builder.Context cxt, GitPush.Info info, Document doc) {
        EitherTELM request = EitherTELM$.MODULE$.apply(this.getPath(doc, info.pathField())).flatMap((Function1 & Serializable)path -> EitherTELM$.MODULE$.apply(MODULE$.getFolder((Path)path)).flatMap((Function1 & Serializable)folder -> EitherTELM$.MODULE$.apply(MODULE$.getRepo(cxt.user(), doc, info.repoField())).flatMap((Function1 & Serializable)repo -> GitPush$.$anonfun$6$$anonfun$1$$anonfun$1(doc, info, path, folder, repo == null ? null : ((Repository)repo).value()))));
        return request.value().flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                GitPush.Request request = (GitPush.Request)((Right)either).value();
                return MODULE$.run(cxt, doc, request);
            }
            if (either instanceof Left) {
                LogMessage lm = (LogMessage)((Left)either).value();
                return cxt.logRecord(doc, lm);
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Document> run(Builder.Context cxt, Document in, GitPush.Request request) {
        GitLogic$.MODULE$.updateIfNecessary(request.repoBranch());
        this.removeAllExceptDotGit(request);
        return this.copyIntoGit(request).as((Object)in).flatMap((Function1 & Serializable)_$1 -> {
            if (GitLogic$.MODULE$.addCommitAndPush(request.repoBranch(), "Repository Git Push by " + cxt.user().name())) {
                return cxt.logRecord(in, (LogMessage)LogMessage.Info$.MODULE$.apply("Git Push Completed"));
            }
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"Git Push failed"), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
            return cxt.logRecord((Document)in.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (LogMessage)LogMessage.Error$.MODULE$.apply("Git Push failed (see console)"));
        });
    }

    public void removeAllExceptDotGit(GitPush.Request request) {
        File root = package$.MODULE$.FileExtensions(LocalStorage$.MODULE$.getRepositoryRoot(request.repoBranch())).toScala();
        root.list().filterNot((Function1 & Serializable)f -> {
            String string = f.name();
            String string2 = ".git";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).foreach((Function1 & Serializable)_$2 -> _$2.delete(_$2.delete$default$1(), _$2.delete$default$2()));
    }

    public Task<BoxedUnit> copyIntoGit(GitPush.Request request) {
        GitPush.Builder builder = new GitPush.Builder(request.folder(), request.repoBranch());
        return builder.run();
    }

    public Task<Either<LogMessage, Metadata.Folder>> getFolder(Path path) {
        return Metadata$.MODULE$.apply(path).flatMap((Function1 & Serializable)optMetadata -> {
            Left left;
            Metadata.Item item;
            Option option = optMetadata;
            if (option instanceof Some && (item = (Metadata.Item)((Some)option).value()) instanceof Metadata.Folder) {
                Metadata.Folder metadata = (Metadata.Folder)item;
                left = scala.package$.MODULE$.Right().apply((Object)metadata);
            } else {
                left = scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Path " + path + " is not a folder"));
            }
            return Task$.MODULE$.now((Object)left).map((Function1 & Serializable)result -> result);
        });
    }

    public Task<Either<LogMessage, Path>> getPath(Document doc, String field) {
        return Task$.MODULE$.apply(() -> GitPush$.getPath$$anonfun$1(doc, field));
    }

    public Task<Either<LogMessage, Repository>> getRepo(UserDB.User user, Document doc, String field) {
        Option option = BsonETL$.MODULE$.getString(doc, field).map((Function1 & Serializable)_$4 -> _$4.getValue());
        if (option instanceof Some) {
            String repo = (String)((Some)option).value();
            return SecretsUtil$.MODULE$.prefixDecrypt(user, repo, true).map((Function1 & Serializable)s -> scala.package$.MODULE$.Right().apply((Object)new Repository(Repository$.MODULE$.apply((String)s))));
        }
        if (None$.MODULE$.equals(option)) {
            return Task$.MODULE$.now((Object)scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Missing repository field " + field)));
        }
        throw new MatchError((Object)option);
    }

    public Task<Either<LogMessage, Branch>> getBranch(Document doc, String field) {
        return Task$.MODULE$.apply(() -> GitPush$.getBranch$$anonfun$1(doc, field));
    }

    /*
     * WARNING - void declaration
     */
    private final List $init$$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        void var2_1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List build$$anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 build$$anonfun$2() {
        GitPush$Info$ gitPush$Info$ = GitPush$Info$.MODULE$;
        return (Function1 & Serializable)p -> (GitPush.Info)gitPush$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)GitPush$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)GitPush$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)GitPush$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$2() {
        GitPush$Info$ gitPush$Info$ = GitPush$Info$.MODULE$;
        return (Function1 & Serializable)p -> (GitPush.Info)gitPush$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)GitPush$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)GitPush$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)GitPush$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final GitPush.Info $anonfun$4() {
        return GitPush$Info$.MODULE$.apply(GitPush$Info$.MODULE$.$lessinit$greater$default$1(), GitPush$Info$.MODULE$.$lessinit$greater$default$2(), GitPush$Info$.MODULE$.$lessinit$greater$default$3());
    }

    private static final Panel buildPanel$$anonfun$1(Panel.Item pathField$1, Panel.Item repoField$1, Panel.Item branchField$1) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)pathField$1, (List)new .colon.colon((Object)repoField$1, (List)new .colon.colon((Object)branchField$1, (List)Nil$.MODULE$))));
    }

    /*
     * WARNING - void declaration
     */
    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        GitPush$Info$ gitPush$Info$ = GitPush$Info$.MODULE$;
        return (Function1 & Serializable)p -> (GitPush.Info)gitPush$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)GitPush$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)GitPush$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)GitPush$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$5() {
        Encoder encodeA;
        void var3_2;
        void var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$2) {
        String string = "pathField";
        String string2 = "repoField";
        String string3 = "branchField";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", GitPush$::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), GitPush$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(GitPush$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            GitPush.Info info2 = (GitPush.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "pathField";
            String string2 = "repoField";
            String string3 = "branchField";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(GitPush$::$anonfun$5, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string4 = step$2.copy$default$1();
            String string5 = step$2.copy$default$2();
            String string6 = step$2.copy$default$3();
            String string7 = step$2.copy$default$4();
            String string8 = step$2.copy$default$5();
            boolean bl = step$2.copy$default$7();
            boolean bl2 = step$2.copy$default$8();
            return step$2.copy(string4, string5, string6, string7, string8, json, bl, bl2);
        });
    }

    private static final /* synthetic */ EitherTELM $anonfun$6$$anonfun$1$$anonfun$1(Document doc$3, GitPush.Info info$5, Path path$2, Metadata.Folder folder$1, String repo) {
        return EitherTELM$.MODULE$.apply(MODULE$.getBranch(doc$3, info$5.branchField())).map((Function1 & Serializable)branch -> GitPush$Request$.MODULE$.apply(path$2, folder$1, RepoBranch$.MODULE$.apply(repo, branch == null ? null : ((Branch)branch).value())));
    }

    private static final Either getPath$$anonfun$1(Document doc$5, String field$1) {
        Option option = BsonETL$.MODULE$.getString(doc$5, field$1).map((Function1 & Serializable)_$3 -> _$3.getValue());
        if (option instanceof Some) {
            String path = (String)((Some)option).value();
            return scala.package$.MODULE$.Right().apply((Object)Path$.MODULE$.apply(path));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Missing path field " + field$1));
        }
        throw new MatchError((Object)option);
    }

    private static final Either getBranch$$anonfun$1(Document doc$6, String field$2) {
        Option option = BsonETL$.MODULE$.getString(doc$6, field$2).map((Function1 & Serializable)_$5 -> _$5.getValue());
        if (option instanceof Some) {
            String branch = (String)((Some)option).value();
            return scala.package$.MODULE$.Right().apply((Object)new Branch(Branch$.MODULE$.apply(branch)));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Missing branch field " + field$2));
        }
        throw new MatchError((Object)option);
    }

    public static final /* synthetic */ void ambience$repository$etl$GitPush$Builder$$_$run$$anonfun$5$$anonfun$1$$anonfun$1(BoxedUnit x$1) {
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final Object ambience$repository$etl$GitPush$Builder$$_$_$$anonfun$7(Metadata.Folder folder$3) {
        return "copyFolder " + folder$3.path();
    }

    public static final /* synthetic */ Observable ambience$repository$etl$GitPush$Builder$$_$$anonfun$8$$anonfun$1(Metadata.Folder folder$5, BoxedUnit x$1) {
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return Metadata$.MODULE$.repository().findO(ActionHelper$.MODULE$.childFilter(folder$5.path())).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(Metadata$.MODULE$.toItem((Document)doc))).map((Function1 & Serializable)items -> items));
    }

    public static final Object ambience$repository$etl$GitPush$Builder$$_$copyFile$$anonfun$1(Metadata.File f$1) {
        return "Copying " + f$1.path();
    }

    public static final /* synthetic */ String ambience$repository$etl$GitPush$Builder$$_$_$$anonfun$9(Tag _$7) {
        return _$7.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final List ambience$repository$etl$GitPush$Builder$$_$_$$anonfun$10() {
        void var3_2;
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeBoolean();
        void var2_3 = var3_2;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }
}

