/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.etl;

import ambience.chunk.ChunkAPI;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.serverui.PanelBuilder;
import ambience.module.UserDB;
import ambience.panel.Panel;
import ambience.repository.Metadata;
import ambience.repository.Metadata$File$;
import ambience.repository.Metadata$Folder$;
import ambience.repository.RepositoryChunks;
import ambience.repository.etl.GitPush$;
import ambience.repository.etl.GitPush$Info$;
import ambience.repository.etl.GitPush$Request$;
import ambience.repository.git.Branch;
import ambience.repository.git.LocalStorage$;
import ambience.repository.git.RepoBranch;
import ambience.repository.git.Repository;
import better.files.File;
import cats.implicits$;
import cats.kernel.Order;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Tags;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.JsonObject;
import io.circe.JsonObject$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.collection.Iterable;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class GitPush {
    public static Json InfoJson() {
        return GitPush$.MODULE$.InfoJson();
    }

    public static String MetadataFilename() {
        return GitPush$.MODULE$.MetadataFilename();
    }

    public static Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context context, ETLStep eTLStep) {
        return GitPush$.MODULE$.build(context, eTLStep);
    }

    public static Task<Panel> buildPanel(PanelBuilder.Context context, ETLStep eTLStep) {
        return GitPush$.MODULE$.buildPanel(context, eTLStep);
    }

    public static Task<BoxedUnit> copyIntoGit(Request request) {
        return GitPush$.MODULE$.copyIntoGit(request);
    }

    public static BuildError error(ETLStep eTLStep, DecodingFailure decodingFailure) {
        return GitPush$.MODULE$.error(eTLStep, decodingFailure);
    }

    public static Task<Option<String>> explain(ETLStep eTLStep) {
        return GitPush$.MODULE$.explain(eTLStep);
    }

    public static Task<Either<LogMessage, Branch>> getBranch(Document document, String string) {
        return GitPush$.MODULE$.getBranch(document, string);
    }

    public static Task<Either<LogMessage, Metadata.Folder>> getFolder(Path path) {
        return GitPush$.MODULE$.getFolder(path);
    }

    public static Task<Either<LogMessage, Path>> getPath(Document document, String string) {
        return GitPush$.MODULE$.getPath(document, string);
    }

    public static Task<Either<LogMessage, Repository>> getRepo(UserDB.User user, Document document, String string) {
        return GitPush$.MODULE$.getRepo(user, document, string);
    }

    public static LoggingInterface log() {
        return GitPush$.MODULE$.log();
    }

    public static void removeAllExceptDotGit(Request request) {
        GitPush$.MODULE$.removeAllExceptDotGit(request);
    }

    public static Task<Document> run(Builder.Context context, Document document, Request request) {
        return GitPush$.MODULE$.run(context, document, request);
    }

    public static Task<Document> run(Builder.Context context, Info info, Document document) {
        return GitPush$.MODULE$.run(context, info, document);
    }

    public static Observable<Document> run(Builder.Context context, Info info, Observable<Document> observable) {
        return GitPush$.MODULE$.run(context, info, observable);
    }

    public static Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context context, ETLStep eTLStep, Json json) {
        return GitPush$.MODULE$.savePanel(context, eTLStep, json);
    }

    public static String stepType() {
        return GitPush$.MODULE$.stepType();
    }

    public static class Builder {
        private final Metadata.Folder root;
        private final RepositoryChunks chunkDB;
        private final String rootPrefixSlash;
        private final File outFolder;
        private final ListBuffer metadata;

        public Builder(Metadata.Folder root, RepoBranch rb) {
            this.root = root;
            this.chunkDB = (RepositoryChunks)((Object)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(RepositoryChunks.class)));
            this.rootPrefixSlash = root.path().isEmpty() ? root.path().toString() : root.path().toString() + "/";
            this.outFolder = better.files.package$.MODULE$.FileExtensions(LocalStorage$.MODULE$.getRepositoryRoot(rb)).toScala();
            this.metadata = new ListBuffer();
            GitPush$.MODULE$.log().info(this::$init$$$anonfun$2, Line$.MODULE$.apply(128), FullName$.MODULE$.apply("ambience.repository.etl.GitPush.Builder"));
        }

        public RepositoryChunks chunkDB() {
            return this.chunkDB;
        }

        public String rootPrefixSlash() {
            return this.rootPrefixSlash;
        }

        public File outFolder() {
            return this.outFolder;
        }

        public ListBuffer<Json> metadata() {
            return this.metadata;
        }

        public Task<BoxedUnit> run() {
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.run$$anonfun$4();
                return BoxedUnit.UNIT;
            }).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return this.copyFolderChildren(this.root).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.addMetadata().map((Function1)((JProcedure1 & Serializable)GitPush$::ambience$repository$etl$GitPush$Builder$$_$run$$anonfun$5$$anonfun$1$$anonfun$1));
                });
            });
        }

        public Task<BoxedUnit> addMetadata() {
            return Task$.MODULE$.apply((Function0 & Serializable)() -> {
                this.addMetadata$$anonfun$1();
                return BoxedUnit.UNIT;
            });
        }

        public Task<BoxedUnit> copyFolderChildren(Metadata.Folder folder) {
            BoxedUnit[] boxedUnitArray = new BoxedUnit[1];
            GitPush$.MODULE$.log().info(() -> GitPush$.ambience$repository$etl$GitPush$Builder$$_$_$$anonfun$7(folder), Line$.MODULE$.apply(147), FullName$.MODULE$.apply("ambience.repository.etl.GitPush.Builder.all"));
            boxedUnitArray[0] = BoxedUnit.UNIT;
            Observable all = Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapUnitArray(boxedUnitArray)).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                this.addMetadata(folder);
                return Observable$.MODULE$.now((Object)BoxedUnit.UNIT).flatMap(arg_0 -> GitPush$.ambience$repository$etl$GitPush$Builder$$_$$anonfun$8$$anonfun$1(folder, arg_0));
            });
            return all.mapEval((Function1 & Serializable)x$1 -> {
                Metadata.Item item = x$1;
                if (item instanceof Metadata.File) {
                    Metadata.File f = (Metadata.File)item;
                    return this.copyFile(f);
                }
                if (item instanceof Metadata.Folder) {
                    Metadata.Folder f = (Metadata.Folder)item;
                    return this.copyFolderChildren(f);
                }
                throw new MatchError((Object)item);
            }).completedL();
        }

        public Task<BoxedUnit> copyFile(Metadata.File f) {
            String remainder = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(f.path().toString()), this.rootPrefixSlash());
            File file = this.outFolder().$div(remainder);
            File file2 = file.createFileIfNotExists(true, file.createFileIfNotExists$default$2(true), file.createFileIfNotExists$default$3(true));
            GitPush$.MODULE$.log().info(() -> GitPush$.ambience$repository$etl$GitPush$Builder$$_$copyFile$$anonfun$1(f), Line$.MODULE$.apply(161), FullName$.MODULE$.apply("ambience.repository.etl.GitPush.Builder.copyFile"));
            return this.chunkDB().readToFile(f.chunkIds(), file2.toJava()).map((Function1)(JProcedure1 & Serializable)_$6 -> this.addMetadata(f));
        }

        public void addMetadata(Metadata.Item f) {
            Json json;
            Metadata.Item item = f;
            if (item instanceof Metadata.File) {
                Metadata.File file = Metadata$File$.MODULE$.unapply((Metadata.File)item);
                Path path = file._1();
                Metadata.ACL aCL = file._2();
                Tags tags = file._3();
                long l = file._4();
                long l2 = file._5();
                List<ChunkAPI.ChunkId> list = file._6();
                Path path2 = path;
                Metadata.ACL acl = aCL;
                Tags tags2 = tags;
                long length = l;
                long lastModified = l2;
                List<ChunkAPI.ChunkId> chunkIds = list;
                json = this.asJson(path2, acl, tags2, (Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)lastModified)));
            } else if (item instanceof Metadata.Folder) {
                Metadata.Folder folder = Metadata$Folder$.MODULE$.unapply((Metadata.Folder)item);
                Path path = folder._1();
                Metadata.ACL aCL = folder._2();
                Tags tags = folder._3();
                Path path3 = path;
                Metadata.ACL acl = aCL;
                Tags tags3 = tags;
                json = this.asJson(path3, acl, tags3, (Option<Object>)None$.MODULE$);
            } else {
                throw new MatchError((Object)item);
            }
            Json json2 = json;
            this.metadata().$plus$eq((Object)json2);
        }

        public Json asJson(Path path, Metadata.ACL acl, Tags tags, Option<Object> optLM) {
            List list = (List)io.circe.syntax.package$.MODULE$.EncoderOps(tags.values().toList().map(GitPush$::ambience$repository$etl$GitPush$Builder$$_$_$$anonfun$9).sorted(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForString())));
            List list2 = (List)io.circe.syntax.package$.MODULE$.EncoderOps(acl.acl());
            String string = "by";
            String string2 = "write";
            JsonObject base = JsonObject$.MODULE$.empty().add("path", Json$.MODULE$.fromString(path.toString())).add("tags", package.EncoderOps$.MODULE$.asJson$extension((Object)list, (Encoder)Encoder$.MODULE$.encodeList(Encoder$.MODULE$.encodeString()))).add("acl", package.EncoderOps$.MODULE$.asJson$extension((Object)list2, (Encoder)Encoder$.MODULE$.encodeList(Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(GitPush$::ambience$repository$etl$GitPush$Builder$$_$_$$anonfun$10, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))))));
            Option<Object> option = optLM;
            if (option instanceof Some) {
                long lm = BoxesRunTime.unboxToLong((Object)((Some)option).value());
                return base.add("lastModified", Json$.MODULE$.fromLong(lm)).toJson();
            }
            if (None$.MODULE$.equals(option)) {
                return base.toJson();
            }
            throw new MatchError(option);
        }

        private final Object $init$$$anonfun$2() {
            return "Building files in " + this.outFolder();
        }

        private final Object run$$anonfun$4$$anonfun$1() {
            return "Building content from " + this.root.path();
        }

        private final void run$$anonfun$4() {
            GitPush$.MODULE$.log().info(this::run$$anonfun$4$$anonfun$1, Line$.MODULE$.apply(132), FullName$.MODULE$.apply("ambience.repository.etl.GitPush.Builder.run"));
        }

        private final Charset utf8$lzyINIT1$1(LazyRef utf8$lzy1$1) {
            Charset charset;
            LazyRef lazyRef = utf8$lzy1$1;
            synchronized (lazyRef) {
                charset = (Charset)(utf8$lzy1$1.initialized() ? utf8$lzy1$1.value() : utf8$lzy1$1.initialize((Object)StandardCharsets.UTF_8));
            }
            return charset;
        }

        private final Charset utf8$1(LazyRef utf8$lzy1$2) {
            return (Charset)(utf8$lzy1$2.initialized() ? utf8$lzy1$2.value() : this.utf8$lzyINIT1$1(utf8$lzy1$2));
        }

        private final void addMetadata$$anonfun$1() {
            LazyRef lazyRef = new LazyRef();
            String content = Json$.MODULE$.fromValues((Iterable)this.metadata().toList()).spaces2();
            File file = this.outFolder().$div(GitPush$.MODULE$.MetadataFilename());
            Charset charset = this.utf8$1(lazyRef);
            Seq seq = file.overwrite$default$2(content);
            file.overwrite(content, seq, charset);
        }
    }

    public static final class Info
    implements Product,
    Serializable {
        private final String pathField;
        private final String repoField;
        private final String branchField;

        public static Info apply(String string, String string2, String string3) {
            return GitPush$Info$.MODULE$.apply(string, string2, string3);
        }

        public static Info fromProduct(Product product) {
            return GitPush$Info$.MODULE$.fromProduct(product);
        }

        public static Info unapply(Info info) {
            return GitPush$Info$.MODULE$.unapply(info);
        }

        public static String $lessinit$greater$default$1() {
            return GitPush$Info$.MODULE$.$lessinit$greater$default$1();
        }

        public static String $lessinit$greater$default$2() {
            return GitPush$Info$.MODULE$.$lessinit$greater$default$2();
        }

        public static String $lessinit$greater$default$3() {
            return GitPush$Info$.MODULE$.$lessinit$greater$default$3();
        }

        public Info(String pathField, String repoField, String branchField) {
            this.pathField = pathField;
            this.repoField = repoField;
            this.branchField = branchField;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Info)) return false;
            Info info = (Info)object;
            String string = this.pathField();
            String string2 = info.pathField();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.repoField();
            String string4 = info.repoField();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.branchField();
            String string6 = info.branchField();
            if (string5 == null) {
                if (string6 == null) return true;
                return false;
            } else {
                if (!string5.equals(string6)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Info;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Info";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "pathField";
                }
                case 1: {
                    return "repoField";
                }
                case 2: {
                    return "branchField";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String pathField() {
            return this.pathField;
        }

        public String repoField() {
            return this.repoField;
        }

        public String branchField() {
            return this.branchField;
        }

        public Info copy(String pathField, String repoField, String branchField) {
            return new Info(pathField, repoField, branchField);
        }

        public String copy$default$1() {
            return this.pathField();
        }

        public String copy$default$2() {
            return this.repoField();
        }

        public String copy$default$3() {
            return this.branchField();
        }

        public String _1() {
            return this.pathField();
        }

        public String _2() {
            return this.repoField();
        }

        public String _3() {
            return this.branchField();
        }
    }

    public static final class Request
    implements Product,
    Serializable {
        private final Path path;
        private final Metadata.Folder folder;
        private final RepoBranch repoBranch;

        public static Request apply(Path path, Metadata.Folder folder, RepoBranch repoBranch) {
            return GitPush$Request$.MODULE$.apply(path, folder, repoBranch);
        }

        public static Request fromProduct(Product product) {
            return GitPush$Request$.MODULE$.fromProduct(product);
        }

        public static Request unapply(Request request) {
            return GitPush$Request$.MODULE$.unapply(request);
        }

        public Request(Path path, Metadata.Folder folder, RepoBranch repoBranch) {
            this.path = path;
            this.folder = folder;
            this.repoBranch = repoBranch;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Request)) return false;
            Request request = (Request)object;
            Path path = this.path();
            Path path2 = request.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!path.equals(path2)) return false;
            Metadata.Folder folder = this.folder();
            Metadata.Folder folder2 = request.folder();
            if (folder == null) {
                if (folder2 != null) {
                    return false;
                }
            } else if (!((Object)folder).equals(folder2)) return false;
            RepoBranch repoBranch = this.repoBranch();
            RepoBranch repoBranch2 = request.repoBranch();
            if (repoBranch == null) {
                if (repoBranch2 == null) return true;
                return false;
            } else {
                if (!((Object)repoBranch).equals(repoBranch2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Request;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Request";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "path";
                }
                case 1: {
                    return "folder";
                }
                case 2: {
                    return "repoBranch";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Path path() {
            return this.path;
        }

        public Metadata.Folder folder() {
            return this.folder;
        }

        public RepoBranch repoBranch() {
            return this.repoBranch;
        }

        public Request copy(Path path, Metadata.Folder folder, RepoBranch repoBranch) {
            return new Request(path, folder, repoBranch);
        }

        public Path copy$default$1() {
            return this.path();
        }

        public Metadata.Folder copy$default$2() {
            return this.folder();
        }

        public RepoBranch copy$default$3() {
            return this.repoBranch();
        }

        public Path _1() {
            return this.path();
        }

        public Metadata.Folder _2() {
            return this.folder();
        }

        public RepoBranch _3() {
            return this.repoBranch();
        }
    }
}

