/*
 * Decompiled with CFR 0.152.
 */
package ambience.repository.git;

import ambience.repository.git.ConsoleProcLogger$;
import ambience.repository.git.IdLogger$;
import ambience.repository.git.LocalLogger;
import ambience.repository.git.LocalStorage$;
import ambience.repository.git.RepoBranch;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.File;
import java.io.Serializable;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class GitLogic$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(GitLogic$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final GitLogic$ MODULE$ = new GitLogic$();

    private GitLogic$() {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GitLogic$.class);
    }

    public void init() {
        Integer n;
        this.log().info(GitLogic$::init$$anonfun$1, Line$.MODULE$.apply(11), FullName$.MODULE$.apply("ambience.repository.git.GitLogic.init"));
        try {
            n = BoxesRunTime.boxToInteger((int)Process$.MODULE$.apply("git config --global push.autoSetupRemote true").$bang((ProcessLogger)IdLogger$.MODULE$.apply("init", ConsoleProcLogger$.MODULE$)));
        }
        catch (Throwable ex) {
            this.log().error(() -> GitLogic$.init$$anonfun$2(ex), Line$.MODULE$.apply(17), FullName$.MODULE$.apply("ambience.repository.git.GitLogic.init"));
            n = BoxedUnit.UNIT;
        }
    }

    public boolean updateIfNecessary(RepoBranch rb) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(rb.repo()))) {
            File store = LocalStorage$.MODULE$.getLocation(rb);
            if (store.exists()) {
                return this.updateIfNecessary(rb, store);
            }
            return this.clone(rb, store);
        }
        return false;
    }

    public boolean addCommitAndPush(RepoBranch rb, String msg) {
        LocalLogger logger = new LocalLogger();
        File root = LocalStorage$.MODULE$.getRepositoryRoot(rb);
        if (Process$.MODULE$.apply("git -C \"" + root + "\" add .").$bang((ProcessLogger)IdLogger$.MODULE$.apply("add", logger)) == 0) {
            if (Process$.MODULE$.apply("git -C \"" + root + "\" diff-index --quiet HEAD").$bang((ProcessLogger)IdLogger$.MODULE$.apply("diff-index", logger)) != 0) {
                if (Process$.MODULE$.apply("git -C \"" + root + "\" commit -m \"" + this.safe(msg) + "\"").$bang((ProcessLogger)IdLogger$.MODULE$.apply("commit", logger)) == 0) {
                    int c = Process$.MODULE$.apply("git -C \"" + root + "\" push origin \"" + this.safe(rb.branch()) + "\"").$bang((ProcessLogger)IdLogger$.MODULE$.apply("push origin", logger));
                    if (c != 0) {
                        this.log().warn(() -> GitLogic$.addCommitAndPush$$anonfun$1(c, logger), Line$.MODULE$.apply(39), FullName$.MODULE$.apply("ambience.repository.git.GitLogic.addCommitAndPush"));
                    } else {
                        this.log().info(() -> GitLogic$.addCommitAndPush$$anonfun$2(c), Line$.MODULE$.apply(40), FullName$.MODULE$.apply("ambience.repository.git.GitLogic.addCommitAndPush"));
                    }
                    return c == 0;
                }
                this.log().warn(() -> GitLogic$.addCommitAndPush$$anonfun$3(logger), Line$.MODULE$.apply(44), FullName$.MODULE$.apply("ambience.repository.git.GitLogic.addCommitAndPush"));
                return false;
            }
            this.log().info(GitLogic$::addCommitAndPush$$anonfun$4, Line$.MODULE$.apply(49), FullName$.MODULE$.apply("ambience.repository.git.GitLogic.addCommitAndPush"));
            return true;
        }
        this.log().warn(() -> GitLogic$.addCommitAndPush$$anonfun$5(logger), Line$.MODULE$.apply(54), FullName$.MODULE$.apply("ambience.repository.git.GitLogic.addCommitAndPush"));
        return false;
    }

    private boolean updateIfNecessary(RepoBranch rb, File store) {
        this.log().info(() -> GitLogic$.updateIfNecessary$$anonfun$1(rb, store), Line$.MODULE$.apply(60), FullName$.MODULE$.apply("ambience.repository.git.GitLogic.updateIfNecessary"));
        LocalLogger logger = new LocalLogger();
        Process$.MODULE$.apply("git -C \"" + LocalStorage$.MODULE$.getRepositoryRoot(rb) + "\" checkout -f").$bang((ProcessLogger)IdLogger$.MODULE$.apply("checkout", ConsoleProcLogger$.MODULE$));
        String check1 = this.checksum(rb);
        int ret = Process$.MODULE$.apply("git -C \"" + LocalStorage$.MODULE$.getRepositoryRoot(rb) + "\" pull origin \"" + this.safe(rb.branch()) + "\" ").$bang((ProcessLogger)IdLogger$.MODULE$.apply("pull", ConsoleProcLogger$.MODULE$));
        if (ret == 0) {
            String string = this.checksum(rb);
            String string2 = check1;
            return string == null ? string2 != null : !string.equals(string2);
        }
        this.log().warn(GitLogic$::updateIfNecessary$$anonfun$2, Line$.MODULE$.apply(70), FullName$.MODULE$.apply("ambience.repository.git.GitLogic.updateIfNecessary"));
        return false;
    }

    public String checksum(RepoBranch rb) {
        return Process$.MODULE$.apply("git rev-parse \"" + this.safe(rb.branch()) + "\" ", LocalStorage$.MODULE$.getRepositoryRoot(rb), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang$bang();
    }

    public boolean clone(RepoBranch rb, File store) {
        store.mkdirs();
        this.log().info(() -> GitLogic$.clone$$anonfun$1(rb, store), Line$.MODULE$.apply(81), FullName$.MODULE$.apply("ambience.repository.git.GitLogic.clone"));
        int ret = Process$.MODULE$.apply("git -C \"" + store.getAbsolutePath() + "\" -c advice.detachedHead=false clone " + rb.repo() + " -q --single-branch --branch \"" + this.safe(rb.branch()) + "\" ").$bang((ProcessLogger)IdLogger$.MODULE$.apply("clone", ConsoleProcLogger$.MODULE$));
        return ret == 0;
    }

    public String safe(String s) {
        return s.replace("$", "\\$").replace("!", "\\!").replace("`", "\\`").replace("\"", "\\\"");
    }

    private static final Object init$$anonfun$1() {
        return "Init";
    }

    private static final Object init$$anonfun$2(Throwable ex$1) {
        return "Cannot configure git: " + ex$1;
    }

    private static final Object addCommitAndPush$$anonfun$1(int c$1, LocalLogger logger$1) {
        return "git push origin returns " + c$1 + "\n" + logger$1.getLog();
    }

    private static final Object addCommitAndPush$$anonfun$2(int c$2) {
        return "git push origin returns " + c$2;
    }

    private static final Object addCommitAndPush$$anonfun$3(LocalLogger logger$2) {
        return "git commit failed\n" + logger$2.getLog();
    }

    private static final Object addCommitAndPush$$anonfun$4() {
        return "No changes to commit";
    }

    private static final Object addCommitAndPush$$anonfun$5(LocalLogger logger$3) {
        return "git add failed\n" + logger$3.getLog();
    }

    private static final Object updateIfNecessary$$anonfun$1(RepoBranch rb$1, File store$1) {
        return "Updating " + rb$1 + " in " + store$1.getAbsolutePath();
    }

    private static final Object updateIfNecessary$$anonfun$2() {
        return "git pull failed";
    }

    private static final Object clone$$anonfun$1(RepoBranch rb$2, File store$2) {
        return "Cloning " + rb$2 + " to " + store$2.getAbsolutePath();
    }
}

