/*
 * Decompiled with CFR 0.152.
 */
package monix.execution;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.CancelableFuture$;
import monix.execution.CancelableFuture$Async$;
import monix.execution.CancelableFuture$Never$;
import monix.execution.CancelableFuture$Pure$;
import monix.execution.FutureUtils$;
import monix.execution.cancelables.ChainedCancelable;
import monix.execution.cancelables.ChainedCancelable$;
import monix.execution.misc.Local;
import monix.execution.misc.Local$;
import monix.execution.schedulers.TrampolineExecutionContext;
import monix.execution.schedulers.TrampolineExecutionContext$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.concurrent.CanAwait;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public abstract class CancelableFuture<A>
implements Future<A>,
Cancelable {
    public static <A> CancelableFuture<A> apply(Future<A> future, Cancelable cancelable) {
        return CancelableFuture$.MODULE$.apply(future, cancelable);
    }

    public static <A> CancelableFuture<A> applyWithLocal(Future<A> future, Cancelable cancelable, Local.Context context) {
        return CancelableFuture$.MODULE$.applyWithLocal(future, cancelable, context);
    }

    public static <A> CancelableFuture<A> async(Function1<Function1<Try<A>, BoxedUnit>, Cancelable> function1, ExecutionContext executionContext) {
        return CancelableFuture$.MODULE$.async(function1, executionContext);
    }

    public static <A> CancelableFuture<A> fromJavaCompletable(CompletableFuture<A> completableFuture, ExecutionContext executionContext) {
        return CancelableFuture$.MODULE$.fromJavaCompletable(completableFuture, executionContext);
    }

    public static <A> CancelableFuture<A> fromTry(Try<A> try_) {
        return CancelableFuture$.MODULE$.fromTry(try_);
    }

    public static <A> CancelableFuture<A> never() {
        return CancelableFuture$.MODULE$.never();
    }

    public static <A> CancelableFuture<A> pure(A a) {
        return CancelableFuture$.MODULE$.pure(a);
    }

    public static <A> CancelableFuture<A> raiseError(Throwable throwable) {
        return CancelableFuture$.MODULE$.raiseError(throwable);
    }

    public static <A> CancelableFuture<A> successful(A a) {
        return CancelableFuture$.MODULE$.successful(a);
    }

    public static <A> CancelableFuture<A> successfulWithLocal(A a, Local.Context context) {
        return CancelableFuture$.MODULE$.successfulWithLocal(a, context);
    }

    public static <A> CompletableFuture<A> toJavaCompletable(CancelableFuture<A> cancelableFuture, ExecutionContext executionContext) {
        return CancelableFuture$.MODULE$.toJavaCompletable(cancelableFuture, executionContext);
    }

    public static CancelableFuture<BoxedUnit> unit() {
        return CancelableFuture$.MODULE$.unit();
    }

    public CancelableFuture() {
        Future.$init$((Future)this);
    }

    public abstract Cancelable cancelable();

    public abstract Future<A> underlying();

    public Local.Context isolatedCtx() {
        return null;
    }

    public final CancelableFuture<Throwable> failed() {
        TrampolineExecutionContext ec = TrampolineExecutionContext$.MODULE$.immediate();
        return this.transformWith((Function1 & Serializable)x$1 -> {
            CancelableFuture<Object> cancelableFuture;
            Try try_ = x$1;
            if (try_ instanceof Success) {
                cancelableFuture = CancelableFuture$.MODULE$.failed(new NoSuchElementException("failed"));
            } else if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                cancelableFuture = CancelableFuture$.MODULE$.successful(e);
            } else {
                throw new MatchError((Object)try_);
            }
            return cancelableFuture;
        }, (ExecutionContext)ec);
    }

    public final <S> CancelableFuture<S> transform(Function1<A, S> s, Function1<Throwable, Throwable> f, ExecutionContext executor) {
        return this.transform((Function1 & Serializable)x$1 -> {
            Success success;
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Object a = ((Success)try_).value();
                success = Success$.MODULE$.apply(s.apply(a));
            } else if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                success = Failure$.MODULE$.apply((Throwable)f.apply((Object)e));
            } else {
                throw new MatchError((Object)try_);
            }
            return success;
        }, executor);
    }

    public final <S> CancelableFuture<S> map(Function1<A, S> f, ExecutionContext executor) {
        return this.transform((Function1 & Serializable)x$1 -> {
            Try try_;
            Try try_2 = x$1;
            if (try_2 instanceof Success) {
                Object a = ((Success)try_2).value();
                try_ = Success$.MODULE$.apply(f.apply(a));
            } else {
                Try fail;
                try_ = fail = try_2;
            }
            return try_;
        }, executor);
    }

    public final CancelableFuture<A> filter(Function1<A, Object> p, ExecutionContext executor) {
        return this.transform((Function1 & Serializable)x$1 -> {
            Object a;
            Try try_ = x$1;
            if (try_ instanceof Success && !BoxesRunTime.unboxToBoolean((Object)p.apply(a = ((Success)try_).value()))) {
                throw new NoSuchElementException("Future.filter predicate is not satisfied");
            }
            Try pass = try_;
            return pass;
        }, executor);
    }

    public final <S> CancelableFuture<S> collect(PartialFunction<A, S> pf, ExecutionContext executor) {
        return this.transform((Function1 & Serializable)x$1 -> {
            Failure failure;
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Object a = ((Success)try_).value();
                if (!pf.isDefinedAt(a)) throw new NoSuchElementException(new StringBuilder(51).append("Future.collect partial function is not defined at: ").append(a).toString());
                failure = Success$.MODULE$.apply(pf.apply(a));
                return failure;
            } else {
                Failure fail;
                if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                failure = fail = (Failure)try_;
            }
            return failure;
        }, executor);
    }

    public final <U> CancelableFuture<U> recover(PartialFunction<Throwable, U> pf, ExecutionContext executor) {
        return this.transform((Function1 & Serializable)x$1 -> {
            Success success;
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Success ref;
                success = ref = (Success)try_;
            } else if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                if (!pf.isDefinedAt((Object)e)) {
                    throw e;
                }
                success = Success$.MODULE$.apply(pf.apply((Object)e));
            } else {
                throw new MatchError((Object)try_);
            }
            return success;
        }, executor);
    }

    public final <U> CancelableFuture<U> recoverWith(PartialFunction<Throwable, Future<U>> pf, ExecutionContext executor) {
        return this.transformWith((Function1 & Serializable)x$1 -> {
            CancelableFuture<A> cancelableFuture;
            Try try_ = x$1;
            if (try_ instanceof Success) {
                cancelableFuture = this;
            } else if (try_ instanceof Failure) {
                Throwable e = ((Failure)try_).exception();
                cancelableFuture = !pf.isDefinedAt((Object)e) ? this : (Future)pf.apply((Object)e);
            } else {
                throw new MatchError((Object)try_);
            }
            return cancelableFuture;
        }, executor);
    }

    public final <U> CancelableFuture<Tuple2<A, U>> zip(Future<U> that) {
        TrampolineExecutionContext ec = TrampolineExecutionContext$.MODULE$.immediate();
        return this.flatMap((Function1 & Serializable)a -> that.map((Function1 & Serializable)b -> Tuple2$.MODULE$.apply(a, b), (ExecutionContext)ec), (ExecutionContext)ec);
    }

    public final <U> CancelableFuture<U> fallbackTo(Future<U> that) {
        TrampolineExecutionContext ec = TrampolineExecutionContext$.MODULE$.immediate();
        return this.transformWith((Function1 & Serializable)x$1 -> {
            CancelableFuture cancelableFuture;
            Try try_ = x$1;
            if (try_ instanceof Success) {
                cancelableFuture = this;
            } else if (try_ instanceof Failure) {
                cancelableFuture = that;
            } else {
                throw new MatchError((Object)try_);
            }
            return cancelableFuture;
        }, (ExecutionContext)ec);
    }

    public final <S> CancelableFuture<S> mapTo(ClassTag<S> tag) {
        CancelableFuture cancelableFuture;
        CancelableFuture cancelableFuture2 = this;
        if (cancelableFuture2 instanceof Async) {
            Async async = CancelableFuture$Async$.MODULE$.unapply((Async)cancelableFuture2);
            Future future = async._1();
            Cancelable cancelable = async._2();
            Local.Context context = async._3();
            Future other = future;
            Cancelable cRef = cancelable;
            Local.Context local = context;
            cancelableFuture = CancelableFuture$.MODULE$.applyWithLocal(other.mapTo(tag), cRef, local);
        } else if (cancelableFuture2 instanceof Pure) {
            Pure p = (Pure)cancelableFuture2;
            cancelableFuture = CancelableFuture$.MODULE$.applyWithLocal(Future.mapTo$((Future)this, tag), Cancelable$.MODULE$.empty(), p.isolatedCtx());
        } else if (CancelableFuture$Never$.MODULE$.equals(cancelableFuture2)) {
            cancelableFuture = CancelableFuture$Never$.MODULE$;
        } else {
            throw new MatchError((Object)cancelableFuture2);
        }
        return cancelableFuture;
    }

    public final <U> CancelableFuture<A> andThen(PartialFunction<Try<A>, U> pf, ExecutionContext executor) {
        return this.transformWith((Function1 & Serializable)r -> {
            if (pf.isDefinedAt(r)) {
                pf.apply(r);
            }
            return this;
        }, executor);
    }

    public final <S> CancelableFuture<S> flatMap(Function1<A, Future<S>> f, ExecutionContext executor) {
        return this.transformWith((Function1 & Serializable)x$1 -> {
            CancelableFuture cancelableFuture;
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Object s = ((Success)try_).value();
                cancelableFuture = (Future)f.apply(s);
            } else if (try_ instanceof Failure) {
                cancelableFuture = this;
            } else {
                throw new MatchError((Object)try_);
            }
            return cancelableFuture;
        }, executor);
    }

    public <S> CancelableFuture<S> transform(Function1<Try<A>, Try<S>> f, ExecutionContext executor) {
        Function1 & Serializable g = (Function1 & Serializable)result -> {
            if (this.isolatedCtx() != null) {
                Local$.MODULE$.setContext(this.isolatedCtx());
            }
            return (Try)f.apply(result);
        };
        Future next = FutureUtils$.MODULE$.transform(this.underlying(), g, executor);
        return CancelableFuture$.MODULE$.applyWithLocal(next, this.cancelable(), this.isolatedCtx());
    }

    public <S> CancelableFuture<S> transformWith(Function1<Try<A>, Future<S>> f, ExecutionContext executor) {
        ChainedCancelable cRef = ChainedCancelable$.MODULE$.apply(this.cancelable());
        Future f2 = FutureUtils$.MODULE$.transformWith(this.underlying(), (Function1 & Serializable)result -> {
            Future<A> future;
            CancelableFuture ref;
            Future<A> nextRef;
            Future<A> future2;
            if (this.isolatedCtx() != null) {
                Local$.MODULE$.setContext(this.isolatedCtx());
            }
            try {
                future2 = (Future<A>)f.apply(result);
            }
            catch (Throwable throwable) {
                Throwable throwable2;
                Throwable e = throwable2 = throwable;
                if (NonFatal$.MODULE$.apply(e)) {
                    future2 = Future$.MODULE$.failed(e);
                }
                throw throwable;
            }
            Future<A> future3 = nextRef = future2;
            if (future3 instanceof CancelableFuture && (ref = (CancelableFuture)future3) != CancelableFuture$Never$.MODULE$) {
                CancelableFuture cf = ref;
                if (!cf.isCompleted()) {
                    Cancelable cancelable = cf.cancelable();
                    if (cancelable instanceof ChainedCancelable) {
                        ChainedCancelable cRef2 = (ChainedCancelable)cancelable;
                        cRef2.forwardTo(cRef);
                    } else {
                        Cancelable cRef2 = cancelable;
                        if (!(cRef2 instanceof Cancelable.IsDummy)) {
                            cRef.$colon$eq(cRef2);
                        }
                    }
                }
                future = cf.underlying();
            } else {
                future = nextRef;
            }
            return future;
        }, executor);
        return CancelableFuture$.MODULE$.applyWithLocal(f2, cRef, this.isolatedCtx());
    }

    public static final class Async<A>
    extends CancelableFuture<A>
    implements Product {
        private final Future underlying;
        private final Cancelable cancelable;
        private final Local.Context isolatedCtx;

        public static <A> Async<A> apply(Future<A> future, Cancelable cancelable, Local.Context context) {
            return CancelableFuture$Async$.MODULE$.apply(future, cancelable, context);
        }

        public static Async<?> fromProduct(Product product) {
            return CancelableFuture$Async$.MODULE$.fromProduct(product);
        }

        public static <A> Async<A> unapply(Async<A> async) {
            return CancelableFuture$Async$.MODULE$.unapply(async);
        }

        public static <A> Local.Context $lessinit$greater$default$3() {
            return CancelableFuture$Async$.MODULE$.$lessinit$greater$default$3();
        }

        public Async(Future<A> underlying, Cancelable cancelable, Local.Context isolatedCtx) {
            this.underlying = underlying;
            this.cancelable = cancelable;
            this.isolatedCtx = isolatedCtx;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Async)) return false;
            Async async = (Async)object;
            Future<A> future = this.underlying();
            Future<A> future2 = async.underlying();
            if (future == null) {
                if (future2 != null) {
                    return false;
                }
            } else if (!future.equals(future2)) return false;
            Cancelable cancelable = this.cancelable();
            Cancelable cancelable2 = async.cancelable();
            if (cancelable == null) {
                if (cancelable2 != null) {
                    return false;
                }
            } else if (!cancelable.equals(cancelable2)) return false;
            Local.Context context = this.isolatedCtx();
            Local.Context context2 = async.isolatedCtx();
            if (context == null) {
                if (context2 == null) return true;
                return false;
            } else {
                if (!context.equals(context2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Async;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "Async";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "underlying";
                    break;
                }
                case 1: {
                    string = "cancelable";
                    break;
                }
                case 2: {
                    string = "isolatedCtx";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        @Override
        public Future<A> underlying() {
            return this.underlying;
        }

        @Override
        public Cancelable cancelable() {
            return this.cancelable;
        }

        @Override
        public Local.Context isolatedCtx() {
            return this.isolatedCtx;
        }

        public <U> void onComplete(Function1<Try<A>, U> f, ExecutionContext executor) {
            this.underlying().onComplete(f, executor);
        }

        public boolean isCompleted() {
            return this.underlying().isCompleted();
        }

        public Option<Try<A>> value() {
            return this.underlying().value();
        }

        public A result(Duration atMost, CanAwait permit) throws Exception {
            return (A)this.underlying().result(atMost, permit);
        }

        public Async ready(Duration atMost, CanAwait permit) throws TimeoutException, InterruptedException {
            this.underlying().ready(atMost, permit);
            return this;
        }

        @Override
        public void cancel() {
            this.cancelable().cancel();
        }

        public <A> Async<A> copy(Future<A> underlying, Cancelable cancelable, Local.Context isolatedCtx) {
            return new Async<A>(underlying, cancelable, isolatedCtx);
        }

        public <A> Future<A> copy$default$1() {
            return this.underlying();
        }

        public <A> Cancelable copy$default$2() {
            return this.cancelable();
        }

        public <A> Local.Context copy$default$3() {
            return this.isolatedCtx();
        }

        public Future<A> _1() {
            return this.underlying();
        }

        public Cancelable _2() {
            return this.cancelable();
        }

        public Local.Context _3() {
            return this.isolatedCtx();
        }
    }

    public static final class Pure<A>
    extends CancelableFuture<A> {
        public final Try<A> monix$execution$CancelableFuture$Pure$$immediate;
        private final Local.Context isolatedCtx;
        private final Future underlying;

        public static <A> Local.Context $lessinit$greater$default$2() {
            return CancelableFuture$Pure$.MODULE$.$lessinit$greater$default$2();
        }

        public Pure(Try<A> immediate, Local.Context isolatedCtx) {
            this.monix$execution$CancelableFuture$Pure$$immediate = immediate;
            this.isolatedCtx = isolatedCtx;
            this.underlying = Future$.MODULE$.fromTry(immediate);
        }

        @Override
        public Local.Context isolatedCtx() {
            return this.isolatedCtx;
        }

        public Pure ready(Duration atMost, CanAwait permit) {
            return this;
        }

        public A result(Duration atMost, CanAwait permit) {
            return (A)this.monix$execution$CancelableFuture$Pure$$immediate.get();
        }

        @Override
        public Cancelable cancelable() {
            return Cancelable$.MODULE$.empty();
        }

        @Override
        public Future<A> underlying() {
            return this.underlying;
        }

        @Override
        public void cancel() {
        }

        public boolean isCompleted() {
            return true;
        }

        public Option<Try<A>> value() {
            return this.underlying().value();
        }

        public <U> void onComplete(Function1<Try<A>, U> f, ExecutionContext executor) {
            executor.execute(new Runnable(f, this){
                private final Function1 f$6;
                private final /* synthetic */ Pure $outer;
                {
                    this.f$6 = f$7;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public void run() {
                    this.f$6.apply(this.$outer.monix$execution$CancelableFuture$Pure$$immediate);
                }
            });
        }
    }
}

