/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.cancelables;

import monix.execution.Cancelable;
import monix.execution.Cancelable$;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicAny$;
import monix.execution.atomic.PaddingStrategy$LeftRight128$;
import monix.execution.cancelables.BooleanCancelable;
import monix.execution.cancelables.StackedCancelable$;
import scala.MatchError;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;

public abstract class StackedCancelable
implements BooleanCancelable {
    public static StackedCancelable alreadyCanceled() {
        return StackedCancelable$.MODULE$.alreadyCanceled();
    }

    public static StackedCancelable apply() {
        return StackedCancelable$.MODULE$.apply();
    }

    public static StackedCancelable apply(Cancelable cancelable) {
        return StackedCancelable$.MODULE$.apply(cancelable);
    }

    public static StackedCancelable apply(List<Cancelable> list) {
        return StackedCancelable$.MODULE$.apply(list);
    }

    public static StackedCancelable uncancelable() {
        return StackedCancelable$.MODULE$.uncancelable();
    }

    public abstract Cancelable popAndPushList(List<Cancelable> var1);

    public abstract Cancelable popAndPush(Cancelable var1);

    public abstract void pushList(List<Cancelable> var1);

    public abstract void push(Cancelable var1);

    public abstract Cancelable pop();

    private static final class AlreadyCanceled
    extends StackedCancelable {
        @Override
        public void cancel() {
        }

        @Override
        public boolean isCanceled() {
            return true;
        }

        @Override
        public Cancelable pop() {
            return Cancelable$.MODULE$.empty();
        }

        @Override
        public void push(Cancelable value) {
            value.cancel();
        }

        @Override
        public Cancelable popAndPushList(List<Cancelable> list) {
            Cancelable$.MODULE$.cancelAll((Iterable<Cancelable>)list);
            return Cancelable$.MODULE$.empty();
        }

        @Override
        public Cancelable popAndPush(Cancelable value) {
            value.cancel();
            return Cancelable$.MODULE$.empty();
        }

        @Override
        public void pushList(List<Cancelable> list) {
            Cancelable$.MODULE$.cancelAll((Iterable<Cancelable>)list);
        }
    }

    private static final class Impl
    extends StackedCancelable {
        private List<Cancelable> cache;
        private final AtomicAny<List<Cancelable>> state;

        public Impl(List<Cancelable> initial) {
            this.cache = initial;
            this.state = AtomicAny$.MODULE$.withPadding(initial, PaddingStrategy$LeftRight128$.MODULE$);
        }

        @Override
        public boolean isCanceled() {
            return this.state.get() == null;
        }

        @Override
        public void cancel() {
            block0: {
                List list = this.state.getAndSet(null);
                if (list == null) break block0;
                List list2 = list;
                Cancelable$.MODULE$.cancelAll((Iterable<Cancelable>)list2);
            }
        }

        @Override
        public Cancelable popAndPushList(List<Cancelable> list) {
            Cancelable cancelable;
            block3: {
                List<Cancelable> list2;
                Impl impl = this;
                while (true) {
                    if ((list2 = impl.state.get()) == null) {
                        Cancelable$.MODULE$.cancelAll((Iterable<Cancelable>)list);
                        cancelable = Cancelable$.MODULE$.empty();
                        break block3;
                    }
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List<Cancelable> list3 = list2;
                    if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
                        if (!impl.state.compareAndSet((List<Cancelable>)package$.MODULE$.Nil(), list)) continue;
                        cancelable = Cancelable$.MODULE$.empty();
                        break block3;
                    }
                    if (!(list2 instanceof .colon.colon)) break;
                    .colon.colon colon2 = (.colon.colon)list2;
                    List list4 = colon2.next$access$1();
                    Cancelable head = (Cancelable)colon2.head();
                    .colon.colon ref = colon2;
                    List tail = list4;
                    if (!impl.state.compareAndSet((List<Cancelable>)ref, impl.concatList(list, (List<Cancelable>)tail))) continue;
                    cancelable = head;
                    break block3;
                }
                throw new MatchError(list2);
            }
            return cancelable;
        }

        @Override
        public Cancelable popAndPush(Cancelable value) {
            Cancelable cancelable;
            block3: {
                List<Cancelable> list;
                Impl impl = this;
                while (true) {
                    if ((list = impl.state.get()) == null) {
                        value.cancel();
                        cancelable = Cancelable$.MODULE$.empty();
                        break block3;
                    }
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List<Cancelable> list2 = list;
                    if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                        if (!impl.state.compareAndSet((List<Cancelable>)package$.MODULE$.Nil(), (List<Cancelable>)package$.MODULE$.Nil().$colon$colon((Object)value))) continue;
                        cancelable = Cancelable$.MODULE$.empty();
                        break block3;
                    }
                    if (!(list instanceof .colon.colon)) break;
                    .colon.colon colon2 = (.colon.colon)list;
                    List list3 = colon2.next$access$1();
                    Cancelable head = (Cancelable)colon2.head();
                    .colon.colon ref = colon2;
                    List tail = list3;
                    if (!impl.state.compareAndSet((List<Cancelable>)ref, (List<Cancelable>)tail.$colon$colon((Object)value))) continue;
                    cancelable = head;
                    break block3;
                }
                throw new MatchError(list);
            }
            return cancelable;
        }

        @Override
        public void pushList(List<Cancelable> list) {
            List<Cancelable> list2;
            List<Cancelable> current;
            Impl impl = this;
            do {
                if ((list2 = impl.state.get()) != null) continue;
                Cancelable$.MODULE$.cancelAll((Iterable<Cancelable>)list);
                break;
            } while (!impl.state.compareAndSet(current = list2, impl.concatList(list, current)));
        }

        private void pushLoop(List<Cancelable> current, Cancelable value) {
            block2: {
                List update;
                Impl impl = this;
                List<Cancelable> list = current;
                while (true) {
                    if (list == null) {
                        impl.cache = null;
                        value.cancel();
                        break block2;
                    }
                    update = list.$colon$colon((Object)value);
                    if (impl.state.compareAndSet(list, (List<Cancelable>)update)) break;
                    Impl impl2 = impl;
                    List<Cancelable> list2 = impl.state.get();
                    impl = impl2;
                    list = list2;
                }
                impl.cache = update;
            }
        }

        @Override
        public void push(Cancelable value) {
            this.pushLoop(this.cache, value);
        }

        private Cancelable popLoop(List<Cancelable> current, boolean isFresh) {
            Cancelable cancelable;
            block5: {
                List<Cancelable> list;
                Impl impl = this;
                boolean bl = isFresh;
                List<Cancelable> list2 = current;
                while (true) {
                    block8: {
                        block6: {
                            List<Cancelable> list3;
                            Nil$ nil$;
                            block7: {
                                if ((list = list2) == null) break block6;
                                nil$ = package$.MODULE$.Nil();
                                list3 = list;
                                if (nil$ != null) break block7;
                                if (list3 == null) break block6;
                                break block8;
                            }
                            if (!nil$.equals(list3)) break block8;
                        }
                        if (bl) {
                            cancelable = Cancelable$.MODULE$.empty();
                            break block5;
                        }
                        Impl impl2 = impl;
                        List<Cancelable> list4 = impl.state.get();
                        boolean bl2 = true;
                        impl = impl2;
                        list2 = list4;
                        bl = bl2;
                        continue;
                    }
                    if (!(list instanceof .colon.colon)) break;
                    .colon.colon colon2 = (.colon.colon)list;
                    List list5 = colon2.next$access$1();
                    Cancelable head = (Cancelable)colon2.head();
                    .colon.colon ref = colon2;
                    List tail = list5;
                    if (impl.state.compareAndSet((List<Cancelable>)ref, (List<Cancelable>)tail)) {
                        impl.cache = tail;
                        cancelable = head;
                        break block5;
                    }
                    Impl impl3 = impl;
                    List<Cancelable> list6 = impl.state.get();
                    boolean bl3 = true;
                    impl = impl3;
                    list2 = list6;
                    bl = bl3;
                }
                throw new MatchError(list);
            }
            return cancelable;
        }

        private boolean popLoop$default$2() {
            return false;
        }

        @Override
        public Cancelable pop() {
            return this.popLoop(this.cache, this.popLoop$default$2());
        }

        private List<Cancelable> concatList(List<Cancelable> list, List<Cancelable> current) {
            List list2;
            block1: {
                List list3;
                Impl impl = this;
                list2 = current;
                List list4 = list;
                while (true) {
                    list3 = list4;
                    Nil$ nil$ = package$.MODULE$.Nil();
                    List list5 = list3;
                    if (!(nil$ == null ? list5 != null : !nil$.equals(list5))) break block1;
                    if (!(list3 instanceof .colon.colon)) break;
                    .colon.colon colon2 = (.colon.colon)list3;
                    List list6 = colon2.next$access$1();
                    Cancelable x = (Cancelable)colon2.head();
                    List xs = list6;
                    Impl impl2 = impl;
                    List list7 = xs;
                    List list8 = list2.$colon$colon((Object)x);
                    impl = impl2;
                    list4 = list7;
                    list2 = list8;
                }
                throw new MatchError(list3);
            }
            return list2;
        }
    }

    private static final class Uncancelable
    extends StackedCancelable {
        @Override
        public void cancel() {
        }

        @Override
        public boolean isCanceled() {
            return false;
        }

        @Override
        public Cancelable pop() {
            return Cancelable$.MODULE$.empty();
        }

        @Override
        public void pushList(List<Cancelable> list) {
        }

        @Override
        public void push(Cancelable value) {
        }

        @Override
        public Cancelable popAndPushList(List<Cancelable> list) {
            return Cancelable$.MODULE$.empty();
        }

        @Override
        public Cancelable popAndPush(Cancelable value) {
            return Cancelable$.MODULE$.empty();
        }
    }
}

