/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internal;

import java.io.Serializable;
import monix.execution.atomic.AtomicAny;
import monix.execution.atomic.AtomicAny$;
import monix.execution.atomic.PaddingStrategy;
import monix.execution.internal.Constants$;
import monix.execution.internal.GenericSemaphore$;
import monix.execution.internal.GenericSemaphore$State$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Queue;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Either;

public abstract class GenericSemaphore<CancelToken>
implements Serializable {
    private final AtomicAny<State> stateRef;
    private final Function1<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>, BoxedUnit> cancelAwaitRelease;

    public GenericSemaphore(long provisioned, PaddingStrategy ps) {
        Predef$.MODULE$.require(provisioned >= 0L, GenericSemaphore::$init$$$anonfun$1);
        this.stateRef = AtomicAny$.MODULE$.withPadding(GenericSemaphore$.MODULE$.monix$execution$internal$GenericSemaphore$$$initialState(provisioned), ps);
        this.cancelAwaitRelease = (JProcedure1 & Serializable)p -> this.loop$1((Function1)p);
    }

    public abstract CancelToken emptyCancelable();

    public abstract CancelToken makeCancelable(Function1<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>, BoxedUnit> var1, Function1<Either<Throwable, BoxedUnit>, BoxedUnit> var2);

    public final long unsafeAvailable() {
        return this.stateRef.get().available();
    }

    public final long unsafeCount() {
        return this.stateRef.get().count();
    }

    public final CancelToken unsafeAcquireN(long n, Function1<Either<Throwable, BoxedUnit>, BoxedUnit> await) {
        CancelToken CancelToken;
        block4: {
            State state;
            block3: {
                GenericSemaphore genericSemaphore = this;
                while (true) {
                    if (n < 0L) {
                        throw Scala3RunTime$.MODULE$.assertFailed((Object)"n must be positive");
                    }
                    state = genericSemaphore.stateRef.get();
                    if (state == null) break block3;
                    State state2 = GenericSemaphore$State$.MODULE$.unapply(state);
                    long l = state2._1();
                    Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> queue = state2._2();
                    List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> list = state2._3();
                    long available = l;
                    Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> awaitPermits = queue;
                    State current = state;
                    long stillAvailable = available - n;
                    if (stillAvailable >= 0L) {
                        State update = current.copy(stillAvailable, current.copy$default$2(), current.copy$default$3());
                        if (!genericSemaphore.stateRef.compareAndSet(current, update)) continue;
                        await.apply(Constants$.MODULE$.eitherOfUnit());
                        CancelToken = genericSemaphore.emptyCancelable();
                        break block4;
                    }
                    Tuple2 tuple = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(-stillAvailable)), await);
                    State update = current.copy(0L, (Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>>)awaitPermits.enqueue((Object)tuple), current.copy$default$3());
                    if (genericSemaphore.stateRef.compareAndSet(current, update)) break;
                }
                CancelToken = genericSemaphore.makeCancelable(genericSemaphore.cancelAcquisition(n, false), await);
                break block4;
            }
            throw new MatchError((Object)state);
        }
        return CancelToken;
    }

    public final CancelToken unsafeAsyncAcquireN(long n, Function1<Either<Throwable, BoxedUnit>, BoxedUnit> await) {
        CancelToken CancelToken;
        block4: {
            State state;
            block3: {
                GenericSemaphore genericSemaphore = this;
                while (true) {
                    if (n < 0L) {
                        throw Scala3RunTime$.MODULE$.assertFailed((Object)"n must be positive");
                    }
                    state = genericSemaphore.stateRef.get();
                    if (state == null) break block3;
                    State state2 = GenericSemaphore$State$.MODULE$.unapply(state);
                    long l = state2._1();
                    Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> queue = state2._2();
                    List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> list = state2._3();
                    long available = l;
                    Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> awaitPermits = queue;
                    State current = state;
                    long stillAvailable = available - n;
                    if (stillAvailable >= 0L) {
                        State update = current.copy(stillAvailable, current.copy$default$2(), current.copy$default$3());
                        if (!genericSemaphore.stateRef.compareAndSet(current, update)) continue;
                        await.apply(Constants$.MODULE$.eitherOfUnit());
                        CancelToken = genericSemaphore.makeCancelable(genericSemaphore.cancelAcquisition(n, true), await);
                        break block4;
                    }
                    Tuple2 tuple = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(-stillAvailable)), await);
                    State update = current.copy(0L, (Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>>)awaitPermits.enqueue((Object)tuple), current.copy$default$3());
                    if (genericSemaphore.stateRef.compareAndSet(current, update)) break;
                }
                CancelToken = genericSemaphore.makeCancelable(genericSemaphore.cancelAcquisition(n, true), await);
                break block4;
            }
            throw new MatchError((Object)state);
        }
        return CancelToken;
    }

    public final boolean unsafeTryAcquireN(long n) {
        boolean bl;
        block3: {
            State state;
            GenericSemaphore genericSemaphore = this;
            while ((state = genericSemaphore.stateRef.get()) != null) {
                State state2 = GenericSemaphore$State$.MODULE$.unapply(state);
                long l = state2._1();
                Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> queue = state2._2();
                List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> list = state2._3();
                long available = l;
                State current = state;
                long stillAvailable = available - n;
                if (stillAvailable >= 0L) {
                    State update = current.copy(stillAvailable, current.copy$default$2(), current.copy$default$3());
                    if (!genericSemaphore.stateRef.compareAndSet(current, update)) continue;
                    bl = true;
                } else {
                    bl = false;
                }
                break block3;
            }
            throw new MatchError((Object)state);
        }
        return bl;
    }

    public final void unsafeReleaseN(long n) {
        block14: {
            State state;
            GenericSemaphore genericSemaphore = this;
            long l = n;
            while (true) {
                if (l < 0L) {
                    throw Scala3RunTime$.MODULE$.assertFailed((Object)"n must be positive");
                }
                state = genericSemaphore.stateRef.get();
                if (state == null) break;
                State state2 = GenericSemaphore$State$.MODULE$.unapply(state);
                long l2 = state2._1();
                Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> queue = state2._2();
                List list = state2._3();
                long available = l2;
                Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> promises = queue;
                List awaitReleases = list;
                State current = state;
                if (promises.isEmpty()) {
                    Tuple2 tuple2;
                    List list2;
                    long available2 = available + l;
                    Option<Tuple2<List<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>, List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>>>> triggeredReleases = current.triggerAwaitReleases(available2);
                    Nil$ promisesAwaitingRelease = package$.MODULE$.Nil();
                    Option<Tuple2<List<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>, List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>>>> option = triggeredReleases;
                    if (None$.MODULE$.equals(option)) {
                        list2 = awaitReleases;
                    } else if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                        List list3 = (List)tuple2._1();
                        List newValue = (List)tuple2._2();
                        promisesAwaitingRelease = list3;
                        list2 = newValue;
                    } else {
                        throw new MatchError(option);
                    }
                    List awaitReleases2 = list2;
                    State update = current.copy(available2, current.copy$default$2(), awaitReleases2);
                    if (!genericSemaphore.stateRef.compareAndSet(current, update)) continue;
                    if (promisesAwaitingRelease != package$.MODULE$.Nil()) {
                        genericSemaphore.triggerAll((Seq<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>)promisesAwaitingRelease);
                    }
                } else {
                    Tuple2 tuple2;
                    Tuple2 tuple22;
                    Tuple2 tuple23 = tuple22 = promises.nonEmpty() ? promises.dequeue() : Tuple2$.MODULE$.apply(null, promises);
                    if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
                        throw new MatchError((Object)tuple22);
                    }
                    long c = BoxesRunTime.unboxToLong((Object)tuple2._1());
                    Function1 cb = (Function1)tuple2._2();
                    Queue newPromises = (Queue)tuple22._2();
                    Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)c), (Object)cb, (Object)newPromises);
                    long c2 = BoxesRunTime.unboxToLong((Object)tuple3._1());
                    Function1 cb2 = (Function1)tuple3._2();
                    Queue newPromises2 = (Queue)tuple3._3();
                    if (c2 <= l) {
                        long rem = l - c2;
                        State update = current.copy(current.copy$default$1(), (Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>>)newPromises2, current.copy$default$3());
                        if (!genericSemaphore.stateRef.compareAndSet(current, update)) continue;
                        cb2.apply(Constants$.MODULE$.eitherOfUnit());
                        if (rem > 0L) {
                            GenericSemaphore genericSemaphore2 = genericSemaphore;
                            long l3 = rem;
                            genericSemaphore = genericSemaphore2;
                            l = l3;
                            continue;
                        }
                    } else {
                        List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> list4;
                        long rem = c2 - l;
                        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)rem), (Object)cb2);
                        Queue queue2 = (Queue)newPromises2.$plus$colon((Object)tuple24);
                        long l4 = current.copy$default$1();
                        State update = current.copy(l4, (Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>>)queue2, list4 = current.copy$default$3());
                        if (!genericSemaphore.stateRef.compareAndSet(current, update)) {
                            continue;
                        }
                    }
                }
                break block14;
                break;
            }
            throw new MatchError((Object)state);
        }
    }

    public final CancelToken unsafeAwaitAvailable(long n, Function1<Either<Throwable, BoxedUnit>, BoxedUnit> await) {
        CancelToken CancelToken;
        block3: {
            State state;
            GenericSemaphore genericSemaphore = this;
            while ((state = genericSemaphore.stateRef.get()) != null) {
                State state2 = GenericSemaphore$State$.MODULE$.unapply(state);
                long l = state2._1();
                Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> queue = state2._2();
                List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> list = state2._3();
                long available = l;
                List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> awaitReleases = list;
                State current = state;
                if (available >= n) {
                    await.apply(Constants$.MODULE$.eitherOfUnit());
                    CancelToken = genericSemaphore.emptyCancelable();
                } else {
                    Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> queue2;
                    Long l2 = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)n));
                    Tuple2 tuple2 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l2, await);
                    List list2 = awaitReleases.$colon$colon((Object)tuple2);
                    long l3 = current.copy$default$1();
                    State update = current.copy(l3, queue2 = current.copy$default$2(), (List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>>)list2);
                    if (!genericSemaphore.stateRef.compareAndSet(current, update)) continue;
                    CancelToken = genericSemaphore.makeCancelable(genericSemaphore.cancelAwaitRelease, await);
                }
                break block3;
            }
            throw new MatchError((Object)state);
        }
        return CancelToken;
    }

    private final void triggerAll(Seq<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>> promises) {
        Iterator cursor = promises.iterator();
        while (cursor.hasNext()) {
            ((Function1)cursor.next()).apply(Constants$.MODULE$.eitherOfUnit());
        }
    }

    private Function1<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>, BoxedUnit> cancelAcquisition(long n, boolean isAsync) {
        return (JProcedure1 & Serializable)permit -> this.loop$2(n, isAsync, (Function1)permit);
    }

    private static final String $init$$$anonfun$1() {
        return "provisioned >= 0";
    }

    private final void loop$1(Function1 p) {
        State update;
        State current;
        while (!this.stateRef.compareAndSet(current = this.stateRef.get(), update = current.removeAwaitReleaseRef((Function1<Either<Throwable, BoxedUnit>, BoxedUnit>)p))) {
        }
    }

    private final void loop$2(long n$1, boolean isAsync$1, Function1 permit) {
        block4: {
            Option option;
            block5: {
                long m;
                State update;
                State current;
                do {
                    Tuple2 tuple2;
                    if (None$.MODULE$.equals(option = (current = this.stateRef.get()).awaitPermits().find((Function1 & Serializable)_$1 -> _$1._2() == permit))) {
                        if (isAsync$1) {
                            this.unsafeReleaseN(n$1);
                        }
                        break block4;
                    }
                    if (!(option instanceof Some) || (tuple2 = (Tuple2)((Some)option).value()) == null) break block5;
                    m = BoxesRunTime.unboxToLong((Object)tuple2._1());
                } while (!this.stateRef.compareAndSet(current, update = current.removeAwaitPermitRef((Function1<Either<Throwable, BoxedUnit>, BoxedUnit>)permit)));
                if (n$1 > m) {
                    this.unsafeReleaseN(n$1 - m);
                }
                break block4;
            }
            throw new MatchError((Object)option);
        }
    }

    private static final class State
    implements Product,
    Serializable {
        private final long available;
        private final Queue awaitPermits;
        private final List awaitReleases;

        public static State apply(long l, Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> queue, List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> list) {
            return GenericSemaphore$State$.MODULE$.apply(l, queue, list);
        }

        public static State fromProduct(Product product) {
            return GenericSemaphore$State$.MODULE$.fromProduct(product);
        }

        public static State unapply(State state) {
            return GenericSemaphore$State$.MODULE$.unapply(state);
        }

        public State(long available, Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> awaitPermits, List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> awaitReleases) {
            this.available = available;
            this.awaitPermits = awaitPermits;
            this.awaitReleases = awaitReleases;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.available()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.awaitPermits()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.awaitReleases()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.available() != state.available()) return false;
            Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> queue = this.awaitPermits();
            Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> queue2 = state.awaitPermits();
            if (queue == null) {
                if (queue2 != null) {
                    return false;
                }
            } else if (!queue.equals(queue2)) return false;
            List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> list = this.awaitReleases();
            List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> list2 = state.awaitReleases();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToLong((long)this._1());
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "available";
                    break;
                }
                case 1: {
                    string = "awaitPermits";
                    break;
                }
                case 2: {
                    string = "awaitReleases";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public long available() {
            return this.available;
        }

        public Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> awaitPermits() {
            return this.awaitPermits;
        }

        public List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> awaitReleases() {
            return this.awaitReleases;
        }

        public long count() {
            return this.available() > 0L ? this.available() : -BoxesRunTime.unboxToLong((Object)((IterableOnceOps)this.awaitPermits().map((Function1 & Serializable)_$2 -> BoxesRunTime.unboxToLong((Object)_$2._1()))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }

        public State removeAwaitPermitRef(Function1<Either<Throwable, BoxedUnit>, BoxedUnit> p) {
            Queue queue = (Queue)this.awaitPermits().filter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Function1 ref = (Function1)tuple2._2();
                return ref != p;
            });
            long l = this.copy$default$1();
            List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> list = this.copy$default$3();
            return this.copy(l, (Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>>)queue, list);
        }

        public State removeAwaitReleaseRef(Function1<Either<Throwable, BoxedUnit>, BoxedUnit> p) {
            List list = this.awaitReleases().filter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Function1 ref = (Function1)tuple2._2();
                return ref != p;
            });
            long l = this.copy$default$1();
            Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> queue = this.copy$default$2();
            return this.copy(l, queue, (List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>>)list);
        }

        public Option<Tuple2<List<Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>, List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>>>> triggerAwaitReleases(long available2) {
            None$ none$;
            if (available2 < 0L) {
                throw Scala3RunTime$.MODULE$.assertFailed((Object)"n >= 0");
            }
            if (available2 == 0L) {
                none$ = None$.MODULE$;
            } else {
                List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> list = this.awaitReleases();
                Nil$ nil$ = package$.MODULE$.Nil();
                List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> list2 = list;
                if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
                    none$ = None$.MODULE$;
                } else {
                    List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> list3 = list;
                    Iterator cursor = list3.iterator();
                    List toComplete = package$.MODULE$.List().empty();
                    List toKeep = package$.MODULE$.List().empty();
                    while (cursor.hasNext()) {
                        Tuple2 ref = (Tuple2)cursor.next();
                        Tuple2 tuple2 = ref;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        long awaits = BoxesRunTime.unboxToLong((Object)tuple2._1());
                        Function1 p = (Function1)tuple2._2();
                        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)awaits), (Object)p);
                        long awaits2 = BoxesRunTime.unboxToLong((Object)tuple22._1());
                        Function1 p2 = (Function1)tuple22._2();
                        if (awaits2 <= available2) {
                            toComplete = toComplete.$colon$colon((Object)p2);
                            continue;
                        }
                        toKeep = toKeep.$colon$colon((Object)ref);
                    }
                    none$ = Some$.MODULE$.apply((Object)Tuple2$.MODULE$.apply((Object)toComplete, (Object)toKeep));
                }
            }
            return none$;
        }

        public State copy(long available, Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> awaitPermits, List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> awaitReleases) {
            return new State(available, awaitPermits, awaitReleases);
        }

        public long copy$default$1() {
            return this.available();
        }

        public Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> copy$default$2() {
            return this.awaitPermits();
        }

        public List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> copy$default$3() {
            return this.awaitReleases();
        }

        public long _1() {
            return this.available();
        }

        public Queue<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> _2() {
            return this.awaitPermits();
        }

        public List<Tuple2<Object, Function1<Either<Throwable, BoxedUnit>, BoxedUnit>>> _3() {
            return this.awaitReleases();
        }
    }
}

