/*
 * Decompiled with CFR 0.152.
 */
package monix.execution.internal.collection.queues;

import java.util.concurrent.ConcurrentLinkedQueue;
import monix.execution.BufferCapacity;
import monix.execution.BufferCapacity$Bounded$;
import monix.execution.BufferCapacity$Unbounded$;
import monix.execution.ChannelType;
import monix.execution.ChannelType$MPMC$;
import monix.execution.ChannelType$MPSC$;
import monix.execution.ChannelType$SPMC$;
import monix.execution.ChannelType$SPSC$;
import monix.execution.internal.Platform$;
import monix.execution.internal.atomic.UnsafeAccess;
import monix.execution.internal.collection.LowLevelConcurrentQueue;
import monix.execution.internal.collection.queues.FromCircularQueue$;
import monix.execution.internal.collection.queues.FromJavaQueue;
import monix.execution.internal.collection.queues.FromMessagePassingQueue$;
import monix.execution.internal.jctools.queues.MpmcArrayQueue;
import monix.execution.internal.jctools.queues.MpscArrayQueue;
import monix.execution.internal.jctools.queues.MpscUnboundedArrayQueue;
import monix.execution.internal.jctools.queues.SpmcArrayQueue;
import monix.execution.internal.jctools.queues.SpscArrayQueue;
import monix.execution.internal.jctools.queues.SpscUnboundedArrayQueue;
import monix.execution.internal.jctools.queues.atomic.MpmcAtomicArrayQueue;
import monix.execution.internal.jctools.queues.atomic.MpscAtomicArrayQueue;
import monix.execution.internal.jctools.queues.atomic.MpscUnboundedAtomicArrayQueue;
import monix.execution.internal.jctools.queues.atomic.SpmcAtomicArrayQueue;
import monix.execution.internal.jctools.queues.atomic.SpscAtomicArrayQueue;
import monix.execution.internal.jctools.queues.atomic.SpscUnboundedAtomicArrayQueue;
import scala.MatchError;
import scala.Option;
import scala.runtime.BoxesRunTime;

public interface LowLevelConcurrentQueueBuilders {
    public static LowLevelConcurrentQueue apply$(LowLevelConcurrentQueueBuilders $this, BufferCapacity capacity, ChannelType channelType, boolean fenced) {
        return $this.apply(capacity, channelType, fenced);
    }

    default public <A> LowLevelConcurrentQueue<A> apply(BufferCapacity capacity, ChannelType channelType, boolean fenced) {
        LowLevelConcurrentQueue<A> lowLevelConcurrentQueue;
        BufferCapacity bufferCapacity = capacity;
        if (bufferCapacity instanceof BufferCapacity.Bounded) {
            int n;
            BufferCapacity.Bounded bounded = BufferCapacity$Bounded$.MODULE$.unapply((BufferCapacity.Bounded)bufferCapacity);
            int c = n = bounded._1();
            lowLevelConcurrentQueue = this.bounded(c, channelType, fenced);
        } else if (bufferCapacity instanceof BufferCapacity.Unbounded) {
            Option<Object> option;
            BufferCapacity.Unbounded unbounded = BufferCapacity$Unbounded$.MODULE$.unapply((BufferCapacity.Unbounded)bufferCapacity);
            Option<Object> hint = option = unbounded._1();
            lowLevelConcurrentQueue = this.unbounded(hint, channelType, fenced);
        } else {
            throw new MatchError((Object)bufferCapacity);
        }
        return lowLevelConcurrentQueue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <A> LowLevelConcurrentQueue<A> bounded(int capacity, ChannelType ct, boolean fenced) {
        LowLevelConcurrentQueue lowLevelConcurrentQueue;
        if (UnsafeAccess.IS_OPENJDK_COMPATIBLE) {
            if (UnsafeAccess.HAS_JAVA8_INTRINSICS || !fenced) {
                ChannelType channelType = ct;
                if (ChannelType$MPMC$.MODULE$.equals(channelType)) {
                    lowLevelConcurrentQueue = FromCircularQueue$.MODULE$.apply(new MpmcArrayQueue(capacity), ct);
                    return lowLevelConcurrentQueue;
                } else if (ChannelType$MPSC$.MODULE$.equals(channelType)) {
                    lowLevelConcurrentQueue = FromCircularQueue$.MODULE$.apply(new MpscArrayQueue(capacity), ct);
                    return lowLevelConcurrentQueue;
                } else if (ChannelType$SPMC$.MODULE$.equals(channelType)) {
                    lowLevelConcurrentQueue = FromCircularQueue$.MODULE$.apply(new SpmcArrayQueue(capacity), ct);
                    return lowLevelConcurrentQueue;
                } else {
                    if (!ChannelType$SPSC$.MODULE$.equals(channelType)) throw new MatchError((Object)channelType);
                    lowLevelConcurrentQueue = FromCircularQueue$.MODULE$.apply(new SpscArrayQueue(capacity), ct);
                }
                return lowLevelConcurrentQueue;
            } else {
                lowLevelConcurrentQueue = FromCircularQueue$.MODULE$.apply(new MpmcArrayQueue(capacity), ct);
            }
            return lowLevelConcurrentQueue;
        } else if (UnsafeAccess.HAS_JAVA8_INTRINSICS || !fenced) {
            ChannelType channelType = ct;
            if (ChannelType$MPMC$.MODULE$.equals(channelType)) {
                lowLevelConcurrentQueue = FromMessagePassingQueue$.MODULE$.apply(new MpmcAtomicArrayQueue(capacity), ct);
                return lowLevelConcurrentQueue;
            } else if (ChannelType$MPSC$.MODULE$.equals(channelType)) {
                lowLevelConcurrentQueue = FromMessagePassingQueue$.MODULE$.apply(new MpscAtomicArrayQueue(capacity), ct);
                return lowLevelConcurrentQueue;
            } else if (ChannelType$SPMC$.MODULE$.equals(channelType)) {
                lowLevelConcurrentQueue = FromMessagePassingQueue$.MODULE$.apply(new SpmcAtomicArrayQueue(capacity), ct);
                return lowLevelConcurrentQueue;
            } else {
                if (!ChannelType$SPSC$.MODULE$.equals(channelType)) throw new MatchError((Object)channelType);
                lowLevelConcurrentQueue = FromMessagePassingQueue$.MODULE$.apply(new SpscAtomicArrayQueue(capacity), ct);
            }
            return lowLevelConcurrentQueue;
        } else {
            lowLevelConcurrentQueue = FromMessagePassingQueue$.MODULE$.apply(new MpmcAtomicArrayQueue(capacity), ct);
        }
        return lowLevelConcurrentQueue;
    }

    private <A> LowLevelConcurrentQueue<A> unbounded(Option<Object> chunkSize, ChannelType ct, boolean fenced) {
        ChannelType channelType;
        ChannelType channelType2;
        int chunk = BoxesRunTime.unboxToInt((Object)chunkSize.getOrElse(LowLevelConcurrentQueueBuilders::$anonfun$1));
        LowLevelConcurrentQueue<Object> lowLevelConcurrentQueue = UnsafeAccess.IS_OPENJDK_COMPATIBLE ? (UnsafeAccess.HAS_JAVA8_INTRINSICS || !fenced ? (ChannelType$MPSC$.MODULE$.equals(channelType2 = ct) ? FromMessagePassingQueue$.MODULE$.apply(new MpscUnboundedArrayQueue(chunk), ct) : (ChannelType$SPSC$.MODULE$.equals(channelType2) ? FromMessagePassingQueue$.MODULE$.apply(new SpscUnboundedArrayQueue(chunk), ct) : new FromJavaQueue(new ConcurrentLinkedQueue()))) : new FromJavaQueue(new ConcurrentLinkedQueue())) : (UnsafeAccess.HAS_JAVA8_INTRINSICS || !fenced ? (ChannelType$MPSC$.MODULE$.equals(channelType = ct) ? FromMessagePassingQueue$.MODULE$.apply(new MpscUnboundedAtomicArrayQueue(chunk), ct) : (ChannelType$SPSC$.MODULE$.equals(channelType) ? FromMessagePassingQueue$.MODULE$.apply(new SpscUnboundedAtomicArrayQueue(chunk), ct) : new FromJavaQueue(new ConcurrentLinkedQueue()))) : new FromJavaQueue(new ConcurrentLinkedQueue()));
        return lowLevelConcurrentQueue;
    }

    private static int $anonfun$1() {
        return Platform$.MODULE$.recommendedBufferChunkSize();
    }
}

