/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.docx;

import ambience.api.DocXEngine;
import ambience.api.ReportEngine;
import ambience.api.Repository;
import ambience.etl.BsonToJson$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.module.UserDB;
import ambience.module.UserDB$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeType$;
import com.elixirtech.arch.MimeTypes$;
import com.elixirtech.arch.Path$;
import io.circe.Decoder$;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import monix.eval.Task;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonString;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class RenderDocXRuntime$
implements Builder,
Serializable {
    private static final String stepType;
    private static final BsonString DocXMimeType;
    public static final RenderDocXRuntime$ MODULE$;

    private RenderDocXRuntime$() {
    }

    static {
        MODULE$ = new RenderDocXRuntime$();
        stepType = ETLStepType$.MODULE$.apply("docx.RenderRuntime");
        DocXMimeType = BsonString$.MODULE$.apply(MimeTypes$.MODULE$.DOCX().value());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RenderDocXRuntime$.class);
    }

    public String stepType() {
        return stepType;
    }

    public BsonString DocXMimeType() {
        return DocXMimeType;
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        return package$.MODULE$.Right().apply((Function1 & Serializable)from -> MODULE$.run(cxt, (Observable<Document>)from));
    }

    public Observable<Document> run(Builder.Context cxt, Observable<Document> from) {
        Task userT = this.getUser(cxt).memoize();
        return from.flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromTask(userT).flatMap((Function1 & Serializable)optUser -> {
            Observable observable;
            Option option = optUser;
            if (option instanceof Some) {
                UserDB.User user = (UserDB.User)((Some)option).value();
                observable = MODULE$.renderReport(cxt, user, (Document)doc);
            } else if (None$.MODULE$.equals(option)) {
                observable = Observable$.MODULE$.fromTask(cxt.logRecord(doc, (LogMessage)LogMessage.Error$.MODULE$.apply("User not found")));
            } else {
                throw new MatchError((Object)option);
            }
            return observable.map((Function1 & Serializable)reply -> reply);
        }));
    }

    public Task<Option<UserDB.User>> getUser(Builder.Context cxt) {
        return UserDB$.MODULE$.filterEnabled(((UserDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(UserDB.class))).getUserById(cxt.credentials().ownerId()));
    }

    public Observable<Document> renderReport(Builder.Context cxt, UserDB.User user, Document doc) {
        Option option = doc.get("docx", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$1 -> _$1.getValue());
        if (option instanceof Some) {
            String docx = (String)((Some)option).value();
            LazyRef lazyRef = new LazyRef();
            LazyRef lazyRef2 = new LazyRef();
            Json params = (Json)BsonToJson$.MODULE$.apply(doc).getOrElse(RenderDocXRuntime$::$anonfun$1);
            MimeType mimeType = this.getMimeType(doc, params);
            Task reply = this.repository$1(lazyRef).readFileT(user, Path$.MODULE$.apply(docx)).flatMap((Function1 & Serializable)data -> this.engine$1(lazyRef2).renderReport(user, ReportEngine.Template$.MODULE$.apply(DataBytes$.MODULE$.apply(data)), mimeType, params).flatMap((Function1 & Serializable)eReport -> {
                Task task;
                Either either = eReport;
                if (either instanceof Right) {
                    ReportEngine.Report report = (ReportEngine.Report)((Right)either).value();
                    task = MODULE$.allBytes((DataBytes)report.bytes()).map((Function1 & Serializable)bytes -> {
                        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"bytes");
                        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonBinary$.MODULE$.apply(bytes)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"mimeType");
                        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply(mimeType.value())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                        return (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    });
                } else if (either instanceof Left) {
                    ReportEngine.Error err = (ReportEngine.Error)((Left)either).value();
                    task = cxt.logRecord(doc, (LogMessage)LogMessage.Error$.MODULE$.apply(err.value()));
                } else {
                    throw new MatchError((Object)either);
                }
                return task.map((Function1 & Serializable)reply -> reply);
            }));
            return Observable$.MODULE$.fromTask(reply);
        }
        if (None$.MODULE$.equals(option)) {
            return Observable$.MODULE$.fromTask(cxt.logRecord(doc, (LogMessage)LogMessage.Debug$.MODULE$.apply("Field named docx expected")));
        }
        throw new MatchError((Object)option);
    }

    public MimeType getMimeType(Document doc, Json params) {
        return (MimeType)this.a$1(doc).orElse(() -> this.getMimeType$$anonfun$1(params)).map((Function1 & Serializable)value -> MimeType$.MODULE$.apply(value)).getOrElse(RenderDocXRuntime$::getMimeType$$anonfun$3);
    }

    public Task<byte[]> allBytes(DataBytes bytes) {
        return bytes.observable().toListL().map((Function1 & Serializable)_$3 -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])_$3.toArray(ClassTag$.MODULE$.apply(Byte.TYPE).wrap()));
            return (byte[])ArrayOps$.MODULE$.flatten$extension(object, (Function1 & Serializable)xs -> Predef$.MODULE$.wrapByteArray(xs), ClassTag$.MODULE$.apply(Byte.TYPE));
        });
    }

    private final Repository repository$lzyINIT1$1(LazyRef repository$lzy1$1) {
        Repository repository;
        LazyRef lazyRef = repository$lzy1$1;
        synchronized (lazyRef) {
            repository = (Repository)(repository$lzy1$1.initialized() ? repository$lzy1$1.value() : repository$lzy1$1.initialize((Object)((Repository)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Repository.class)))));
        }
        return repository;
    }

    private final Repository repository$1(LazyRef repository$lzy1$2) {
        return (Repository)(repository$lzy1$2.initialized() ? repository$lzy1$2.value() : this.repository$lzyINIT1$1(repository$lzy1$2));
    }

    private final DocXEngine engine$lzyINIT1$1(LazyRef engine$lzy1$1) {
        DocXEngine docXEngine;
        LazyRef lazyRef = engine$lzy1$1;
        synchronized (lazyRef) {
            docXEngine = (DocXEngine)(engine$lzy1$1.initialized() ? engine$lzy1$1.value() : engine$lzy1$1.initialize((Object)((DocXEngine)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(DocXEngine.class)))));
        }
        return docXEngine;
    }

    private final DocXEngine engine$1(LazyRef engine$lzy1$2) {
        return (DocXEngine)(engine$lzy1$2.initialized() ? engine$lzy1$2.value() : this.engine$lzyINIT1$1(engine$lzy1$2));
    }

    private static final Json $anonfun$1() {
        return Json$.MODULE$.fromFields((Iterable)package$.MODULE$.Nil());
    }

    private final Option a$1(Document doc$5) {
        return doc$5.get("mimeType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$2 -> _$2.getValue());
    }

    private final Option b$1(Json params$2) {
        return params$2.hcursor().downField("mimeType").as(Decoder$.MODULE$.decodeString()).toOption();
    }

    private final Option getMimeType$$anonfun$1(Json params$3) {
        return this.b$1(params$3);
    }

    private static final MimeType getMimeType$$anonfun$3() {
        return MimeTypes$.MODULE$.DOCX();
    }
}

