/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.external;

import ambience.etl.BuildError;
import ambience.etl.BuildError$;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.Util$;
import ambience.etl.external.RunCommand;
import ambience.etl.external.RunCommand$CommandList$;
import ambience.etl.external.RunCommand$Info$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.kernel.Order;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.util.ConfigUtil$;
import com.typesafe.config.Config;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicInteger;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple6$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.sys.process.Process$;
import scala.sys.process.ProcessLogger;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class RunCommand$
implements Builder,
PanelBuilder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(RunCommand$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final RunCommand$CommandList$ CommandList;
    private static final Map<String, String> programList;
    private static final Scheduler scheduler;
    private static final AtomicInteger concurrentCount;
    public static final RunCommand$Info$ Info;
    private static final Json InfoJson;
    private static final String stepType;
    public static final RunCommand$ MODULE$;

    private RunCommand$() {
    }

    static {
        MODULE$ = new RunCommand$();
        Config cfg = ((Config)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Config.class))).getConfig("ambience.etl.external.run-command.commands");
        programList = ConfigUtil$.MODULE$.getStringMap(cfg);
        int concurrent = ((Config)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Config.class))).getInt("ambience.etl.external.run-command.concurrent");
        scheduler = concurrent > 0 ? Scheduler$.MODULE$.fixedPool("run-command", concurrent, Scheduler$.MODULE$.fixedPool$default$3(), Scheduler$.MODULE$.fixedPool$default$4(), Scheduler$.MODULE$.fixedPool$default$5()) : Scheduler$.MODULE$.global();
        concurrentCount = new AtomicInteger(0);
        RunCommand.Info info = (RunCommand.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)RunCommand$Info$.MODULE$.apply(RunCommand$Info$.MODULE$.$lessinit$greater$default$1(), RunCommand$Info$.MODULE$.$lessinit$greater$default$2(), RunCommand$Info$.MODULE$.$lessinit$greater$default$3(), RunCommand$Info$.MODULE$.$lessinit$greater$default$4(), RunCommand$Info$.MODULE$.$lessinit$greater$default$5(), RunCommand$Info$.MODULE$.$lessinit$greater$default$6()));
        String string = "command";
        String string2 = "arguments";
        String string3 = "workingDirectory";
        String string4 = "outputField";
        String string5 = "errorField";
        String string6 = "exitCodeField";
        InfoJson = package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        stepType = ETLStepType$.MODULE$.apply("external.RunCommand");
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(RunCommand$.class);
    }

    public Json InfoJson() {
        return InfoJson;
    }

    public String stepType() {
        return stepType;
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "command";
        String string2 = "arguments";
        String string3 = "workingDirectory";
        String string4 = "outputField";
        String string5 = "errorField";
        String string6 = "exitCodeField";
        int size = 6;
        RunCommand.Info info = (RunCommand.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", RunCommand$::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), RunCommand$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(RunCommand$::$anonfun$3))))).toOption().getOrElse(RunCommand$::$anonfun$4);
        List choices = ((List)programList.keys().toList().sorted(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForString()))).map((Function1 & Serializable)k -> Panel.SelectChoice$.MODULE$.apply(k, Json$.MODULE$.fromString(k)));
        Panel.Item command = PanelItem$.MODULE$.select("command", "Command", Json$.MODULE$.fromString(info.command()), choices, PanelItem$.MODULE$.select$default$5());
        Panel.Item arguments = PanelItem$.MODULE$.text("arguments", "Arguments", info.arguments(), PanelItem$.MODULE$.text$default$4());
        Panel.Item workingDirectory = PanelItem$.MODULE$.text("workingDirectory", "Working Directory", info.workingDirectory(), PanelItem$.MODULE$.text$default$4());
        Panel.Item outputField = PanelItem$.MODULE$.text("outputField", "Output Field", info.outputField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item errorField = PanelItem$.MODULE$.text("errorField", "Error Field", info.errorField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item exitCodeField = PanelItem$.MODULE$.text("exitCodeField", "Exit Code Field", info.exitCodeField(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.apply(() -> RunCommand$.buildPanel$$anonfun$1(command, arguments, workingDirectory, outputField, errorField, exitCodeField));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> RunCommand$.savePanel$$anonfun$1(results, step));
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "command";
        String string2 = "arguments";
        String string3 = "workingDirectory";
        String string4 = "outputField";
        String string5 = "errorField";
        String string6 = "exitCodeField";
        int size = 6;
        Either either = this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", RunCommand$::build$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), RunCommand$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(RunCommand$::build$$anonfun$3)))));
        if (either instanceof Right) {
            RunCommand.Info info = (RunCommand.Info)((Right)either).value();
            Option option = programList.get((Object)info.command());
            if (option instanceof Some) {
                String command = (String)((Some)option).value();
                return package$.MODULE$.Right().apply((Function1 & Serializable)from -> MODULE$.run(cxt, info, command, (Observable<Document>)from));
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)BuildError$.MODULE$.apply("Invalid command " + info.command(), (Option)Some$.MODULE$.apply((Object)step), BuildError$.MODULE$.$lessinit$greater$default$3()));
            }
            throw new MatchError((Object)option);
        }
        if (either instanceof Left) {
            DecodingFailure err = (DecodingFailure)((Left)either).value();
            return package$.MODULE$.Left().apply((Object)this.error(step, err));
        }
        throw new MatchError((Object)either);
    }

    public Observable<Document> run(Builder.Context cxt, RunCommand.Info info, String command, Observable<Document> from) {
        return from.flatMap((Function1 & Serializable)doc -> MODULE$.getWorkingDirectory(cxt, info).flatMap((Function1 & Serializable)workingDirectory -> MODULE$.runCommand(cxt, info, command, (Option<File>)workingDirectory, (Document)doc).map((Function1 & Serializable)result -> result)));
    }

    public Observable<Option<File>> getWorkingDirectory(Builder.Context cxt, RunCommand.Info info) {
        if (info.workingDirectory().isEmpty()) {
            return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new None$[]{None$.MODULE$}));
        }
        File test = new File(info.workingDirectory());
        if (test.exists() && test.isDirectory()) {
            return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Some[]{Some$.MODULE$.apply((Object)test)}));
        }
        String msg = "Can't access working directory " + test.getAbsolutePath();
        return Observable$.MODULE$.fromTask(cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply(msg))).flatMap((Function1 & Serializable)_$1 -> Observable$.MODULE$.raiseError((Throwable)new RuntimeException(msg)));
    }

    public Observable<Document> runCommand(Builder.Context cxt, RunCommand.Info info, String command, Option<File> workingDirectory, Document doc) {
        Observable observable;
        try {
            String fullCommand = command + " " + this.substitute(info.arguments().trim(), doc);
            String wdPath = (String)workingDirectory.map((Function1 & Serializable)_$2 -> _$2.getAbsolutePath()).getOrElse(RunCommand$::$anonfun$8);
            Task out = Task$.MODULE$.apply(RunCommand$::$anonfun$9).flatMap((Function1 & Serializable)currentCount -> RunCommand$.$anonfun$10(fullCommand, wdPath, cxt, info, workingDirectory, doc, BoxesRunTime.unboxToInt((Object)currentCount)));
            observable = Observable$.MODULE$.fromTask(out.executeOn(scheduler, out.executeOn$default$2()));
        }
        catch (Exception e) {
            observable = Observable$.MODULE$.fromTask(cxt.logT((LogMessage)LogMessage.Error$.MODULE$.apply("Exception: " + e))).flatMap((Function1 & Serializable)_$3 -> Observable$.MODULE$.raiseError((Throwable)e));
        }
        return observable;
    }

    public String substitute(String params, Document doc) {
        return Util$.MODULE$.substituteDocumentValues(params, doc);
    }

    /*
     * WARNING - void declaration
     */
    private final List $init$$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        Encoder encodeA5;
        void var2_1;
        Encoder encodeA6 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA5 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA4 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder4 = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder5 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder5).$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        void var3_2;
        void var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA6 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$2() {
        RunCommand$Info$ runCommand$Info$ = RunCommand$Info$.MODULE$;
        return (Function1 & Serializable)p -> (RunCommand.Info)runCommand$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple6$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$5()), (Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$6()));
    }

    private static final RunCommand.Info $anonfun$4() {
        return RunCommand$Info$.MODULE$.apply(RunCommand$Info$.MODULE$.$lessinit$greater$default$1(), RunCommand$Info$.MODULE$.$lessinit$greater$default$2(), RunCommand$Info$.MODULE$.$lessinit$greater$default$3(), RunCommand$Info$.MODULE$.$lessinit$greater$default$4(), RunCommand$Info$.MODULE$.$lessinit$greater$default$5(), RunCommand$Info$.MODULE$.$lessinit$greater$default$6());
    }

    private static final Panel buildPanel$$anonfun$1(Panel.Item command$1, Panel.Item arguments$1, Panel.Item workingDirectory$1, Panel.Item outputField$1, Panel.Item errorField$1, Panel.Item exitCodeField$1) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)command$1, (List)new .colon.colon((Object)arguments$1, (List)new .colon.colon((Object)workingDirectory$1, (List)new .colon.colon((Object)outputField$1, (List)new .colon.colon((Object)errorField$1, (List)new .colon.colon((Object)exitCodeField$1, (List)Nil$.MODULE$)))))));
    }

    /*
     * WARNING - void declaration
     */
    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        void var3_2;
        void var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA6 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        RunCommand$Info$ runCommand$Info$ = RunCommand$Info$.MODULE$;
        return (Function1 & Serializable)p -> (RunCommand.Info)runCommand$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple6$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$5()), (Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$6()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$6() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        void var3_2;
        void var1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA6 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA4 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder4 = encodeA = Encoder$.MODULE$.encodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$1) {
        String string = "command";
        String string2 = "arguments";
        String string3 = "workingDirectory";
        String string4 = "outputField";
        String string5 = "errorField";
        String string6 = "exitCodeField";
        int size = 6;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", RunCommand$::savePanel$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), RunCommand$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(RunCommand$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            RunCommand.Info info2 = (RunCommand.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "command";
            String string2 = "arguments";
            String string3 = "workingDirectory";
            String string4 = "outputField";
            String string5 = "errorField";
            String string6 = "exitCodeField";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(RunCommand$::$anonfun$6, package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string7 = step$1.copy$default$1();
            String string8 = step$1.copy$default$2();
            String string9 = step$1.copy$default$3();
            String string10 = step$1.copy$default$4();
            String string11 = step$1.copy$default$5();
            boolean bl = step$1.copy$default$7();
            boolean bl2 = step$1.copy$default$8();
            return step$1.copy(string7, string8, string9, string10, string11, json, bl, bl2);
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final List build$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        void var3_2;
        void var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA6 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeString();
        return package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 build$$anonfun$2() {
        RunCommand$Info$ runCommand$Info$ = RunCommand$Info$.MODULE$;
        return (Function1 & Serializable)p -> (RunCommand.Info)runCommand$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple6$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$5()), (Object)Some$.MODULE$.apply((Object)RunCommand$Info$.MODULE$.$lessinit$greater$default$6()));
    }

    private static final String $anonfun$8() {
        return "current directory";
    }

    private static final int $anonfun$9() {
        return concurrentCount.incrementAndGet();
    }

    private static final Object $anonfun$10$$anonfun$1$$anonfun$1(int currentCount$2, String fullCommand$2, String wdPath$2) {
        return "Running external command (concurrentCount=" + currentCount$2 + "): " + fullCommand$2 + " in " + wdPath$2;
    }

    private static final void $anonfun$10$$anonfun$1(int currentCount$1, String fullCommand$1, String wdPath$1) {
        MODULE$.log().info(() -> RunCommand$.$anonfun$10$$anonfun$1$$anonfun$1(currentCount$1, fullCommand$1, wdPath$1), Line$.MODULE$.apply(105), FullName$.MODULE$.apply("ambience.etl.external.RunCommand.out"));
    }

    private static final RunCommand.MyProcessLogger $anonfun$10$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(Builder.Context cxt$8, RunCommand.Info info$8) {
        return new RunCommand.MyProcessLogger(cxt$8, info$8);
    }

    private static final int $anonfun$10$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(String fullCommand$8, Option workingDirectory$7, RunCommand.MyProcessLogger myLogger$1) {
        return Process$.MODULE$.apply(fullCommand$8, workingDirectory$7, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])).$bang((ProcessLogger)myLogger$1);
    }

    private static final int $anonfun$10$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1() {
        return concurrentCount.decrementAndGet();
    }

    private static final /* synthetic */ Task $anonfun$10$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2(Builder.Context cxt$11, int exitCode$1, RunCommand.MyProcessLogger myLogger$3, Document doc$8, int x$12) {
        int n = x$12;
        return cxt$11.logT((LogMessage)LogMessage.Debug$.MODULE$.apply("Exit code: " + exitCode$1)).map((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return myLogger$3.augmentAndClose(doc$8, exitCode$1);
        });
    }

    private static final /* synthetic */ Task $anonfun$10$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(Builder.Context cxt$10, RunCommand.MyProcessLogger myLogger$2, Document doc$7, int exitCode) {
        return Task$.MODULE$.apply(RunCommand$::$anonfun$10$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$1).flatMap((Function1 & Serializable)x$1 -> RunCommand$.$anonfun$10$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2$$anonfun$2(cxt$10, exitCode, myLogger$2, doc$7, BoxesRunTime.unboxToInt((Object)x$1)));
    }

    private static final /* synthetic */ Task $anonfun$10(String fullCommand$3, String wdPath$3, Builder.Context cxt$4, RunCommand.Info info$4, Option workingDirectory$2, Document doc$2, int currentCount) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            RunCommand$.$anonfun$10$$anonfun$1(currentCount, fullCommand$3, wdPath$3);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return cxt$4.logT((LogMessage)LogMessage.Debug$.MODULE$.apply("Working directory: " + wdPath$3)).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return cxt$4.logT((LogMessage)LogMessage.Debug$.MODULE$.apply(fullCommand$3)).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return Task$.MODULE$.apply(() -> RunCommand$.$anonfun$10$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(cxt$4, info$4)).flatMap((Function1 & Serializable)myLogger -> Task$.MODULE$.apply(() -> RunCommand$.$anonfun$10$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$1(fullCommand$3, workingDirectory$2, myLogger)).flatMap((Function1 & Serializable)exitCode -> RunCommand$.$anonfun$10$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2$$anonfun$2(cxt$4, myLogger, doc$2, BoxesRunTime.unboxToInt((Object)exitCode))));
                });
            });
        });
    }
}

