/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.file;

import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.DataInUrl$;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.file.FileCategory$;
import ambience.etl.file.FileChunkReader;
import ambience.etl.file.FileChunkReader$Chunk$;
import ambience.etl.file.FileChunkReader$Info$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelperT;
import com.elixirtech.arch.LoggingInterfaceT;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonString;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public final class FileChunkReader$
implements Builder,
PanelBuilder,
LoggingHelperT,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(FileChunkReader$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final FileChunkReader$Info$ Info;
    public static final FileChunkReader$Chunk$ Chunk;
    private static final String stepType;
    public static final FileChunkReader$ MODULE$;

    private FileChunkReader$() {
    }

    static {
        MODULE$ = new FileChunkReader$();
        stepType = ETLStepType$.MODULE$.apply("file.FileChunkReader");
    }

    public LoggingInterfaceT log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterfaceT) {
            return (LoggingInterfaceT)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterfaceT)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterfaceT loggingInterfaceT = null;
                    try {
                        loggingInterfaceT = LoggingHelperT.log$((LoggingHelperT)this);
                        object2 = loggingInterfaceT == null ? LazyVals.NullValue$.MODULE$ : loggingInterfaceT;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterfaceT;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FileChunkReader$.class);
    }

    public String stepType() {
        return stepType;
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "file";
        String string2 = "chunkKb";
        int size = 2;
        Either either = implicits$.MODULE$.catsSyntaxEither(step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", FileChunkReader$::build$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), FileChunkReader$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(FileChunkReader$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> MODULE$.run(cxt, (FileChunkReader.Info)info, (Observable<Document>)from));
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "file";
        String string2 = "chunkKb";
        int size = 2;
        FileChunkReader.Info info = (FileChunkReader.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", FileChunkReader$::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), FileChunkReader$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(FileChunkReader$::$anonfun$3))))).toOption().getOrElse(FileChunkReader$::$anonfun$4);
        Panel.Item file = PanelItem$.MODULE$.text("file", "File", info.file(), this.loadChoices());
        Panel.Item size2 = PanelItem$.MODULE$.integer("chunkKb", "Chunk Size (kb)", info.chunkKb(), PanelItem$.MODULE$.integer$default$4());
        return Task$.MODULE$.apply(() -> FileChunkReader$.buildPanel$$anonfun$1(file, size2));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> FileChunkReader$.savePanel$$anonfun$1(results, step));
    }

    public Observable<Document> run(Builder.Context cxt, FileChunkReader.Info info, Observable<Document> from) {
        File file = new File(info.file());
        String path = file.getAbsolutePath();
        if (FileCategory$.MODULE$.canRead(file)) {
            return from.flatMap((Function1 & Serializable)doc -> {
                BsonString mimeType = BsonString$.MODULE$.apply(FileCategory$.MODULE$.getMimeType(file).value());
                return MODULE$.loadBytes(cxt, file, info.chunkKb()).map((Function1 & Serializable)chunk -> {
                    Object[] objectArray = new BsonMagnets.CanBeBsonElement[4];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"filename");
                    objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)file.getName()), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"bytes");
                    objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)chunk.bytes()), (BsonTransformer)BsonTransformer$.MODULE$.TransformBinary());
                    String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"chunkIdx");
                    objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BoxesRunTime.boxToInteger((int)chunk.idx())), (BsonTransformer)BsonTransformer$.MODULE$.TransformInt());
                    String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"mimeType");
                    objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)mimeType), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                    return (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                });
            });
        }
        return cxt.logStart(from, (LogMessage)LogMessage.Error$.MODULE$.apply("Can't access file " + path + " - check folder restrictions"));
    }

    public Observable<FileChunkReader.Chunk> loadBytes(Builder.Context cxt, File file, int chunkKb) {
        Task use = cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Reading " + file.getAbsolutePath())).as((Object)new FileInputStream(file));
        return Observable$.MODULE$.fromInputStream(use, chunkKb * 1024).zipWithIndex().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                byte[] bytes = (byte[])tuple2._1();
                long idx = BoxesRunTime.unboxToLong((Object)tuple2._2());
                return FileChunkReader$Chunk$.MODULE$.apply((int)idx, bytes);
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public List<String> loadChoices() {
        return DataInUrl$.MODULE$.load(FileCategory$.MODULE$.FileReadable(), "").take(100).map((Function1 & Serializable)_$1 -> StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(_$1), "file:")).map((Function1 & Serializable)_$2 -> URLDecoder.decode(_$2, "UTF-8"));
    }

    /*
     * WARNING - void declaration
     */
    private static final List build$$anonfun$1() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeInt();
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 build$$anonfun$2() {
        FileChunkReader$Info$ fileChunkReader$Info$ = FileChunkReader$Info$.MODULE$;
        return (Function1 & Serializable)p -> (FileChunkReader.Info)fileChunkReader$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)FileChunkReader$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)FileChunkReader$Info$.MODULE$.$lessinit$greater$default$2())));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeInt();
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$2() {
        FileChunkReader$Info$ fileChunkReader$Info$ = FileChunkReader$Info$.MODULE$;
        return (Function1 & Serializable)p -> (FileChunkReader.Info)fileChunkReader$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)FileChunkReader$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)FileChunkReader$Info$.MODULE$.$lessinit$greater$default$2())));
    }

    private static final FileChunkReader.Info $anonfun$4() {
        return FileChunkReader$Info$.MODULE$.apply(FileChunkReader$Info$.MODULE$.$lessinit$greater$default$1(), FileChunkReader$Info$.MODULE$.$lessinit$greater$default$2());
    }

    private static final Panel buildPanel$$anonfun$1(Panel.Item file$1, Panel.Item size$1) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)file$1, (List)new .colon.colon((Object)size$1, (List)Nil$.MODULE$)));
    }

    /*
     * WARNING - void declaration
     */
    private static final List savePanel$$anonfun$1$$anonfun$1() {
        void var3_2;
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeInt();
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        FileChunkReader$Info$ fileChunkReader$Info$ = FileChunkReader$Info$.MODULE$;
        return (Function1 & Serializable)p -> (FileChunkReader.Info)fileChunkReader$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)FileChunkReader$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)FileChunkReader$Info$.MODULE$.$lessinit$greater$default$2())));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$5() {
        void var3_2;
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeInt();
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$2) {
        String string = "file";
        String string2 = "chunkKb";
        int size = 2;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", FileChunkReader$::savePanel$$anonfun$1$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), FileChunkReader$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(FileChunkReader$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            FileChunkReader.Info info2 = (FileChunkReader.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "file";
            String string2 = "chunkKb";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(FileChunkReader$::$anonfun$5, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string3 = step$2.copy$default$1();
            String string4 = step$2.copy$default$2();
            String string5 = step$2.copy$default$3();
            String string6 = step$2.copy$default$4();
            String string7 = step$2.copy$default$5();
            boolean bl = step$2.copy$default$7();
            boolean bl2 = step$2.copy$default$8();
            return step$2.copy(string3, string4, string5, string6, string7, json, bl, bl2);
        });
    }
}

