/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.jdbc;

import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ChainSetIdentifier;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.Helpers$;
import ambience.etl.jdbc.BlobInserter;
import ambience.etl.jdbc.BooleanInserter;
import ambience.etl.jdbc.ByteInserter;
import ambience.etl.jdbc.CharInserter;
import ambience.etl.jdbc.ColumnInserter;
import ambience.etl.jdbc.ConnectionPool$;
import ambience.etl.jdbc.DateInserter;
import ambience.etl.jdbc.DecimalInserter;
import ambience.etl.jdbc.DoubleInserter;
import ambience.etl.jdbc.HikariPool;
import ambience.etl.jdbc.IntInserter;
import ambience.etl.jdbc.JDBCInserter;
import ambience.etl.jdbc.JDBCInserter$Info$;
import ambience.etl.jdbc.JDBCInserter$Result$;
import ambience.etl.jdbc.LongInserter;
import ambience.etl.jdbc.ShortInserter;
import ambience.etl.jdbc.StringInserter;
import ambience.etl.jdbc.TimeInserter;
import ambience.etl.jdbc.TimestampInserter;
import ambience.etl.jdbc.UnknownInserter;
import ambience.etl.jdbc.sql.BasicSQLBuilder;
import ambience.etl.jdbc.sql.BasicSQLBuilder$;
import ambience.etl.jdbc.sql.Dialect;
import ambience.etl.jdbc.sql.Dialect$;
import ambience.etl.jdbc.sql.JDBCMetadata;
import ambience.etl.jdbc.sql.JDBCMetadata$;
import ambience.etl.jdbc.sql.JDBCSchema;
import ambience.etl.package$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.UnorderedFoldable;
import cats.implicits$;
import cats.kernel.Order;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple5$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LongRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class JDBCInserter$
implements Builder,
PanelBuilder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(JDBCInserter$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(JDBCInserter$.class.getDeclaredField("PoolChoices$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(JDBCInserter$.class.getDeclaredField("clock$lzy1"));
    private volatile Object log$lzy1;
    private static final String stepType;
    public static final JDBCInserter$Info$ Info;
    private static final Json InfoJson;
    public static final JDBCInserter$Result$ Result;
    private volatile Object clock$lzy1;
    private volatile Object PoolChoices$lzy1;
    public static final JDBCInserter$ MODULE$;

    private JDBCInserter$() {
    }

    static {
        MODULE$ = new JDBCInserter$();
        stepType = ETLStepType$.MODULE$.apply("jdbc.JDBCInserter");
        JDBCInserter.Info info = (JDBCInserter.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)JDBCInserter$Info$.MODULE$.apply(JDBCInserter$Info$.MODULE$.$lessinit$greater$default$1(), JDBCInserter$Info$.MODULE$.$lessinit$greater$default$2(), JDBCInserter$Info$.MODULE$.$lessinit$greater$default$3(), JDBCInserter$Info$.MODULE$.$lessinit$greater$default$4(), JDBCInserter$Info$.MODULE$.$lessinit$greater$default$5()));
        String string = "pool";
        String string2 = "table";
        String string3 = "successChainName";
        String string4 = "failureChainName";
        String string5 = "logCount";
        InfoJson = package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_2, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JDBCInserter$.class);
    }

    public String stepType() {
        return stepType;
    }

    public Json InfoJson() {
        return InfoJson;
    }

    public Clock clock() {
        Object object = this.clock$lzy1;
        if (object instanceof Clock) {
            return (Clock)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Clock)this.clock$lzyINIT1();
    }

    private Object clock$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.clock$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Clock clock = null;
                    try {
                        clock = (Clock)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Clock.class));
                        object2 = clock == null ? LazyVals.NullValue$.MODULE$ : clock;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.clock$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clock;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public List<Panel.SelectChoice> PoolChoices() {
        Object object = this.PoolChoices$lzy1;
        if (object instanceof List) {
            return (List)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (List)this.PoolChoices$lzyINIT1();
    }

    private Object PoolChoices$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.PoolChoices$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    List list = null;
                    try {
                        list = ((List)ConnectionPool$.MODULE$.getPoolNames().toList().sorted(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForString()))).map((Function1 & Serializable)s -> Panel.SelectChoice$.MODULE$.apply(s, Json$.MODULE$.fromString(s)));
                        object2 = list == null ? LazyVals.NullValue$.MODULE$ : list;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.PoolChoices$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return list;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "pool";
        String string2 = "table";
        String string3 = "successChainName";
        String string4 = "failureChainName";
        String string5 = "logCount";
        int size = 5;
        Either either = implicits$.MODULE$.catsSyntaxEither(this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JDBCInserter$::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), JDBCInserter$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JDBCInserter$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> MODULE$.run(cxt, (JDBCInserter.Info)info, (Observable<Document>)from));
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "pool";
        String string2 = "table";
        String string3 = "successChainName";
        String string4 = "failureChainName";
        String string5 = "logCount";
        int size = 5;
        JDBCInserter.Info info = (JDBCInserter.Info)this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JDBCInserter$::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), JDBCInserter$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JDBCInserter$::$anonfun$3))))).toOption().getOrElse(JDBCInserter$::$anonfun$4);
        return this.getTables(info.pool()).flatMap((Function1 & Serializable)tables -> Helpers$.MODULE$.getChainChoices(cxt.user(), (ChainSetIdentifier)cxt.chainSetId()).map((Function1 & Serializable)allChainChoices -> {
            Panel.SelectChoice selectChoice = Panel.SelectChoice$.MODULE$.apply("", Json$.MODULE$.fromString(""));
            List chainChoices = allChainChoices.$colon$colon((Object)selectChoice);
            List tableChoices = ((List)tables.sorted(implicits$.MODULE$.catsKernelOrderingForOrder((Order)implicits$.MODULE$.catsKernelStdOrderForString()))).map((Function1 & Serializable)s -> Panel.SelectChoice$.MODULE$.apply(s, Json$.MODULE$.fromString(s)));
            Panel.Item poolField = PanelItem$.MODULE$.select("pool", "Database", Json$.MODULE$.fromString(info.pool()), MODULE$.PoolChoices(), true);
            Panel.Item tableField = PanelItem$.MODULE$.select("table", "Table", Json$.MODULE$.fromString(info.table()), tableChoices, PanelItem$.MODULE$.select$default$5());
            Panel.Item successChainName = PanelItem$.MODULE$.select("successChainName", "Success Chain", Json$.MODULE$.fromString(info.successChainName()), chainChoices, PanelItem$.MODULE$.select$default$5());
            Panel.Item failureChainName = PanelItem$.MODULE$.select("failureChainName", "Failure Chain", Json$.MODULE$.fromString(info.failureChainName()), chainChoices, PanelItem$.MODULE$.select$default$5());
            Panel.Item logCount = PanelItem$.MODULE$.integer("logCount", "Log Every", info.logCount(), PanelItem$.MODULE$.integer$default$4());
            return Panel$.MODULE$.apply((List)new .colon.colon((Object)poolField, (List)new .colon.colon((Object)tableField, (List)new .colon.colon((Object)successChainName, (List)new .colon.colon((Object)failureChainName, (List)new .colon.colon((Object)logCount, (List)Nil$.MODULE$))))));
        }));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> JDBCInserter$.savePanel$$anonfun$1(results, step));
    }

    public Observable<Document> run(Builder.Context cxt, JDBCInserter.Info info, Observable<Document> from) {
        Option option = ConnectionPool$.MODULE$.getPool(info.pool());
        if (option instanceof Some) {
            HikariPool pool = (HikariPool)((Some)option).value();
            Observable from2 = cxt.logStart(from, (LogMessage)LogMessage.Info$.MODULE$.apply("Got JDBC connection to " + info.pool()));
            Connection connection = pool.ds().getConnection();
            DatabaseMetaData md = connection.getMetaData();
            Option<JDBCMetadata.Table> option2 = JDBCMetadata$.MODULE$.getTable(md, pool, info.table());
            if (option2 instanceof Some) {
                JDBCMetadata.Table table = (JDBCMetadata.Table)((Some)option2).value();
                return this.populateTable(cxt, info, connection, md, table, (Observable<Document>)from2).guarantee(Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    JDBCInserter$.run$$anonfun$1(connection);
                    return BoxedUnit.UNIT;
                }));
            }
            if (None$.MODULE$.equals(option2)) {
                return cxt.logStart(from2, (LogMessage)LogMessage.Warn$.MODULE$.apply("Can't find table " + info.table())).guarantee(Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    JDBCInserter$.run$$anonfun$2(connection);
                    return BoxedUnit.UNIT;
                }));
            }
            throw new MatchError(option2);
        }
        if (None$.MODULE$.equals(option)) {
            return cxt.logStart(from, (LogMessage)LogMessage.Warn$.MODULE$.apply("Can't find pool " + info.pool()));
        }
        throw new MatchError((Object)option);
    }

    public Observable<Document> populateTable(Builder.Context cxt, JDBCInserter.Info info, Connection connection, DatabaseMetaData md, JDBCMetadata.Table table, Observable<Document> from) {
        JDBCSchema schema = JDBCMetadata$.MODULE$.getSchema(md, table);
        Dialect dialect = Dialect$.MODULE$.defaultDialect();
        BasicSQLBuilder sqlBuilder = BasicSQLBuilder$.MODULE$.apply(dialect, table, schema);
        PreparedStatement ps = connection.prepareStatement(sqlBuilder.insertString());
        Either<LogMessage, Function1<Observable<Document>, Observable<Document>>> optSuccessChain = this.buildChain(cxt, info.successChainName());
        Either<LogMessage, Function1<Observable<Document>, Observable<Document>>> optFailureChain = this.buildChain(cxt, info.failureChainName());
        IntRef successCount = IntRef.create((int)0);
        IntRef failureCount = IntRef.create((int)0);
        LongRef startTime = LongRef.create((long)this.clock().now());
        List inserters = ((List)schema.columns().zipWithIndex()).map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                JDBCMetadata.Column col = (JDBCMetadata.Column)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                return MODULE$.getInserter(cxt, ps, idx + 1, col);
            }
            throw new MatchError((Object)tuple2);
        });
        return from.doOnStart((Function1 & Serializable)t -> this.atStart$1(startTime, cxt, (Either)optSuccessChain, (Either)optFailureChain, (Document)t)).flatMap((Function1 & Serializable)doc -> {
            Observable observable;
            block6: {
                ps.clearParameters();
                inserters.foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.apply((Document)doc));
                try {
                    ps.executeUpdate();
                    ++successCount$4.elem;
                    Option option = optSuccessChain.toOption();
                    if (option instanceof Some) {
                        Function1 chain = (Function1)((Some)option).value();
                        observable = (Observable)chain.apply((Object)Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Document[]{doc})));
                        break block6;
                    }
                    if (None$.MODULE$.equals(option)) {
                        observable = Observable$.MODULE$.empty();
                        break block6;
                    }
                    throw new MatchError((Object)option);
                }
                catch (SQLException ex) {
                    ++failureCount$4.elem;
                    Option option = optFailureChain.toOption();
                    if (option instanceof Some) {
                        Function1 chain = (Function1)((Some)option).value();
                        observable = (Observable)chain.apply((Object)Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Document[]{doc})));
                    }
                    if (None$.MODULE$.equals(option)) {
                        observable = Observable$.MODULE$.fromTask(cxt.logT((LogMessage)LogMessage.ErrorEx$.MODULE$.apply("Error inserting: " + ex, (Throwable)ex))).flatMap((Function1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return Observable$.MODULE$.empty().map((Function1 & Serializable)ret -> ret);
                        });
                    }
                    throw new MatchError((Object)option);
                }
            }
            Observable ret = observable;
            Task task = successCount$4.elem + failureCount$4.elem % scala.math.package$.MODULE$.max(1, info.logCount()) == 0 ? cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Successes: " + successCount$4.elem + " Failures: " + failureCount$4.elem)) : Task$.MODULE$.unit();
            return Observable$.MODULE$.fromTask(task).flatMap((Function1 & Serializable)_$2 -> ret);
        }).$plus$plus(() -> this.populateTable$$anonfun$3(cxt, successCount, failureCount, ps, optSuccessChain, optFailureChain, startTime));
    }

    public Either<LogMessage, Function1<Observable<Document>, Observable<Document>>> buildChain(Builder.Context cxt, String chainName) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(chainName))) {
            Either either = cxt.buildChain(chainName, cxt.buildChain$default$2());
            if (either instanceof Right) {
                Function1 flow = (Function1)((Right)either).value();
                return scala.package$.MODULE$.Right().apply((Object)flow);
            }
            if (either instanceof Left) {
                BuildError err = (BuildError)((Left)either).value();
                return scala.package$.MODULE$.Left().apply((Object)LogMessage.Warn$.MODULE$.apply("Can't find chain: " + chainName + ": " + err));
            }
            throw new MatchError((Object)either);
        }
        return scala.package$.MODULE$.Left().apply((Object)LogMessage.None$.MODULE$);
    }

    public Task<BoxedUnit> logChainErrorT(Builder.Context cxt, Either<LogMessage, Function1<Observable<Document>, Observable<Document>>> messageOrFlow) {
        Either<LogMessage, Function1<Observable<Document>, Observable<Document>>> either = messageOrFlow;
        if (either instanceof Right) {
            Function1 flow = (Function1)((Right)either).value();
            return Task$.MODULE$.unit();
        }
        if (either instanceof Left) {
            LogMessage msg = (LogMessage)((Left)either).value();
            return cxt.logT(msg);
        }
        throw new MatchError(either);
    }

    public Task<List<String>> getTables(String pool) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(pool))) {
            Option option = ConnectionPool$.MODULE$.getPool(pool);
            if (option instanceof Some) {
                HikariPool poolConfig = (HikariPool)((Some)option).value();
                return poolConfig.use((Function1 & Serializable)connection -> this.buildTables$1(poolConfig, (Connection)connection));
            }
            if (None$.MODULE$.equals(option)) {
                this.log().info(() -> JDBCInserter$.getTables$$anonfun$2(pool), Line$.MODULE$.apply(181), FullName$.MODULE$.apply("ambience.etl.jdbc.JDBCInserter.getTables"));
                return Task$.MODULE$.now((Object)scala.package$.MODULE$.Nil());
            }
            throw new MatchError((Object)option);
        }
        return Task$.MODULE$.now((Object)scala.package$.MODULE$.Nil());
    }

    public Option<JDBCMetadata.Table> getTable(DatabaseMetaData md, HikariPool pool, JDBCInserter.Info info) {
        return JDBCMetadata$.MODULE$.getTable(md, pool, info.table());
    }

    public ColumnInserter getInserter(Builder.Context cxt, PreparedStatement ps, int idx, JDBCMetadata.Column col) {
        int n = col.dataType();
        return switch (n) {
            case -9, -1, 12, 2005 -> new StringInserter(ps, col.dataType(), idx, col.name());
            case -7, 16 -> new BooleanInserter(ps, col.dataType(), idx, col.name());
            case 1 -> new CharInserter(ps, col.dataType(), idx, col.name());
            case 4 -> new IntInserter(ps, col.dataType(), idx, col.name());
            case 5 -> new ShortInserter(ps, col.dataType(), idx, col.name());
            case -6 -> new ByteInserter(ps, col.dataType(), idx, col.name());
            case -5 -> new LongInserter(ps, col.dataType(), idx, col.name());
            case 6, 8 -> new DoubleInserter(ps, col.dataType(), idx, col.name());
            case 2, 3 -> new DecimalInserter(ps, col.dataType(), idx, col.name());
            case 91 -> new DateInserter(ps, col.dataType(), idx, col.name());
            case 92, 2013 -> new TimeInserter(ps, col.dataType(), idx, col.name());
            case 93, 2014 -> new TimestampInserter(ps, col.dataType(), idx, col.name());
            case -4, -3, -2, 2004 -> new BlobInserter(ps, col.dataType(), idx, col.name());
            default -> {
                cxt.logT((LogMessage)LogMessage.Warn$.MODULE$.apply("Unsupported datatype for " + col.name() + ": " + col.typeName() + " (" + col.dataType() + ")")).runToFuture(Scheduler$.MODULE$.global());
                yield new UnknownInserter(ps, col.dataType(), idx, col.name());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private final List $init$$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        void var2_1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA4 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder4 = encodeA = Encoder$.MODULE$.encodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List build$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        void var3_2;
        void var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 build$$anonfun$2() {
        JDBCInserter$Info$ jDBCInserter$Info$ = JDBCInserter$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JDBCInserter.Info)jDBCInserter$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple5$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JDBCInserter$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JDBCInserter$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)JDBCInserter$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)JDBCInserter$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)JDBCInserter$Info$.MODULE$.$lessinit$greater$default$5())));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        void var3_2;
        void var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$2() {
        JDBCInserter$Info$ jDBCInserter$Info$ = JDBCInserter$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JDBCInserter.Info)jDBCInserter$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple5$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JDBCInserter$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JDBCInserter$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)JDBCInserter$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)JDBCInserter$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)JDBCInserter$Info$.MODULE$.$lessinit$greater$default$5())));
    }

    private static final JDBCInserter.Info $anonfun$4() {
        return JDBCInserter$Info$.MODULE$.apply(JDBCInserter$Info$.MODULE$.$lessinit$greater$default$1(), JDBCInserter$Info$.MODULE$.$lessinit$greater$default$2(), JDBCInserter$Info$.MODULE$.$lessinit$greater$default$3(), JDBCInserter$Info$.MODULE$.$lessinit$greater$default$4(), JDBCInserter$Info$.MODULE$.$lessinit$greater$default$5());
    }

    /*
     * WARNING - void declaration
     */
    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        void var3_2;
        void var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        JDBCInserter$Info$ jDBCInserter$Info$ = JDBCInserter$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JDBCInserter.Info)jDBCInserter$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple5$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JDBCInserter$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JDBCInserter$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)JDBCInserter$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)JDBCInserter$Info$.MODULE$.$lessinit$greater$default$4()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)JDBCInserter$Info$.MODULE$.$lessinit$greater$default$5())));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$6() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        void var3_2;
        void var1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA = Encoder$.MODULE$.encodeInt();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$2) {
        String string = "pool";
        String string2 = "table";
        String string3 = "successChainName";
        String string4 = "failureChainName";
        String string5 = "logCount";
        int size = 5;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JDBCInserter$::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), JDBCInserter$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JDBCInserter$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            JDBCInserter.Info info2 = (JDBCInserter.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "pool";
            String string2 = "table";
            String string3 = "successChainName";
            String string4 = "failureChainName";
            String string5 = "logCount";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(JDBCInserter$::$anonfun$6, scala.package$.MODULE$.Nil().$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string6 = step$2.copy$default$1();
            String string7 = step$2.copy$default$2();
            String string8 = step$2.copy$default$3();
            String string9 = step$2.copy$default$4();
            String string10 = step$2.copy$default$5();
            boolean bl = step$2.copy$default$7();
            boolean bl2 = step$2.copy$default$8();
            return step$2.copy(string6, string7, string8, string9, string10, json, bl, bl2);
        });
    }

    private static final void run$$anonfun$1(Connection connection$1) {
        connection$1.close();
    }

    private static final void run$$anonfun$2(Connection connection$2) {
        connection$2.close();
    }

    private static final void atStart$1$$anonfun$1(LongRef startTime$2) {
        startTime$2.elem = MODULE$.clock().now();
    }

    private final Task atStart$1(LongRef startTime$1, Builder.Context cxt$4, Either optSuccessChain$1, Either optFailureChain$1, Document t) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            JDBCInserter$.atStart$1$$anonfun$1(startTime$1);
            return BoxedUnit.UNIT;
        }).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return MODULE$.logChainErrorT(cxt$4, (Either<LogMessage, Function1<Observable<Document>, Observable<Document>>>)optSuccessChain$1).flatMap((Function1 & Serializable)x$12 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return MODULE$.logChainErrorT(cxt$4, (Either<LogMessage, Function1<Observable<Document>, Observable<Document>>>)optFailureChain$1).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                });
            });
        });
    }

    private static final void atEnd$1$$anonfun$1$$anonfun$1$$anonfun$1(PreparedStatement ps$4) {
        ps$4.close();
    }

    private static final Try atEnd$1$$anonfun$1$$anonfun$1(PreparedStatement ps$3) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            JDBCInserter$.atEnd$1$$anonfun$1$$anonfun$1$$anonfun$1(ps$3);
            return BoxedUnit.UNIT;
        });
    }

    private final Observable atEnd$1(Builder.Context cxt$7, IntRef successCount$1, IntRef failureCount$1, PreparedStatement ps$1, Either optSuccessChain$3, Either optFailureChain$4, LongRef startTime$3) {
        return Observable$.MODULE$.fromTask(cxt$7.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Successes: " + successCount$1.elem + " Failures: " + failureCount$1.elem))).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return Observable$.MODULE$.fromTask(Task$.MODULE$.apply(() -> JDBCInserter$.atEnd$1$$anonfun$1$$anonfun$1(ps$1))).flatMap((Function1 & Serializable)x$1 -> {
                Try try_ = x$1;
                return this.doAtEnd$1(optSuccessChain$3, optFailureChain$4, successCount$1, failureCount$1, startTime$3).map((Function1 & Serializable)ret -> ret);
            });
        });
    }

    private final Observable doAtEnd$1(Either optSuccessChain$5, Either optFailureChain$6, IntRef successCount$3, IntRef failureCount$3, LongRef startTime$5) {
        if (implicits$.MODULE$.toUnorderedFoldableOps((Object)optSuccessChain$5, (UnorderedFoldable)implicits$.MODULE$.catsStdInstancesForEither()).isEmpty() && implicits$.MODULE$.toUnorderedFoldableOps((Object)optFailureChain$6, (UnorderedFoldable)implicits$.MODULE$.catsStdInstancesForEither()).isEmpty()) {
            Object[] objectArray = new Document[1];
            Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[3];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"successCount");
            objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt32$.MODULE$.apply(successCount$3.elem)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"failureCount");
            objectArray2[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt32$.MODULE$.apply(failureCount$3.elem)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"elapsedTime");
            objectArray2[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonInt64$.MODULE$.apply(this.clock().now() - startTime$5.elem)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            objectArray[0] = package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
            return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        }
        return Observable$.MODULE$.empty();
    }

    private final Observable populateTable$$anonfun$3(Builder.Context cxt$11, IntRef successCount$6, IntRef failureCount$6, PreparedStatement ps$8, Either optSuccessChain$9, Either optFailureChain$10, LongRef startTime$9) {
        return this.atEnd$1(cxt$11, successCount$6, failureCount$6, ps$8, optSuccessChain$9, optFailureChain$10, startTime$9);
    }

    private static final List buildTables$1$$anonfun$1(Connection connection$3, HikariPool poolConfig$1) {
        return JDBCMetadata$.MODULE$.buildTables(connection$3.getMetaData(), poolConfig$1).map((Function1 & Serializable)_$3 -> _$3.uniqueName());
    }

    private final Task buildTables$1(HikariPool poolConfig$2, Connection connection) {
        return Task$.MODULE$.apply(() -> JDBCInserter$.buildTables$1$$anonfun$1(connection, poolConfig$2));
    }

    private static final Object getTables$$anonfun$2(String pool$1) {
        return "Can't load tables for pool " + pool$1;
    }
}

