/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.jdbc;

import ambience.etl.BsonExtractJson$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLException;
import ambience.etl.ETLException$;
import ambience.etl.ETLJsonParsingException;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.jdbc.ConnectionPool$;
import ambience.etl.jdbc.DocBuilder;
import ambience.etl.jdbc.DocBuilder$;
import ambience.etl.jdbc.HikariPool;
import ambience.etl.jdbc.JDBCCategory$;
import ambience.etl.jdbc.JDBCDefinition;
import ambience.etl.jdbc.JDBCDefinition$;
import ambience.etl.jdbc.JDBCReader;
import ambience.etl.jdbc.JDBCReader$Info$;
import ambience.etl.jdbc.JDBCReader$JDBCStream$;
import ambience.etl.jdbc.ParameterBuilder$;
import ambience.etl.package$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.atomic.AtomicLong;
import monix.execution.atomic.AtomicLong$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple1$;
import scala.Tuple4$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class JDBCReader$
implements Builder,
PanelBuilder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(JDBCReader$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final String stepType;
    private static final AtomicLong serialId;
    public static final JDBCReader$Info$ Info;
    private static final Json InfoJson;
    public static final JDBCReader$JDBCStream$ JDBCStream;
    private static final Function1 getDef;
    private static final Function1 streamToRecord;
    public static final JDBCReader$ MODULE$;

    private JDBCReader$() {
    }

    static {
        MODULE$ = new JDBCReader$();
        stepType = ETLStepType$.MODULE$.apply("jdbc.Reader");
        serialId = AtomicLong$.MODULE$.apply(0L);
        JDBCReader.Info info = (JDBCReader.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)JDBCReader$Info$.MODULE$.apply(JDBCReader$Info$.MODULE$.$lessinit$greater$default$1()));
        String string = "preserveNulls";
        InfoJson = package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        getDef = (Function1 & Serializable)from -> from.flatMap((Function1 & Serializable)doc -> {
            Json json = BsonExtractJson$.MODULE$.toJson((BsonValue)doc.toBsonDocument());
            String string = "pool";
            String string2 = "sql";
            String string3 = "parameters";
            String string4 = "base";
            int size = 4;
            Either either = json.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("JDBCDefinition", this::$init$$$anonfun$2$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), this::$init$$$anonfun$2$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::$init$$$anonfun$2$$anonfun$1$$anonfun$3)))));
            if (either instanceof Right) {
                JDBCDefinition jdbcDef = (JDBCDefinition)((Right)either).value();
                return Observable$.MODULE$.now((Object)JDBCCategory$.MODULE$.substituteParams((Document)doc, jdbcDef));
            }
            if (either instanceof Left) {
                DecodingFailure err = (DecodingFailure)((Left)either).value();
                return Observable$.MODULE$.raiseError((Throwable)new ETLJsonParsingException("Can't read JDBCDefinition", json, (Throwable)err));
            }
            throw new MatchError((Object)either);
        });
        streamToRecord = (Function1 & Serializable)from -> from.flatMap((Function1 & Serializable)in -> this.rsStream((JDBCReader.JDBCStream)in));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JDBCReader$.class);
    }

    public String stepType() {
        return stepType;
    }

    public AtomicLong serialId() {
        return serialId;
    }

    public Json InfoJson() {
        return InfoJson;
    }

    public void logError(String msg, Try<?> result) {
        Try<?> try_ = result;
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            this.log().error(() -> JDBCReader$.logError$$anonfun$1(msg), ex, Line$.MODULE$.apply(49), FullName$.MODULE$.apply("ambience.etl.jdbc.JDBCReader.logError"));
            return;
        }
        throw new MatchError(try_);
    }

    public Function1<Observable<Document>, Observable<JDBCDefinition>> getDef() {
        return getDef;
    }

    public Function1<Observable<JDBCDefinition>, Observable<JDBCReader.JDBCStream>> defToStream(Builder.Context cxt, JDBCReader.Info info) {
        return (Function1 & Serializable)from -> {
            MODULE$.log().info(() -> JDBCReader$.defToStream$$anonfun$1$$anonfun$1(cxt), Line$.MODULE$.apply(64), FullName$.MODULE$.apply("ambience.etl.jdbc.JDBCReader.defToStream"));
            return from.flatMap((Function1 & Serializable)jdbcDef -> {
                Option option = ConnectionPool$.MODULE$.getPool(jdbcDef.pool());
                if (option instanceof Some) {
                    HikariPool pool = (HikariPool)((Some)option).value();
                    Try try_ = Try$.MODULE$.apply(() -> JDBCReader$.defToStream$$anonfun$1$$anonfun$2$$anonfun$1(pool));
                    if (try_ instanceof Success) {
                        Connection connection = (Connection)((Success)try_).value();
                        connection.setReadOnly(true);
                        PreparedStatement statement = ParameterBuilder$.MODULE$.buildPreparedStatement(cxt, connection, (JDBCDefinition)jdbcDef);
                        ResultSet rs = statement.executeQuery();
                        Option optBase = Try$.MODULE$.apply(() -> JDBCReader$.$anonfun$1(jdbcDef)).toOption();
                        DocBuilder[] builders = DocBuilder$.MODULE$.constructBuilders(rs.getMetaData(), info.preserveNulls());
                        JDBCReader.JDBCStream js = JDBCReader$JDBCStream$.MODULE$.apply((JDBCDefinition)jdbcDef, connection, statement, rs, (Option<Document>)optBase, builders);
                        return Observable$.MODULE$.now((Object)js).guarantee(Task$.MODULE$.apply((Function0 & Serializable)() -> {
                            JDBCReader$.defToStream$$anonfun$1$$anonfun$2$$anonfun$2(js);
                            return BoxedUnit.UNIT;
                        }));
                    }
                    if (try_ instanceof Failure) {
                        Throwable ex = ((Failure)try_).exception();
                        return Observable$.MODULE$.raiseError((Throwable)new ETLException("JDBC connection error: " + ex.getMessage(), ETLException$.MODULE$.$lessinit$greater$default$2()));
                    }
                    throw new MatchError((Object)try_);
                }
                if (None$.MODULE$.equals(option)) {
                    return Observable$.MODULE$.raiseError((Throwable)new ETLException("JDBC pool not available", ETLException$.MODULE$.$lessinit$greater$default$2()));
                }
                throw new MatchError((Object)option);
            });
        };
    }

    public Function1<Observable<JDBCReader.JDBCStream>, Observable<Document>> streamToRecord() {
        return streamToRecord;
    }

    private Observable<Document> rsStream(JDBCReader.JDBCStream in) {
        if (in.rs().next()) {
            return Observable$.MODULE$.now((Object)this.rsRecord(in)).$plus$plus(() -> JDBCReader$.rsStream$$anonfun$1(in));
        }
        return Observable$.MODULE$.empty();
    }

    private Document rsRecord(JDBCReader.JDBCStream in) {
        BsonDocument doc = BsonDocument$.MODULE$.apply();
        for (int i = 0; i < in.builders().length; ++i) {
            in.builders()[i].build(doc, in.rs());
        }
        Option<Document> option = in.optBase();
        if (option instanceof Some) {
            Document base = (Document)((Some)option).value();
            return base.$plus$plus((IterableOnce)package$.MODULE$.ETLRecord().apply(doc));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.ETLRecord().apply(doc);
        }
        throw new MatchError(option);
    }

    public Function1<Observable<Document>, Observable<Document>> pipeline(Builder.Context cxt, JDBCReader.Info info) {
        return this.getDef().andThen(this.defToStream(cxt, info)).andThen(this.streamToRecord());
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "preserveNulls";
        boolean size = true;
        Either either = implicits$.MODULE$.catsSyntaxEither(this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JDBCReader$::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string), JDBCReader$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JDBCReader$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> MODULE$.pipeline(cxt, (JDBCReader.Info)info));
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "preserveNulls";
        boolean size = true;
        JDBCReader.Info info = (JDBCReader.Info)this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JDBCReader$::$anonfun$2, scala.package$.MODULE$.Nil().$colon$colon((Object)string), JDBCReader$::$anonfun$3, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JDBCReader$::$anonfun$4))))).toOption().getOrElse(JDBCReader$::$anonfun$5);
        Panel.Item preserveField = PanelItem$.MODULE$.checkbox("preserveNulls", "Preserve Nulls", info.preserveNulls(), PanelItem$.MODULE$.checkbox$default$4());
        return Task$.MODULE$.apply(() -> JDBCReader$.buildPanel$$anonfun$1(preserveField));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> JDBCReader$.savePanel$$anonfun$1(results, step));
    }

    /*
     * WARNING - void declaration
     */
    private final List $init$$$anonfun$1() {
        void var2_1;
        Encoder encodeA = Encoder$.MODULE$.encodeBoolean();
        void var1_2 = var2_1;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private final List $init$$$anonfun$2$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        void var2_1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA3 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA2 = Decoder$.MODULE$.decodeJson();
        Decoder decoder3 = decodeA = Decoder$.MODULE$.decodeJson();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 $init$$$anonfun$2$$anonfun$1$$anonfun$2() {
        JDBCDefinition$ jDBCDefinition$ = JDBCDefinition$.MODULE$;
        return (Function1 & Serializable)p -> (JDBCDefinition)jDBCDefinition$.fromProduct((Product)p);
    }

    private final Product $init$$$anonfun$2$$anonfun$1$$anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)JDBCDefinition$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)JDBCDefinition$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)JDBCDefinition$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)JDBCDefinition$.MODULE$.$lessinit$greater$default$4()));
    }

    private static final Object logError$$anonfun$1(String msg$1) {
        return "Error " + msg$1;
    }

    private static final Object defToStream$$anonfun$1$$anonfun$1(Builder.Context cxt$2) {
        return "Constructing stream for " + cxt$2.position().chainName() + cxt$2.position().stepName() + "[" + cxt$2.position().stepIdx() + "]";
    }

    private static final Connection defToStream$$anonfun$1$$anonfun$2$$anonfun$1(HikariPool pool$1) {
        return pool$1.ds().getConnection();
    }

    private static final Document $anonfun$1(JDBCDefinition jdbcDef$1) {
        return package$.MODULE$.ETLRecord().apply(jdbcDef$1.base().noSpaces());
    }

    private static final void defToStream$$anonfun$1$$anonfun$2$$anonfun$2(JDBCReader.JDBCStream js$1) {
        js$1.close();
    }

    private static final Observable rsStream$$anonfun$1(JDBCReader.JDBCStream in$1) {
        return MODULE$.rsStream(in$1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List build$$anonfun$1() {
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeBoolean();
        void var0_1 = var1;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var0_1);
    }

    private static final Function1 build$$anonfun$2() {
        JDBCReader$Info$ jDBCReader$Info$ = JDBCReader$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JDBCReader.Info)jDBCReader$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)JDBCReader$Info$.MODULE$.$lessinit$greater$default$1())));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$2() {
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeBoolean();
        void var0_1 = var1;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$3() {
        JDBCReader$Info$ jDBCReader$Info$ = JDBCReader$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JDBCReader.Info)jDBCReader$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$4() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)JDBCReader$Info$.MODULE$.$lessinit$greater$default$1())));
    }

    private static final JDBCReader.Info $anonfun$5() {
        return JDBCReader$Info$.MODULE$.apply(JDBCReader$Info$.MODULE$.$lessinit$greater$default$1());
    }

    private static final Panel buildPanel$$anonfun$1(Panel.Item preserveField$1) {
        return Panel$.MODULE$.apply((List)new .colon.colon((Object)preserveField$1, (List)Nil$.MODULE$));
    }

    /*
     * WARNING - void declaration
     */
    private static final List savePanel$$anonfun$1$$anonfun$1() {
        void var1;
        Decoder decodeA = Decoder$.MODULE$.decodeBoolean();
        void var0_1 = var1;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var0_1);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        JDBCReader$Info$ jDBCReader$Info$ = JDBCReader$Info$.MODULE$;
        return (Function1 & Serializable)p -> (JDBCReader.Info)jDBCReader$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple1$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)JDBCReader$Info$.MODULE$.$lessinit$greater$default$1())));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$6() {
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeBoolean();
        void var0_1 = var1;
        return scala.package$.MODULE$.Nil().$colon$colon((Object)var0_1);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$2) {
        String string = "preserveNulls";
        boolean size = true;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", JDBCReader$::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string), JDBCReader$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(JDBCReader$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            JDBCReader.Info info2 = (JDBCReader.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "preserveNulls";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(JDBCReader$::$anonfun$6, scala.package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string2 = step$2.copy$default$1();
            String string3 = step$2.copy$default$2();
            String string4 = step$2.copy$default$3();
            String string5 = step$2.copy$default$4();
            String string6 = step$2.copy$default$5();
            boolean bl = step$2.copy$default$7();
            boolean bl2 = step$2.copy$default$8();
            return step$2.copy(string2, string3, string4, string5, string6, json, bl, bl2);
        });
    }
}

