/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.mongodb;

import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLException;
import ambience.etl.ETLException$;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.mongodb.ConnectionPool$;
import ambience.etl.mongodb.MongoDBDecrypt;
import ambience.etl.mongodb.MongoDBDecrypt$Info$;
import ambience.etl.mongodb.MongoDBDefinition$;
import ambience.etl.mongodb.MongoDBEncrypt$;
import ambience.etl.package$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.SystemConfig;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.mongodb.BsonETL$;
import com.elixirtech.mongodb.RichMongoCollection;
import com.elixirtech.mongodb.RichMongoDatabase;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.security.Key;
import java.security.MessageDigest;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.atomic.AtomicLong;
import monix.execution.atomic.AtomicLong$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonArray;
import org.bson.BsonDateTime;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Updates$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple4$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;
import scala.util.Either;

public final class MongoDBDecrypt$
implements Builder,
PanelBuilder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(MongoDBDecrypt$.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(MongoDBDecrypt$.class.getDeclaredField("clock$lzy1"));
    private volatile Object log$lzy1;
    private static final String DefaultAlgorithm;
    private static final Base64.Decoder Base64Decoder;
    private static final IvParameterSpec IVParamSpec;
    private static final ExecutionContext exeCxt;
    private volatile Object clock$lzy1;
    public static final MongoDBDecrypt$Info$ Info;
    private static final String stepType;
    public static final MongoDBDecrypt$ MODULE$;

    private MongoDBDecrypt$() {
    }

    static {
        MODULE$ = new MongoDBDecrypt$();
        DefaultAlgorithm = MongoDBEncrypt$.MODULE$.DefaultAlgorithm();
        Base64Decoder = Base64.getDecoder();
        IVParamSpec = MongoDBEncrypt$.MODULE$.IVParamSpec();
        exeCxt = ((SystemConfig)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(SystemConfig.class))).exeCxt();
        stepType = ETLStepType$.MODULE$.apply("mongodb.Decrypt");
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(MongoDBDecrypt$.class);
    }

    public String DefaultAlgorithm() {
        return DefaultAlgorithm;
    }

    public Base64.Decoder Base64Decoder() {
        return Base64Decoder;
    }

    public IvParameterSpec IVParamSpec() {
        return IVParamSpec;
    }

    public ExecutionContext exeCxt() {
        return exeCxt;
    }

    public Clock clock() {
        Object object = this.clock$lzy1;
        if (object instanceof Clock) {
            return (Clock)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Clock)this.clock$lzyINIT1();
    }

    private Object clock$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.clock$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Clock clock = null;
                    try {
                        clock = (Clock)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Clock.class));
                        object2 = clock == null ? LazyVals.NullValue$.MODULE$ : clock;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.clock$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clock;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String stepType() {
        return stepType;
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "pool";
        String string2 = "collectionField";
        String string3 = "fieldsField";
        String string4 = "secretField";
        int size = 4;
        Either either = implicits$.MODULE$.catsSyntaxEither(step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", MongoDBDecrypt$::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), MongoDBDecrypt$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(MongoDBDecrypt$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> MODULE$.run(cxt, (MongoDBDecrypt.Info)info, (Observable<Document>)from));
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "pool";
        String string2 = "collectionField";
        String string3 = "fieldsField";
        String string4 = "secretField";
        int size = 4;
        MongoDBDecrypt.Info info = (MongoDBDecrypt.Info)step.json().as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", MongoDBDecrypt$::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), MongoDBDecrypt$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(MongoDBDecrypt$::$anonfun$3))))).toOption().getOrElse(MongoDBDecrypt$::$anonfun$4);
        Panel.Item poolField = PanelItem$.MODULE$.select("pool", "Database", Json$.MODULE$.fromString(info.pool()), MongoDBDefinition$.MODULE$.Choices(), true);
        Panel.Item collectionField = PanelItem$.MODULE$.text("collectionField", "Collection Field", info.collectionField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item fieldsField = PanelItem$.MODULE$.text("fieldsField", "Fields Array", info.fieldsField(), PanelItem$.MODULE$.text$default$4());
        Panel.Item secretField = PanelItem$.MODULE$.text("secretField", "Secret Field", info.secretField(), PanelItem$.MODULE$.text$default$4());
        return Task$.MODULE$.now((Object)Panel$.MODULE$.apply((List)new .colon.colon((Object)poolField, (List)new .colon.colon((Object)collectionField, (List)new .colon.colon((Object)fieldsField, (List)new .colon.colon((Object)secretField, (List)Nil$.MODULE$))))));
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> MongoDBDecrypt$.savePanel$$anonfun$1(results, step));
    }

    public Observable<Document> run(Builder.Context cxt, MongoDBDecrypt.Info info, Observable<Document> from) {
        Option option = ConnectionPool$.MODULE$.getPool(info.pool());
        if (option instanceof Some) {
            MongoDatabase db = (MongoDatabase)((Some)option).value();
            return this.doRun(cxt, new RichMongoDatabase(db), info, from);
        }
        if (None$.MODULE$.equals(option)) {
            return Observable$.MODULE$.raiseError((Throwable)new ETLException("MongoDB pool " + info.pool() + " not available", ETLException$.MODULE$.$lessinit$greater$default$2()));
        }
        throw new MatchError((Object)option);
    }

    public Observable<Document> doRun(Builder.Context cxt, RichMongoDatabase db, MongoDBDecrypt.Info info, Observable<Document> from) {
        return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{this.clock().now()})).flatMap((Function1 & Serializable)startTime -> MongoDBDecrypt$.doRun$$anonfun$1(cxt, db, info, from, BoxesRunTime.unboxToLong((Object)startTime)));
    }

    public Observable<Object> updateEveryOne(Builder.Context cxt, RichMongoDatabase db, MongoDBDecrypt.Info info, Observable<Document> from) {
        AtomicLong count = AtomicLong$.MODULE$.apply(0L);
        Observable ret = from.flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(BsonETL$.MODULE$.get(doc, info.collectionField()).flatMap((Function1 & Serializable)bv -> MODULE$.extractString((BsonValue)bv)))).flatMap((Function1 & Serializable)cltnName -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(BsonETL$.MODULE$.get(doc, info.secretField()).flatMap((Function1 & Serializable)bv -> MODULE$.extractString((BsonValue)bv)).map((Function1 & Serializable)secret -> MODULE$.buildSecretKeySpec((String)secret)))).flatMap((Function1 & Serializable)secret -> Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{BsonETL$.MODULE$.get(doc, info.fieldsField()).toList().flatMap((Function1 & Serializable)bv -> MODULE$.extractStringArray((BsonValue)bv))})).flatMap((Function1 & Serializable)fields -> Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new RichMongoCollection[]{db.getRichCollection(cltnName)})).flatMap((Function1 & Serializable)cltn -> Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new BsonDateTime[]{new BsonDateTime(MODULE$.clock().now())})).flatMap((Function1 & Serializable)now -> cltn.findO().flatMap((Function1 & Serializable)record -> Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{MODULE$.decrypt((SecretKeySpec)secret, (List<String>)fields, (Document)record, (BsonDateTime)now)})).flatMap((Function1 & Serializable)update -> Observable$.MODULE$.fromTask(cltn.updateOneT(Filters$.MODULE$.eq("_id", (Object)record.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class))), update)).flatMap((Function1 & Serializable)ok -> Observable$.MODULE$.fromTask(MODULE$.logProgress(cxt, count)).map((Function1)(JFunction1.mcJJ.sp & Serializable)x$1 -> {
            long l = x$1;
            return ok.getModifiedCount();
        }))))))))));
        return ret.foldLeft(MongoDBDecrypt$::updateEveryOne$$anonfun$1, (Function2)(JFunction2.mcJJJ.sp & Serializable)(_$1, _$2) -> _$1 + _$2);
    }

    public Task<Object> logProgress(Builder.Context cxt, AtomicLong count) {
        long nc = count.incrementAndGet(count.incrementAndGet$default$1());
        if (nc % 100000L == 0L) {
            return cxt.logT((LogMessage)LogMessage.Info$.MODULE$.apply("Processed " + nc + " records")).as((Object)BoxesRunTime.boxToLong((long)nc));
        }
        return Task$.MODULE$.now((Object)BoxesRunTime.boxToLong((long)nc));
    }

    public Option<String> extractString(BsonValue bv) {
        BsonValue bsonValue = bv;
        if (bsonValue instanceof BsonString) {
            BsonString bs = (BsonString)bsonValue;
            return Some$.MODULE$.apply((Object)bs.getValue());
        }
        return None$.MODULE$;
    }

    public List<String> extractStringArray(BsonValue bv2) {
        BsonValue bsonValue = bv2;
        if (bsonValue instanceof BsonArray) {
            BsonArray bs = (BsonArray)bsonValue;
            return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(bs.getValues()).asScala().flatMap((Function1 & Serializable)bv -> MODULE$.extractString((BsonValue)bv))).toList();
        }
        return scala.package$.MODULE$.Nil();
    }

    public byte[] hashSecret(String s) {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        return md.digest(s.getBytes(Gravity$.MODULE$.UTF_8()));
    }

    public Bson decrypt(SecretKeySpec secretKeySpec, List<String> fields, Document document, BsonDateTime now) {
        List updates = fields.flatMap((Function1 & Serializable)f -> {
            BsonValue bsonValue;
            Option option = BsonETL$.MODULE$.get(document, f);
            if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonString) {
                BsonString bs = (BsonString)bsonValue;
                return Some$.MODULE$.apply((Object)Updates$.MODULE$.set(f, (Object)MODULE$.decryptString(secretKeySpec, bs)));
            }
            return None$.MODULE$;
        });
        Bson bson = Updates$.MODULE$.unset("_elxEncrypted");
        return Updates$.MODULE$.combine((Seq)updates.$colon$colon((Object)bson));
    }

    public BsonString decryptString(SecretKeySpec secretKeySpec, BsonString text) {
        Cipher cipher = Cipher.getInstance(this.DefaultAlgorithm());
        cipher.init(2, (Key)secretKeySpec, this.IVParamSpec());
        byte[] bytes = cipher.doFinal(this.Base64Decoder().decode(text.getValue()));
        return BsonString$.MODULE$.apply(new String(bytes, Gravity$.MODULE$.UTF_8()));
    }

    public SecretKeySpec buildSecretKeySpec(String secret) {
        return new SecretKeySpec(this.hashSecret(Crypt$.MODULE$.encPrefixDecrypt(secret, false)), "AES");
    }

    /*
     * WARNING - void declaration
     */
    private static final List build$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        void var3_2;
        void var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 build$$anonfun$2() {
        MongoDBDecrypt$Info$ mongoDBDecrypt$Info$ = MongoDBDecrypt$Info$.MODULE$;
        return (Function1 & Serializable)p -> (MongoDBDecrypt.Info)mongoDBDecrypt$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        void var3_2;
        void var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$2() {
        MongoDBDecrypt$Info$ mongoDBDecrypt$Info$ = MongoDBDecrypt$Info$.MODULE$;
        return (Function1 & Serializable)p -> (MongoDBDecrypt.Info)mongoDBDecrypt$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    private static final MongoDBDecrypt.Info $anonfun$4() {
        return MongoDBDecrypt$Info$.MODULE$.apply(MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$1(), MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$2(), MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$3(), MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$4());
    }

    /*
     * WARNING - void declaration
     */
    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        void var3_2;
        void var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA4 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        MongoDBDecrypt$Info$ mongoDBDecrypt$Info$ = MongoDBDecrypt$Info$.MODULE$;
        return (Function1 & Serializable)p -> (MongoDBDecrypt.Info)mongoDBDecrypt$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple4$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)MongoDBDecrypt$Info$.MODULE$.$lessinit$greater$default$4()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$5() {
        Encoder encodeA;
        Encoder encodeA2;
        void var3_2;
        void var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA4 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$2) {
        String string = "pool";
        String string2 = "collectionField";
        String string3 = "fieldsField";
        String string4 = "secretField";
        int size = 4;
        Either either = implicits$.MODULE$.catsSyntaxEither(results$1.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", MongoDBDecrypt$::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), MongoDBDecrypt$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(MongoDBDecrypt$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            MongoDBDecrypt.Info info2 = (MongoDBDecrypt.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "pool";
            String string2 = "collectionField";
            String string3 = "fieldsField";
            String string4 = "secretField";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MongoDBDecrypt$::$anonfun$5, scala.package$.MODULE$.Nil().$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string5 = step$2.copy$default$1();
            String string6 = step$2.copy$default$2();
            String string7 = step$2.copy$default$3();
            String string8 = step$2.copy$default$4();
            String string9 = step$2.copy$default$5();
            boolean bl = step$2.copy$default$7();
            boolean bl2 = step$2.copy$default$8();
            return step$2.copy(string5, string6, string7, string8, string9, json, bl, bl2);
        });
    }

    private static final /* synthetic */ Document doRun$$anonfun$1$$anonfun$1$$anonfun$1(long count$1, long startTime$1, long endTime) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"count");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonInt64$.MODULE$.apply(count$1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"elapsedTime");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt64$.MODULE$.apply(endTime - startTime$1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    private static final /* synthetic */ Observable doRun$$anonfun$1$$anonfun$1(long startTime$2, long count) {
        return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{MODULE$.clock().now()})).map((Function1 & Serializable)endTime -> MongoDBDecrypt$.doRun$$anonfun$1$$anonfun$1$$anonfun$1(count, startTime$2, BoxesRunTime.unboxToLong((Object)endTime)));
    }

    private static final /* synthetic */ Observable doRun$$anonfun$1(Builder.Context cxt$3, RichMongoDatabase db$1, MongoDBDecrypt.Info info$2, Observable from$1, long startTime) {
        return MODULE$.updateEveryOne(cxt$3, db$1, info$2, (Observable<Document>)from$1).flatMap((Function1 & Serializable)count -> MongoDBDecrypt$.doRun$$anonfun$1$$anonfun$1(startTime, BoxesRunTime.unboxToLong((Object)count)));
    }

    private static final long updateEveryOne$$anonfun$1() {
        return 0L;
    }
}

