/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.structure.conversions;

import ambience.etl.structure.conversions.TypeConverter;
import com.elixirtech.arch.Crypt$;
import java.io.Serializable;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.bson.BsonBinary;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonString$;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class ToString$
implements TypeConverter,
Serializable {
    private static final String name;
    private static final DateTimeFormatter Formatter;
    public static final ToString$ MODULE$;

    private ToString$() {
    }

    static {
        MODULE$ = new ToString$();
        name = "String";
        Formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME.withLocale(Locale.getDefault()).withZone(ZoneId.systemDefault());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ToString$.class);
    }

    @Override
    public String name() {
        return name;
    }

    public DateTimeFormatter Formatter() {
        return Formatter;
    }

    public Option<BsonString> apply(BsonValue bv) {
        BsonValue bsonValue = bv;
        if (bsonValue instanceof BsonBoolean) {
            BsonBoolean b = (BsonBoolean)bsonValue;
            if (b.getValue()) {
                return Some$.MODULE$.apply((Object)BsonString$.MODULE$.apply("true"));
            }
            return Some$.MODULE$.apply((Object)BsonString$.MODULE$.apply("false"));
        }
        if (bsonValue instanceof BsonInt32) {
            BsonInt32 i = (BsonInt32)bsonValue;
            return Some$.MODULE$.apply((Object)BsonString$.MODULE$.apply(BoxesRunTime.boxToInteger((int)i.getValue()).toString()));
        }
        if (bsonValue instanceof BsonInt64) {
            BsonInt64 i = (BsonInt64)bsonValue;
            return Some$.MODULE$.apply((Object)BsonString$.MODULE$.apply(BoxesRunTime.boxToLong((long)i.getValue()).toString()));
        }
        if (bsonValue instanceof BsonDouble) {
            BsonDouble d = (BsonDouble)bsonValue;
            return Some$.MODULE$.apply((Object)BsonString$.MODULE$.apply(BoxesRunTime.boxToDouble((double)d.getValue()).toString()));
        }
        if (bsonValue instanceof BsonDecimal128) {
            BsonDecimal128 d = (BsonDecimal128)bsonValue;
            return Some$.MODULE$.apply((Object)BsonString$.MODULE$.apply(d.getValue().toString()));
        }
        if (bsonValue instanceof BsonString) {
            BsonString s = (BsonString)bsonValue;
            return Some$.MODULE$.apply((Object)BsonString$.MODULE$.apply(Crypt$.MODULE$.encPrefixDecrypt(s.getValue())));
        }
        if (bsonValue instanceof BsonDateTime) {
            BsonDateTime dt = (BsonDateTime)bsonValue;
            return Some$.MODULE$.apply((Object)BsonString$.MODULE$.apply(this.Formatter().format(Instant.ofEpochMilli(dt.getValue()))));
        }
        if (bsonValue instanceof BsonBinary) {
            BsonBinary bytes = (BsonBinary)bsonValue;
            return Some$.MODULE$.apply((Object)BsonString$.MODULE$.apply(new String(bytes.getData(), "UTF-8")));
        }
        return None$.MODULE$;
    }
}

