/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.xlsx;

import ambience.etl.BsonExtractJson$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLJsonParsingException;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.ETLURL;
import ambience.etl.ETLURL$;
import ambience.etl.package$;
import ambience.etl.xlsx.XlsxCategory$;
import ambience.etl.xlsx.XlsxDefinition;
import ambience.etl.xlsx.XlsxDefinition$;
import ambience.etl.xlsx.XlsxReader;
import ambience.etl.xlsx.XlsxReader$Header$;
import ambience.etl.xlsx.XlsxReader$Record$;
import ambience.etl.xlsx.XlsxReader$XlsxRecordDef$;
import ambience.etl.xlsx.XlsxReader$XlsxStream$;
import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.BsonUtils$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import monix.eval.Task$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple6$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class XlsxReader$
implements Builder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(XlsxReader$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final String stepType;
    public static final XlsxReader$XlsxRecordDef$ XlsxRecordDef;
    public static final XlsxReader$Header$ Header;
    public static final XlsxReader$XlsxStream$ XlsxStream;
    public static final XlsxReader$Record$ Record;
    private static final Function1 getDef;
    private static final Function1 defToStream;
    private static final Function1 streamToRecord;
    private static final Function1 setBase;
    private static final Function1 pipeline;
    public static final XlsxReader$ MODULE$;

    private XlsxReader$() {
    }

    static {
        MODULE$ = new XlsxReader$();
        stepType = ETLStepType$.MODULE$.apply("xlsx.Reader");
        getDef = (Function1 & Serializable)from -> from.flatMap((Function1 & Serializable)doc -> {
            Json json = BsonExtractJson$.MODULE$.toJson((BsonValue)doc.toBsonDocument());
            String string = "url";
            String string2 = "sheet";
            String string3 = "headerRows";
            String string4 = "startRow";
            String string5 = "password";
            String string6 = "base";
            int size = 6;
            Either either = XlsxDefinition$.MODULE$.XlsxDefinitionJson().deepMerge(json).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("XlsxDefinition", this::$init$$$anonfun$1$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), this::$init$$$anonfun$1$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(this::$init$$$anonfun$1$$anonfun$1$$anonfun$3)))));
            if (either instanceof Right) {
                XlsxDefinition xdef = (XlsxDefinition)((Right)either).value();
                return Observable$.MODULE$.now((Object)XlsxReader$XlsxRecordDef$.MODULE$.apply((Document)doc, xdef));
            }
            if (either instanceof Left) {
                DecodingFailure err = (DecodingFailure)((Left)either).value();
                return Observable$.MODULE$.raiseError((Throwable)new ETLJsonParsingException("Can't read XlsxDefinition", json, (Throwable)err));
            }
            throw new MatchError((Object)either);
        });
        defToStream = (Function1 & Serializable)from -> from.flatMap((Function1 & Serializable)xlsxDef -> {
            ETLURL url = ETLURL$.MODULE$.apply(xlsxDef.doc(), xlsxDef.xdef().url());
            boolean readable = url.optFile().forall((Function1 & Serializable)f -> this.canRead((File)f));
            if (!readable) {
                return Observable$.MODULE$.raiseError((Throwable)new IOException("XlsxReader reading from " + xlsxDef.xdef().url() + " disallowed (see elixir.data.xlsx.readable)"));
            }
            InputStream in = url.openStream();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(xlsxDef.xdef().password()))) {
                POIFSFileSystem fs = new POIFSFileSystem(in);
                EncryptionInfo encInfo = new EncryptionInfo(fs);
                Decryptor dec = encInfo.getDecryptor();
                dec.verifyPassword(Crypt$.MODULE$.encPrefixDecrypt(xlsxDef.xdef().password()));
                InputStream dataStream = dec.getDataStream(fs);
                XSSFWorkbook wb = new XSSFWorkbook(dataStream);
                return Observable$.MODULE$.now((Object)XlsxReader$XlsxStream$.MODULE$.apply(xlsxDef.xdef(), wb)).guarantee(Task$.MODULE$.apply((Function0 & Serializable)() -> {
                    this.$init$$$anonfun$2$$anonfun$1$$anonfun$1(wb, dataStream, in);
                    return BoxedUnit.UNIT;
                }));
            }
            XSSFWorkbook wb = new XSSFWorkbook(in);
            return Observable$.MODULE$.now((Object)XlsxReader$XlsxStream$.MODULE$.apply(xlsxDef.xdef(), wb)).guarantee(Task$.MODULE$.apply(() -> this.$init$$$anonfun$2$$anonfun$1$$anonfun$2(wb)).void());
        });
        streamToRecord = (Function1 & Serializable)from -> from.flatMap((Function1 & Serializable)in -> {
            Option optBase = Try$.MODULE$.apply(() -> this.$anonfun$2(in)).toOption();
            Iterator it = in.xlsxDef().sheet().trim().isEmpty() ? CollectionConverters$.MODULE$.IteratorHasAsScala(in.workbook().sheetIterator()).asScala().collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Sheet x) {
                    Sheet sheet = x;
                    if (sheet instanceof XSSFSheet) {
                        XSSFSheet x2 = (XSSFSheet)sheet;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Sheet x, Function1 function1) {
                    Sheet sheet = x;
                    if (sheet instanceof XSSFSheet) {
                        XSSFSheet x2 = (XSSFSheet)sheet;
                        return x2;
                    }
                    return function1.apply((Object)x);
                }
            }).flatMap((Function1 & Serializable)sheet -> {
                List headers = in.xlsxDef().headerRows().map((Function1 & Serializable)_$1 -> this.$anonfun$4((XSSFSheet)sheet, BoxesRunTime.unboxToInt((Object)_$1)));
                XlsxReader.Header header = (XlsxReader.Header)headers.foldLeft((Object)XlsxReader$Header$.MODULE$.apply((List<String>)scala.package$.MODULE$.Nil()), (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        XlsxReader.Header a = (XlsxReader.Header)tuple2._1();
                        XlsxReader.Header b = (XlsxReader.Header)tuple2._2();
                        return a.mergeWith(b);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return this.buildRows((XSSFSheet)sheet, in.xlsxDef().startRow(), header, (Option<String>)Some$.MODULE$.apply((Object)sheet.getSheetName())).iterator();
            }) : (Iterator)Option$.MODULE$.apply((Object)in.workbook().getSheet(in.xlsxDef().sheet())).map((Function1 & Serializable)sheet -> {
                List headers = in.xlsxDef().headerRows().map((Function1 & Serializable)_$2 -> this.$anonfun$7((XSSFSheet)sheet, BoxesRunTime.unboxToInt((Object)_$2)));
                XlsxReader.Header header = (XlsxReader.Header)headers.foldLeft((Object)XlsxReader$Header$.MODULE$.apply((List<String>)scala.package$.MODULE$.Nil()), (Function2 & Serializable)(x$1, x$2) -> {
                    Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple2 != null) {
                        XlsxReader.Header a = (XlsxReader.Header)tuple2._1();
                        XlsxReader.Header b = (XlsxReader.Header)tuple2._2();
                        return a.mergeWith(b);
                    }
                    throw new MatchError((Object)tuple2);
                });
                return this.buildRows((XSSFSheet)sheet, in.xlsxDef().startRow(), header, (Option<String>)None$.MODULE$).iterator();
            }).getOrElse(this::$anonfun$9);
            return Observable$.MODULE$.fromIterator(Task$.MODULE$.apply(() -> this.$init$$$anonfun$3$$anonfun$1$$anonfun$1(it))).map((Function1 & Serializable)doc -> XlsxReader$Record$.MODULE$.apply((Option<Document>)optBase, (Document)doc));
        });
        setBase = (Function1 & Serializable)from -> from.map((Function1 & Serializable)rec -> {
            Option<Document> option = rec.optBase();
            if (option instanceof Some) {
                Document base = (Document)((Some)option).value();
                return base.$plus$plus((IterableOnce)rec.actual());
            }
            if (None$.MODULE$.equals(option)) {
                return rec.actual();
            }
            throw new MatchError(option);
        });
        pipeline = MODULE$.getDef().andThen(MODULE$.defToStream()).andThen(MODULE$.streamToRecord()).andThen(MODULE$.setBase());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(XlsxReader$.class);
    }

    public String stepType() {
        return stepType;
    }

    public Function1<Observable<Document>, Observable<XlsxReader.XlsxRecordDef>> getDef() {
        return getDef;
    }

    public Function1<Observable<XlsxReader.XlsxRecordDef>, Observable<XlsxReader.XlsxStream>> defToStream() {
        return defToStream;
    }

    public Function1<Observable<XlsxReader.XlsxStream>, Observable<XlsxReader.Record>> streamToRecord() {
        return streamToRecord;
    }

    public Function1<Observable<XlsxReader.Record>, Observable<Document>> setBase() {
        return setBase;
    }

    public Function1<Observable<Document>, Observable<Document>> pipeline() {
        return pipeline;
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        return scala.package$.MODULE$.Right().apply(this.pipeline());
    }

    public XlsxReader.Header buildHeader(XSSFSheet sheet, int i) {
        return (XlsxReader.Header)Option$.MODULE$.apply((Object)sheet.getRow(i - 1)).map((Function1 & Serializable)row -> XlsxReader$Header$.MODULE$.apply((List<String>)MODULE$.headerText((XSSFRow)row, 0).toList())).getOrElse(XlsxReader$::buildHeader$$anonfun$2);
    }

    public LazyList<String> headerText(XSSFRow row, int col) {
        Option option = Option$.MODULE$.apply((Object)row.getCell(col));
        if (option instanceof Some) {
            XSSFCell cell = (XSSFCell)((Some)option).value();
            scala.package$.MODULE$.LazyList();
            return LazyList.cons$.MODULE$.apply(() -> XlsxReader$.headerText$$anonfun$1(cell), () -> XlsxReader$.headerText$$anonfun$2(row, col));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.LazyList().empty();
        }
        throw new MatchError((Object)option);
    }

    public LazyList<Document> buildRows(XSSFSheet sheet, int i, XlsxReader.Header header, Option<String> optSheetName) {
        Option<Document> option = this.buildRow(sheet, i, header, optSheetName);
        if (option instanceof Some) {
            Document doc = (Document)((Some)option).value();
            scala.package$.MODULE$.LazyList();
            return LazyList.cons$.MODULE$.apply(() -> XlsxReader$.buildRows$$anonfun$1(doc), () -> XlsxReader$.buildRows$$anonfun$2(sheet, i, header, optSheetName));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.LazyList().empty();
        }
        throw new MatchError(option);
    }

    public Option<Document> buildRow(XSSFSheet sheet, int i, XlsxReader.Header header, Option<String> optSheetName) {
        BsonDocument doc = new BsonDocument();
        return Option$.MODULE$.apply((Object)sheet.getRow(i - 1)).map((Function1 & Serializable)row -> {
            ((List)header.names().zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String h = (String)tuple2._1();
                    int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return doc.append(h, MODULE$.cellValue((XSSFRow)row, idx));
                }
                throw new MatchError((Object)tuple2);
            });
            optSheetName.foreach((Function1 & Serializable)s -> doc.append("sheet", (BsonValue)new BsonString(s)));
            return Document$.MODULE$.apply(doc);
        });
    }

    public BsonValue cellValue(XSSFRow row, int col) {
        Option option = Option$.MODULE$.apply((Object)row.getCell(col, Row.MissingCellPolicy.CREATE_NULL_AS_BLANK));
        if (option instanceof Some) {
            XSSFCell cell = (XSSFCell)((Some)option).value();
            return this.getValue((Cell)cell);
        }
        if (None$.MODULE$.equals(option)) {
            return BsonUtils$.MODULE$.Null();
        }
        throw new MatchError((Object)option);
    }

    public String getString(XSSFCell cell) {
        return BsonUtils$.MODULE$.asString(this.getValue((Cell)cell));
    }

    public BsonValue getValue(Cell cell) {
        return (BsonValue)Try$.MODULE$.apply(() -> XlsxReader$.getValue$$anonfun$1(cell)).getOrElse(() -> XlsxReader$.getValue$$anonfun$2(cell));
    }

    public boolean canRead(File f) {
        boolean ret = XlsxCategory$.MODULE$.XLSXReadable().exists((Function1 & Serializable)base -> com.elixirtech.arch.package$.MODULE$.enrichFile(f).isChildOf(base));
        if (!ret) {
            this.log().info(() -> XlsxReader$.canRead$$anonfun$1(f), Line$.MODULE$.apply(188), FullName$.MODULE$.apply("ambience.etl.xlsx.XlsxReader.canRead"));
            this.log().info(XlsxReader$::canRead$$anonfun$2, Line$.MODULE$.apply(189), FullName$.MODULE$.apply("ambience.etl.xlsx.XlsxReader.canRead"));
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private final List $init$$$anonfun$1$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        Decoder decodeA5;
        void var2_1;
        Decoder decodeA6 = Decoder$.MODULE$.decodeString();
        void var1_2 = var2_1;
        Decoder decoder = decodeA5 = Decoder$.MODULE$.decodeString();
        Decoder decoder2 = decodeA4 = Decoder$.MODULE$.decodeList(Decoder$.MODULE$.decodeInt());
        Decoder decoder3 = decodeA3 = Decoder$.MODULE$.decodeInt();
        Decoder decoder4 = decodeA2 = Decoder$.MODULE$.decodeString();
        Decoder decoder5 = decodeA = Decoder$.MODULE$.decodeJson();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder5).$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var1_2);
    }

    private final Function1 $init$$$anonfun$1$$anonfun$1$$anonfun$2() {
        XlsxDefinition$ xlsxDefinition$ = XlsxDefinition$.MODULE$;
        return (Function1 & Serializable)p -> (XlsxDefinition)xlsxDefinition$.fromProduct((Product)p);
    }

    private final Product $init$$$anonfun$1$$anonfun$1$$anonfun$3() {
        return Tuple6$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)XlsxDefinition$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)XlsxDefinition$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply(XlsxDefinition$.MODULE$.$lessinit$greater$default$3()), (Object)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)XlsxDefinition$.MODULE$.$lessinit$greater$default$4())), (Object)Some$.MODULE$.apply((Object)XlsxDefinition$.MODULE$.$lessinit$greater$default$5()), (Object)Some$.MODULE$.apply((Object)XlsxDefinition$.MODULE$.$lessinit$greater$default$6()));
    }

    private final void $init$$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(XSSFWorkbook wb$2) {
        wb$2.close();
    }

    private final void $init$$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(InputStream dataStream$2) {
        dataStream$2.close();
    }

    private final void $init$$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3(InputStream in$2) {
        in$2.close();
    }

    private final void $init$$$anonfun$2$$anonfun$1$$anonfun$1(XSSFWorkbook wb$1, InputStream dataStream$1, InputStream in$1) {
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$init$$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$1(wb$1);
            return BoxedUnit.UNIT;
        });
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$init$$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$2(dataStream$1);
            return BoxedUnit.UNIT;
        });
        Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$init$$$anonfun$2$$anonfun$1$$anonfun$1$$anonfun$3(in$1);
            return BoxedUnit.UNIT;
        });
    }

    private final void $init$$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(XSSFWorkbook wb$4) {
        wb$4.close();
    }

    private final Try $init$$$anonfun$2$$anonfun$1$$anonfun$2(XSSFWorkbook wb$3) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$init$$$anonfun$2$$anonfun$1$$anonfun$2$$anonfun$1(wb$3);
            return BoxedUnit.UNIT;
        });
    }

    private final Document $anonfun$2(XlsxReader.XlsxStream in$3) {
        return package$.MODULE$.ETLRecord().apply(in$3.xlsxDef().base().noSpaces());
    }

    private final /* synthetic */ XlsxReader.Header $anonfun$4(XSSFSheet sheet$1, int _$1) {
        return this.buildHeader(sheet$1, _$1);
    }

    private final /* synthetic */ XlsxReader.Header $anonfun$7(XSSFSheet sheet$2, int _$2) {
        return this.buildHeader(sheet$2, _$2);
    }

    private final Iterator $anonfun$9() {
        return scala.package$.MODULE$.Iterator().empty();
    }

    private final Iterator $init$$$anonfun$3$$anonfun$1$$anonfun$1(Iterator it$1) {
        return it$1;
    }

    public static final /* synthetic */ String ambience$etl$xlsx$XlsxReader$Header$$_$_$$anonfun$10(Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            String a = (String)tuple2._1();
            String b = (String)tuple2._2();
            return a + " " + b;
        }
        throw new MatchError((Object)tuple2);
    }

    private static final XlsxReader.Header buildHeader$$anonfun$2() {
        return XlsxReader$Header$.MODULE$.apply((List<String>)scala.package$.MODULE$.Nil());
    }

    private static final String headerText$$anonfun$1(XSSFCell cell$1) {
        return MODULE$.getString(cell$1);
    }

    private static final LazyList headerText$$anonfun$2(XSSFRow row$1, int col$1) {
        return MODULE$.headerText(row$1, col$1 + 1);
    }

    private static final Document buildRows$$anonfun$1(Document doc$1) {
        return doc$1;
    }

    private static final LazyList buildRows$$anonfun$2(XSSFSheet sheet$3, int i$1, XlsxReader.Header header$1, Option optSheetName$1) {
        return MODULE$.buildRows(sheet$3, i$1 + 1, header$1, (Option<String>)optSheetName$1);
    }

    private static final BsonDouble $anonfun$11(Cell cell$3) {
        return new BsonDouble(cell$3.getNumericCellValue());
    }

    private static final BsonValue getValue$$anonfun$1$$anonfun$1(Cell cell$4) {
        return new BsonString(cell$4.getStringCellValue());
    }

    private static final BsonValue getValue$$anonfun$1(Cell cell$2) {
        CellType cellType = cell$2.getCellType();
        CellType cellType2 = CellType.BLANK;
        CellType cellType3 = cellType;
        if (!(cellType2 != null ? !cellType2.equals(cellType3) : cellType3 != null)) {
            return new BsonString("");
        }
        CellType cellType4 = CellType.BOOLEAN;
        CellType cellType5 = cellType;
        if (!(cellType4 != null ? !cellType4.equals(cellType5) : cellType5 != null)) {
            return new BsonBoolean(cell$2.getBooleanCellValue());
        }
        CellType cellType6 = CellType.ERROR;
        CellType cellType7 = cellType;
        if (!(cellType6 != null ? !cellType6.equals(cellType7) : cellType7 != null)) {
            return BsonUtils$.MODULE$.Null();
        }
        CellType cellType8 = CellType.FORMULA;
        CellType cellType9 = cellType;
        if (!(cellType8 != null ? !cellType8.equals(cellType9) : cellType9 != null)) {
            Option numericValue = Try$.MODULE$.apply(() -> XlsxReader$.$anonfun$11(cell$2)).toOption();
            return (BsonValue)numericValue.getOrElse(() -> XlsxReader$.getValue$$anonfun$1$$anonfun$1(cell$2));
        }
        CellType cellType10 = CellType.NUMERIC;
        CellType cellType11 = cellType;
        if (!(cellType10 != null ? !cellType10.equals(cellType11) : cellType11 != null)) {
            return (BsonValue)(DateUtil.isCellDateFormatted((Cell)cell$2) ? new BsonDateTime(cell$2.getDateCellValue().getTime()) : new BsonDouble(cell$2.getNumericCellValue()));
        }
        CellType cellType12 = CellType.STRING;
        CellType cellType13 = cellType;
        if (!(cellType12 != null ? !cellType12.equals(cellType13) : cellType13 != null)) {
            return new BsonString(cell$2.getStringCellValue());
        }
        CellType cellType14 = CellType._NONE;
        CellType cellType15 = cellType;
        if (!(cellType14 != null ? !cellType14.equals(cellType15) : cellType15 != null)) {
            return BsonUtils$.MODULE$.Null();
        }
        if (cellType == null) {
            return BsonUtils$.MODULE$.Null();
        }
        throw new MatchError((Object)cellType);
    }

    private static final Object getValue$$anonfun$2$$anonfun$1(Cell cell$6) {
        return "Can't read cell " + cell$6.getAddress();
    }

    private static final BsonValue getValue$$anonfun$2(Cell cell$5) {
        MODULE$.log().warn(() -> XlsxReader$.getValue$$anonfun$2$$anonfun$1(cell$5), Line$.MODULE$.apply(180), FullName$.MODULE$.apply("ambience.etl.xlsx.XlsxReader.getValue"));
        return BsonUtils$.MODULE$.Null();
    }

    private static final Object canRead$$anonfun$1(File f$2) {
        return "canRead: " + f$2.getAbsolutePath();
    }

    private static final Object canRead$$anonfun$2() {
        return "Does not match:\n" + XlsxCategory$.MODULE$.XLSXReadable().map((Function1 & Serializable)_$3 -> _$3.getAbsolutePath()).mkString("\n");
    }
}

