/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.s3;

import ambience.etl.s3.AWSInfo;
import ambience.etl.s3.AssumeRoleHelper;
import ambience.etl.s3.AssumeRoleHelper$;
import ambience.etl.s3.AssumeRoleHelper$STSEndpointConfig$;
import ambience.etl.s3.AssumeRoleHelper$STSRegionConfig$;
import ambience.etl.s3.S3Builder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class S3Builder$
implements LoggingHelper2,
Serializable {
    private volatile Object log$lzy1;
    public static final S3Builder$ MODULE$ = new S3Builder$();

    private S3Builder$() {
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, S3Builder.OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, S3Builder.OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, S3Builder.OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, S3Builder.OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(S3Builder$.class);
    }

    public List<Panel.Item> buildStandardPanelItems(AWSInfo info) {
        Panel.Item regionField = PanelItem$.MODULE$.text("region", "Region Field", info.region(), PanelItem$.MODULE$.text$default$4());
        Panel.Item accessField = PanelItem$.MODULE$.text("access", "Access Id Field", info.access(), PanelItem$.MODULE$.text$default$4());
        Panel.Item secretField = PanelItem$.MODULE$.text("secret", "Secret Field", info.secret(), PanelItem$.MODULE$.text$default$4());
        Panel.Item bucketField = PanelItem$.MODULE$.text("bucket", "Bucket Field", info.bucket(), PanelItem$.MODULE$.text$default$4());
        Panel.Item pathField = PanelItem$.MODULE$.text("path", "Path Field", info.path(), PanelItem$.MODULE$.text$default$4());
        Panel.Item roleArn = PanelItem$.MODULE$.text("roleArn", "Role ARN", info.roleArn(), PanelItem$.MODULE$.text$default$4());
        Panel.Item roleSessionName = PanelItem$.MODULE$.text("roleSessionName", "Session Name", info.roleSessionName(), PanelItem$.MODULE$.text$default$4());
        Panel.Item stsServiceEndpoint = PanelItem$.MODULE$.text("stsServiceEndpoint", "STS Endpoint", info.stsServiceEndpoint(), PanelItem$.MODULE$.text$default$4());
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Panel.Item[]{regionField, accessField, secretField, bucketField, pathField, roleArn, roleSessionName, stsServiceEndpoint}));
    }

    public <T> T client(AWSInfo info, Function1<S3Client, T> fn) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(info.roleArn()))) {
            return this.assumeClient(info.region(), info.creds(), info.roleArn(), info.roleSessionName(), info.stsServiceEndpoint(), fn);
        }
        return this.directClient(info.region(), info.creds(), fn);
    }

    public <T> T directClient(String regionName, AwsCredentials credentials, Function1<S3Client, T> fn) {
        this.log().info(S3Builder$::directClient$$anonfun$1, Line$.MODULE$.apply(40), FullName$.MODULE$.apply("ambience.etl.s3.S3Builder.directClient"));
        Region region = Region.of((String)regionName);
        StaticCredentialsProvider credsProvider = StaticCredentialsProvider.create((AwsCredentials)credentials);
        return (T)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
            S3Client s3 = (S3Client)arm.manage(S3Client.builder().region(region).credentialsProvider((AwsCredentialsProvider)credsProvider).build());
            return fn.apply((Object)s3);
        });
    }

    public <T> T assumeClient(String regionName, AwsCredentials creds, String roleArn, String roleSessionName, String serviceEndpoint, Function1<S3Client, T> fn) {
        this.log().info(() -> S3Builder$.assumeClient$$anonfun$1(roleArn), Line$.MODULE$.apply(57), FullName$.MODULE$.apply("ambience.etl.s3.S3Builder.assumeClient"));
        Region region = Region.of((String)regionName);
        AssumeRoleHelper.STSConfig stsConfig = serviceEndpoint.trim().isEmpty() ? AssumeRoleHelper$STSRegionConfig$.MODULE$.apply(region) : AssumeRoleHelper$STSEndpointConfig$.MODULE$.apply(region, serviceEndpoint);
        AssumeRoleRequest roleRequest = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName(roleSessionName).build();
        return (T)ARM$.MODULE$.run((Function1 & Serializable)arm -> {
            StsClient client = (StsClient)arm.manage((Object)AssumeRoleHelper$.MODULE$.buildSts(creds, stsConfig));
            StsAssumeRoleCredentialsProvider provider = (StsAssumeRoleCredentialsProvider)arm.manage((Object)((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(client)).refreshRequest(roleRequest).build());
            S3Client s3 = (S3Client)arm.manage(S3Client.builder().credentialsProvider((AwsCredentialsProvider)provider).region(region).build());
            return fn.apply((Object)s3);
        });
    }

    private static final Object directClient$$anonfun$1() {
        return "direct client";
    }

    private static final Object assumeClient$$anonfun$1(String roleArn$1) {
        return "assume client " + roleArn$1;
    }
}

