/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.s3v2;

import ambience.bson.BsonETL$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.s3v2.Bucket;
import ambience.etl.s3v2.Bucket$;
import ambience.etl.s3v2.S3Category$;
import ambience.etl.s3v2.S3GenerateExpiringURL;
import ambience.etl.s3v2.S3GenerateExpiringURL$Info$;
import ambience.etl.s3v2.S3GenerateExpiringURL$Result$;
import ambience.etl.s3v2.S3Logic$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import java.time.Duration;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.matching.Regex;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class S3GenerateExpiringURL$
implements Builder,
PanelBuilder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(S3GenerateExpiringURL$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final String stepType;
    public static final S3GenerateExpiringURL$Info$ Info;
    private static final Json InfoJson;
    private static final Regex ExpiryRE;
    private static final long OneSecondMS;
    private static final long OneMinuteMS;
    private static final long OneHourMS;
    private static final long OneDayMS;
    private static final long OneWeekMS;
    public static final S3GenerateExpiringURL$Result$ Result;
    public static final S3GenerateExpiringURL$ MODULE$;

    private S3GenerateExpiringURL$() {
    }

    static {
        MODULE$ = new S3GenerateExpiringURL$();
        stepType = ETLStepType$.MODULE$.apply("s3v2.GenerateExpiringURL");
        S3GenerateExpiringURL.Info info = (S3GenerateExpiringURL.Info)package$.MODULE$.EncoderOps((Object)S3GenerateExpiringURL$Info$.MODULE$.apply(S3GenerateExpiringURL$Info$.MODULE$.$lessinit$greater$default$1(), S3GenerateExpiringURL$Info$.MODULE$.$lessinit$greater$default$2(), S3GenerateExpiringURL$Info$.MODULE$.$lessinit$greater$default$3()));
        String string = "bucket";
        String string2 = "path";
        String string3 = "expiry";
        InfoJson = package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        ExpiryRE = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(\\d+)\\s*(week|day|hour|minute|second)s?"));
        OneSecondMS = 1000L;
        OneMinuteMS = 60L * MODULE$.OneSecondMS();
        OneHourMS = 60L * MODULE$.OneMinuteMS();
        OneDayMS = 24L * MODULE$.OneHourMS();
        OneWeekMS = 7L * MODULE$.OneDayMS();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(S3GenerateExpiringURL$.class);
    }

    public String stepType() {
        return stepType;
    }

    public Json InfoJson() {
        return InfoJson;
    }

    public Regex ExpiryRE() {
        return ExpiryRE;
    }

    public long OneSecondMS() {
        return OneSecondMS;
    }

    public long OneMinuteMS() {
        return OneMinuteMS;
    }

    public long OneHourMS() {
        return OneHourMS;
    }

    public long OneDayMS() {
        return OneDayMS;
    }

    public long OneWeekMS() {
        return OneWeekMS;
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "bucket";
        String string2 = "path";
        String string3 = "expiry";
        int size = 3;
        S3GenerateExpiringURL.Info info = (S3GenerateExpiringURL.Info)this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", S3GenerateExpiringURL$::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), S3GenerateExpiringURL$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(S3GenerateExpiringURL$::$anonfun$3))))).toOption().getOrElse(S3GenerateExpiringURL$::$anonfun$4);
        return S3Category$.MODULE$.bucketChoicesT().map((Function1 & Serializable)bucketChoices -> {
            Panel.Item bucketField = PanelItem$.MODULE$.select("bucket", "Bucket", Json$.MODULE$.fromString(info.bucket()), bucketChoices, PanelItem$.MODULE$.select$default$5());
            Panel.Item pathField = PanelItem$.MODULE$.text("path", "Path Field", info.path(), PanelItem$.MODULE$.text$default$4());
            Panel.Item expiryField = PanelItem$.MODULE$.text("expiry", "Expire After", info.expiry(), PanelItem$.MODULE$.text$default$4());
            Panel.Item infoField = PanelItem$.MODULE$.html("(Maximum expiry is 7 days)");
            return Panel$.MODULE$.apply((List)new .colon.colon((Object)bucketField, (List)new .colon.colon((Object)pathField, (List)new .colon.colon((Object)expiryField, (List)new .colon.colon((Object)infoField, (List)Nil$.MODULE$)))));
        });
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> S3GenerateExpiringURL$.savePanel$$anonfun$1(results, step));
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "bucket";
        String string2 = "path";
        String string3 = "expiry";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", S3GenerateExpiringURL$::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), S3GenerateExpiringURL$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(S3GenerateExpiringURL$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> MODULE$.run(cxt, (S3GenerateExpiringURL.Info)info, (Observable<Document>)from));
    }

    public Observable<Document> run(Builder.Context cxt, S3GenerateExpiringURL.Info info, Observable<Document> from) {
        return from.mapEval((Function1 & Serializable)doc -> MODULE$.getFile(cxt, info, (Document)doc));
    }

    public Task<Document> getFile(Builder.Context cxt, S3GenerateExpiringURL.Info info, Document doc) {
        EitherT reply = EitherT$.MODULE$.apply(Bucket$.MODULE$.load(info.bucket())).flatMap((Function1 & Serializable)bucket -> EitherT$.MODULE$.apply(S3Logic$.MODULE$.credentials(cxt.user(), (Bucket)bucket)).flatMap((Function1 & Serializable)creds -> EitherT$.MODULE$.apply(MODULE$.getExpiry(info.expiry())).flatMap((Function1 & Serializable)expiryMs -> S3GenerateExpiringURL$.$anonfun$6$$anonfun$1$$anonfun$1(bucket, creds, info, doc, BoxesRunTime.unboxToLong((Object)expiryMs)), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        return ((Task)reply.value()).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                S3GenerateExpiringURL.Result result = (S3GenerateExpiringURL.Result)((Right)either).value();
                return cxt.logRecord(result.doc(), result.msg());
            }
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                MODULE$.log().apply(msg, Line$.MODULE$.apply(76), FullName$.MODULE$.apply("ambience.etl.s3v2.S3GenerateExpiringURL.getFile"));
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)msg.msg()), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
                return cxt.logRecord((Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), msg);
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Either<LogMessage, Object>> getExpiry(String s) {
        return Task$.MODULE$.apply(() -> S3GenerateExpiringURL$.getExpiry$$anonfun$1(s));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Either<LogMessage, Object> getExpiry(String number, String units) {
        Option option;
        block9: {
            long l;
            int num;
            block10: {
                option = StringOps$.MODULE$.toIntOption$extension(Predef$.MODULE$.augmentString(number));
                if (!(option instanceof Some)) break block9;
                num = BoxesRunTime.unboxToInt((Object)((Some)option).value());
                String string = units;
                switch (string == null ? 0 : string.hashCode()) {
                    case -1074026988: {
                        if (!"minute".equals(string)) break;
                        l = this.OneMinuteMS();
                        break block10;
                    }
                    case -906279820: {
                        if (!"second".equals(string)) break;
                        l = this.OneSecondMS();
                        break block10;
                    }
                    case 99228: {
                        if (!"day".equals(string)) break;
                        l = this.OneDayMS();
                        break block10;
                    }
                    case 3208676: {
                        if (!"hour".equals(string)) break;
                        l = this.OneHourMS();
                        break block10;
                    }
                    case 3645428: {
                        if (!"week".equals(string)) break;
                        l = this.OneWeekMS();
                        break block10;
                    }
                }
                l = 0L;
            }
            long mult = l;
            long total = mult * (long)num;
            if (total <= this.OneWeekMS()) {
                return scala.package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToLong((long)total));
            }
            return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Maximum expiry is one week"));
        }
        if (None$.MODULE$.equals(option)) {
            return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Can't parse integer " + number));
        }
        throw new MatchError((Object)option);
    }

    public String extraPath(S3GenerateExpiringURL.Info info, Document doc) {
        BsonValue bsonValue;
        if (info.path().isEmpty()) {
            return "";
        }
        Option option = BsonETL$.MODULE$.get(doc, info.path());
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonString) {
            BsonString value = (BsonString)bsonValue;
            return value.getValue();
        }
        return "";
    }

    public S3GenerateExpiringURL.Result tryGetFileURL(S3GenerateExpiringURL.Info info, Document doc, Bucket bucket, long expiryMs, S3Client s3Client) {
        S3GenerateExpiringURL.Result result;
        try {
            result = this.getFileURL(info, doc, bucket, expiryMs, s3Client);
        }
        catch (Exception ex) {
            this.log().error(() -> S3GenerateExpiringURL$.tryGetFileURL$$anonfun$1(ex), (Throwable)ex, Line$.MODULE$.apply(118), FullName$.MODULE$.apply("ambience.etl.s3v2.S3GenerateExpiringURL.tryGetFileURL"));
            result = S3GenerateExpiringURL$Result$.MODULE$.apply(doc, (LogMessage)LogMessage.Error$.MODULE$.apply("S3Get failed: " + ex));
        }
        return result;
    }

    public S3GenerateExpiringURL.Result getFileURL(S3GenerateExpiringURL.Info info, Document doc, Bucket bucket, long expiryMs, S3Client s3Client) {
        String extra = this.extraPath(info, doc);
        String location = bucket.path() + extra;
        GetObjectRequest req = (GetObjectRequest)GetObjectRequest.builder().bucket(bucket.bucket()).key(location).build();
        GetObjectPresignRequest req2 = GetObjectPresignRequest.builder().signatureDuration(Duration.ofMillis(expiryMs)).getObjectRequest(req).build();
        S3Presigner presigner = S3Presigner.create();
        PresignedGetObjectRequest presignedRequest = presigner.presignGetObject(req2);
        LogMessage.Info msg = LogMessage.Info$.MODULE$.apply("Presigned URL for " + bucket.info(extra));
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"url");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(presignedRequest.url().toExternalForm())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return S3GenerateExpiringURL$Result$.MODULE$.apply((Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (LogMessage)msg);
    }

    /*
     * WARNING - void declaration
     */
    private final List $init$$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        void var2_1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$2() {
        S3GenerateExpiringURL$Info$ s3GenerateExpiringURL$Info$ = S3GenerateExpiringURL$Info$.MODULE$;
        return (Function1 & Serializable)p -> (S3GenerateExpiringURL.Info)s3GenerateExpiringURL$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)S3GenerateExpiringURL$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)S3GenerateExpiringURL$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)S3GenerateExpiringURL$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final S3GenerateExpiringURL.Info $anonfun$4() {
        return S3GenerateExpiringURL$Info$.MODULE$.apply(S3GenerateExpiringURL$Info$.MODULE$.$lessinit$greater$default$1(), S3GenerateExpiringURL$Info$.MODULE$.$lessinit$greater$default$2(), S3GenerateExpiringURL$Info$.MODULE$.$lessinit$greater$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        S3GenerateExpiringURL$Info$ s3GenerateExpiringURL$Info$ = S3GenerateExpiringURL$Info$.MODULE$;
        return (Function1 & Serializable)p -> (S3GenerateExpiringURL.Info)s3GenerateExpiringURL$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)S3GenerateExpiringURL$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)S3GenerateExpiringURL$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)S3GenerateExpiringURL$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$5() {
        Encoder encodeA;
        void var3_2;
        void var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$1) {
        String string = "bucket";
        String string2 = "path";
        String string3 = "expiry";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(MODULE$.InfoJson().deepMerge(results$1).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", S3GenerateExpiringURL$::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), S3GenerateExpiringURL$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(S3GenerateExpiringURL$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            S3GenerateExpiringURL.Info info2 = (S3GenerateExpiringURL.Info)package$.MODULE$.EncoderOps(info);
            String string = "bucket";
            String string2 = "path";
            String string3 = "expiry";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(S3GenerateExpiringURL$::$anonfun$5, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string4 = step$1.copy$default$1();
            String string5 = step$1.copy$default$2();
            String string6 = step$1.copy$default$3();
            String string7 = step$1.copy$default$4();
            String string8 = step$1.copy$default$5();
            boolean bl = step$1.copy$default$7();
            boolean bl2 = step$1.copy$default$8();
            return step$1.copy(string4, string5, string6, string7, string8, json, bl, bl2);
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final List build$$anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 build$$anonfun$2() {
        S3GenerateExpiringURL$Info$ s3GenerateExpiringURL$Info$ = S3GenerateExpiringURL$Info$.MODULE$;
        return (Function1 & Serializable)p -> (S3GenerateExpiringURL.Info)s3GenerateExpiringURL$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)S3GenerateExpiringURL$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)S3GenerateExpiringURL$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)S3GenerateExpiringURL$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final Either $anonfun$6$$anonfun$1$$anonfun$1$$anonfun$1(Bucket bucket$3, AwsCredentials creds$2, S3GenerateExpiringURL.Info info$7, Document doc$4, long expiryMs$1) {
        return S3Logic$.MODULE$.client(bucket$3, creds$2, (Function1 & Serializable)s3Client -> MODULE$.tryGetFileURL(info$7, doc$4, bucket$3, expiryMs$1, (S3Client)s3Client));
    }

    private static final /* synthetic */ EitherT $anonfun$6$$anonfun$1$$anonfun$1(Bucket bucket$2, AwsCredentials creds$1, S3GenerateExpiringURL.Info info$6, Document doc$3, long expiryMs) {
        return EitherT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> S3GenerateExpiringURL$.$anonfun$6$$anonfun$1$$anonfun$1$$anonfun$1(bucket$2, creds$1, info$6, doc$3, expiryMs))).map((Function1 & Serializable)result -> result, (Functor)Task$.MODULE$.catsAsync());
    }

    private static final Either getExpiry$$anonfun$1(String s$1) {
        List list;
        Option option;
        String string = s$1.toLowerCase().trim();
        if (string != null && !(option = MODULE$.ExpiryRE().unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(2) == 0) {
            String string2 = (String)list.apply(0);
            String string3 = (String)list.apply(1);
            String number = string2;
            String units = string3;
            return MODULE$.getExpiry(number, units);
        }
        return scala.package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Unknown expiry format: " + s$1));
    }

    private static final Object tryGetFileURL$$anonfun$1(Exception ex$1) {
        return "Get failed: " + ex$1;
    }
}

