/*
 * Decompiled with CFR 0.152.
 */
package ambience.etl.s3v2;

import ambience.bson.BsonETL$;
import ambience.etl.BuildError;
import ambience.etl.Builder;
import ambience.etl.ETLStep;
import ambience.etl.ETLStepType$;
import ambience.etl.package$;
import ambience.etl.s3v2.Bucket;
import ambience.etl.s3v2.Bucket$;
import ambience.etl.s3v2.S3Category$;
import ambience.etl.s3v2.S3Logic$;
import ambience.etl.s3v2.S3Put;
import ambience.etl.s3v2.S3Put$Info$;
import ambience.etl.s3v2.S3Put$Result$;
import ambience.etl.serverui.PanelBuilder;
import ambience.etl.serverui.PanelItem$;
import ambience.panel.Panel;
import ambience.panel.Panel$;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT;
import cats.data.EitherT$;
import cats.implicits$;
import cats.syntax.EitherOps$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.util.HashMap;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonBinary;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonInt64$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple3$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class S3Put$
implements Builder,
PanelBuilder,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(S3Put$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final String stepType;
    public static final S3Put$Info$ Info;
    private static final Json InfoJson;
    public static final S3Put$Result$ Result;
    public static final S3Put$ MODULE$;

    private S3Put$() {
    }

    static {
        MODULE$ = new S3Put$();
        stepType = ETLStepType$.MODULE$.apply("s3v2.Put");
        S3Put.Info info = (S3Put.Info)io.circe.syntax.package$.MODULE$.EncoderOps((Object)S3Put$Info$.MODULE$.apply(S3Put$Info$.MODULE$.$lessinit$greater$default$1(), S3Put$Info$.MODULE$.$lessinit$greater$default$2(), S3Put$Info$.MODULE$.$lessinit$greater$default$3()));
        String string = "bucket";
        String string2 = "path";
        String string3 = "mimeType";
        InfoJson = package.EncoderOps$.MODULE$.asJson$extension((Object)info, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(MODULE$::$init$$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(S3Put$.class);
    }

    public String stepType() {
        return stepType;
    }

    public Json InfoJson() {
        return InfoJson;
    }

    public Task<Panel> buildPanel(PanelBuilder.Context cxt, ETLStep step) {
        String string = "bucket";
        String string2 = "path";
        String string3 = "mimeType";
        int size = 3;
        S3Put.Info info = (S3Put.Info)this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", S3Put$::$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), S3Put$::$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(S3Put$::$anonfun$3))))).toOption().getOrElse(S3Put$::$anonfun$4);
        return S3Category$.MODULE$.bucketChoicesT().map((Function1 & Serializable)bucketChoices -> {
            Panel.Item bucketField = PanelItem$.MODULE$.select("bucket", "Bucket", Json$.MODULE$.fromString(info.bucket()), bucketChoices, PanelItem$.MODULE$.select$default$5());
            Panel.Item pathField = PanelItem$.MODULE$.text("path", "Path Field", info.path(), PanelItem$.MODULE$.text$default$4());
            Panel.Item mimeTypeField = PanelItem$.MODULE$.text("mimeType", "MimeType Field", info.mimeType(), PanelItem$.MODULE$.text$default$4());
            return Panel$.MODULE$.apply((List)new .colon.colon((Object)bucketField, (List)new .colon.colon((Object)pathField, (List)new .colon.colon((Object)mimeTypeField, (List)Nil$.MODULE$))));
        });
    }

    public Task<Either<String, ETLStep>> savePanel(PanelBuilder.Context cxt, ETLStep step, Json results) {
        return Task$.MODULE$.apply(() -> S3Put$.savePanel$$anonfun$1(results, step));
    }

    public Either<BuildError, Function1<Observable<Document>, Observable<Document>>> build(Builder.Context cxt, ETLStep step) {
        String string = "bucket";
        String string2 = "path";
        String string3 = "mimeType";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(this.InfoJson().deepMerge(step.json()).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", S3Put$::build$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), S3Put$::build$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(S3Put$::build$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> MODULE$.error(step, (DecodingFailure)err), (Function1 & Serializable)info -> (Function1 & Serializable)from -> MODULE$.run(cxt, (S3Put.Info)info, (Observable<Document>)from));
    }

    public Observable<Document> run(Builder.Context cxt, S3Put.Info info, Observable<Document> from) {
        return from.mapEval((Function1 & Serializable)doc -> MODULE$.putFile(cxt, info, (Document)doc));
    }

    public Task<Document> putFile(Builder.Context cxt, S3Put.Info info, Document doc) {
        EitherT reply = EitherT$.MODULE$.apply(Bucket$.MODULE$.load(info.bucket())).flatMap((Function1 & Serializable)bucket -> EitherT$.MODULE$.apply(S3Logic$.MODULE$.credentials(cxt.user(), (Bucket)bucket)).flatMap((Function1 & Serializable)creds -> EitherT$.MODULE$.apply((Object)Task$.MODULE$.apply(() -> S3Put$.$anonfun$6$$anonfun$1$$anonfun$1(bucket, creds, info, doc))).map((Function1 & Serializable)result -> result, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync());
        return ((Task)reply.value()).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                S3Put.Result result = (S3Put.Result)((Right)either).value();
                return cxt.logRecord(result.doc(), result.msg());
            }
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                MODULE$.log().apply(msg, Line$.MODULE$.apply(64), FullName$.MODULE$.apply("ambience.etl.s3v2.S3Put.putFile"));
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"error");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)msg.msg()), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
                return cxt.logRecord((Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), msg);
            }
            throw new MatchError((Object)either);
        });
    }

    public String extraPath(S3Put.Info info, Document doc) {
        BsonValue bsonValue;
        if (info.path().isEmpty()) {
            return "";
        }
        Option option = BsonETL$.MODULE$.get(doc, info.path());
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonString) {
            BsonString value = (BsonString)bsonValue;
            return value.getValue();
        }
        return "";
    }

    public String mimeType(S3Put.Info info, Document doc) {
        BsonValue bsonValue;
        if (info.mimeType().isEmpty()) {
            return "application/octet-stream";
        }
        Option option = BsonETL$.MODULE$.get(doc, info.mimeType());
        if (option instanceof Some && (bsonValue = (BsonValue)((Some)option).value()) instanceof BsonString) {
            BsonString value = (BsonString)bsonValue;
            return value.getValue();
        }
        return "application/octet-stream";
    }

    public S3Put.Result tryPutFile(S3Put.Info info, Document doc, Bucket bucket, S3Client s3Client) {
        S3Put.Result result;
        try {
            result = this.putFile(info, doc, bucket, s3Client);
        }
        catch (Exception ex) {
            this.log().error(() -> S3Put$.tryPutFile$$anonfun$1(ex), (Throwable)ex, Line$.MODULE$.apply(91), FullName$.MODULE$.apply("ambience.etl.s3v2.S3Put.tryPutFile"));
            result = S3Put$Result$.MODULE$.apply(doc, (LogMessage)LogMessage.Error$.MODULE$.apply("S3Put failed: " + ex));
        }
        return result;
    }

    public S3Put.Result putFile(S3Put.Info info, Document doc, Bucket bucket, S3Client s3Client) {
        Option option = doc.get("bytes", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBinary.class)).map((Function1 & Serializable)_$1 -> _$1.getData());
        if (option instanceof Some) {
            byte[] bytes = (byte[])((Some)option).value();
            String extra = this.extraPath(info, doc);
            String location = bucket.path() + extra;
            long contentLength = bytes.length;
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("Content-Length", String.valueOf(contentLength));
            metadata.put("Content-Type", this.mimeType(info, doc));
            PutObjectRequest req = (PutObjectRequest)PutObjectRequest.builder().bucket(bucket.bucket()).key(location).metadata(metadata).build();
            s3Client.putObject(req, RequestBody.fromBytes((byte[])bytes));
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"s3-put-info");
            Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[4];
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"region");
            objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply(bucket.region())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"bucket");
            objectArray2[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonString$.MODULE$.apply(bucket.bucket())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"path");
            objectArray2[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)BsonString$.MODULE$.apply(location)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
            objectArray2[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)BsonInt64$.MODULE$.apply(contentLength)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)package$.MODULE$.ETLRecord().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument());
            return S3Put$Result$.MODULE$.apply((Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (LogMessage)LogMessage.Info$.MODULE$.apply("Sent " + contentLength + " bytes to " + bucket.info(extra)));
        }
        if (None$.MODULE$.equals(option)) {
            return S3Put$Result$.MODULE$.apply(doc, (LogMessage)LogMessage.Error$.MODULE$.apply("No bytes to put"));
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     */
    private final List $init$$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        void var2_1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var1_2 = var2_1;
        Encoder encoder = encodeA2 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$2() {
        S3Put$Info$ s3Put$Info$ = S3Put$Info$.MODULE$;
        return (Function1 & Serializable)p -> (S3Put.Info)s3Put$Info$.fromProduct((Product)p);
    }

    private static final Product $anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)S3Put$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)S3Put$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)S3Put$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final S3Put.Info $anonfun$4() {
        return S3Put$Info$.MODULE$.apply(S3Put$Info$.MODULE$.$lessinit$greater$default$1(), S3Put$Info$.MODULE$.$lessinit$greater$default$2(), S3Put$Info$.MODULE$.$lessinit$greater$default$3());
    }

    /*
     * WARNING - void declaration
     */
    private static final List savePanel$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 savePanel$$anonfun$1$$anonfun$2() {
        S3Put$Info$ s3Put$Info$ = S3Put$Info$.MODULE$;
        return (Function1 & Serializable)p -> (S3Put.Info)s3Put$Info$.fromProduct((Product)p);
    }

    private static final Product savePanel$$anonfun$1$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)S3Put$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)S3Put$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)S3Put$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$5() {
        Encoder encodeA;
        void var3_2;
        void var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Either savePanel$$anonfun$1(Json results$1, ETLStep step$1) {
        String string = "bucket";
        String string2 = "path";
        String string3 = "mimeType";
        int size = 3;
        Either either = implicits$.MODULE$.catsSyntaxEither(MODULE$.InfoJson().deepMerge(results$1).as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("Info", S3Put$::savePanel$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), S3Put$::savePanel$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(S3Put$::savePanel$$anonfun$1$$anonfun$3))))));
        return EitherOps$.MODULE$.bimap$extension(either, (Function1 & Serializable)err -> err.message(), (Function1 & Serializable)info -> {
            S3Put.Info info2 = (S3Put.Info)io.circe.syntax.package$.MODULE$.EncoderOps(info);
            String string = "bucket";
            String string2 = "path";
            String string3 = "mimeType";
            Json json = package.EncoderOps$.MODULE$.asJson$extension((Object)info2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(S3Put$::$anonfun$5, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
            String string4 = step$1.copy$default$1();
            String string5 = step$1.copy$default$2();
            String string6 = step$1.copy$default$3();
            String string7 = step$1.copy$default$4();
            String string8 = step$1.copy$default$5();
            boolean bl = step$1.copy$default$7();
            boolean bl2 = step$1.copy$default$8();
            return step$1.copy(string4, string5, string6, string7, string8, json, bl, bl2);
        });
    }

    /*
     * WARNING - void declaration
     */
    private static final List build$$anonfun$1() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeString();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 build$$anonfun$2() {
        S3Put$Info$ s3Put$Info$ = S3Put$Info$.MODULE$;
        return (Function1 & Serializable)p -> (S3Put.Info)s3Put$Info$.fromProduct((Product)p);
    }

    private static final Product build$$anonfun$3() {
        return Tuple3$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)S3Put$Info$.MODULE$.$lessinit$greater$default$1()), (Object)Some$.MODULE$.apply((Object)S3Put$Info$.MODULE$.$lessinit$greater$default$2()), (Object)Some$.MODULE$.apply((Object)S3Put$Info$.MODULE$.$lessinit$greater$default$3()));
    }

    private static final Either $anonfun$6$$anonfun$1$$anonfun$1(Bucket bucket$2, AwsCredentials creds$1, S3Put.Info info$6, Document doc$3) {
        return S3Logic$.MODULE$.client(bucket$2, creds$1, (Function1 & Serializable)s3Client -> MODULE$.tryPutFile(info$6, doc$3, bucket$2, (S3Client)s3Client));
    }

    private static final Object tryPutFile$$anonfun$1(Exception ex$1) {
        return "Put failed: " + ex$1;
    }
}

