/*
 * Decompiled with CFR 0.152.
 */
package ambience.framework;

import ambience.api.BinaryStore;
import ambience.api.Secrets;
import ambience.framework.AESCipher;
import ambience.framework.AESCipher$;
import ambience.framework.AWSS3BinaryStoreLocation;
import ambience.framework.BinaryStoreAPI;
import cats.Functor;
import cats.Monad;
import cats.data.OptionT$;
import cats.implicits$;
import cats.syntax.OptionIdOps$;
import com.elixirtech.arch.Crypt$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.FullDataBytes;
import com.elixirtech.arch.FullDataBytes$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Try$;

public class AWSS3EncBinaryStoreLocation
implements BinaryStore.Location,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(AWSS3EncBinaryStoreLocation.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(AWSS3EncBinaryStoreLocation.class.getDeclaredField("secretsAPI$lzy1"));
    private volatile Object log$lzy1;
    private final BinaryStoreAPI.BSConfig bsConfig;
    private volatile Object secretsAPI$lzy1;
    private final AWSS3BinaryStoreLocation base;
    private final long maxSize;
    private final Option optEncryptionKey;
    private final Option optSecret;
    private final Task encryptionKeyT;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AWSS3EncBinaryStoreLocation(BinaryStoreAPI.BSConfig bsConfig) {
        Task task;
        this.bsConfig = bsConfig;
        this.base = new AWSS3BinaryStoreLocation(bsConfig);
        this.maxSize = bsConfig.config().getMemorySize("maxSize").toBytes();
        this.optEncryptionKey = Try$.MODULE$.apply(() -> AWSS3EncBinaryStoreLocation.$init$$$anonfun$1(bsConfig)).toOption();
        this.optSecret = Try$.MODULE$.apply(() -> AWSS3EncBinaryStoreLocation.$init$$$anonfun$2(bsConfig)).toOption();
        Option<AESCipher.Secret> option = this.optEncryptionKey();
        if (option instanceof Some) {
            AESCipher.Secret encKey = (AESCipher.Secret)((Some)option).value();
            task = Task$.MODULE$.now((Object)encKey);
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError(option);
            Option<String> option2 = this.optSecret();
            if (option2 instanceof Some) {
                String secretName = (String)((Some)option2).value();
                task = this.secretsAPI().getSystemSecret(secretName).flatMap((Function1 & Serializable)opts -> Task$.MODULE$.apply(() -> AWSS3EncBinaryStoreLocation.$init$$$anonfun$3$$anonfun$1(opts, secretName)).flatMap((Function1 & Serializable)s -> Task$.MODULE$.apply(() -> AWSS3EncBinaryStoreLocation.$init$$$anonfun$3$$anonfun$2$$anonfun$1(s)).map((Function1 & Serializable)key -> key)));
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError(option2);
                throw new RuntimeException("No encryptionSecret defined");
            }
        }
        this.encryptionKeyT = task;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Secrets secretsAPI() {
        Object object = this.secretsAPI$lzy1;
        if (object instanceof Secrets) {
            return (Secrets)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Secrets)this.secretsAPI$lzyINIT1();
    }

    private Object secretsAPI$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.secretsAPI$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Secrets secrets = null;
                    try {
                        secrets = (Secrets)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Secrets.class));
                        object2 = secrets == null ? LazyVals.NullValue$.MODULE$ : secrets;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.secretsAPI$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return secrets;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public AWSS3BinaryStoreLocation base() {
        return this.base;
    }

    public long maxSize() {
        return this.maxSize;
    }

    public Option<AESCipher.Secret> optEncryptionKey() {
        return this.optEncryptionKey;
    }

    public Option<String> optSecret() {
        return this.optSecret;
    }

    public Task<AESCipher.Secret> encryptionKeyT() {
        return this.encryptionKeyT;
    }

    public String id() {
        return this.bsConfig.id();
    }

    public String description() {
        return this.base().description();
    }

    public Task<BinaryStore.ContentId> add(BinaryStore.Content content) {
        return DataBytes$.MODULE$.toFullT(content.bytes()).flatMap((Function1 & Serializable)full -> this.encrypt((FullDataBytes)full).flatMap((Function1 & Serializable)enc -> this.base().add(content.copy((DataBytes)enc, content.copy$default$2())).map((Function1 & Serializable)v1 -> new BinaryStore.ContentId(v1 == null ? null : ((BinaryStore.ContentId)v1).value()))));
    }

    public Observable<BinaryStore.ContentId> all() {
        return this.base().all();
    }

    public Task<Option<BinaryStore.Content>> get(String id) {
        return (Task)OptionT$.MODULE$.apply(this.base().get(id)).flatMap((Function1 & Serializable)content -> OptionT$.MODULE$.apply((Object)DataBytes$.MODULE$.toFullT(content.bytes()).map((Function1 & Serializable)_$1 -> {
            FullDataBytes fullDataBytes = (FullDataBytes)implicits$.MODULE$.catsSyntaxOptionId(_$1);
            return OptionIdOps$.MODULE$.some$extension((Object)fullDataBytes);
        })).flatMap((Function1 & Serializable)full -> OptionT$.MODULE$.apply((Object)this.decrypt((FullDataBytes)full).map((Function1 & Serializable)_$2 -> Option$.MODULE$.apply(_$2))).map((Function1 & Serializable)dec -> content.copy((DataBytes)dec, content.copy$default$2()), (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public Task<Option<Json>> getMetadata(String id) {
        return this.base().getMetadata(id);
    }

    public Task<BoxedUnit> remove(String id) {
        return this.base().remove(id);
    }

    public Task<FullDataBytes> encrypt(FullDataBytes full) {
        return this.encryptionKeyT().map((Function1 & Serializable)encryptionKey -> FullDataBytes$.MODULE$.apply(AESCipher$.MODULE$.encrypt(encryptionKey, full.bytes())));
    }

    public Task<FullDataBytes> decrypt(FullDataBytes full) {
        return this.encryptionKeyT().map((Function1 & Serializable)encryptionKey -> FullDataBytes$.MODULE$.apply(AESCipher$.MODULE$.decrypt(encryptionKey, full.bytes())));
    }

    private static final AESCipher.Secret $init$$$anonfun$1(BinaryStoreAPI.BSConfig bsConfig$1) {
        return AESCipher.Secret$.MODULE$.apply(Crypt$.MODULE$.encPrefixDecrypt(bsConfig$1.config().getString("encryptionKey")));
    }

    private static final String $init$$$anonfun$2(BinaryStoreAPI.BSConfig bsConfig$2) {
        return bsConfig$2.config().getString("encryptionSecret");
    }

    private static final Secrets.Value $init$$$anonfun$3$$anonfun$1$$anonfun$1(String secretName$3) {
        throw new RuntimeException("Secret " + secretName$3 + " not found");
    }

    private static final Secrets.Value $init$$$anonfun$3$$anonfun$1(Option opts$1, String secretName$1) {
        return (Secrets.Value)opts$1.getOrElse(() -> AWSS3EncBinaryStoreLocation.$init$$$anonfun$3$$anonfun$1$$anonfun$1(secretName$1));
    }

    private static final AESCipher.Secret $init$$$anonfun$3$$anonfun$2$$anonfun$1(Secrets.Value s$1) {
        return AESCipher.Secret$.MODULE$.apply(Crypt$.MODULE$.encPrefixDecrypt(s$1.value()));
    }
}

