/*
 * Decompiled with CFR 0.152.
 */
package ambience.ocr;

import ambience.api.BinaryStore;
import ambience.ocr.AttachmentInfo;
import ambience.ocr.BinaryStoreHelper$;
import ambience.ocr.ETLRunner$;
import ambience.ocr.ETLRunner$Context$;
import ambience.ocr.ImageId$;
import ambience.ocr.ImageInfo;
import ambience.ocr.ImageInfo$;
import ambience.ocr.Lenses$;
import ambience.ocr.PageIdx;
import ambience.ocr.PageIdx$;
import ambience.ocr.PageLoadCalculator$;
import ambience.ocr.PagedImageHelper;
import ambience.ocr.PagedImageHelper$Context$;
import ambience.ocr.Util$;
import ambience.ocr.host.OCRHostContext;
import cats.Functor;
import cats.Monad;
import cats.data.EitherT$;
import cats.data.OptionT$;
import com.elixirtech.arch.ARM$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.bson.BsonBinary;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class PagedImageHelper$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(PagedImageHelper$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    public static final PagedImageHelper$Context$ Context;
    public static final PagedImageHelper$ MODULE$;

    private PagedImageHelper$() {
    }

    static {
        MODULE$ = new PagedImageHelper$();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PagedImageHelper$.class);
    }

    public Task<Either<String, List<ImageInfo>>> store(OCRHostContext cxt, AttachmentInfo info, int pageCount, int pageIdx, List<PageIdx> existing) {
        Either either = Try$.MODULE$.apply(() -> PagedImageHelper$.store$$anonfun$1(pageCount, pageIdx, existing, cxt, info)).toEither();
        if (either instanceof Left) {
            Throwable ex = (Throwable)((Left)either).value();
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)ex.getMessage()));
        }
        if (either instanceof Right) {
            Task res = (Task)((Right)either).value();
            return res;
        }
        throw new MatchError((Object)either);
    }

    public List<PageIdx> store$default$5() {
        return package$.MODULE$.Nil();
    }

    public Either<String, Object> getPageCount(String name, byte[] data) {
        if (this.isPDF(name)) {
            return this.getPDFPageCount(data);
        }
        return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)1));
    }

    private Either<String, Object> getPDFPageCount(byte[] data) {
        Either either = Try$.MODULE$.apply(() -> PagedImageHelper$.getPDFPageCount$$anonfun$1(data)).toEither();
        if (either instanceof Left) {
            Throwable ex = (Throwable)((Left)either).value();
            return package$.MODULE$.Left().apply((Object)ex.getMessage());
        }
        if (either instanceof Right) {
            int res = BoxesRunTime.unboxToInt((Object)((Right)either).value());
            return package$.MODULE$.Right().apply((Object)BoxesRunTime.boxToInteger((int)res));
        }
        throw new MatchError((Object)either);
    }

    public Task<Either<String, List<ImageInfo>>> store(OCRHostContext hostCxt, AttachmentInfo info, int pageCount, List<Object> pages) {
        return ((BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class))).location(hostCxt.ocrHolder().tempLocationId()).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                BinaryStore.Location loc = (BinaryStore.Location)((Some)option).value();
                PagedImageHelper.Context cxt = PagedImageHelper$Context$.MODULE$.apply(hostCxt.user(), loc, info, hostCxt.dpi(), pageCount, pages);
                if (MODULE$.isPDF(info.name())) {
                    MODULE$.log().info(() -> PagedImageHelper$.store$$anonfun$2$$anonfun$1(info), Line$.MODULE$.apply(63), FullName$.MODULE$.apply("ambience.ocr.PagedImageHelper.store"));
                    return MODULE$.storePDFImages(cxt);
                }
                MODULE$.log().info(() -> PagedImageHelper$.store$$anonfun$2$$anonfun$2(info), Line$.MODULE$.apply(67), FullName$.MODULE$.apply("ambience.ocr.PagedImageHelper.store"));
                return MODULE$.storeImage(cxt, Util$.MODULE$.getMimeType(info.name()), false).map((Function1 & Serializable)_$2 -> _$2.map((Function1 & Serializable)_$3 -> (List)new .colon.colon(_$3, (List)Nil$.MODULE$)));
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)("BinaryStore not found: " + new BinaryStore.LocationId(hostCxt.ocrHolder().tempLocationId()))));
            }
            throw new MatchError((Object)option);
        });
    }

    public boolean isPDF(String name) {
        return name.endsWith(".pdf");
    }

    public Task<Either<String, ImageInfo>> storeImage(PagedImageHelper.Context cxt, String mimeType, boolean fromPDF) {
        return (Task)EitherT$.MODULE$.apply(this.getBytes(cxt.info())).flatMap((Function1 & Serializable)bytes -> EitherT$.MODULE$.apply(MODULE$.storeImageBytes(cxt.location(), (byte[])bytes, PageIdx$.MODULE$.apply(0), mimeType, fromPDF)).map((Function1 & Serializable)cbytes -> cbytes, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public Task<Either<String, List<ImageInfo>>> storePDFImages(PagedImageHelper.Context cxt) {
        return (Task)EitherT$.MODULE$.apply(this.getAsJSON(cxt.info())).flatMap((Function1 & Serializable)json -> EitherT$.MODULE$.apply(ETLRunner$.MODULE$.PDFToImage(ETLRunner$Context$.MODULE$.apply("dummy-id", cxt.user(), (Json)json), cxt.dpi(), (List<Object>)cxt.pages().map((Function1)(JFunction1.mcII.sp & Serializable)_$4 -> _$4 + 1))).flatMap((Function1 & Serializable)imageDocs -> EitherT$.MODULE$.apply(MODULE$.storeImages(cxt, (List<Tuple2<Document, Object>>)((List)imageDocs.zip(cxt.pages())))).map((Function1 & Serializable)res -> res, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value();
    }

    public Task<Either<String, List<ImageInfo>>> storeImages(PagedImageHelper.Context cxt, List<Tuple2<Document, Object>> docIdxPair) {
        this.log().info(() -> PagedImageHelper$.storeImages$$anonfun$1(docIdxPair), Line$.MODULE$.apply(91), FullName$.MODULE$.apply("ambience.ocr.PagedImageHelper.storeImages"));
        List tasks = docIdxPair.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Document doc = (Document)tuple2._1();
                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                int pageIdx = PageIdx$.MODULE$.apply(idx);
                Option option = doc.get("bytes", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBinary.class));
                if (option instanceof Some) {
                    BsonBinary bytes = (BsonBinary)((Some)option).value();
                    return MODULE$.storeImageBytes(cxt.location(), bytes.getData(), pageIdx, "image/png", true);
                }
                if (None$.MODULE$.equals(option)) {
                    return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)("no bytes found for image pageIdx=" + new PageIdx(pageIdx))));
                }
                throw new MatchError((Object)option);
            }
            throw new MatchError((Object)tuple2);
        });
        return Task$.MODULE$.sequence((Iterable)tasks, BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)res -> {
            List errors = res.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Either x) {
                    Either either = x;
                    if (either instanceof Left) {
                        String value = (String)((Left)either).value();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Either x, Function1 function1) {
                    Either either = x;
                    if (either instanceof Left) {
                        String value = (String)((Left)either).value();
                        return value;
                    }
                    return function1.apply((Object)x);
                }
            });
            if (errors.nonEmpty()) {
                errors.foreach((Function1)(JProcedure1 & Serializable)_$5 -> MODULE$.log().error(() -> PagedImageHelper$.storeImages$$anonfun$2$$anonfun$1$$anonfun$1(_$5), Line$.MODULE$.apply(102), FullName$.MODULE$.apply("ambience.ocr.PagedImageHelper.storeImages")));
                return package$.MODULE$.Left().apply((Object)("Error storing image pages=" + errors.mkString(",") + " to BinaryStore"));
            }
            return package$.MODULE$.Right().apply(res.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Either x) {
                    Either either = x;
                    if (either instanceof Right) {
                        ImageInfo value = (ImageInfo)((Right)either).value();
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Either x, Function1 function1) {
                    Either either = x;
                    if (either instanceof Right) {
                        ImageInfo value = (ImageInfo)((Right)either).value();
                        return value;
                    }
                    return function1.apply((Object)x);
                }
            }).sortBy((Function1 & Serializable)_$6 -> _$6.pageIdx(), (Ordering)Ordering.Int$.MODULE$));
        });
    }

    public Task<Either<String, ImageInfo>> storeImageBytes(BinaryStore.Location loc, byte[] bytes, int pageIdx, String mimeType, boolean fromPDF) {
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"pageIdx");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromInt(pageIdx));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"mimeType");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(mimeType));
        Json metadata = Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return BinaryStoreHelper$.MODULE$.save(loc, metadata, bytes).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                String uuid = (String)((Some)option).value();
                return package$.MODULE$.Right().apply((Object)ImageInfo$.MODULE$.apply(ImageId$.MODULE$.apply(uuid), pageIdx, fromPDF));
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)PageIdx$.MODULE$.toString$extension(pageIdx));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<String, Json>> getAsJSON(AttachmentInfo info) {
        return ((Task)OptionT$.MODULE$.apply(BinaryStoreHelper$.MODULE$.getContent(BinaryStore.LocationId$.MODULE$.apply(info.store()), BinaryStore.ContentId$.MODULE$.apply(info.uuid()))).flatMap((Function1 & Serializable)content -> OptionT$.MODULE$.apply(MODULE$.getBytes((BinaryStore.Content)content)).flatMap((Function1 & Serializable)bytes -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)Lenses$.MODULE$.Filename().getOption((Object)content.metadata()))).flatMap((Function1 & Serializable)filename -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)Lenses$.MODULE$.MimeType().getOption((Object)content.metadata()))).flatMap((Function1 & Serializable)mimeType -> OptionT$.MODULE$.apply((Object)Task$.MODULE$.now((Object)Util$.MODULE$.docToJson(Util$.MODULE$.buildDocument((String)filename, (String)mimeType, (byte[])bytes)).toOption())).map((Function1 & Serializable)json -> json, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value()).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Json json = (Json)((Some)option).value();
                return package$.MODULE$.Right().apply((Object)json);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)("Document not found with id=" + info.uuid()));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Either<String, byte[]>> getBytes(AttachmentInfo info) {
        return ((Task)OptionT$.MODULE$.apply(BinaryStoreHelper$.MODULE$.getContent(BinaryStore.LocationId$.MODULE$.apply(info.store()), BinaryStore.ContentId$.MODULE$.apply(info.uuid()))).flatMap((Function1 & Serializable)content -> OptionT$.MODULE$.apply(MODULE$.getBytes((BinaryStore.Content)content)).map((Function1 & Serializable)bytes -> bytes, (Functor)Task$.MODULE$.catsAsync()), (Monad)Task$.MODULE$.catsAsync()).value()).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                byte[] bytes = (byte[])((Some)option).value();
                return package$.MODULE$.Right().apply((Object)bytes);
            }
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)("Document not found with id=" + info.uuid()));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<Option<byte[]>> getBytes(BinaryStore.Content content) {
        return content.bytes().observable().foldLeftL(PagedImageHelper$::getBytes$$anonfun$3, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                byte[] a1 = (byte[])tuple2._1();
                byte[] a2 = (byte[])tuple2._2();
                return (byte[])Array$.MODULE$.concat((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new byte[][]{a1, a2}), ClassTag$.MODULE$.apply(Byte.TYPE));
            }
            throw new MatchError((Object)tuple2);
        }).map((Function1 & Serializable)_$7 -> Some$.MODULE$.apply(_$7));
    }

    private static final Task store$$anonfun$1(int pageCount$1, int pageIdx$1, List existing$1, OCRHostContext cxt$1, AttachmentInfo info$1) {
        List<Object> ps = PageLoadCalculator$.MODULE$.getPagesToLoad(pageCount$1, pageIdx$1, (List<PageIdx>)existing$1);
        return MODULE$.store(cxt$1, info$1, pageCount$1, ps).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                String msg = (String)((Left)either).value();
                return package$.MODULE$.Left().apply((Object)msg);
            }
            if (either instanceof Right) {
                List piList = (List)((Right)either).value();
                return package$.MODULE$.Right().apply((Object)piList);
            }
            throw new MatchError((Object)either);
        });
    }

    private static final int getPDFPageCount$$anonfun$1(byte[] data$1) {
        return BoxesRunTime.unboxToInt((Object)ARM$.MODULE$.run((Function1 & Serializable)_$1 -> ((PDDocument)_$1.manage((Object)Loader.loadPDF((byte[])data$1))).getNumberOfPages()));
    }

    private static final Object store$$anonfun$2$$anonfun$1(AttachmentInfo info$3) {
        return "storing pdf images from " + info$3.name();
    }

    private static final Object store$$anonfun$2$$anonfun$2(AttachmentInfo info$4) {
        return "storing image " + info$4.name();
    }

    private static final Object storeImages$$anonfun$1(List docIdxPair$1) {
        return "storing " + docIdxPair$1.size() + " images to BinaryStore";
    }

    private static final Object storeImages$$anonfun$2$$anonfun$1$$anonfun$1(String _$5$1) {
        return _$5$1;
    }

    private static final byte[] getBytes$$anonfun$3() {
        return Array$.MODULE$.emptyByteArray();
    }
}

