/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.MongoServerException;
import com.mongodb.ServerAddress;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.lang.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class MongoBulkWriteException
extends MongoServerException {
    private static final long serialVersionUID = -4345399805987210275L;
    private final BulkWriteResult writeResult;
    private final List<BulkWriteError> errors;
    private final ServerAddress serverAddress;
    private final WriteConcernError writeConcernError;

    public MongoBulkWriteException(BulkWriteResult writeResult, List<BulkWriteError> writeErrors, @Nullable WriteConcernError writeConcernError, ServerAddress serverAddress, Set<String> errorLabels) {
        super("Bulk write operation error on server " + serverAddress + ". " + (writeErrors.isEmpty() ? "" : "Write errors: " + writeErrors + ". ") + (writeConcernError == null ? "" : "Write concern error: " + writeConcernError + ". "), serverAddress);
        this.writeResult = writeResult;
        this.errors = writeErrors;
        this.writeConcernError = writeConcernError;
        this.serverAddress = serverAddress;
        this.addLabels(errorLabels);
    }

    public BulkWriteResult getWriteResult() {
        return this.writeResult;
    }

    public List<BulkWriteError> getWriteErrors() {
        return this.errors;
    }

    @Nullable
    public WriteConcernError getWriteConcernError() {
        return this.writeConcernError;
    }

    @Override
    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MongoBulkWriteException that = (MongoBulkWriteException)o;
        if (!this.errors.equals(that.errors)) {
            return false;
        }
        if (!this.serverAddress.equals(that.serverAddress)) {
            return false;
        }
        if (!Objects.equals(this.writeConcernError, that.writeConcernError)) {
            return false;
        }
        return this.writeResult.equals(that.writeResult);
    }

    public int hashCode() {
        int result = this.writeResult.hashCode();
        result = 31 * result + this.errors.hashCode();
        result = 31 * result + this.serverAddress.hashCode();
        result = 31 * result + (this.writeConcernError != null ? this.writeConcernError.hashCode() : 0);
        return result;
    }
}

