/*
 * Decompiled with CFR 0.152.
 */
package ambience.cli;

import ambience.cli.CommandProcessor;
import ambience.cli.SystemSummaryCLI;
import ambience.cli.SystemSummaryCLI$JavaSetting$;
import ambience.cli.SystemSummaryCLI$JavaSettings$;
import ambience.cli.SystemSummaryCLI$JsonSummary$;
import ambience.module.ConfigLoader$;
import com.elixirtech.arch.CustomSysConfig;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.SystemConfig;
import com.typesafe.config.Config;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.TextStyle;
import java.util.Locale;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;

public final class SystemSummaryCLI$
implements CommandProcessor,
LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(SystemSummaryCLI$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final String name;
    private static final String help;
    private static final String usage;
    public static final SystemSummaryCLI$JavaSettings$ JavaSettings;
    public static final SystemSummaryCLI$JavaSetting$ JavaSetting;
    public static final SystemSummaryCLI$JsonSummary$ JsonSummary;
    public static final SystemSummaryCLI$ MODULE$;

    private SystemSummaryCLI$() {
    }

    static {
        MODULE$ = new SystemSummaryCLI$();
        name = "system-summary";
        help = "Outputs system summary information (if system-information module is installed)";
        usage = "system-summary (no parameters are supported)";
    }

    @Override
    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SystemSummaryCLI$.class);
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public String help() {
        return help;
    }

    @Override
    public String usage() {
        return usage;
    }

    @Override
    public int main(Seq<String> params) {
        Config config = ConfigLoader$.MODULE$.config();
        Elixir$.MODULE$.registerInstance((Object)config, ClassTag$.MODULE$.apply(Config.class));
        Elixir$.MODULE$.registerInstance((Object)new CustomSysConfig(config), ClassTag$.MODULE$.apply(SystemConfig.class));
        SystemSummaryCLI.JsonSummary jsonSummary = (SystemSummaryCLI.JsonSummary)io.circe.syntax.package$.MODULE$.EncoderOps((Object)this.build());
        String string = "now";
        String string2 = "version";
        String string3 = "release";
        String string4 = "locale";
        String string5 = "timeZone";
        String string6 = "javaSettings";
        Predef$.MODULE$.println((Object)package.EncoderOps$.MODULE$.asJson$extension((Object)jsonSummary, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(SystemSummaryCLI$::main$$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))).spaces2());
        return 0;
    }

    public SystemSummaryCLI.JsonSummary build() {
        Config config = (Config)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Config.class));
        String version = (String)Try$.MODULE$.apply(() -> SystemSummaryCLI$.$anonfun$3(config)).toOption().getOrElse(SystemSummaryCLI$::$anonfun$4);
        String release = (String)Try$.MODULE$.apply(() -> SystemSummaryCLI$.$anonfun$5(config)).toOption().getOrElse(SystemSummaryCLI$::$anonfun$6);
        SystemSummaryCLI.JavaSettings javaSettings = this.buildJavaSettings();
        String locale = Locale.getDefault().toLanguageTag();
        String timeZone = ZoneId.systemDefault().getDisplayName(TextStyle.FULL, Locale.getDefault());
        return SystemSummaryCLI$JsonSummary$.MODULE$.apply(this.now(), version, release, locale, timeZone, javaSettings);
    }

    public String now() {
        String full = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
        return full.substring(0, 10) + "-" + full.substring(11, 19).replace(":", "");
    }

    public SystemSummaryCLI.JavaSettings buildJavaSettings() {
        List items = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"user.name", "user.home", "user.dir", "java.version", "java.vendor", "java.home", "java.io.tmpdir", "os.name", "os.arch", "os.version"}));
        List core = items.map((Function1 & Serializable)item -> SystemSummaryCLI$JavaSetting$.MODULE$.apply((String)item, System.getProperty(item)));
        SystemSummaryCLI.JavaSetting gc = this.buildGCSettings();
        return SystemSummaryCLI$JavaSettings$.MODULE$.apply((List<SystemSummaryCLI.JavaSetting>)((List)new .colon.colon((Object)gc, (List)Nil$.MODULE$)).$colon$colon$colon(core));
    }

    public SystemSummaryCLI.JavaSetting buildGCSettings() {
        Buffer gcMxBeans = CollectionConverters$.MODULE$.ListHasAsScala(ManagementFactory.getGarbageCollectorMXBeans()).asScala();
        return SystemSummaryCLI$JavaSetting$.MODULE$.apply("garbage collection", ((IterableOnceOps)gcMxBeans.map((Function1 & Serializable)bean -> bean.getName())).mkString(", "));
    }

    public String trunc(String s) {
        if (s.length() > 19) {
            return s.substring(0, 10) + " " + s.substring(11, 19) + "Z";
        }
        return s;
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$2() {
        void var3_2;
        void var1;
        Encoder encodeA = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$1() {
        void var1_2;
        String string = "name";
        String string2 = "value";
        Encoder.AsArray encodeA = Encoder$.MODULE$.encodeList(Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(SystemSummaryCLI$::$anonfun$2, package$.MODULE$.Nil().$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        void var0_3 = var1_2;
        return package$.MODULE$.Nil().$colon$colon((Object)var0_3);
    }

    /*
     * WARNING - void declaration
     */
    private static final List main$$anonfun$1() {
        Encoder encodeA;
        Encoder encodeA2;
        Encoder encodeA3;
        Encoder encodeA4;
        void var3_2;
        void var1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA6 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA4 = Encoder$.MODULE$.encodeString();
        Encoder encoder2 = encodeA3 = Encoder$.MODULE$.encodeString();
        Encoder encoder3 = encodeA2 = Encoder$.MODULE$.encodeString();
        String string = "items";
        Encoder encoder4 = encodeA = Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(SystemSummaryCLI$::$anonfun$1, package$.MODULE$.Nil().$colon$colon((Object)string), Configuration$.MODULE$.default())));
        return package$.MODULE$.Nil().$colon$colon((Object)encoder4).$colon$colon((Object)encoder3).$colon$colon((Object)encoder2).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    public static final /* synthetic */ Tuple2 ambience$cli$SystemSummaryCLI$JavaSettings$$_$asMap$$anonfun$1(SystemSummaryCLI.JavaSetting item) {
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)item.name());
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)item.value());
    }

    private static final String $anonfun$3(Config config$1) {
        return MODULE$.trunc(config$1.getString("ambience.ElxVersion"));
    }

    private static final String $anonfun$4() {
        return "Unknown";
    }

    private static final String $anonfun$5(Config config$2) {
        return MODULE$.trunc(config$2.getString("ambience.ElxRelease"));
    }

    private static final String $anonfun$6() {
        return "Unknown";
    }
}

