/*
 * Decompiled with CFR 0.152.
 */
package ambience.codex;

import ambience.codex.DocumentManager;
import ambience.codex.DocumentManager$;
import ambience.codex.DocumentManager$Existence$;
import ambience.codex.URFilter$;
import ambience.codex.UUIDDocumentManager$;
import ambience.framework.ErrorExplanation$;
import ambience.module.UserDB;
import ambience.util.ONConverter$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingMixin;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexFindOptions;
import com.elixirtech.codex.CodexFindOptions$;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.mongodb.BsonUtils$;
import io.circe.Json;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public abstract class UUIDDocumentManager {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(UUIDDocumentManager.class.getDeclaredField("clock$lzy1"));
    private volatile Object clock$lzy1;

    public static CodexFilter owner(UserDB.User user) {
        return UUIDDocumentManager$.MODULE$.owner(user);
    }

    public static CodexFilter withId(BsonString bsonString) {
        return UUIDDocumentManager$.MODULE$.withId(bsonString);
    }

    public static CodexFilter withId(String string) {
        return UUIDDocumentManager$.MODULE$.withId(string);
    }

    public Clock clock() {
        Object object = this.clock$lzy1;
        if (object instanceof Clock) {
            return (Clock)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Clock)this.clock$lzyINIT1();
    }

    private Object clock$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.clock$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Clock clock = null;
                    try {
                        clock = (Clock)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Clock.class));
                        object2 = clock == null ? LazyVals.NullValue$.MODULE$ : clock;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.clock$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return clock;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public abstract Task<CodexCollection> cltnT();

    public abstract String uniqueKey();

    public abstract String extension();

    public Task<BoxedUnit> init() {
        return this.cltnT().flatMap((Function1 & Serializable)cltn -> DocumentManager$.MODULE$.setupUniqueColumn((CodexCollection)cltn, this.uniqueKey()).map((Function1)(JProcedure1 & Serializable)reply -> {}));
    }

    public String filenameExtractor(Json json) {
        String name = (String)json.hcursor().downField(this.uniqueKey()).focus().flatMap((Function1 & Serializable)_$1 -> _$1.asString()).getOrElse(UUIDDocumentManager::$anonfun$2);
        return name + this.extension();
    }

    public Task<Json> get(UserDB.User user) {
        CodexFindOptions options = CodexFindOptions$.MODULE$.sorts((CodexFindOptions.Sort)CodexFindOptions.Ascending$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.uniqueKey()})));
        return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.findO(DocumentManager$.MODULE$.exists(this.uniqueKey()), options).toListL().map((Function1 & Serializable)docs -> ONConverter$.MODULE$.bsonToRelaxedJson((List<Document>)docs)).map((Function1 & Serializable)reply -> reply));
    }

    public Task<Option<Json>> get(UserDB.User user, String uuid) {
        return this.cltnT().flatMap((Function1 & Serializable)cltn -> URFilter$.MODULE$.accessFilterT(user).flatMap((Function1 & Serializable)filter -> cltn.findO((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{filter, CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(uuid))}))).firstOptionL().map((Function1 & Serializable)optDoc -> optDoc.map((Function1 & Serializable)doc -> ONConverter$.MODULE$.bsonToRelaxedJson((Document)doc))).map((Function1 & Serializable)reply -> reply)));
    }

    public Task<GravityResponse> download(UserDB.User user, String uuid) {
        return this.get(user, uuid).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Json json = (Json)((Some)option).value();
                String filename = this.filenameExtractor(json);
                Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{GravityResponse$.MODULE$.Html(), GravityResponse.ContentDisposition$.MODULE$.attachment(filename)}));
                DataBytes dataBytes = DataBytes$.MODULE$.apply(json.spaces2());
                int n = GravityResponse$.MODULE$.$lessinit$greater$default$1();
                return GravityResponse$.MODULE$.apply(n, headers, dataBytes);
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.NotFoundResponse();
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<BoxedUnit> upload(UserDB.User user, Document doc) {
        return this.cltnT().flatMap((Function1 & Serializable)cltn -> Task$.MODULE$.apply(() -> UUIDDocumentManager.upload$$anonfun$1$$anonfun$1(doc)).flatMap((Function1 & Serializable)id -> this.uuidExists((BsonString)id).flatMap((Function1 & Serializable)exists -> {
            Task task;
            if (exists.exists()) {
                if (exists.active()) {
                    Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
                    String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
                    objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)this.newUUID()), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                    String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"owner");
                    objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply(user.id())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                    task = Task$.MODULE$.now(doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                } else {
                    task = this.silentDelete((BsonString)id).map((Function1 & Serializable)_$2 -> {
                        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"owner");
                        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(user.id())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                        return (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
                    });
                }
            } else {
                Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"owner");
                objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(user.id())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
                task = Task$.MODULE$.now(doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
            }
            return task.flatMap((Function1 & Serializable)fullDoc -> cltn.insertOneT(fullDoc).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                CodexDB.InsertOneResult insertOneResult = x$1;
            }));
        })));
    }

    public Task<Either<LogMessage, Json>> save(UserDB.User user, Json json) {
        Tuple2 tuple2;
        Document doc = Document$.MODULE$.apply(json.noSpaces());
        Either unpacked = this.extractId(doc).flatMap((Function1 & Serializable)optId -> this.extractKey(doc).map((Function1 & Serializable)key -> Tuple2$.MODULE$.apply(optId, key)));
        Either either = unpacked;
        if (either instanceof Left) {
            LogMessage msg2 = (LogMessage)((Left)either).value();
            return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)msg2));
        }
        if (either instanceof Right && (tuple2 = (Tuple2)((Right)either).value()) != null) {
            Option optId2 = (Option)tuple2._1();
            BsonValue key = (BsonValue)tuple2._2();
            Option option = optId2;
            if (option instanceof Some) {
                BsonString id = (BsonString)((Some)option).value();
                return this.update(user, id, key, doc).map((Function1 & Serializable)msg -> package$.MODULE$.Left().apply(msg));
            }
            if (None$.MODULE$.equals(option)) {
                return this.add(user, key, doc).map((Function1 & Serializable)reply -> reply.map((Function1 & Serializable)doc -> this.docToJson((Document)doc)));
            }
            throw new MatchError((Object)option);
        }
        throw new MatchError((Object)either);
    }

    public Json docToJson(Document doc) {
        return ONConverter$.MODULE$.bsonToRelaxedJson(doc);
    }

    public Task<LogMessage> delete(UserDB.User user, String uuid) {
        Task ret = this.logInfo((Function0<String>)((Function0 & Serializable)() -> UUIDDocumentManager.$anonfun$4(uuid))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.updateOneT(this.getEditFilter(user, BsonString$.MODULE$.apply(uuid)), DocumentManager$.MODULE$.deleteAction(this.uniqueKey())).map((Function1 & Serializable)x$1 -> {
                CodexDB.UpdateResult updateResult = x$1;
                return LogMessage.None$.MODULE$;
            }));
        });
        return ret.onErrorHandle((Function1 & Serializable)ex -> ErrorExplanation$.MODULE$.apply("Delete failed", (Throwable)ex));
    }

    public Task<LogMessage> undelete(UserDB.User user, String uuid) {
        Task ret = this.logInfo((Function0<String>)((Function0 & Serializable)() -> UUIDDocumentManager.$anonfun$6(uuid))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.updateOneT(this.getEditFilter(user, BsonString$.MODULE$.apply(uuid)), DocumentManager$.MODULE$.undeleteAction(this.uniqueKey())).map((Function1 & Serializable)x$1 -> {
                CodexDB.UpdateResult updateResult = x$1;
                return LogMessage.None$.MODULE$;
            }));
        });
        return ret.onErrorHandle((Function1 & Serializable)ex -> ErrorExplanation$.MODULE$.apply("Undelete failed", (Throwable)ex));
    }

    public Task<Either<LogMessage, Document>> add(UserDB.User user, BsonValue key, Document doc) {
        Task ret = this.logInfo((Function0<String>)((Function0 & Serializable)() -> UUIDDocumentManager.$anonfun$8(key))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.cltnT().flatMap((Function1 & Serializable)cltn -> Task$.MODULE$.apply(() -> this.$anonfun$9$$anonfun$1$$anonfun$1(user, doc)).flatMap((Function1 & Serializable)finalDoc -> cltn.insertOneT(finalDoc).map((Function1 & Serializable)x$1 -> {
                CodexDB.InsertOneResult insertOneResult = x$1;
                return package$.MODULE$.Right().apply(finalDoc);
            })));
        });
        return ret.onErrorHandle((Function1 & Serializable)ex -> package$.MODULE$.Left().apply((Object)ErrorExplanation$.MODULE$.apply("Add failed", (Throwable)ex)));
    }

    public Task<LogMessage> update(UserDB.User user, BsonString uuid, BsonValue key, Document doc) {
        Task ret = this.logInfo((Function0<String>)((Function0 & Serializable)() -> UUIDDocumentManager.$anonfun$10(key))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.replaceOneT((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{this.getEditFilter(user, uuid), DocumentManager$.MODULE$.exists(this.uniqueKey())})), this.withLastModified(user, doc)).map((Function1 & Serializable)x$1 -> {
                CodexDB.UpdateResult updateResult = x$1;
                return LogMessage.None$.MODULE$;
            }));
        });
        return ret.onErrorHandle((Function1 & Serializable)ex -> ErrorExplanation$.MODULE$.apply("Update failed", BsonUtils$.MODULE$.asString(key), (Throwable)ex));
    }

    public Task<BoxedUnit> logInfo(Function0<String> msg) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.logInfo$$anonfun$1(msg);
            return BoxedUnit.UNIT;
        });
    }

    public CodexFilter getEditFilter(UserDB.User user, BsonString uuid) {
        return CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{UUIDDocumentManager$.MODULE$.withId(uuid), UUIDDocumentManager$.MODULE$.owner(user)}));
    }

    public Either<LogMessage, Option<BsonString>> extractId(Document doc) {
        Option option = doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString s = (BsonString)bsonValue;
                return package$.MODULE$.Right().apply((Object)Some$.MODULE$.apply((Object)s));
            }
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Invalid id"));
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Right().apply((Object)None$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    public Task<DocumentManager.Existence> uuidExists(BsonString uuid) {
        CodexFindOptions options = CodexFindOptions$.MODULE$.projections((CodexFindOptions.Projection)CodexFindOptions.Retain$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"_id", "name"})));
        return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.findO(UUIDDocumentManager$.MODULE$.withId(uuid), options).firstOptionL().map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                return DocumentManager$Existence$.MODULE$.apply(true, doc.contains("name"));
            }
            if (None$.MODULE$.equals(option)) {
                return DocumentManager$Existence$.MODULE$.apply(false, false);
            }
            throw new MatchError((Object)option);
        }).map((Function1 & Serializable)reply -> reply));
    }

    public Task<BoxedUnit> silentDelete(BsonString uuid) {
        return this.cltnT().flatMap((Function1 & Serializable)cltn -> cltn.deleteOneT(UUIDDocumentManager$.MODULE$.withId(uuid)).map((Function1)(JProcedure1 & Serializable)_$3 -> {}).map((Function1)(JProcedure1 & Serializable)reply -> {}));
    }

    public Either<LogMessage, BsonValue> extractKey(Document doc) {
        Option option = doc.get(this.uniqueKey(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString bs = (BsonString)bsonValue;
                String s = bs.getValue().trim();
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(s))) {
                    return package$.MODULE$.Right().apply((Object)BsonString$.MODULE$.apply(s));
                }
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Empty key field"));
            }
            BsonValue x = bsonValue;
            return package$.MODULE$.Right().apply((Object)x);
        }
        if (None$.MODULE$.equals(option)) {
            return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Missing key field"));
        }
        throw new MatchError((Object)option);
    }

    public Document withLastModified(UserDB.User user, Document doc) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"lastModified");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDateTime$.MODULE$.apply(this.clock().now())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"lastModifiedBy");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonString$.MODULE$.apply(user.name())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return (Document)doc.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public BsonString newUUID() {
        return BsonString$.MODULE$.apply(UUID.randomUUID().toString());
    }

    private static final String $anonfun$2() {
        return "unknown";
    }

    private static final BsonString upload$$anonfun$1$$anonfun$1(Document doc$2) {
        return (BsonString)doc$2.apply("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class));
    }

    private static final String $anonfun$4(String uuid$3) {
        return "deleting " + uuid$3;
    }

    private static final String $anonfun$6(String uuid$6) {
        return "undeleting " + uuid$6;
    }

    private static final String $anonfun$8(BsonValue key$1) {
        return "inserting " + key$1;
    }

    private final Document $anonfun$9$$anonfun$1$$anonfun$1(UserDB.User user$12, Document doc$9) {
        BsonString id = this.newUUID();
        BsonString owner = BsonString$.MODULE$.apply(user$12.id());
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)id), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"owner");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)owner), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return this.withLastModified(user$12, (Document)doc$9.updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    private static final String $anonfun$10(BsonValue key$2) {
        return "updating " + key$2;
    }

    private final void logInfo$$anonfun$1(Function0 msg$1) {
        ((LoggingMixin)this).log().info(msg$1, Line$.MODULE$.apply(153), FullName$.MODULE$.apply("ambience.codex.UUIDDocumentManager.logInfo"));
    }
}

