/*
 * Decompiled with CFR 0.152.
 */
package ambience.framework;

import ambience.api.BinaryStore;
import ambience.api.BinaryStore$ContentId$;
import ambience.api.BinaryStore$LocationId$;
import ambience.framework.BinaryStoreAPI$;
import ambience.gravity.GravityHelper$;
import ambience.module.UserDB;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import com.elixirtech.gravity.GravitySystem$;
import com.elixirtech.json.JsonLens$;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monocle.POptional;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class BinaryStoreRoute$
implements Serializable {
    private static final Scheduler scheduler;
    private static final BinaryStore binaryStoreAPI;
    private static final POptional Filename;
    private static final POptional MimeType;
    public static final BinaryStoreRoute$ MODULE$;

    private BinaryStoreRoute$() {
    }

    static {
        MODULE$ = new BinaryStoreRoute$();
        scheduler = Scheduler$.MODULE$.global();
        binaryStoreAPI = (BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class));
        Filename = JsonLens$.MODULE$.root().selectDynamic("filename").string();
        MimeType = JsonLens$.MODULE$.root().selectDynamic("mimeType").string();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BinaryStoreRoute$.class);
    }

    public Scheduler scheduler() {
        return scheduler;
    }

    public BinaryStore binaryStoreAPI() {
        return binaryStoreAPI;
    }

    public POptional<Json, Json, String, String> Filename() {
        return Filename;
    }

    public POptional<Json, Json, String, String> MimeType() {
        return MimeType;
    }

    public Function1<GravityRequest, Task<GravityResponse>> apply(UserDB.User user) {
        return GravitySystem$.MODULE$.fromRoutes(this.routes(user), GravitySystem$.MODULE$.fromRoutes$default$2());
    }

    public List<GravityRoute> routes(UserDB.User user) {
        return (List)new .colon.colon((Object)GravityRoute$.MODULE$.pathOnly(Gravity$.MODULE$.GET(), "stores", (Function1 & Serializable)request -> MODULE$.getStores(user, (GravityRequest)request)), (List)new .colon.colon((Object)GravityRoute$.MODULE$.all((Function1 & Serializable)request -> MODULE$.handleGetAndDelete(user, (GravityRequest)request)), (List)Nil$.MODULE$));
    }

    public Task<GravityResponse> getStores(UserDB.User user, GravityRequest request) {
        Task taskJsonString = this.binaryStoreAPI().locations().toListL().map((Function1 & Serializable)locs -> locs.map((Function1 & Serializable)_$1 -> _$1 == null ? null : ((BinaryStore.LocationId)_$1).value()).mkString("[", ",", "]"));
        return taskJsonString.map((Function1 & Serializable)jsonString -> GravityResponse$.MODULE$.json(jsonString));
    }

    public Task<GravityResponse> handleGetAndDelete(UserDB.User user, GravityRequest request) {
        return GravityHelper$.MODULE$.seg2(request, (Function2<Gravity.Segment, Gravity.Segment, Task<GravityResponse>>)(Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                Gravity.Segment store = (Gravity.Segment)tuple2._1();
                Gravity.Segment uuid = (Gravity.Segment)tuple2._2();
                Gravity.Method method = request.method();
                Gravity.Method method2 = Gravity$.MODULE$.GET();
                if (!(method != null ? !method.equals(method2) : method2 != null)) {
                    return MODULE$.getContent(user, store.value(), uuid.value());
                }
                Gravity.Method method3 = request.method();
                Gravity.Method method4 = Gravity$.MODULE$.DELETE();
                if (!(method3 != null ? !method3.equals(method4) : method4 != null)) {
                    return MODULE$.deleteContent(user, store.value(), uuid.value());
                }
                return Gravity$.MODULE$.MethodNotAllowedResponseT();
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Task<GravityResponse> getContent(UserDB.User user, String store, String uuid) {
        return BinaryStoreAPI$.MODULE$.location(BinaryStore$LocationId$.MODULE$.apply(store)).flatMap((Function1 & Serializable)x$12 -> {
            Option option = x$12;
            if (option instanceof Some) {
                BinaryStore.Location loc = (BinaryStore.Location)((Some)option).value();
                return loc.get(BinaryStore$ContentId$.MODULE$.apply(uuid)).map((Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (option instanceof Some) {
                        BinaryStore.Content content = (BinaryStore.Content)((Some)option).value();
                        Option optFilename = MODULE$.Filename().getOption((Object)content.metadata());
                        Gravity.Header contentDisposition = GravityResponse.ContentDisposition$.MODULE$.inline(optFilename);
                        String mimeType = (String)MODULE$.MimeType().getOption((Object)content.metadata()).getOrElse(BinaryStoreRoute$::$anonfun$2);
                        Gravity.Header contentType = Gravity.Header$.MODULE$.ContentType(mimeType);
                        Gravity.Headers headers = Gravity.Headers$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Gravity.Header[]{contentType, contentDisposition}));
                        return GravityResponse$.MODULE$.apply(Gravity.Status$.MODULE$.OK(), headers, content.bytes());
                    }
                    if (None$.MODULE$.equals(option)) {
                        return Gravity$.MODULE$.NotFoundResponse();
                    }
                    throw new MatchError((Object)option);
                });
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)Gravity$.MODULE$.NotFoundResponse());
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<GravityResponse> deleteContent(UserDB.User user, String store, String uuid) {
        return BinaryStoreAPI$.MODULE$.location(BinaryStore$LocationId$.MODULE$.apply(store)).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                BinaryStore.Location loc = (BinaryStore.Location)((Some)option).value();
                return loc.remove(BinaryStore$ContentId$.MODULE$.apply(uuid)).map((Function1 & Serializable)_$2 -> Gravity$.MODULE$.OkResponse());
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)Gravity$.MODULE$.NotFoundResponse());
            }
            throw new MatchError((Object)option);
        });
    }

    private static final String $anonfun$2() {
        return "application/octet-stream";
    }
}

