/*
 * Decompiled with CFR 0.152.
 */
package ambience.framework;

import ambience.api.BinaryStore;
import ambience.api.BinaryStore$Content$;
import ambience.api.BinaryStore$ContentId$;
import ambience.chunk.ObservableChunker;
import ambience.framework.BinaryStoreAPI;
import ambience.framework.MongoDBChunkedBinaryStoreLocation$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.arch.ObservableDataBytes;
import com.elixirtech.arch.ObservableDataBytes$;
import com.elixirtech.arch.SyncDataBytes;
import com.elixirtech.mongodb.FindOptions$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Json;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonBinary;
import org.bson.BsonDateTime;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.bson.BsonBinary$;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.package$;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Indexes$;
import org.mongodb.scala.model.Projections$;
import org.mongodb.scala.model.Sorts$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class MongoDBChunkedBinaryStoreLocation
implements BinaryStore.Location,
LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(MongoDBChunkedBinaryStoreLocation.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MongoDBChunkedBinaryStoreLocation.class.getDeclaredField("chunks$lzy1"));
    private volatile Object log$lzy1;
    private final String id;
    private final String dbName;
    private final String cltnName;
    private final String chunksName;
    private final long maxSize;
    private volatile Object chunks$lzy1;

    public static int TenMB() {
        return MongoDBChunkedBinaryStoreLocation$.MODULE$.TenMB();
    }

    public MongoDBChunkedBinaryStoreLocation(BinaryStoreAPI.BSConfig bsConfig) {
        this.id = bsConfig.id();
        this.dbName = bsConfig.config().getString("database");
        this.cltnName = bsConfig.config().getString("collection");
        this.chunksName = bsConfig.config().getString("collection");
        this.maxSize = bsConfig.config().getMemorySize("maxSize").toBytes();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String dbName() {
        return this.dbName;
    }

    public String cltnName() {
        return this.cltnName;
    }

    public String chunksName() {
        return this.chunksName;
    }

    @Override
    public long maxSize() {
        return this.maxSize;
    }

    public RichMongoCollection chunks() {
        Object object = this.chunks$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.chunks$lzyINIT1();
    }

    private Object chunks$lzyINIT1() {
        Object object;
        block7: {
            while (true) {
                if ((object = this.chunks$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        MongoDB mongoDB = (MongoDB)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(MongoDB.class));
                        MongoDatabase db = this.dbName().trim().isEmpty() ? mongoDB.database() : mongoDB.mongoClient().getDatabase(this.dbName());
                        RichMongoCollection cltn = new RichMongoCollection(db.getCollection(this.cltnName(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        cltn.createIndexT(Indexes$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"contentId", "idx"}))).runToFuture(Scheduler$.MODULE$.global());
                        richMongoCollection = cltn;
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    catch (Throwable throwable) {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.chunks$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                        throw throwable;
                    }
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                        LazyVals.Waiting waiting = (LazyVals.Waiting)this.chunks$lzy1;
                        LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                        waiting.countDown();
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block7;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public String description() {
        return "MongoDB Chunked BinaryStore using " + this.dbName() + ":" + this.cltnName();
    }

    @Override
    public Task<BinaryStore.ContentId> add(BinaryStore.Content content) {
        BsonString metadata = BsonString$.MODULE$.apply(content.metadata().noSpaces());
        String contentId = BinaryStore$ContentId$.MODULE$.apply(UUID.randomUUID().toString());
        BsonDateTime created = BsonDateTime$.MODULE$.apply(System.currentTimeMillis());
        this.wherePossibleCheckSize(content.bytes());
        int maxChunkCount = (int)scala.math.package$.MODULE$.ceil((double)this.maxSize() / (double)MongoDBChunkedBinaryStoreLocation$.MODULE$.TenMB());
        return new ObservableChunker(MongoDBChunkedBinaryStoreLocation$.MODULE$.TenMB()).apply((Observable<byte[]>)content.bytes().observable()).zipWithIndex().mapEval((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                byte[] bytes = (byte[])tuple2._1();
                long idx = BoxesRunTime.unboxToLong((Object)tuple2._2());
                if (idx >= (long)maxChunkCount) {
                    return this.remove(contentId).map((Function1 & Serializable)_$1 -> {
                        throw new BinaryStore.MaxSizeException("Streamed", this.maxSize());
                    });
                }
                Document doc = this.buildChunk(contentId, metadata, bytes, created, idx);
                return this.chunks().insertOneT(doc);
            }
            throw new MatchError((Object)tuple2);
        }).completedL().map((Function1 & Serializable)_$2 -> new BinaryStore.ContentId(contentId));
    }

    public Document buildChunk(String contentId, BsonString metadata, byte[] chunk, BsonDateTime created, long idx) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[5];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"contentId");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(contentId)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"idx");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonInt32$.MODULE$.apply((int)idx)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"bytes");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonBinary$.MODULE$.apply(chunk)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"metadata");
        objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)metadata), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"created");
        objectArray[4] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)created), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return package$.MODULE$.Document().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    public void wherePossibleCheckSize(DataBytes data) {
        DataBytes dataBytes = data;
        if (dataBytes instanceof SyncDataBytes) {
            SyncDataBytes bytes = (SyncDataBytes)dataBytes;
            if (bytes.length() > this.maxSize()) {
                throw new BinaryStore.MaxSizeException(bytes.length(), this.maxSize());
            }
            return;
        }
    }

    @Override
    public Observable<BinaryStore.ContentId> all() {
        return this.chunks().distinctO("contentId").flatMap((Function1 & Serializable)x$1 -> {
            BsonValue bsonValue = x$1;
            if (bsonValue instanceof BsonString) {
                BsonString v = (BsonString)bsonValue;
                return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new BinaryStore.ContentId[]{new BinaryStore.ContentId(BinaryStore$ContentId$.MODULE$.apply(v.getValue()))}));
            }
            return Observable$.MODULE$.empty();
        });
    }

    @Override
    public Task<Option<BinaryStore.Content>> get(String id) {
        ObservableDataBytes dataBytes = ObservableDataBytes$.MODULE$.apply(this.chunks().findO(Filters$.MODULE$.eq("contentId", (Object)BsonString$.MODULE$.apply(id)), FindOptions$.MODULE$.sorts(Sorts$.MODULE$.ascending((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"idx"})))).flatMap((Function1 & Serializable)doc -> Observable$.MODULE$.fromIterable(Option$.MODULE$.option2Iterable(this.getBytes((Document)doc)))));
        return this.getMetadata(id).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Json metadata = (Json)((Some)option).value();
                return Some$.MODULE$.apply((Object)BinaryStore$Content$.MODULE$.apply((DataBytes)dataBytes, metadata));
            }
            if (None$.MODULE$.equals(option)) {
                return None$.MODULE$;
            }
            throw new MatchError((Object)option);
        });
    }

    @Override
    public Task<Option<Json>> getMetadata(String id) {
        return this.chunks().findO(Filters$.MODULE$.eq("contentId", (Object)BsonString$.MODULE$.apply(id)), FindOptions$.MODULE$.projections(Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"metadata"})))).firstOptionL().map((Function1 & Serializable)_$3 -> _$3.flatMap((Function1 & Serializable)doc -> this.getMetadata((Document)doc)));
    }

    @Override
    public Task<BoxedUnit> remove(String id) {
        return this.chunks().deleteManyT(Filters$.MODULE$.eq("contentId", (Object)BsonString$.MODULE$.apply(id))).map((Function1)(JProcedure1 & Serializable)_$4 -> {});
    }

    private Option<Json> parseJson(String s) {
        return io.circe.parser.package$.MODULE$.parse(s).toOption();
    }

    private Option<byte[]> getBytes(Document doc) {
        return doc.get("bytes", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBinary.class)).map((Function1 & Serializable)_$5 -> _$5.getData());
    }

    private Option<Json> getMetadata(Document doc) {
        return doc.get("metadata", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$6 -> _$6.getValue()).flatMap((Function1 & Serializable)s -> this.parseJson((String)s));
    }
}

