/*
 * Decompiled with CFR 0.152.
 */
package ambience.housekeeping;

import ambience.agenda.Agenda;
import ambience.agenda.Agenda$EpochMinute$;
import ambience.agenda.Agenda$Listener$;
import ambience.agenda.Agenda$ListenerId$;
import ambience.agenda.Agenda$Result$;
import ambience.agenda.AmbienceAgenda;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.MongoDB;
import com.mongodb.client.result.DeleteResult;
import io.circe.Json$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import org.bson.BsonArray;
import org.bson.BsonDateTime;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.MongoCollection;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import org.reactivestreams.Publisher;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Try;
import scala.util.Try$;
import sourcecode.FullName$;
import sourcecode.Line$;

public class TempCleaner
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(TempCleaner.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final MongoDB mongoDB;
    private final Clock clock;
    private final AmbienceAgenda agenda;
    private final Scheduler scheduler;
    private final long ExpiryInterval;
    private final int BatchSize;
    private final String listenerId;
    private final MongoCollection cltn;

    public TempCleaner(MongoDB mongoDB, Clock clock, AmbienceAgenda agenda) {
        this.mongoDB = mongoDB;
        this.clock = clock;
        this.agenda = agenda;
        this.scheduler = Scheduler$.MODULE$.global();
        this.ExpiryInterval = mongoDB.sysConfig().config().getDuration("ambience.temp-cleaner.expiry").toMillis();
        this.BatchSize = mongoDB.sysConfig().config().getInt("ambience.temp-cleaner.batch-size");
        this.listenerId = Agenda$ListenerId$.MODULE$.apply("TempCleaner");
        this.cltn = mongoDB.database().getCollection("TempCleaner", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class));
        agenda.add(Agenda$Listener$.MODULE$.apply(this.listenerId(), (Function1<Agenda.Item, Try<Agenda.Result>>)(Function1 & Serializable)item -> this.onRun((Agenda.Item)item)));
        this.schedule().runToFuture(this.scheduler()).recover((PartialFunction)new Serializable(this){
            private final /* synthetic */ TempCleaner $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof Exception) {
                    Exception ex = (Exception)throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof Exception) {
                    Exception ex = (Exception)throwable;
                    this.$outer.log().error(() -> TempCleaner.ambience$housekeeping$TempCleaner$$anon$1$$_$applyOrElse$$anonfun$1(ex), (Throwable)ex, Line$.MODULE$.apply(31), FullName$.MODULE$.apply("ambience.housekeeping.TempCleaner"));
                    return BoxedUnit.UNIT;
                }
                return function1.apply((Object)x);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$housekeeping$TempCleaner$$anon$1$$_$applyOrElse$$anonfun$1(java.lang.Exception )}, serializedLambda);
            }
        }, (ExecutionContext)this.scheduler());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public long ExpiryInterval() {
        return this.ExpiryInterval;
    }

    public int BatchSize() {
        return this.BatchSize;
    }

    public String listenerId() {
        return this.listenerId;
    }

    public MongoCollection<Document> cltn() {
        return this.cltn;
    }

    public Try<Agenda.Result> onRun(Agenda.Item item) {
        return Try$.MODULE$.apply(this::onRun$$anonfun$1);
    }

    private Task<BoxedUnit> schedule() {
        return this.taskInfo((Function0<String>)((Function0 & Serializable)TempCleaner::schedule$$anonfun$1)).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.agenda.isActive(this.listenerId()).flatMap((Function1 & Serializable)active -> this.schedule$$anonfun$2$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)active)));
        });
    }

    private Task<Agenda.ItemId> addSchedule() {
        this.log().info(TempCleaner::addSchedule$$anonfun$1, Line$.MODULE$.apply(47), FullName$.MODULE$.apply("ambience.housekeeping.TempCleaner.addSchedule"));
        return this.agenda.notify(Agenda$EpochMinute$.MODULE$.now().addHours(1), this.listenerId(), Json$.MODULE$.fromFields((Iterable)package$.MODULE$.Nil()));
    }

    public Agenda.Result run() {
        this.log().info(this::run$$anonfun$1, Line$.MODULE$.apply(52), FullName$.MODULE$.apply("ambience.housekeeping.TempCleaner.run"));
        Task tresult = this.buildExpired().flatMap((Function1 & Serializable)recorded -> this.currentCollections().flatMap((Function1 & Serializable)names -> Task$.MODULE$.apply(() -> TempCleaner.$anonfun$1$$anonfun$1$$anonfun$1(recorded, names)).flatMap((Function1 & Serializable)expired -> this.deleteExpired((Seq<String>)expired.toSeq()).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.buildDoc((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)names.$minus$minus((IterableOnce)expired))).flatMap((Function1 & Serializable)doc -> this.removeIds(BsonDateTime$.MODULE$.apply(this.clock.now() - this.ExpiryInterval() - 60000L)).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().insertOne(doc)).completedL().flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.schedule().map((Function1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        Object[] objectArray = new Tuple2[2];
                        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"counted");
                        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromInt(names.size()));
                        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"removed");
                        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromInt(expired.size()));
                        return Agenda$Result$.MODULE$.apply(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
                    });
                });
            }));
        }))));
        Agenda.Result result = (Agenda.Result)Await$.MODULE$.result((Awaitable)tresult.runToFuture(Scheduler$.MODULE$.global()), (Duration)Duration$.MODULE$.Inf());
        this.log().info(() -> TempCleaner.run$$anonfun$2(result), Line$.MODULE$.apply(64), FullName$.MODULE$.apply("ambience.housekeeping.TempCleaner.run"));
        return result;
    }

    public Task<scala.collection.immutable.Set<String>> buildExpired() {
        BsonDateTime expiry = BsonDateTime$.MODULE$.apply(this.clock.now() - this.ExpiryInterval());
        Observable run = Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().find(Filters$.MODULE$.lt("ts", (Object)expiry), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).flatMap((Function1 & Serializable)doc -> this.buildExpired((Document)doc).map((Function1 & Serializable)expired -> expired));
        return run.toListL().map((Function1 & Serializable)_$1 -> _$1.toSet());
    }

    public Task<scala.collection.immutable.Set<String>> currentCollections() {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.mongoDB.temp().listCollectionNames()).toListL().map((Function1 & Serializable)_$2 -> _$2.toSet());
    }

    public Task<Document> buildDoc(scala.collection.immutable.Set<String> names) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"ts");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDateTime$.MODULE$.apply(this.clock.now())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"names");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonArray$.MODULE$.fromIterable((Iterable)names.toSeq().map((Function1 & Serializable)_$3 -> BsonString$.MODULE$.apply(_$3)))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return Task$.MODULE$.now((Object)Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    public Observable<String> buildExpired(Document doc) {
        Option names = doc.get("names", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).map((Function1 & Serializable)_$4 -> CollectionConverters$.MODULE$.ListHasAsScala(_$4.getValues()).asScala().toSeq()).flatMap((Function1 & Serializable)bsonNames -> Some$.MODULE$.apply(bsonNames.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(BsonValue x) {
                BsonValue bsonValue = x;
                if (bsonValue instanceof BsonString) {
                    BsonString s = (BsonString)bsonValue;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(BsonValue x, Function1 function1) {
                BsonValue bsonValue = x;
                if (bsonValue instanceof BsonString) {
                    BsonString s = (BsonString)bsonValue;
                    return s.getValue();
                }
                return function1.apply((Object)x);
            }
        })).map((Function1 & Serializable)names -> names));
        return Observable$.MODULE$.fromIterable((Iterable)names.getOrElse(TempCleaner::buildExpired$$anonfun$2));
    }

    public Task<BoxedUnit> deleteExpired(Seq<String> names) {
        Tuple2 tuple2 = names.splitAt(this.BatchSize());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq first = (Seq)tuple2._1();
        Seq rest = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)first, (Object)rest);
        Seq first2 = (Seq)tuple22._1();
        Seq rest2 = (Seq)tuple22._2();
        return this.deleteExpiredBatch((Seq<String>)first2).flatMap((Function1 & Serializable)_$5 -> {
            if (rest2.nonEmpty()) {
                return this.deleteExpired((Seq<String>)rest2);
            }
            return Task$.MODULE$.unit();
        });
    }

    public Task<BoxedUnit> deleteExpiredBatch(Seq<String> names) {
        return Task$.MODULE$.parSequence((Iterable)names.map((Function1 & Serializable)name -> this.drop((String)name)), BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1)(JProcedure1 & Serializable)_$6 -> {});
    }

    public Task<BoxedUnit> drop(String name) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.mongoDB.temp().getCollection(name, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)).drop()).completedL();
    }

    public Task<BoxedUnit> removeIds(BsonDateTime expiry) {
        return Observable$.MODULE$.fromReactivePublisher((Publisher)this.cltn().deleteMany(Filters$.MODULE$.lt("ts", (Object)expiry))).map((Function1)(JProcedure1 & Serializable)reply -> {
            if (reply.getDeletedCount() > 1L) {
                this.log().info(() -> TempCleaner.removeIds$$anonfun$1$$anonfun$1(reply), Line$.MODULE$.apply(113), FullName$.MODULE$.apply("ambience.housekeeping.TempCleaner.removeIds"));
                return;
            }
        }).completedL();
    }

    public Task<BoxedUnit> taskInfo(Function0<String> msg) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.taskInfo$$anonfun$1(msg);
            return BoxedUnit.UNIT;
        });
    }

    public static final Object ambience$housekeeping$TempCleaner$$anon$1$$_$applyOrElse$$anonfun$1(Exception ex$1) {
        return "Error caught in init: " + ex$1;
    }

    private final Agenda.Result onRun$$anonfun$1() {
        return this.run();
    }

    private static final String schedule$$anonfun$1() {
        return "Scheduling...";
    }

    private static final String schedule$$anonfun$2$$anonfun$1$$anonfun$1() {
        return "There is already a scheduled activity recorded";
    }

    private final /* synthetic */ Task schedule$$anonfun$2$$anonfun$1(boolean active) {
        return (!active ? this.addSchedule() : this.taskInfo((Function0<String>)((Function0 & Serializable)TempCleaner::schedule$$anonfun$2$$anonfun$1$$anonfun$1))).map((Function1)(JProcedure1 & Serializable)x$1 -> {
            Object object = x$1;
        });
    }

    private static final Object addSchedule$$anonfun$1() {
        return "Adding scheduled activity to run in 60 minutes";
    }

    private final Object run$$anonfun$1() {
        return "Running with expiry " + this.ExpiryInterval() / 60000L + " mins";
    }

    private static final scala.collection.immutable.Set $anonfun$1$$anonfun$1$$anonfun$1(scala.collection.immutable.Set recorded$2, scala.collection.immutable.Set names$1) {
        return (scala.collection.immutable.Set)recorded$2.intersect((Set)names$1);
    }

    private static final Object run$$anonfun$2(Agenda.Result result$1) {
        return "Result: " + result$1.value().noSpaces();
    }

    private static final Seq buildExpired$$anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private static final Object removeIds$$anonfun$1$$anonfun$1(DeleteResult reply$1) {
        return "Removed " + reply$1.getDeletedCount() + " TempCleaner records";
    }

    private final void taskInfo$$anonfun$1(Function0 msg$1) {
        this.log().info(msg$1, Line$.MODULE$.apply(119), FullName$.MODULE$.apply("ambience.housekeeping.TempCleaner.taskInfo"));
    }
}

