/*
 * Decompiled with CFR 0.152.
 */
package ambience.module;

import ambience.module.APITokenDB;
import ambience.module.APITokenDB$APIInfo$;
import ambience.module.CodexHelper$;
import ambience.module.UserDB;
import ambience.util.ONConverter$;
import com.elixirtech.api.AuditAPI;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexUpdate;
import com.elixirtech.gravity.Gravity;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import org.bson.BsonBoolean;
import org.bson.BsonObjectId;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class APITokenCodexDB
implements APITokenDB,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(APITokenCodexDB.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final UserDB userDB;
    private final AuditAPI.AuditAppender auditAppender;
    private final Scheduler scheduler;
    private final Task tokensT;
    private final AuditAPI.Component auditComponent;

    public APITokenCodexDB(CodexDB codexDB, UserDB userDB, AuditAPI.AuditAppender auditAppender) {
        this.userDB = userDB;
        this.auditAppender = auditAppender;
        this.scheduler = Scheduler$.MODULE$.global();
        this.tokensT = codexDB.getCodexCollection("APITokens");
        this.auditComponent = AuditAPI.Component$.MODULE$.apply("Kernel", "APITokenDB");
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Task<CodexCollection> tokensT() {
        return this.tokensT;
    }

    public AuditAPI.Component auditComponent() {
        return this.auditComponent;
    }

    @Override
    public Task<Option<APITokenDB.APIInfo>> lookupUserForToken(String token, Gravity.Path uri) {
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("token", (BsonValue)BsonString$.MODULE$.apply(token)), CodexHelper$.MODULE$.IsEnabled()}));
        Task ret = this.tokensT().flatMap((Function1 & Serializable)_$1 -> _$1.findO((CodexFilter)filter).toListL().flatMap((Function1 & Serializable)reply -> {
            Option option = reply.headOption();
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                return this.buildAPIInfo(doc);
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.now((Object)None$.MODULE$);
            }
            throw new MatchError((Object)option);
        }));
        return ret.map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                APITokenDB.APIInfo apiInfo = (APITokenDB.APIInfo)((Some)option).value();
                this.bumpAccess(token);
                AuditAPI.Action action = AuditAPI.Success$.MODULE$.apply(token, "Access", (Option)Some$.MODULE$.apply((Object)uri.toString()), AuditAPI.Success$.MODULE$.apply$default$4());
                AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply(apiInfo.user().name(), this.auditComponent(), action);
                this.auditAppender.append(auditMsg);
                this.log().info(() -> APITokenCodexDB.lookupUserForToken$$anonfun$1$$anonfun$1(token, apiInfo), Line$.MODULE$.apply(47), FullName$.MODULE$.apply("ambience.module.APITokenCodexDB.lookupUserForToken"));
                return Some$.MODULE$.apply((Object)apiInfo);
            }
            if (None$.MODULE$.equals(option)) {
                AuditAPI.Action action = AuditAPI.Failure$.MODULE$.apply(token, "Access", (Option)Some$.MODULE$.apply((Object)uri.toString()), AuditAPI.Failure$.MODULE$.apply$default$4());
                AuditAPI.AuditMessage auditMsg = AuditAPI.AuditMessage$.MODULE$.apply("", this.auditComponent(), action);
                this.auditAppender.append(auditMsg);
                this.log().warn(() -> APITokenCodexDB.lookupUserForToken$$anonfun$1$$anonfun$2(token), Line$.MODULE$.apply(53), FullName$.MODULE$.apply("ambience.module.APITokenCodexDB.lookupUserForToken"));
                return None$.MODULE$;
            }
            throw new MatchError((Object)option);
        });
    }

    public void bumpAccess(String token) {
        CodexUpdate.CurrentTimestamp bump = CodexUpdate.CurrentTimestamp$.MODULE$.apply("lastAccess");
        this.tokensT().flatMap((Function1 & Serializable)_$2 -> _$2.updateOneT((CodexFilter)CodexFilter.Eq$.MODULE$.apply("token", (BsonValue)BsonString$.MODULE$.apply(token)), (CodexUpdate)bump).map((Function1)(JProcedure1 & Serializable)_$3 -> {})).runAsyncAndForget(this.scheduler());
    }

    public Task<Option<APITokenDB.APIInfo>> buildAPIInfo(Document doc) {
        boolean addCookie = doc.get("addCookie", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonBoolean.class)).exists((Function1 & Serializable)_$4 -> _$4.getValue());
        Option option = doc.get("userId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonObjectId.class));
        if (option instanceof Some) {
            BsonObjectId userId = (BsonObjectId)((Some)option).value();
            return this.userDB.getUserById(userId.getValue().toHexString()).map((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    UserDB.User user = (UserDB.User)((Some)option).value();
                    UserDB.User user2 = user;
                    if (user2.enabled()) {
                        return Some$.MODULE$.apply((Object)APITokenDB$APIInfo$.MODULE$.apply(user2, addCookie));
                    }
                    UserDB.User user3 = user;
                    this.log().info(() -> APITokenCodexDB.buildAPIInfo$$anonfun$1$$anonfun$1(user3), Line$.MODULE$.apply(70), FullName$.MODULE$.apply("ambience.module.APITokenCodexDB.buildAPIInfo"));
                    return None$.MODULE$;
                }
                if (None$.MODULE$.equals(option)) {
                    this.log().info(() -> APITokenCodexDB.buildAPIInfo$$anonfun$1$$anonfun$2(userId), Line$.MODULE$.apply(73), FullName$.MODULE$.apply("ambience.module.APITokenCodexDB.buildAPIInfo"));
                    return None$.MODULE$;
                }
                throw new MatchError((Object)option);
            });
        }
        if (None$.MODULE$.equals(option)) {
            this.log().info(() -> APITokenCodexDB.buildAPIInfo$$anonfun$2(doc), Line$.MODULE$.apply(77), FullName$.MODULE$.apply("ambience.module.APITokenCodexDB.buildAPIInfo"));
            return Task$.MODULE$.now((Object)None$.MODULE$);
        }
        throw new MatchError((Object)option);
    }

    private static final Object lookupUserForToken$$anonfun$1$$anonfun$1(String token$2, APITokenDB.APIInfo apiInfo$1) {
        return "access with " + token$2 + " for " + apiInfo$1.user().name();
    }

    private static final Object lookupUserForToken$$anonfun$1$$anonfun$2(String token$3) {
        return "access with " + token$3 + " failed - invalid token";
    }

    private static final Object buildAPIInfo$$anonfun$1$$anonfun$1(UserDB.User user$1) {
        return "User " + user$1.name() + " (" + user$1.id() + ") is not enabled";
    }

    private static final Object buildAPIInfo$$anonfun$1$$anonfun$2(BsonObjectId userId$2) {
        return "User id " + userId$2 + " not found";
    }

    private static final Object buildAPIInfo$$anonfun$2(Document doc$1) {
        return "Valid token, but no userId: " + ONConverter$.MODULE$.bsonToRelaxedJson(doc$1);
    }
}

