/*
 * Decompiled with CFR 0.152.
 */
package ambience.queue;

import ambience.queue.Payload;
import ambience.queue.Payload$;
import ambience.queue.QId;
import ambience.queue.QId$;
import ambience.queue.Queue$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexFindOptions;
import com.elixirtech.codex.CodexIndex;
import com.elixirtech.codex.CodexUpdate;
import com.typesafe.config.Config;
import java.io.Serializable;
import java.util.UUID;
import java.util.regex.Pattern;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import org.bson.BsonArray;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class Queue
implements LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(Queue.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(Queue.class.getDeclaredField("systemId$lzy1"));
    private volatile Object log$lzy1;
    private final Clock clock;
    private final Task<CodexCollection> cltnT;
    private final long expiryDuration;
    private volatile Object systemId$lzy1;
    private final Task init;

    public static BsonString Added() {
        return Queue$.MODULE$.Added();
    }

    public static BsonString Cancelled() {
        return Queue$.MODULE$.Cancelled();
    }

    public static BsonString Completed() {
        return Queue$.MODULE$.Completed();
    }

    public static BsonString Deleted() {
        return Queue$.MODULE$.Deleted();
    }

    public static BsonString Failed() {
        return Queue$.MODULE$.Failed();
    }

    public static BsonString JobTimeout() {
        return Queue$.MODULE$.JobTimeout();
    }

    public static CodexFilter NotFilter() {
        return Queue$.MODULE$.NotFilter();
    }

    public static BsonString Processing() {
        return Queue$.MODULE$.Processing();
    }

    public static BsonString Replied() {
        return Queue$.MODULE$.Replied();
    }

    public static BsonString WaitTimeout() {
        return Queue$.MODULE$.WaitTimeout();
    }

    public Queue(Clock clock, Task<CodexCollection> cltnT, long expiryDuration, Scheduler scheduler) {
        this.clock = clock;
        this.cltnT = cltnT;
        this.expiryDuration = expiryDuration;
        this.init = cltnT.flatMap((Function1 & Serializable)cltn -> cltn.createIndexT((CodexIndex)CodexIndex.Ascending$.MODULE$.apply("status", CodexIndex.Ascending$.MODULE$.$lessinit$greater$default$2(), CodexIndex.Ascending$.MODULE$.$lessinit$greater$default$3())).flatMap((Function1 & Serializable)x$12 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return cltn.createIndexT((CodexIndex)CodexIndex.ExpireAt$.MODULE$.apply("expireAt")).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return cltn.createIndexT((CodexIndex)CodexIndex.Ascending$.MODULE$.apply("waitTimeoutAt", CodexIndex.Ascending$.MODULE$.$lessinit$greater$default$2(), CodexIndex.Ascending$.MODULE$.$lessinit$greater$default$3())).flatMap((Function1 & Serializable)x$12 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return this.terminateInProgressFromThisSystemId((CodexCollection)cltn).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    });
                });
            });
        }));
        this.init().runAsyncAndForget(scheduler);
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public String systemId() {
        Object object = this.systemId$lzy1;
        if (object instanceof String) {
            return (String)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (String)this.systemId$lzyINIT1();
    }

    private Object systemId$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.systemId$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    String string = null;
                    try {
                        string = ((Config)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(Config.class))).getString("ambience.systemId");
                        object2 = string == null ? LazyVals.NullValue$.MODULE$ : string;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.systemId$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return string;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<BoxedUnit> init() {
        return this.init;
    }

    public Task<BoxedUnit> terminateInProgressFromThisSystemId(CodexCollection cltn) {
        CodexFilter.Eq filter1 = CodexFilter.Eq$.MODULE$.apply("status", (BsonValue)BsonString$.MODULE$.apply("Processing"));
        CodexFilter.Regex filter2 = CodexFilter.Regex$.MODULE$.apply("engine", "^" + Pattern.quote(this.systemId() + "["));
        CodexUpdate.Set update1 = CodexUpdate.Set$.MODULE$.apply("status", (BsonValue)BsonString$.MODULE$.apply("Failed"));
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"action");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply("Failed")), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"at");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonDateTime$.MODULE$.apply(System.currentTimeMillis())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"msg");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonString$.MODULE$.apply("Shutdown Detected")), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        CodexUpdate.Push update2 = CodexUpdate.Push$.MODULE$.apply("history", (BsonValue)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
        return cltn.updateManyT((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{filter1, filter2})), (CodexUpdate)CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{update1, update2}))).map((Function1)(JProcedure1 & Serializable)reply -> {
            if (reply.getModifiedCount() > 0L) {
                this.log().info(() -> Queue.terminateInProgressFromThisSystemId$$anonfun$1$$anonfun$1(reply), Line$.MODULE$.apply(60), FullName$.MODULE$.apply("ambience.queue.Queue.terminateInProgressFromThisSystemId"));
                return;
            }
        });
    }

    public Task<QId> writeRequest(Document request, long waitTimeoutMs) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> new QId(Queue.writeRequest$$anonfun$1())).flatMap((Function1 & Serializable)qid -> this.writeRequest$$anonfun$2(request, waitTimeoutMs, qid == null ? null : ((QId)qid).value()));
    }

    public Task<Option<Payload>> readRequest(String engineId, Set<BsonString> jobTypes) {
        CodexFilter.Eq statusAdded = CodexFilter.Eq$.MODULE$.apply("status", (BsonValue)Queue$.MODULE$.Added());
        CodexFilter.In jobTypeIn = CodexFilter.In$.MODULE$.apply("request.jobType", jobTypes.toSet());
        BsonDateTime now = BsonDateTime$.MODULE$.apply(System.currentTimeMillis());
        CodexFilter.Or afterNow = CodexFilter.Or$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.NotExists$.MODULE$.apply("request.runAfter"), CodexFilter.Lte$.MODULE$.apply("request.runAfter", (BsonValue)now)}));
        CodexFilter.Gt notWaitTimedOut = CodexFilter.Gt$.MODULE$.apply("waitTimeoutAt", (BsonValue)now);
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{statusAdded, jobTypeIn, afterNow, notWaitTimedOut}));
        String engineString = this.systemId() + "[" + engineId + "]";
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("status", (BsonValue)Queue$.MODULE$.Processing()), CodexUpdate.Set$.MODULE$.apply("engine", (BsonValue)BsonString$.MODULE$.apply(engineString)), this.history("Started")}));
        CodexFindOptions.Sorts options = CodexFindOptions.Sorts$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFindOptions.Sort[]{CodexFindOptions.Ascending$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"request.jobPriority"})), CodexFindOptions.Ascending$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"expireAt"}))}));
        return this.cltnT.flatMap((Function1 & Serializable)_$3 -> _$3.findOneAndUpdateT((CodexFilter)filter, (CodexUpdate)update, (CodexFindOptions.Sort)options).map((Function1 & Serializable)reply -> reply.flatMap((Function1 & Serializable)doc -> doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$4 -> _$4.getValue()).flatMap((Function1 & Serializable)id -> doc.get("request", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).map((Function1 & Serializable)request -> Payload$.MODULE$.apply(QId$.MODULE$.apply((String)id), Document$.MODULE$.apply(request)))))));
    }

    public Task<BoxedUnit> syncWaitTimeout() {
        CodexFilter.Eq statusAdded = CodexFilter.Eq$.MODULE$.apply("status", (BsonValue)Queue$.MODULE$.Added());
        BsonDateTime now = BsonDateTime$.MODULE$.apply(System.currentTimeMillis());
        CodexFilter.Lte waitTimedOut = CodexFilter.Lte$.MODULE$.apply("waitTimeoutAt", (BsonValue)now);
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{statusAdded, waitTimedOut}));
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("status", (BsonValue)Queue$.MODULE$.WaitTimeout()), this.history("WaitTimeout")}));
        return this.cltnT.flatMap((Function1 & Serializable)_$5 -> _$5.updateManyT((CodexFilter)filter, (CodexUpdate)update).map((Function1)(JProcedure1 & Serializable)res -> {
            if (res.getModifiedCount() > 0L) {
                this.log().info(() -> Queue.syncWaitTimeout$$anonfun$1$$anonfun$1$$anonfun$1(res), Line$.MODULE$.apply(119), FullName$.MODULE$.apply("ambience.queue.Queue.syncWaitTimeout"));
                return;
            }
        }));
    }

    public Task<BoxedUnit> writeResult(Payload result) {
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(result.qId())), CodexFilter.Eq$.MODULE$.apply("status", (BsonValue)Queue$.MODULE$.Processing())}));
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("status", (BsonValue)Queue$.MODULE$.Replied()), CodexUpdate.Set$.MODULE$.apply("result", (BsonValue)result.doc().toBsonDocument()), this.history("Finished")}));
        return this.cltnT.flatMap((Function1 & Serializable)_$6 -> _$6.updateOneT((CodexFilter)filter, (CodexUpdate)update).map((Function1 & Serializable)reply -> {
            if (reply.getModifiedCount() == 1L) {
                return BoxedUnit.UNIT;
            }
            return Task$.MODULE$.raiseError((Throwable)new RuntimeException("writeResult failed for qid " + result.qId()));
        })).void();
    }

    public Task<Option<String>> getStatus(String qid) {
        CodexFilter.Eq filter = CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(qid));
        return this.cltnT.flatMap((Function1 & Serializable)_$7 -> _$7.findOneO((CodexFilter)filter).firstOptionL()).map((Function1 & Serializable)optDoc -> optDoc.flatMap((Function1 & Serializable)doc -> doc.get("status", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$8 -> _$8.getValue())));
    }

    public Task<Option<Document>> readResultAndMarkCompleted(String qid) {
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(qid)), CodexFilter.Eq$.MODULE$.apply("status", (BsonValue)Queue$.MODULE$.Replied())}));
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("status", (BsonValue)Queue$.MODULE$.Completed()), this.history("Completed")}));
        return this.cltnT.flatMap((Function1 & Serializable)_$9 -> _$9.findOneAndUpdateT((CodexFilter)filter, (CodexUpdate)update).map((Function1 & Serializable)reply -> reply.flatMap((Function1 & Serializable)doc -> doc.get("result", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).map((Function1 & Serializable)result -> Document$.MODULE$.apply(result)))));
    }

    public Task<Option<Document>> getResult(String qid) {
        CodexFilter.Eq filter = CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(qid));
        return this.cltnT.flatMap((Function1 & Serializable)_$10 -> _$10.findOneO((CodexFilter)filter).firstOptionL().map((Function1 & Serializable)reply -> reply.flatMap((Function1 & Serializable)doc -> doc.get("result", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDocument.class)).map((Function1 & Serializable)result -> Document$.MODULE$.apply(result)))));
    }

    public Task<BoxedUnit> cancel(String qid) {
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(qid)), CodexFilter.Eq$.MODULE$.apply("status", (BsonValue)Queue$.MODULE$.Processing())}));
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("status", (BsonValue)Queue$.MODULE$.Cancelled()), this.history("Cancelled")}));
        return this.cltnT.flatMap((Function1 & Serializable)_$11 -> _$11.findOneAndUpdateT((CodexFilter)filter, (CodexUpdate)update).void());
    }

    public Task<BoxedUnit> waitTimeout(String qid) {
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(qid)), Queue$.MODULE$.NotFilter()}));
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("status", (BsonValue)Queue$.MODULE$.WaitTimeout()), this.history("WaitTimeout")}));
        return this.cltnT.flatMap((Function1 & Serializable)_$12 -> _$12.findOneAndUpdateT((CodexFilter)filter, (CodexUpdate)update).void());
    }

    public Task<BoxedUnit> jobTimeout(String qid) {
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(qid)), Queue$.MODULE$.NotFilter()}));
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("status", (BsonValue)Queue$.MODULE$.JobTimeout()), this.history("JobTimeout")}));
        return this.cltnT.flatMap((Function1 & Serializable)_$13 -> _$13.findOneAndUpdateT((CodexFilter)filter, (CodexUpdate)update).void());
    }

    public Task<BoxedUnit> failed(String qid, String msg) {
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(qid)), Queue$.MODULE$.NotFilter()}));
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("status", (BsonValue)Queue$.MODULE$.Failed()), this.history("Failed", msg)}));
        return this.cltnT.flatMap((Function1 & Serializable)_$14 -> _$14.findOneAndUpdateT((CodexFilter)filter, (CodexUpdate)update).void());
    }

    public Task<BoxedUnit> delete(String qid) {
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(qid)), CodexFilter.Eq$.MODULE$.apply("status", (BsonValue)Queue$.MODULE$.Added())}));
        CodexUpdate.Combine update = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{CodexUpdate.Set$.MODULE$.apply("status", (BsonValue)Queue$.MODULE$.Deleted()), this.history("Deleted")}));
        return this.cltnT.flatMap((Function1 & Serializable)_$15 -> _$15.findOneAndUpdateT((CodexFilter)filter, (CodexUpdate)update).void());
    }

    public CodexUpdate history(String what) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"action");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(what)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"at");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonDateTime$.MODULE$.apply(this.clock.now())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return CodexUpdate.Push$.MODULE$.apply("history", (BsonValue)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    public CodexUpdate history(String what, String msg) {
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[3];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"action");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonString$.MODULE$.apply(what)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"at");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonDateTime$.MODULE$.apply(this.clock.now())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"msg");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonString$.MODULE$.apply(msg)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        return CodexUpdate.Push$.MODULE$.apply("history", (BsonValue)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)));
    }

    public BsonDateTime calcExpires(Document request) {
        Option option = request.get("runAfter", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDateTime.class));
        if (option instanceof Some) {
            BsonDateTime dt = (BsonDateTime)((Some)option).value();
            return BsonDateTime$.MODULE$.apply(dt.getValue() + this.expiryDuration);
        }
        if (None$.MODULE$.equals(option)) {
            return BsonDateTime$.MODULE$.apply(this.clock.now() + this.expiryDuration);
        }
        throw new MatchError((Object)option);
    }

    private static final Object terminateInProgressFromThisSystemId$$anonfun$1$$anonfun$1(CodexDB.UpdateResult reply$1) {
        return "Terminated in progress jobs after shutdown recovery: " + reply$1.getModifiedCount();
    }

    private static final String writeRequest$$anonfun$1() {
        return QId$.MODULE$.apply(UUID.randomUUID().toString());
    }

    private static final /* synthetic */ String writeRequest$$anonfun$2$$anonfun$2(String qid$3, String x$1) {
        String string = x$1;
        return qid$3;
    }

    private final /* synthetic */ Task writeRequest$$anonfun$2(Document request$1, long waitTimeoutMs$1, String qid) {
        BsonDateTime expireAt = this.calcExpires(request$1);
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"action");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)"Added"), (BsonTransformer)BsonTransformer$.MODULE$.TransformString());
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"at");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonDateTime$.MODULE$.apply(this.clock.now())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        BsonArray initialHistory = BsonArray$.MODULE$.fromIterable((Iterable)new .colon.colon((Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray)), (List)Nil$.MODULE$));
        Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[6];
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)BsonString$.MODULE$.apply(qid)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"request");
        objectArray2[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)request$1), (BsonTransformer)BsonTransformer$.MODULE$.TransformImmutableDocument());
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"status");
        objectArray2[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)Queue$.MODULE$.Added()), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"expireAt");
        objectArray2[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)expireAt), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"waitTimeoutAt");
        objectArray2[4] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)BsonDateTime$.MODULE$.apply(waitTimeoutMs$1)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"history");
        objectArray2[5] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)initialHistory), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        Document doc = Document$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2));
        return this.cltnT.flatMap((Function1 & Serializable)_$1 -> _$1.insertOneT(doc).map((Function1 & Serializable)_$2 -> new QId(qid))).map((Function1 & Serializable)v1 -> new QId(Queue.writeRequest$$anonfun$2$$anonfun$2(qid, v1 == null ? null : ((QId)v1).value())));
    }

    private static final Object syncWaitTimeout$$anonfun$1$$anonfun$1$$anonfun$1(CodexDB.UpdateResult res$1) {
        return "(" + res$1.getModifiedCount() + ") Jobs found that exceeded wait timeout";
    }
}

