/*
 * Decompiled with CFR 0.152.
 */
package ambience.queue;

import ambience.queue.QueueManager$;
import com.elixirtech.coredata.Iso8601$;
import com.elixirtech.json.JsonLens$;
import com.elixirtech.mongodb.BsonETL$;
import io.circe.ACursor;
import io.circe.Decoder$;
import io.circe.Json;
import java.io.Serializable;
import org.bson.BsonDateTime;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.java8.JFunction1;

public final class QueueUtil$
implements Serializable {
    private static final long MinDurationMs;
    public static final QueueUtil$ MODULE$;

    private QueueUtil$() {
    }

    static {
        MODULE$ = new QueueUtil$();
        MinDurationMs = 60000L;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(QueueUtil$.class);
    }

    public long MinDurationMs() {
        return MinDurationMs;
    }

    public String getJobType(Json params, String string) {
        return (String)params.hcursor().downField("elx-jobType").as(Decoder$.MODULE$.decodeString()).toOption().getOrElse(() -> QueueUtil$.getJobType$$anonfun$1(string));
    }

    public int getJobPriority(Json params) {
        ACursor hc = params.hcursor().downField("elx-jobPriority");
        return BoxesRunTime.unboxToInt((Object)hc.as(Decoder$.MODULE$.decodeInt()).toOption().orElse(() -> QueueUtil$.getJobPriority$$anonfun$1(hc)).getOrElse(QueueUtil$::getJobPriority$$anonfun$2));
    }

    public Option<Object> getRunAfter(Json params) {
        return params.hcursor().downField("elx-jobRunAfter").focus().flatMap((Function1 & Serializable)json -> MODULE$.getRunAfterField((Json)json));
    }

    public Option<Object> getRunAfterField(Json json) {
        return (Option)json.fold(QueueUtil$::getRunAfterField$$anonfun$1, (Function1 & Serializable)_$2 -> QueueUtil$.getRunAfterField$$anonfun$2(BoxesRunTime.unboxToBoolean((Object)_$2)), (Function1 & Serializable)num -> num.toLong(), (Function1 & Serializable)s -> StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(s)).orElse(() -> QueueUtil$.getRunAfterField$$anonfun$4$$anonfun$1(s)), (Function1 & Serializable)_$3 -> None$.MODULE$, (Function1 & Serializable)obj -> JsonLens$.MODULE$.DateTimeLongExtractor().getOption(obj));
    }

    public Option<Object> getOptWaitTimeoutMs(Document req) {
        Option option = req.get("parameters", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString ps = (BsonString)bsonValue;
                return this.getWaitTimeoutMsFromString(req, ps);
            }
            if (bsonValue instanceof BsonDocument) {
                return this.getWaitTimeoutMsFromObject(req);
            }
        }
        return None$.MODULE$;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Option<Object> getWaitTimeoutMsFromObject(Document req) {
        None$ none$;
        BsonDocument doc = req.toBsonDocument();
        Option option = this.a$1(doc).orElse(() -> this.getWaitTimeoutMsFromObject$$anonfun$1(doc)).orElse(() -> this.getWaitTimeoutMsFromObject$$anonfun$2(req));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString vSecs = (BsonString)bsonValue;
                none$ = StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(vSecs.getValue())).map((Function1)(JFunction1.mcJJ.sp & Serializable)_$4 -> _$4 * 1000L);
                return none$.map((Function1)(JFunction1.mcJJ.sp & Serializable)_$5 -> Math.max(_$5, MODULE$.MinDurationMs()));
            }
            if (bsonValue instanceof BsonInt32) {
                BsonInt32 vSecs = (BsonInt32)bsonValue;
                none$ = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)((long)vSecs.getValue() * 1000L)));
                return none$.map((Function1)(JFunction1.mcJJ.sp & Serializable)_$5 -> Math.max(_$5, MODULE$.MinDurationMs()));
            }
            if (bsonValue instanceof BsonInt64) {
                BsonInt64 vSecs = (BsonInt64)bsonValue;
                none$ = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(vSecs.getValue() * 1000L)));
                return none$.map((Function1)(JFunction1.mcJJ.sp & Serializable)_$5 -> Math.max(_$5, MODULE$.MinDurationMs()));
            }
        }
        none$ = None$.MODULE$;
        return none$.map((Function1)(JFunction1.mcJJ.sp & Serializable)_$5 -> Math.max(_$5, MODULE$.MinDurationMs()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public Option<Object> getWaitTimeoutMsFromString(Document req, BsonString ps) {
        None$ none$;
        BsonDocument doc = BsonDocument$.MODULE$.apply(ps.getValue());
        Option option = this.a$2(doc).orElse(() -> this.getWaitTimeoutMsFromString$$anonfun$1(doc)).orElse(() -> this.getWaitTimeoutMsFromString$$anonfun$2(req));
        if (option instanceof Some) {
            BsonValue bsonValue = (BsonValue)((Some)option).value();
            if (bsonValue instanceof BsonString) {
                BsonString vSecs = (BsonString)bsonValue;
                none$ = StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString(vSecs.getValue())).map((Function1)(JFunction1.mcJJ.sp & Serializable)_$6 -> _$6 * 1000L);
                return none$.map((Function1)(JFunction1.mcJJ.sp & Serializable)_$7 -> Math.max(_$7, MODULE$.MinDurationMs()));
            }
            if (bsonValue instanceof BsonInt32) {
                BsonInt32 vSecs = (BsonInt32)bsonValue;
                none$ = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)((long)vSecs.getValue() * 1000L)));
                return none$.map((Function1)(JFunction1.mcJJ.sp & Serializable)_$7 -> Math.max(_$7, MODULE$.MinDurationMs()));
            }
            if (bsonValue instanceof BsonInt64) {
                BsonInt64 vSecs = (BsonInt64)bsonValue;
                none$ = Some$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)(vSecs.getValue() * 1000L)));
                return none$.map((Function1)(JFunction1.mcJJ.sp & Serializable)_$7 -> Math.max(_$7, MODULE$.MinDurationMs()));
            }
        }
        none$ = None$.MODULE$;
        return none$.map((Function1)(JFunction1.mcJJ.sp & Serializable)_$7 -> Math.max(_$7, MODULE$.MinDurationMs()));
    }

    public long getWaitTimeoutMs(Document req, long defaultTimeout) {
        return BoxesRunTime.unboxToLong((Object)this.getOptWaitTimeoutMs(req).getOrElse(() -> QueueUtil$.getWaitTimeoutMs$$anonfun$1(defaultTimeout)));
    }

    public FiniteDuration getDuration(long mills) {
        return FiniteDuration$.MODULE$.apply(Math.max(this.MinDurationMs(), mills), package$.MODULE$.MILLISECONDS());
    }

    public int getPriority(Document req) {
        return BoxesRunTime.unboxToInt((Object)req.get("jobPriority", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonInt32.class)).map((Function1 & Serializable)_$8 -> _$8.getValue()).getOrElse(QueueUtil$::getPriority$$anonfun$2));
    }

    public boolean isRunAfter(Document req) {
        Option<Object> option = this.getRunAfter(req);
        if (option instanceof Some) {
            long v = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            return v > System.currentTimeMillis();
        }
        if (None$.MODULE$.equals(option)) {
            return false;
        }
        throw new MatchError(option);
    }

    public Option<Object> getRunAfter(Document req) {
        return req.get("runAfter", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonDateTime.class)).map((Function1 & Serializable)_$9 -> _$9.getValue());
    }

    public long calculateWaitTimeOutTs(Document req) {
        long waitTimeoutMs = this.getWaitTimeoutMs(req);
        Option<Object> option = this.getRunAfter(req);
        if (option instanceof Some) {
            long v = BoxesRunTime.unboxToLong((Object)((Some)option).value());
            return v + waitTimeoutMs;
        }
        if (None$.MODULE$.equals(option)) {
            return System.currentTimeMillis() + waitTimeoutMs;
        }
        throw new MatchError(option);
    }

    public long getWaitTimeoutMs(Document req) {
        return this.getWaitTimeoutMs(req, QueueManager$.MODULE$.waitTimeoutMs());
    }

    private static final String getJobType$$anonfun$1(String default$1) {
        return default$1;
    }

    private static final Option getJobPriority$$anonfun$1(ACursor hc$1) {
        return hc$1.as(Decoder$.MODULE$.decodeString()).toOption().flatMap((Function1 & Serializable)_$1 -> StringOps$.MODULE$.toIntOption$extension(Predef$.MODULE$.augmentString(_$1)));
    }

    private static final int getJobPriority$$anonfun$2() {
        return QueueManager$.MODULE$.DefaultPriority();
    }

    private static final Option getRunAfterField$$anonfun$1() {
        return None$.MODULE$;
    }

    private static final /* synthetic */ Option getRunAfterField$$anonfun$2(boolean _$2) {
        return None$.MODULE$;
    }

    private static final Option getRunAfterField$$anonfun$4$$anonfun$1(String s$1) {
        return Iso8601$.MODULE$.parse(s$1);
    }

    private final Option a$1(BsonDocument doc$1) {
        return BsonETL$.MODULE$.get((BsonValue)doc$1, (List)new .colon.colon((Object)"parameters", (List)new .colon.colon((Object)"elx.wait.timeout", (List)Nil$.MODULE$)));
    }

    private final Option b$1(BsonDocument doc$2) {
        return BsonETL$.MODULE$.get((BsonValue)doc$2, (List)new .colon.colon((Object)"parameters", (List)new .colon.colon((Object)"elx-wait-timeout", (List)Nil$.MODULE$)));
    }

    private final Option c$1(Document req$1) {
        return req$1.get("elx-wait-timeout", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
    }

    private final Option getWaitTimeoutMsFromObject$$anonfun$1(BsonDocument doc$5) {
        return this.b$1(doc$5);
    }

    private final Option getWaitTimeoutMsFromObject$$anonfun$2(Document req$3) {
        return this.c$1(req$3);
    }

    private final Option a$2(BsonDocument doc$3) {
        return Option$.MODULE$.apply((Object)doc$3.get((Object)"elx.wait.timeout"));
    }

    private final Option b$2(BsonDocument doc$4) {
        return Option$.MODULE$.apply((Object)doc$4.get((Object)"elx-wait-timeout"));
    }

    private final Option c$2(Document req$2) {
        return req$2.get("elx-wait-timeout", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(BsonValue.class));
    }

    private final Option getWaitTimeoutMsFromString$$anonfun$1(BsonDocument doc$6) {
        return this.b$2(doc$6);
    }

    private final Option getWaitTimeoutMsFromString$$anonfun$2(Document req$4) {
        return this.c$2(req$4);
    }

    private static final long getWaitTimeoutMs$$anonfun$1(long defaultTimeout$1) {
        return defaultTimeout$1;
    }

    private static final int getPriority$$anonfun$2() {
        return QueueManager$.MODULE$.DefaultPriority();
    }
}

