/*
 * Decompiled with CFR 0.152.
 */
package ambience.queue.overflow;

import ambience.chunk.ChunkAPI;
import ambience.chunk.ChunkAPI$ChunkId$;
import ambience.queue.overflow.JobOverflowChunkDB;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.memory.EncryptAtRest$;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class MyRepertoireChunkDB
implements JobOverflowChunkDB,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MyRepertoireChunkDB.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final long expiryMs;
    private final File tmpRoot;
    private final File tmpDir;

    public MyRepertoireChunkDB(long expiryMs) {
        this.expiryMs = expiryMs;
        this.tmpRoot = new File(System.getProperty("java.io.tmpdir"));
        this.tmpDir = new File(this.tmpRoot(), "RepertoireChunkDB");
        this.tmpDir().mkdirs();
        this.cleanup();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public File tmpRoot() {
        return this.tmpRoot;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    @Override
    public Task<BoxedUnit> readToOutputStream(List<ChunkAPI.ChunkId> chunkIds, OutputStream os) {
        return Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.readToOutputStream$$anonfun$1(chunkIds, os);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public Task<List<ChunkAPI.ChunkId>> writeBytes(byte[] bytes) {
        this.cleanup();
        String chunkId = ChunkAPI$ChunkId$.MODULE$.apply(UUID.randomUUID().toString());
        File file = new File(this.tmpDir(), chunkId);
        Files.write(file.toPath(), EncryptAtRest$.MODULE$.encrypt(bytes), new OpenOption[0]);
        this.log().info(() -> MyRepertoireChunkDB.writeBytes$$anonfun$1(bytes, chunkId), Line$.MODULE$.apply(35), FullName$.MODULE$.apply("ambience.queue.overflow.MyRepertoireChunkDB.writeBytes"));
        return Task$.MODULE$.apply(() -> MyRepertoireChunkDB.writeBytes$$anonfun$2(chunkId));
    }

    @Override
    public Task<DataBytes> readDataBytes(List<ChunkAPI.ChunkId> chunkIds) {
        this.cleanup();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        return this.readToOutputStream(chunkIds, baos).map((Function1 & Serializable)_$1 -> DataBytes$.MODULE$.apply(baos.toByteArray()));
    }

    @Override
    public Task<List<ChunkAPI.ChunkId>> writeDataBytes(DataBytes db) {
        this.cleanup();
        return DataBytes$.MODULE$.toFullT(db).flatMap((Function1 & Serializable)full -> this.writeBytes(full.bytes()));
    }

    public void cleanup() {
        long cutoff = System.currentTimeMillis() - this.expiryMs;
        List files = Predef$.MODULE$.wrapRefArray((Object[])Option$.MODULE$.apply((Object)this.tmpDir().listFiles()).getOrElse(MyRepertoireChunkDB::$anonfun$1)).toList();
        IntRef count = IntRef.create((int)0);
        LongRef sum = LongRef.create((long)0L);
        files.foreach((Function1)(JProcedure1 & Serializable)file -> {
            if (file.lastModified() < cutoff) {
                ++count$1.elem;
                sum$1.elem += file.length();
                file.delete();
                return;
            }
        });
        if (count.elem > 0) {
            this.log().info(() -> MyRepertoireChunkDB.cleanup$$anonfun$2(sum, count), Line$.MODULE$.apply(63), FullName$.MODULE$.apply("ambience.queue.overflow.MyRepertoireChunkDB.cleanup"));
            return;
        }
    }

    private static final Object readToOutputStream$$anonfun$1$$anonfun$1$$anonfun$1(String chunkId$1) {
        return "Chunk " + new ChunkAPI.ChunkId(chunkId$1) + " not found";
    }

    private final /* synthetic */ void readToOutputStream$$anonfun$1$$anonfun$1(OutputStream os$2, String chunkId) {
        File file = new File(this.tmpDir(), chunkId);
        if (file.exists()) {
            byte[] bytes = EncryptAtRest$.MODULE$.decrypt(Files.readAllBytes(file.toPath()));
            os$2.write(bytes);
            return;
        }
        this.log().warn(() -> MyRepertoireChunkDB.readToOutputStream$$anonfun$1$$anonfun$1$$anonfun$1(chunkId), Line$.MODULE$.apply(26), FullName$.MODULE$.apply("ambience.queue.overflow.MyRepertoireChunkDB.readToOutputStream"));
    }

    private final void readToOutputStream$$anonfun$1(List chunkIds$1, OutputStream os$1) {
        this.cleanup();
        chunkIds$1.foreach((Function1 & Serializable)v1 -> {
            this.readToOutputStream$$anonfun$1$$anonfun$1(os$1, v1 == null ? null : ((ChunkAPI.ChunkId)v1).value());
            return BoxedUnit.UNIT;
        });
    }

    private static final Object writeBytes$$anonfun$1(byte[] bytes$1, String chunkId$2) {
        return "Stored " + bytes$1.length + " bytes as " + new ChunkAPI.ChunkId(chunkId$2);
    }

    private static final List writeBytes$$anonfun$2(String chunkId$3) {
        return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new ChunkAPI.ChunkId[]{new ChunkAPI.ChunkId(chunkId$3)}));
    }

    private static final File[] $anonfun$1() {
        return (File[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class));
    }

    private static final Object cleanup$$anonfun$2(LongRef sum$2, IntRef count$2) {
        return "Cleaned " + sum$2.elem + " bytes in " + count$2.elem + " entries";
    }
}

