/*
 * Decompiled with CFR 0.152.
 */
package ambience.session;

import ambience.agenda.AmbienceAgenda;
import ambience.framework.AdminCollections$;
import ambience.module.ProjectConfig;
import ambience.module.UserDB;
import ambience.module.UserDB$RoleIdName$;
import ambience.module.UserDB$User$;
import ambience.session.SessionManager;
import ambience.session.SessionManager$;
import ambience.session.SessionManager$SessionId$;
import ambience.sso.client.ClientModel;
import ambience.util.ONConverter$;
import com.elixirtech.arch.Clock;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.codex.CodexCollection;
import com.elixirtech.codex.CodexDB;
import com.elixirtech.codex.CodexFilter;
import com.elixirtech.codex.CodexUpdate;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.Json;
import io.circe.derivation.Configuration$;
import io.circe.derivation.ConfiguredDecoder$;
import io.circe.derivation.ConfiguredEncoder$;
import io.circe.derivation.Default$;
import io.circe.export.Exported$;
import io.circe.syntax.package;
import io.circe.syntax.package$;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import org.bson.BsonDateTime;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonDateTime$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some$;
import scala.Tuple3$;
import scala.Tuple6$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class CodexSessionManager
implements SessionManager,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CodexSessionManager.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final Clock clock;
    private final ProjectConfig projectConfig;
    private final AmbienceAgenda agenda;
    private final Scheduler exeCxt;
    private final Task sessionsT;
    private final boolean enforceSingleSession;

    public CodexSessionManager(Clock clock, ProjectConfig projectConfig, CodexDB codexDB, AmbienceAgenda agenda) {
        this.clock = clock;
        this.projectConfig = projectConfig;
        this.agenda = agenda;
        this.exeCxt = Scheduler$.MODULE$.global();
        this.sessionsT = codexDB.getCodexCollection("Sessions").memoize();
        this.enforceSingleSession = projectConfig.WebEnforceSingleSession();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Clock clock() {
        return this.clock;
    }

    public AmbienceAgenda agenda() {
        return this.agenda;
    }

    public Scheduler exeCxt() {
        return this.exeCxt;
    }

    public Task<CodexCollection> sessionsT() {
        return this.sessionsT;
    }

    public boolean enforceSingleSession() {
        return this.enforceSingleSession;
    }

    @Override
    public Task<SessionManager.SessionId> createSession(ClientModel.RequestInfo requestInfo, UserDB.User user) {
        Task task;
        String uuid = UUID.randomUUID().toString();
        if (this.enforceSingleSession()) {
            CodexFilter.Eq thisUser = CodexFilter.Eq$.MODULE$.apply("id", (BsonValue)BsonString$.MODULE$.apply(user.id()));
            CodexUpdate.Set expireNow = CodexUpdate.Set$.MODULE$.apply("expiresAt", (BsonValue)BsonDateTime$.MODULE$.apply(this.clock().now()));
            CodexUpdate.Set forcedClose = CodexUpdate.Set$.MODULE$.apply("forcedExpiryBy", (BsonValue)BsonString$.MODULE$.apply(uuid));
            CodexUpdate.Combine updates = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{expireNow, forcedClose}));
            task = this.sessionsT().flatMap((Function1 & Serializable)_$1 -> _$1.updateManyT((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{thisUser, this.laterThanNow()})), (CodexUpdate)updates).map((Function1)(JProcedure1 & Serializable)reply -> {
                if (reply.getModifiedCount() > 0L) {
                    this.log().info(() -> CodexSessionManager.$anonfun$1$$anonfun$1$$anonfun$1(user), Line$.MODULE$.apply(45), FullName$.MODULE$.apply("ambience.session.CodexSessionManager.fr"));
                    return;
                }
            }));
        } else {
            task = Task$.MODULE$.unit();
        }
        Task fr = task;
        BsonDateTime now = BsonDateTime$.MODULE$.apply(this.clock().now());
        UserDB.User user2 = (UserDB.User)package$.MODULE$.EncoderOps((Object)user);
        String string = "id";
        String string2 = "name";
        String string3 = "email";
        String string4 = "roles";
        String string5 = "privileges";
        String string6 = "enabled";
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[5];
        String string7 = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string7, (Object)BsonString$.MODULE$.apply(uuid)), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string8 = (String)Predef$.MODULE$.ArrowAssoc((Object)"clientIP");
        objectArray[1] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string8, (Object)BsonString$.MODULE$.apply((String)requestInfo.peerIP().getOrElse(CodexSessionManager::$anonfun$4))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string9 = (String)Predef$.MODULE$.ArrowAssoc((Object)"requestIP");
        objectArray[2] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string9, (Object)BsonString$.MODULE$.apply(requestInfo.requestIP())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string10 = (String)Predef$.MODULE$.ArrowAssoc((Object)"createdAt");
        objectArray[3] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string10, (Object)now), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        String string11 = (String)Predef$.MODULE$.ArrowAssoc((Object)"expiresAt");
        objectArray[4] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string11, (Object)BsonDateTime$.MODULE$.apply(this.expiresAt())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        Document sessionDoc = (Document)Document$.MODULE$.apply(package.EncoderOps$.MODULE$.asJson$extension((Object)user2, Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(CodexSessionManager::$anonfun$2, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default())))).noSpaces()).updated((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        return fr.flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return this.sessionsT().flatMap((Function1 & Serializable)sessions -> sessions.insertOneT(sessionDoc).flatMap((Function1 & Serializable)x$12 -> {
                CodexDB.InsertOneResult insertOneResult = x$12;
                return this.updateLastLogin(user, now).map((Function1 & Serializable)x$1 -> new SessionManager.SessionId(CodexSessionManager.createSession$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(uuid, x$1)));
            }));
        });
    }

    public Task<BoxedUnit> updateLastLogin(UserDB.User user, BsonDateTime now) {
        return AdminCollections$.MODULE$.usersT().flatMap((Function1 & Serializable)_$2 -> _$2.updateOneT((CodexFilter)CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonObjectId$.MODULE$.apply(user.id())), (CodexUpdate)CodexUpdate.Set$.MODULE$.apply("lastLogin", (BsonValue)now)).map((Function1)(JProcedure1 & Serializable)_$3 -> {}));
    }

    @Override
    public Task<Option<UserDB.User>> getSession(String sid) {
        return this.sessionsT().flatMap((Function1 & Serializable)_$4 -> _$4.findO((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{this.withId(sid), this.laterThanNow()}))).firstOptionL().map((Function1 & Serializable)optDoc -> optDoc.flatMap((Function1 & Serializable)doc -> {
            Json json = ONConverter$.MODULE$.bsonToRelaxedJson((Document)doc);
            String string = "id";
            String string2 = "name";
            String string3 = "email";
            String string4 = "roles";
            String string5 = "privileges";
            String string6 = "enabled";
            int size = 6;
            Either either = json.as(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("User", CodexSessionManager::getSession$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1, scala.package$.MODULE$.Nil().$colon$colon((Object)string6).$colon$colon((Object)string5).$colon$colon((Object)string4).$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), CodexSessionManager::getSession$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(CodexSessionManager::getSession$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3)))));
            if (either instanceof Right) {
                UserDB.User user = (UserDB.User)((Right)either).value();
                return Some$.MODULE$.apply((Object)user);
            }
            if (either instanceof Left) {
                DecodingFailure err = (DecodingFailure)((Left)either).value();
                this.log().warn(() -> CodexSessionManager.getSession$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$4(json, err), Line$.MODULE$.apply(79), FullName$.MODULE$.apply("ambience.session.CodexSessionManager.getSession"));
                return None$.MODULE$;
            }
            throw new MatchError((Object)either);
        })));
    }

    @Override
    public Task<List<SessionManager.SessionInfo>> getCurrentSessions(UserDB.User user) {
        CodexFilter.Eq withId = CodexFilter.Eq$.MODULE$.apply("id", (BsonValue)BsonString$.MODULE$.apply(user.id()));
        CodexFilter.Gt laterThanNow = CodexFilter.Gt$.MODULE$.apply("expiresAt", (BsonValue)BsonDateTime$.MODULE$.apply(System.currentTimeMillis()));
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{withId, laterThanNow}));
        return this.sessionsT().flatMap((Function1 & Serializable)_$5 -> _$5.findO((CodexFilter)filter).flatMap((Function1 & Serializable)doc -> SessionManager$.MODULE$.toSessionInfo((Document)doc)).toListL());
    }

    @Override
    public Task<Object> bumpSession(String sid) {
        long newTime = this.expiresAt();
        CodexUpdate.Set bump = CodexUpdate.Set$.MODULE$.apply("expiresAt", (BsonValue)BsonDateTime$.MODULE$.apply(newTime));
        Task ret = this.sessionsT().flatMap((Function1 & Serializable)_$6 -> _$6.updateOneT((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{this.withId(sid), this.laterThanNow()})), (CodexUpdate)bump).map((Function1 & Serializable)_$7 -> _$7.getModifiedCount() == 1L));
        return ret.map((Function1 & Serializable)b -> CodexSessionManager.bumpSession$$anonfun$1(newTime, BoxesRunTime.unboxToBoolean((Object)b)));
    }

    @Override
    public Task<BoxedUnit> logout(String sid) {
        CodexUpdate.CurrentTimestamp reset = CodexUpdate.CurrentTimestamp$.MODULE$.apply("expiresAt");
        return this.sessionsT().flatMap((Function1 & Serializable)_$8 -> _$8.updateOneT((CodexFilter)CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{this.withId(sid), this.laterThanNow()})), (CodexUpdate)reset).map((Function1)(JProcedure1 & Serializable)_$9 -> {}));
    }

    @Override
    public Task<BoxedUnit> deleteSession(String sid) {
        return this.sessionsT().flatMap((Function1 & Serializable)_$10 -> _$10.deleteOneT(this.withId(sid)).map((Function1)(JProcedure1 & Serializable)_$11 -> {}));
    }

    @Override
    public Task<Object> getActiveSessionCount() {
        return this.sessionsT().flatMap((Function1 & Serializable)_$12 -> _$12.countDocumentsT(this.laterThanNow()).map((Function1)(JFunction1.mcIJ.sp & Serializable)_$13 -> (int)_$13));
    }

    @Override
    public Task<BoxedUnit> endUserSessions(UserDB.User user, List<SessionManager.SessionId> list) {
        CodexFilter.Eq withUser = CodexFilter.Eq$.MODULE$.apply("id", (BsonValue)BsonString$.MODULE$.apply(user.id()));
        CodexFilter.In withList = CodexFilter.In$.MODULE$.apply("_id", list.map((Function1 & Serializable)id -> BsonString$.MODULE$.apply(id == null ? null : ((SessionManager.SessionId)id).value())).toSet());
        CodexFilter.And filter = CodexFilter.And$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexFilter[]{withUser, withList}));
        CodexUpdate.Set expireNow = CodexUpdate.Set$.MODULE$.apply("expiresAt", (BsonValue)BsonDateTime$.MODULE$.apply(System.currentTimeMillis()));
        CodexUpdate.Set forcedClose = CodexUpdate.Set$.MODULE$.apply("forcedExpiryBy", (BsonValue)BsonString$.MODULE$.apply("user request"));
        CodexUpdate.Combine updates = CodexUpdate.Combine$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodexUpdate[]{expireNow, forcedClose}));
        return this.sessionsT().flatMap((Function1 & Serializable)_$14 -> _$14.updateManyT((CodexFilter)filter, (CodexUpdate)updates)).void();
    }

    private CodexFilter withId(String sid) {
        return CodexFilter.Eq$.MODULE$.apply("_id", (BsonValue)BsonString$.MODULE$.apply(sid));
    }

    private long expiresAt() {
        return this.clock().now() + this.projectConfig.WebSessionTimeout();
    }

    private CodexFilter laterThanNow() {
        return CodexFilter.Gt$.MODULE$.apply("expiresAt", (BsonValue)BsonDateTime$.MODULE$.apply(this.clock().now()));
    }

    private static final Object $anonfun$1$$anonfun$1$$anonfun$1(UserDB.User user$3) {
        return "Enforcing single session for " + user$3.name() + " by terminating existing sessions";
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$3() {
        Encoder encodeA;
        void var3_2;
        void var1;
        Encoder encodeA2 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA3 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA = Encoder$.MODULE$.encodeBoolean();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$2() {
        Encoder encodeA;
        Encoder.AsArray encodeA2;
        Encoder.AsArray encodeA3;
        Encoder encodeA4;
        void var3_2;
        void var1;
        Encoder encodeA5 = Encoder$.MODULE$.encodeString();
        void var0_1 = var1;
        Encoder encodeA6 = Encoder$.MODULE$.encodeString();
        void var2_3 = var3_2;
        Encoder encoder = encodeA4 = Encoder$.MODULE$.encodeString();
        String string = "id";
        String string2 = "name";
        String string3 = "enabled";
        Encoder.AsArray asArray = encodeA3 = Encoder$.MODULE$.encodeSet(Encoder$.MODULE$.importedEncoder((Encoder)Exported$.MODULE$.apply((Object)ConfiguredEncoder$.MODULE$.inline$ofProduct(CodexSessionManager::$anonfun$3, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), Configuration$.MODULE$.default()))));
        Encoder.AsArray asArray2 = encodeA2 = Encoder$.MODULE$.encodeSet(Encoder$.MODULE$.encodeString());
        Encoder encoder2 = encodeA = Encoder$.MODULE$.encodeBoolean();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)encoder2).$colon$colon((Object)asArray2).$colon$colon((Object)asArray).$colon$colon((Object)encoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final String $anonfun$4() {
        return "";
    }

    private static final /* synthetic */ String createSession$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(String uuid$4, BoxedUnit x$1) {
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        return SessionManager$SessionId$.MODULE$.apply(uuid$4);
    }

    /*
     * WARNING - void declaration
     */
    private static final List $anonfun$5() {
        Decoder decodeA;
        void var3_2;
        void var1;
        Decoder decodeA2 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA3 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA = Decoder$.MODULE$.decodeBoolean();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 $anonfun$6() {
        UserDB$RoleIdName$ userDB$RoleIdName$ = UserDB$RoleIdName$.MODULE$;
        return (Function1 & Serializable)p -> (UserDB.RoleIdName)userDB$RoleIdName$.fromProduct((Product)p);
    }

    private static final Product $anonfun$7() {
        return Tuple3$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getSession$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1() {
        Decoder decodeA;
        Decoder decodeA2;
        Decoder decodeA3;
        Decoder decodeA4;
        void var3_2;
        void var1;
        Decoder decodeA5 = Decoder$.MODULE$.decodeString();
        void var0_1 = var1;
        Decoder decodeA6 = Decoder$.MODULE$.decodeString();
        void var2_3 = var3_2;
        Decoder decoder = decodeA4 = Decoder$.MODULE$.decodeString();
        String string = "id";
        String string2 = "name";
        String string3 = "enabled";
        int size = 3;
        Decoder decoder2 = decodeA3 = Decoder$.MODULE$.decodeSet(Decoder$.MODULE$.importedDecoder((Decoder)Exported$.MODULE$.apply((Object)ConfiguredDecoder$.MODULE$.inline$ofProduct("RoleIdName", CodexSessionManager::$anonfun$5, scala.package$.MODULE$.Nil().$colon$colon((Object)string3).$colon$colon((Object)string2).$colon$colon((Object)string), CodexSessionManager::$anonfun$6, Configuration$.MODULE$.default(), Default$.MODULE$.inline$of(CodexSessionManager::$anonfun$7)))));
        Decoder decoder3 = decodeA2 = Decoder$.MODULE$.decodeSet(Decoder$.MODULE$.decodeString());
        Decoder decoder4 = decodeA = Decoder$.MODULE$.decodeBoolean();
        return scala.package$.MODULE$.Nil().$colon$colon((Object)decoder4).$colon$colon((Object)decoder3).$colon$colon((Object)decoder2).$colon$colon((Object)decoder).$colon$colon((Object)var2_3).$colon$colon((Object)var0_1);
    }

    private static final Function1 getSession$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$2() {
        UserDB$User$ userDB$User$ = UserDB$User$.MODULE$;
        return (Function1 & Serializable)p -> (UserDB.User)userDB$User$.fromProduct((Product)p);
    }

    private static final Product getSession$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$3() {
        return Tuple6$.MODULE$.apply((Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$, (Object)None$.MODULE$);
    }

    private static final Object getSession$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$4(Json json$1, DecodingFailure err$1) {
        return "Cant parse session data " + json$1.noSpaces() + ": " + err$1;
    }

    private static final /* synthetic */ long bumpSession$$anonfun$1(long newTime$1, boolean b) {
        if (b) {
            return newTime$1;
        }
        return 0L;
    }
}

