/*
 * Decompiled with CFR 0.152.
 */
package ambience.ud;

import ambience.codex.BulkDownload;
import ambience.codex.BulkDownload$;
import ambience.module.UserDB;
import ambience.ud.UDBulkDownload$;
import ambience.ud.UDBulkDownload$Info$;
import ambience.ud.store.Store$;
import better.files.File;
import better.files.File$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.FileDataBytes$;
import com.elixirtech.arch.MimeInfo$;
import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeType$;
import com.elixirtech.arch.MimeTypes$;
import com.elixirtech.arch.Path;
import com.elixirtech.arch.Path$;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class UDBulkDownload {
    public static String ElxMetaJSON() {
        return UDBulkDownload$.MODULE$.ElxMetaJSON();
    }

    public static Task<BulkDownload.Result> apply(UserDB.User user, String string, Set<BsonValue> set) {
        return UDBulkDownload$.MODULE$.apply(user, string, set);
    }

    public static Task<BulkDownload.Intermediate> build(UserDB.User user, List<Tuple2<Info, Json>> list) {
        return UDBulkDownload$.MODULE$.build(user, list);
    }

    public static String buildZipFilename(String string) {
        return UDBulkDownload$.MODULE$.buildZipFilename(string);
    }

    public static String nameField() {
        return UDBulkDownload$.MODULE$.nameField();
    }

    public static class Builder {
        private final UserDB.User user;
        private final File tmpDir;
        private final File zipFile;
        private final File outFolder;

        public Builder(UserDB.User user) {
            this.user = user;
            String string = File$.MODULE$.newTemporaryDirectory$default$1();
            Option option = File$.MODULE$.newTemporaryDirectory$default$2();
            this.tmpDir = File$.MODULE$.newTemporaryDirectory(string, option, File$.MODULE$.newTemporaryDirectory$default$3(string, option));
            boolean bl = this.tmpDir().createChild$default$3();
            this.zipFile = this.tmpDir().createChild("bulk.zip", false, bl, this.tmpDir().createChild$default$4("bulk.zip", false, bl), this.tmpDir().createChild$default$5("bulk.zip", false, bl));
            boolean bl2 = this.tmpDir().createChild$default$3();
            this.outFolder = this.tmpDir().createChild("root", true, bl2, this.tmpDir().createChild$default$4("root", true, bl2), this.tmpDir().createChild$default$5("root", true, bl2));
        }

        public File tmpDir() {
            return this.tmpDir;
        }

        public File zipFile() {
            return this.zipFile;
        }

        public File outFolder() {
            return this.outFolder;
        }

        public Task<BulkDownload.Intermediate> run(List<Tuple2<Info, Json>> list) {
            List tasks = list.map((Function1 & Serializable)info -> this.exportInfo((Tuple2<Info, Json>)info));
            this.createMetainfo(list);
            return Task$.MODULE$.now((Object)BoxedUnit.UNIT).$greater$greater(() -> this.run$$anonfun$1(tasks));
        }

        public Task<String> exportInfo(Tuple2<Info, Json> info) {
            File file = this.outFolder().$div(this.safe(((Info)info._1()).category())).$div(this.getFileName$1(info));
            File file2 = file.createFileIfNotExists(true, file.createFileIfNotExists$default$2(true), file.createFileIfNotExists$default$3(true));
            return Store$.MODULE$.apply().read(this.user, (Json)info._2()).flatMap(arg_0 -> UDBulkDownload$.ambience$ud$UDBulkDownload$Builder$$_$exportInfo$$anonfun$1(file2, info, arg_0));
        }

        public void createMetainfo(List<Tuple2<Info, Json>> info) {
            File file = this.outFolder().$div(UDBulkDownload$.MODULE$.ElxMetaJSON());
            File file2 = file.createFileIfNotExists(true, file.createFileIfNotExists$default$2(true), file.createFileIfNotExists$default$3(true));
            String str = info.map(UDBulkDownload$::ambience$ud$UDBulkDownload$Builder$$_$_$$anonfun$3).mkString("[", ",", "]");
            file2.write(str, file2.write$default$2(str), file2.write$default$3(str));
        }

        public String safe(String fullName) {
            return fullName.replace("\\", "_").replace("/", "_").replace(":", "_");
        }

        public void dispose() {
            BulkDownload$.MODULE$.log().info(this::dispose$$anonfun$1, Line$.MODULE$.apply(124), FullName$.MODULE$.apply("ambience.ud.UDBulkDownload.Builder.dispose"));
            this.tmpDir().delete(this.tmpDir().delete$default$1(), this.tmpDir().delete$default$2());
        }

        private final Task run$$anonfun$1(List tasks$1) {
            return Task$.MODULE$.sequence((Iterable)tasks$1, BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)names -> {
                int n = this.outFolder().zipTo$default$2();
                this.outFolder().zipTo(this.zipFile(), n, this.outFolder().zipTo$default$3(this.zipFile(), n));
                return BulkDownload.Intermediate$.MODULE$.apply(names, (DataBytes)FileDataBytes$.MODULE$.apply(this.zipFile().toJava()));
            });
        }

        private final String getFileName$1(Tuple2 info$1) {
            String n = this.safe(((Info)info$1._1()).name());
            Path p = Path$.MODULE$.apply(n);
            Option option = p.extension();
            if (option instanceof Some) {
                return n;
            }
            if (None$.MODULE$.equals(option)) {
                MimeType mt = ((Info)info$1._1()).contentType().trim().isEmpty() ? MimeTypes$.MODULE$.DEFAULT() : MimeType$.MODULE$.apply(((Info)info$1._1()).contentType());
                return n + "." + MimeInfo$.MODULE$.extension(mt);
            }
            throw new MatchError((Object)option);
        }

        private final Object dispose$$anonfun$1() {
            return "Deleting temporary directory " + this.tmpDir().path();
        }
    }

    public static final class Info
    implements Product,
    Serializable {
        private final String id;
        private final String name;
        private final String category;
        private final String description;
        private final String contentType;
        private final List roles;

        public static Option<Info> apply(Document document) {
            return UDBulkDownload$Info$.MODULE$.apply(document);
        }

        public static Info apply(String string, String string2, String string3, String string4, String string5, List<String> list) {
            return UDBulkDownload$Info$.MODULE$.apply(string, string2, string3, string4, string5, list);
        }

        public static Info fromProduct(Product product) {
            return UDBulkDownload$Info$.MODULE$.fromProduct(product);
        }

        public static Info unapply(Info info) {
            return UDBulkDownload$Info$.MODULE$.unapply(info);
        }

        public Info(String id, String name, String category, String description, String contentType, List<String> roles) {
            this.id = id;
            this.name = name;
            this.category = category;
            this.description = description;
            this.contentType = contentType;
            this.roles = roles;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Info)) return false;
            Info info = (Info)object;
            String string = this.id();
            String string2 = info.id();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.name();
            String string4 = info.name();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.category();
            String string6 = info.category();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.description();
            String string8 = info.description();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.contentType();
            String string10 = info.contentType();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            List<String> list = this.roles();
            List<String> list2 = info.roles();
            if (list == null) {
                if (list2 == null) return true;
                return false;
            } else {
                if (!list.equals(list2)) return false;
                return true;
            }
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Info;
        }

        public int productArity() {
            return 6;
        }

        public String productPrefix() {
            return "Info";
        }

        public Object productElement(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return this._1();
                }
                case 1: {
                    return this._2();
                }
                case 2: {
                    return this._3();
                }
                case 3: {
                    return this._4();
                }
                case 4: {
                    return this._5();
                }
                case 5: {
                    return this._6();
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            switch (n2) {
                case 0: {
                    return "id";
                }
                case 1: {
                    return "name";
                }
                case 2: {
                    return "category";
                }
                case 3: {
                    return "description";
                }
                case 4: {
                    return "contentType";
                }
                case 5: {
                    return "roles";
                }
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String id() {
            return this.id;
        }

        public String name() {
            return this.name;
        }

        public String category() {
            return this.category;
        }

        public String description() {
            return this.description;
        }

        public String contentType() {
            return this.contentType;
        }

        public List<String> roles() {
            return this.roles;
        }

        public Info copy(String id, String name, String category, String description, String contentType, List<String> roles) {
            return new Info(id, name, category, description, contentType, roles);
        }

        public String copy$default$1() {
            return this.id();
        }

        public String copy$default$2() {
            return this.name();
        }

        public String copy$default$3() {
            return this.category();
        }

        public String copy$default$4() {
            return this.description();
        }

        public String copy$default$5() {
            return this.contentType();
        }

        public List<String> copy$default$6() {
            return this.roles();
        }

        public String _1() {
            return this.id();
        }

        public String _2() {
            return this.name();
        }

        public String _3() {
            return this.category();
        }

        public String _4() {
            return this.description();
        }

        public String _5() {
            return this.contentType();
        }

        public List<String> _6() {
            return this.roles();
        }
    }
}

