/*
 * Decompiled with CFR 0.152.
 */
package ambience.ud.store;

import ambience.api.BinaryStore;
import ambience.api.BinaryStore$;
import ambience.arch.EitherTELM;
import ambience.arch.EitherTELM$;
import ambience.format.HumanReadableBytes$;
import ambience.module.UserDB;
import ambience.ud.UDManager;
import ambience.ud.UploadModule;
import ambience.ud.store.BinUploadAPI;
import ambience.ud.store.BinUploadAPI$Access$;
import ambience.ud.store.BinUploadAPI$FileUpload$;
import ambience.ud.store.Store;
import ambience.ud.store.Store$FileInfo$;
import ambience.ud.store.StoreUtil$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.Elixir$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Decoder$;
import io.circe.Json;
import io.circe.Json$;
import io.circe.syntax.package;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonString;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class BinStore
implements LoggingHelper2,
Store {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(BinStore.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final String locationId;

    public BinStore(String locationId) {
        this.locationId = locationId;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Task<Either<LogMessage, Json>> write(UserDB.User user, UDManager manager, UploadModule.UploadInfo info) {
        Json metadata = this.toMetadata(info);
        EitherTELM task = EitherTELM$.MODULE$.apply(this.logInfo(() -> this.$anonfun$1(user, metadata))).flatMap((Function1 & Serializable)x$1 -> {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return EitherTELM$.MODULE$.apply(((BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class))).location(this.locationId).map((Function1 & Serializable)_$1 -> _$1.toRight(this::$anonfun$2$$anonfun$1$$anonfun$1))).flatMap((Function1 & Serializable)location -> EitherTELM$.MODULE$.apply(this.doWrite((BinaryStore.Location)location, metadata, (DataBytes)info.bytes())).flatMap((Function1 & Serializable)uuid -> EitherTELM$.MODULE$.apply(this.logInfo(() -> BinStore.$anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(location, uuid))).map((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return uuid;
            })));
        });
        return task.value().flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                String uuid = (String)((Right)either).value();
                BinUploadAPI.FileUpload fileUpload = (BinUploadAPI.FileUpload)io.circe.syntax.package$.MODULE$.EncoderOps((Object)this.toFileUpload(info, this.locationId, uuid));
                return manager.save(user, package.EncoderOps$.MODULE$.asJson$extension((Object)fileUpload, BinUploadAPI$FileUpload$.MODULE$.encode()));
            }
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                return Task$.MODULE$.apply(() -> BinStore.write$$anonfun$1$$anonfun$1(msg));
            }
            throw new MatchError((Object)either);
        }).onErrorRecover((PartialFunction)new Serializable(this){
            private final /* synthetic */ BinStore $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                if (throwable instanceof BinaryStore.MaxSizeException) {
                    BinaryStore.MaxSizeException ex = (BinaryStore.MaxSizeException)throwable;
                    return true;
                }
                if (throwable != null) {
                    Throwable ex = throwable;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                if (throwable instanceof BinaryStore.MaxSizeException) {
                    BinaryStore.MaxSizeException ex = (BinaryStore.MaxSizeException)throwable;
                    return package$.MODULE$.Left().apply((Object)this.$outer.buildMaxsizeError(ex));
                }
                if (throwable != null) {
                    Throwable ex = throwable;
                    return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("Binary Store upload " + ex.getMessage(), ex));
                }
                return function1.apply((Object)x);
            }
        });
    }

    @Override
    public Task<Either<LogMessage, BoxedUnit>> delete(UserDB.User user, UDManager manager, boolean overwrite, String category, String name) {
        return this.getBinaryStoreId(manager, category, name).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage lm = (LogMessage)((Left)either).value();
                if (overwrite) {
                    return ambience.arch.package$.MODULE$.TRUnit();
                }
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)lm));
            }
            if (either instanceof Right) {
                BinaryStore.Id bId = (BinaryStore.Id)((Right)either).value();
                EitherTELM task = EitherTELM$.MODULE$.apply(((BinaryStore)Elixir$.MODULE$.get(ClassTag$.MODULE$.apply(BinaryStore.class))).location(bId.locationId()).map((Function1 & Serializable)_$2 -> _$2.toRight(this::$anonfun$3$$anonfun$1))).flatMap((Function1 & Serializable)location -> EitherTELM$.MODULE$.apply(manager.permanentDelete(user, category, name)).flatMap((Function1 & Serializable)x$1 -> {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return EitherTELM$.MODULE$.apply(this.logInfo(() -> BinStore.$anonfun$4$$anonfun$1$$anonfun$1(user, bId))).flatMap((Function1 & Serializable)x$12 -> {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return EitherTELM$.MODULE$.apply(this.doDelete((BinaryStore.Location)location, bId.contentId()).map((Function1 & Serializable)x$1 -> {
                            Either either = x$1;
                            if (either instanceof Left) {
                                LogMessage lm = (LogMessage)((Left)either).value();
                                if (overwrite) {
                                    return ambience.arch.package$.MODULE$.RUnit();
                                }
                                return package$.MODULE$.Left().apply((Object)lm);
                            }
                            if (either instanceof Right) {
                                return ambience.arch.package$.MODULE$.RUnit();
                            }
                            throw new MatchError((Object)either);
                        })).map((Function1)(JProcedure1 & Serializable)x$1 -> {
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        });
                    });
                }));
                return task.value();
            }
            throw new MatchError((Object)either);
        }).onErrorRecover((PartialFunction)new Serializable(this){
            private final /* synthetic */ BinStore $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                this.$outer.log().error(() -> BinStore.ambience$ud$store$BinStore$$anon$2$$_$applyOrElse$$anonfun$1(ex), Line$.MODULE$.apply(68), FullName$.MODULE$.apply("ambience.ud.store.BinStore.delete"));
                return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("BinStore  deleting from store " + ex.getMessage(), ex));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$ud$store$BinStore$$anon$2$$_$applyOrElse$$anonfun$1(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    public Task<Either<LogMessage, BinaryStore.Id>> getBinaryStoreId(UDManager manager, String category, String name) {
        return manager.getByCategoryName(category, name).map((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (None$.MODULE$.equals(option)) {
                return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Upload not found with category name " + category + "_" + name));
            }
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                Option option2 = doc.get("contentId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).flatMap((Function1 & Serializable)cid -> doc.get("store", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)store -> BinaryStore.Id$.MODULE$.apply(BinaryStore.LocationId$.MODULE$.apply(store.getValue()), BinaryStore.ContentId$.MODULE$.apply(cid.getValue()))));
                if (option2 instanceof Some) {
                    BinaryStore.Id bId = (BinaryStore.Id)((Some)option2).value();
                    return package$.MODULE$.Right().apply((Object)bId);
                }
                if (None$.MODULE$.equals(option2)) {
                    return package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Problem getting BinaryStoreId " + doc));
                }
                throw new MatchError((Object)option2);
            }
            throw new MatchError((Object)option);
        });
    }

    public LogMessage buildMaxsizeError(BinaryStore.MaxSizeException ex) {
        Object[] split = ex.getMessage().split(" ");
        Object object = Predef$.MODULE$.refArrayOps(split);
        String maxSize = this.toReadable$1(ArrayOps$.MODULE$.lastOption$extension(object));
        Object object2 = Predef$.MODULE$.refArrayOps(split);
        String actual = this.toReadable$1(ArrayOps$.MODULE$.headOption$extension(object2));
        return LogMessage.Error$.MODULE$.apply("<p>Binary Store upload limit " + maxSize + " exceeded. Actual (" + actual + ")</p>");
    }

    private Task<Either<LogMessage, String>> doWrite(BinaryStore.Location location, Json metadata, DataBytes dataBytes) {
        return location.add(BinaryStore.Content$.MODULE$.apply(dataBytes, metadata)).map((Function1 & Serializable)cid -> BinStore.doWrite$$anonfun$1(cid == null ? null : ((BinaryStore.ContentId)cid).value())).onErrorRecover((PartialFunction)new Serializable(location, this){
            private final BinaryStore.Location location$5;
            private final /* synthetic */ BinStore $outer;
            {
                this.location$5 = location$7;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                this.$outer.log().error(() -> this.applyOrElse$$anonfun$2(ex), Line$.MODULE$.apply(97), FullName$.MODULE$.apply("ambience.ud.store.BinStore.doWrite"));
                return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("Error writing to store " + ex.getMessage(), ex));
            }

            private final Object applyOrElse$$anonfun$2(Throwable ex$2) {
                return "Save bytes failed " + this.location$5.id() + ": " + ex$2;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$2(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    private Task<Either<LogMessage, BoxedUnit>> doDelete(BinaryStore.Location location, String contentId) {
        return location.remove(contentId).map((Function1 & Serializable)_$4 -> ambience.arch.package$.MODULE$.RUnit()).onErrorRecover((PartialFunction)new Serializable(location, this){
            private final BinaryStore.Location location$6;
            private final /* synthetic */ BinStore $outer;
            {
                this.location$6 = location$8;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                this.$outer.log().error(() -> this.applyOrElse$$anonfun$3(ex), Line$.MODULE$.apply(104), FullName$.MODULE$.apply("ambience.ud.store.BinStore.doDelete"));
                return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("Error deleting from store " + ex.getMessage(), ex));
            }

            private final Object applyOrElse$$anonfun$3(Throwable ex$3) {
                return "Delete failed " + this.location$6.id() + ": " + ex$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$3(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    private Json toMetadata(UploadModule.UploadInfo info) {
        Object[] objectArray = new Tuple2[6];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"name");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)Json$.MODULE$.fromString(info.name()));
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"description");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)Json$.MODULE$.fromString(info.description()));
        String string3 = (String)Predef$.MODULE$.ArrowAssoc((Object)"category");
        objectArray[2] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string3, (Object)Json$.MODULE$.fromString(info.category()));
        String string4 = (String)Predef$.MODULE$.ArrowAssoc((Object)"filename");
        objectArray[3] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string4, (Object)Json$.MODULE$.fromString(info.filename()));
        String string5 = (String)Predef$.MODULE$.ArrowAssoc((Object)"length");
        objectArray[4] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string5, (Object)Json$.MODULE$.fromLong(info.length()));
        String string6 = (String)Predef$.MODULE$.ArrowAssoc((Object)"contentType");
        objectArray[5] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string6, (Object)Json$.MODULE$.fromString((String)info.optContentType().getOrElse(BinStore::toMetadata$$anonfun$1)));
        return Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
    }

    @Override
    public Task<DataBytes> read(UserDB.User user, Json json) {
        Option<BinaryStore.Id> option = this.getBinaryStoreId(json);
        if (option instanceof Some) {
            BinaryStore.Id bId = (BinaryStore.Id)((Some)option).value();
            return BinaryStore$.MODULE$.get(bId).map((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    BinaryStore.Content content = (BinaryStore.Content)((Some)option).value();
                    return content.bytes();
                }
                if (None$.MODULE$.equals(option)) {
                    this.log().warn(() -> BinStore.read$$anonfun$1$$anonfun$1(bId), Line$.MODULE$.apply(126), FullName$.MODULE$.apply("ambience.ud.store.BinStore.read"));
                    return DataBytes$.MODULE$.empty();
                }
                throw new MatchError((Object)option);
            });
        }
        if (None$.MODULE$.equals(option)) {
            this.log().error(BinStore::read$$anonfun$2, Line$.MODULE$.apply(130), FullName$.MODULE$.apply("ambience.ud.store.BinStore.read"));
            return Task$.MODULE$.now((Object)DataBytes$.MODULE$.empty());
        }
        throw new MatchError(option);
    }

    @Override
    public Task<BoxedUnit> readToOutputStream(Json json, OutputStream os) {
        Option<BinaryStore.Id> option = this.getBinaryStoreId(json);
        if (option instanceof Some) {
            BinaryStore.Id bId = (BinaryStore.Id)((Some)option).value();
            return BinaryStore$.MODULE$.get(bId).map((Function1 & Serializable)x$1 -> {
                Option option = x$1;
                if (option instanceof Some) {
                    BinaryStore.Content content = (BinaryStore.Content)((Some)option).value();
                    return content.bytes().observable().map((Function1)(JProcedure1 & Serializable)bytes -> os.write((byte[])bytes)).completedL();
                }
                if (None$.MODULE$.equals(option)) {
                    this.log().warn(() -> BinStore.readToOutputStream$$anonfun$1$$anonfun$2(bId), Line$.MODULE$.apply(144), FullName$.MODULE$.apply("ambience.ud.store.BinStore.readToOutputStream"));
                    return BoxedUnit.UNIT;
                }
                throw new MatchError((Object)option);
            }).void();
        }
        if (None$.MODULE$.equals(option)) {
            this.log().error(BinStore::readToOutputStream$$anonfun$2, Line$.MODULE$.apply(148), FullName$.MODULE$.apply("ambience.ud.store.BinStore.readToOutputStream"));
            return Task$.MODULE$.unit();
        }
        throw new MatchError(option);
    }

    @Override
    public Option<Store.FileInfo> getFileInfo(Json json) {
        Option<BinaryStore.Id> option = this.getBinaryStoreId(json);
        if (option instanceof Some) {
            BinaryStore.Id bId = (BinaryStore.Id)((Some)option).value();
            return StoreUtil$.MODULE$.getFileName(json).flatMap((Function1 & Serializable)name -> StoreUtil$.MODULE$.getContentType(json).map((Function1 & Serializable)contentType -> Store$FileInfo$.MODULE$.apply((String)name, (String)contentType, StoreUtil$.MODULE$.getDigest(bId.locationId() + "|" + bId.contentId()))));
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    public Option<BinaryStore.Id> getBinaryStoreId(Json json) {
        return this.getStore(json).flatMap((Function1 & Serializable)store -> this.getContentId(json).map((Function1 & Serializable)contentId -> BinaryStore.Id$.MODULE$.apply(BinaryStore.LocationId$.MODULE$.apply(store), BinaryStore.ContentId$.MODULE$.apply(contentId))));
    }

    private BinUploadAPI.FileUpload toFileUpload(UploadModule.UploadInfo info, String locationId, String contentId) {
        return BinUploadAPI$FileUpload$.MODULE$.apply(info.name(), info.description(), info.category(), (String)info.optContentType().getOrElse(BinStore::toFileUpload$$anonfun$1), BinUploadAPI$Access$.MODULE$.apply(info.roles()), locationId, contentId, (int)info.length());
    }

    private Option<String> getStore(Json json) {
        return json.hcursor().downField("store").as(Decoder$.MODULE$.decodeString()).toOption();
    }

    private Option<String> getContentId(Json json) {
        return json.hcursor().downField("contentId").as(Decoder$.MODULE$.decodeString()).toOption();
    }

    public String humanReadableBytesSpan(long bytes) {
        String tip = HumanReadableBytes$.MODULE$.tip(bytes);
        return "<span class=\"hr-bytes\" title=\"" + tip + "\">" + HumanReadableBytes$.MODULE$.apply(bytes) + "</span>";
    }

    private final String $anonfun$1(UserDB.User user$1, Json metadata$1) {
        return "Storing Upload user=" + user$1.name() + " store=" + this.locationId + " metadata=" + metadata$1;
    }

    private final LogMessage.Error $anonfun$2$$anonfun$1$$anonfun$1() {
        return LogMessage.Error$.MODULE$.apply("Can't load location " + new BinaryStore.LocationId(this.locationId));
    }

    private static final String $anonfun$2$$anonfun$2$$anonfun$1$$anonfun$1(BinaryStore.Location location$2, String uuid$1) {
        return "New Upload Added store=" + location$2.id() + " uuid=" + uuid$1;
    }

    private static final Left write$$anonfun$1$$anonfun$1(LogMessage msg$1) {
        return package$.MODULE$.Left().apply((Object)msg$1);
    }

    private final LogMessage.Error $anonfun$3$$anonfun$1() {
        return LogMessage.Error$.MODULE$.apply("Can't load location " + new BinaryStore.LocationId(this.locationId));
    }

    private static final String $anonfun$4$$anonfun$1$$anonfun$1(UserDB.User user$6, BinaryStore.Id bId$3) {
        return "Deleting Upload user=" + user$6.name() + " " + bId$3;
    }

    public static final Object ambience$ud$store$BinStore$$anon$2$$_$applyOrElse$$anonfun$1(Throwable ex$1) {
        return "DBinStore elete failed  " + ex$1;
    }

    private static final String toReadable$1$$anonfun$2() {
        return "";
    }

    private static final long toReadable$1$$anonfun$3() {
        return 0L;
    }

    private final String toReadable$1(Option strOpt) {
        return this.humanReadableBytesSpan(BoxesRunTime.unboxToLong((Object)StringOps$.MODULE$.toLongOption$extension(Predef$.MODULE$.augmentString((String)strOpt.map((Function1 & Serializable)_$3 -> _$3.trim()).getOrElse(BinStore::toReadable$1$$anonfun$2))).getOrElse(BinStore::toReadable$1$$anonfun$3)));
    }

    private static final /* synthetic */ Right doWrite$$anonfun$1(String cid) {
        return package$.MODULE$.Right().apply((Object)cid);
    }

    private static final String toMetadata$$anonfun$1() {
        return "application/octet-stream";
    }

    private static final Object read$$anonfun$1$$anonfun$1(BinaryStore.Id bId$6) {
        return "No content found in binary store=" + bId$6.locationId() + " for contentId " + bId$6.contentId();
    }

    private static final Object read$$anonfun$2() {
        return "BinaryStoreId not found";
    }

    private static final Object readToOutputStream$$anonfun$1$$anonfun$2(BinaryStore.Id bId$8) {
        return "No content found in binary store=" + bId$8.locationId() + " for contentId " + bId$8.contentId();
    }

    private static final Object readToOutputStream$$anonfun$2() {
        return "BinaryStoreId not found";
    }

    private static final String toFileUpload$$anonfun$1() {
        return "application/octet-stream";
    }
}

