/*
 * Decompiled with CFR 0.152.
 */
package ambience.ud.store;

import ambience.module.UserDB;
import ambience.ud.UDManager;
import ambience.ud.UploadModule;
import ambience.ud.store.Store;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.LogMessage;
import io.circe.Json;
import java.io.OutputStream;
import java.io.Serializable;
import monix.eval.Task;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.runtime.BoxedUnit;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public interface StoreWithReadFallback
extends Store {
    public Store store();

    public Store fallback();

    public static Task write$(StoreWithReadFallback $this, UserDB.User user, UDManager manager, UploadModule.UploadInfo info) {
        return $this.write(user, manager, info);
    }

    @Override
    default public Task<Either<LogMessage, Json>> write(UserDB.User user, UDManager manager, UploadModule.UploadInfo info) {
        return this.store().write(user, manager, info);
    }

    public static Task delete$(StoreWithReadFallback $this, UserDB.User user, UDManager manager, boolean overwrite, String category, String name) {
        return $this.delete(user, manager, overwrite, category, name);
    }

    @Override
    default public Task<Either<LogMessage, BoxedUnit>> delete(UserDB.User user, UDManager manager, boolean overwrite, String category, String name) {
        return this.store().delete(user, manager, overwrite, category, name).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage lm = (LogMessage)((Left)either).value();
                this.log().info(() -> StoreWithReadFallback.delete$$anonfun$1$$anonfun$1(lm), Line$.MODULE$.apply(28), FullName$.MODULE$.apply("ambience.ud.store.StoreWithReadFallback.delete"));
                return this.fallback().delete(user, manager, overwrite, category, name);
            }
            if (either instanceof Right) {
                this.log().info(StoreWithReadFallback::delete$$anonfun$1$$anonfun$2, Line$.MODULE$.apply(31), FullName$.MODULE$.apply("ambience.ud.store.StoreWithReadFallback.delete"));
                return this.fallback().delete(user, manager, overwrite, category, name);
            }
            throw new MatchError((Object)either);
        });
    }

    public static Task read$(StoreWithReadFallback $this, UserDB.User user, Json json) {
        return $this.read(user, json);
    }

    @Override
    default public Task<DataBytes> read(UserDB.User user, Json json) {
        Option<Store.FileInfo> option = this.store().getFileInfo(json);
        if (option instanceof Some) {
            return this.store().read(user, json);
        }
        if (None$.MODULE$.equals(option)) {
            this.log().info(StoreWithReadFallback::read$$anonfun$1, Line$.MODULE$.apply(40), FullName$.MODULE$.apply("ambience.ud.store.StoreWithReadFallback.read"));
            return this.fallback().read(user, json);
        }
        throw new MatchError(option);
    }

    public static Task readToOutputStream$(StoreWithReadFallback $this, Json json, OutputStream os) {
        return $this.readToOutputStream(json, os);
    }

    @Override
    default public Task<BoxedUnit> readToOutputStream(Json json, OutputStream os) {
        Option<Store.FileInfo> option = this.store().getFileInfo(json);
        if (option instanceof Some) {
            return this.store().readToOutputStream(json, os);
        }
        if (None$.MODULE$.equals(option)) {
            this.log().info(StoreWithReadFallback::readToOutputStream$$anonfun$1, Line$.MODULE$.apply(49), FullName$.MODULE$.apply("ambience.ud.store.StoreWithReadFallback.readToOutputStream"));
            return this.fallback().readToOutputStream(json, os);
        }
        throw new MatchError(option);
    }

    public static Option getFileInfo$(StoreWithReadFallback $this, Json json) {
        return $this.getFileInfo(json);
    }

    @Override
    default public Option<Store.FileInfo> getFileInfo(Json json) {
        return this.store().getFileInfo(json).orElse(() -> this.getFileInfo$$anonfun$1(json));
    }

    private static Object delete$$anonfun$1$$anonfun$1(LogMessage lm$1) {
        return "left lm:" + lm$1.msg();
    }

    private static Object delete$$anonfun$1$$anonfun$2() {
        return "right";
    }

    private static Object read$$anonfun$1() {
        return "trying fallback";
    }

    private static Object readToOutputStream$$anonfun$1() {
        return "trying fallback";
    }

    private Option getFileInfo$$anonfun$1(Json json$1) {
        return this.fallback().getFileInfo(json$1);
    }
}

