/*
 * Decompiled with CFR 0.152.
 */
package ambience.ud.store;

import ambience.chunk.ChunkAPI;
import ambience.chunk.ChunkDB;
import ambience.module.UserDB;
import ambience.ud.UDManager;
import ambience.ud.UploadModule;
import ambience.ud.store.Store;
import ambience.ud.store.Store$FileInfo$;
import ambience.ud.store.StoreUtil$;
import ambience.ud.store.UDUploadAPI;
import ambience.ud.store.UDUploadAPI$Access$;
import ambience.ud.store.UDUploadAPI$FileUpload$;
import com.elixirtech.arch.DataBytes;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.mongodb.client.result.DeleteResult;
import io.circe.Json;
import io.circe.syntax.package;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Iterator;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonArray;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.util.Either;
import sourcecode.FullName$;
import sourcecode.Line$;

public class UDStore
implements LoggingHelper2,
Store {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(UDStore.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final ChunkDB chunkDB;

    public UDStore(ChunkDB chunkDB) {
        this.chunkDB = chunkDB;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    @Override
    public Task<Either<LogMessage, Json>> write(UserDB.User user, UDManager manager, UploadModule.UploadInfo info) {
        return this.chunkDB.write(info.bytes().observable()).flatMap((Function1 & Serializable)chunks -> {
            UDUploadAPI.FileUpload fileUpload = (UDUploadAPI.FileUpload)io.circe.syntax.package$.MODULE$.EncoderOps((Object)this.toFileUpload(info, (List<ChunkAPI.ChunkId>)chunks));
            return manager.save(user, package.EncoderOps$.MODULE$.asJson$extension((Object)fileUpload, UDUploadAPI$FileUpload$.MODULE$.encode())).map((Function1 & Serializable)res -> res);
        });
    }

    @Override
    public Task<Either<LogMessage, BoxedUnit>> delete(UserDB.User user, UDManager manager, boolean overwrite, String category, String name) {
        return manager.getByCategoryName(category, name).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Document doc = (Document)((Some)option).value();
                List ids = this.getChunkIdsFromDoc(doc).map((Function1 & Serializable)id -> BsonString$.MODULE$.apply(id == null ? null : ((ChunkAPI.ChunkId)id).value()));
                return this.chunkDB.chunks().deleteManyT(Filters$.MODULE$.in("_id", (Seq)ids)).flatMap((Function1 & Serializable)res -> this.logInfo(() -> UDStore.delete$$anonfun$1$$anonfun$1$$anonfun$1(res)).$greater$greater(() -> UDStore.delete$$anonfun$1$$anonfun$1$$anonfun$2(manager, user, category, name))).onErrorRecover((PartialFunction)new Serializable(ids){
                    private final List ids$1;
                    {
                        this.ids$1 = ids$5;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        if (throwable != null) {
                            Throwable ex = throwable;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        if (throwable != null) {
                            Throwable ex = throwable;
                            return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("Problem deleting chunks ids:" + this.ids$1 + ", " + ex.getMessage(), ex));
                        }
                        return function1.apply((Object)x);
                    }
                });
            }
            if (None$.MODULE$.equals(option)) {
                if (overwrite) {
                    return ambience.arch.package$.MODULE$.TRUnit();
                }
                this.log().error(() -> UDStore.delete$$anonfun$1$$anonfun$2(category, name), Line$.MODULE$.apply(52), FullName$.MODULE$.apply("ambience.ud.store.UDStore.delete"));
                return Task$.MODULE$.now((Object)package$.MODULE$.Left().apply((Object)LogMessage.Error$.MODULE$.apply("Problem with deleting upload with category name " + category + "_" + name)));
            }
            throw new MatchError((Object)option);
        }).onErrorRecover((PartialFunction)new Serializable(this){
            private final /* synthetic */ UDStore $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable;
                Throwable ex = throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable;
                Throwable ex = throwable = x;
                this.$outer.log().error(() -> UDStore.ambience$ud$store$UDStore$$anon$2$$_$applyOrElse$$anonfun$1(ex), Line$.MODULE$.apply(57), FullName$.MODULE$.apply("ambience.ud.store.UDStore.delete"));
                return package$.MODULE$.Left().apply((Object)LogMessage.ErrorEx$.MODULE$.apply("onErrorRecover writing to store " + ex.getMessage(), ex));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$ud$store$UDStore$$anon$2$$_$applyOrElse$$anonfun$1(java.lang.Throwable )}, serializedLambda);
            }
        });
    }

    @Override
    public Task<DataBytes> read(UserDB.User user, Json json) {
        Option<List<ChunkAPI.ChunkId>> option = this.getChunkIds(json);
        if (option instanceof Some) {
            List ids = (List)((Some)option).value();
            return Task$.MODULE$.apply(() -> this.read$$anonfun$1(ids));
        }
        if (None$.MODULE$.equals(option)) {
            this.log().error(UDStore::read$$anonfun$2, Line$.MODULE$.apply(65), FullName$.MODULE$.apply("ambience.ud.store.UDStore.read"));
            return Task$.MODULE$.now((Object)DataBytes$.MODULE$.empty());
        }
        throw new MatchError(option);
    }

    @Override
    public Task<BoxedUnit> readToOutputStream(Json json, OutputStream os) {
        Option<List<ChunkAPI.ChunkId>> option = this.getChunkIds(json);
        if (option instanceof Some) {
            List ids = (List)((Some)option).value();
            return this.chunkDB.readToOutputStream(ids, os);
        }
        if (None$.MODULE$.equals(option)) {
            this.log().error(UDStore::readToOutputStream$$anonfun$1, Line$.MODULE$.apply(74), FullName$.MODULE$.apply("ambience.ud.store.UDStore.readToOutputStream"));
            return Task$.MODULE$.unit();
        }
        throw new MatchError(option);
    }

    @Override
    public Option<Store.FileInfo> getFileInfo(Json json) {
        Option<List<ChunkAPI.ChunkId>> option = this.getChunkIds(json);
        if (option instanceof Some) {
            List ids = (List)((Some)option).value();
            return StoreUtil$.MODULE$.getFileName(json).flatMap((Function1 & Serializable)name -> StoreUtil$.MODULE$.getContentType(json).map((Function1 & Serializable)contentType -> Store$FileInfo$.MODULE$.apply((String)name, (String)contentType, StoreUtil$.MODULE$.getDigest(ids.map((Function1 & Serializable)_$1 -> _$1 == null ? null : ((ChunkAPI.ChunkId)_$1).value()).mkString("|")))));
        }
        if (None$.MODULE$.equals(option)) {
            return None$.MODULE$;
        }
        throw new MatchError(option);
    }

    private UDUploadAPI.FileUpload toFileUpload(UploadModule.UploadInfo info, List<ChunkAPI.ChunkId> chunkIds) {
        return UDUploadAPI$FileUpload$.MODULE$.apply(info.name(), info.description(), info.category(), (String)info.optContentType().getOrElse(UDStore::toFileUpload$$anonfun$1), UDUploadAPI$Access$.MODULE$.apply(info.roles()), (List<String>)chunkIds.map((Function1 & Serializable)_$2 -> _$2 == null ? null : ((ChunkAPI.ChunkId)_$2).value()), (int)info.length());
    }

    private Option<List<ChunkAPI.ChunkId>> getChunkIds(Json json) {
        return json.hcursor().downField("chunkIds").values().map((Function1 & Serializable)_$3 -> (Iterable)_$3.flatMap((Function1 & Serializable)_$4 -> _$4.asString())).map((Function1 & Serializable)_$5 -> ((IterableOnceOps)_$5.map((Function1 & Serializable)_$6 -> new ChunkAPI.ChunkId(ChunkAPI.ChunkId$.MODULE$.apply(_$6)))).toList());
    }

    private List<ChunkAPI.ChunkId> getChunkIdsFromDoc(Document doc) {
        return (List)doc.get("chunkIds", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class)).map((Function1 & Serializable)arr -> CollectionConverters$.MODULE$.IteratorHasAsScala((Iterator)arr.listIterator()).asScala().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(BsonValue x) {
                BsonValue bsonValue = x;
                if (bsonValue instanceof BsonString) {
                    BsonString bv = (BsonString)bsonValue;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(BsonValue x, Function1 function1) {
                BsonValue bsonValue = x;
                if (bsonValue instanceof BsonString) {
                    BsonString bv = (BsonString)bsonValue;
                    return new ChunkAPI.ChunkId(ChunkAPI.ChunkId$.MODULE$.apply(bv.getValue()));
                }
                return function1.apply((Object)x);
            }
        }).toList()).getOrElse(UDStore::getChunkIdsFromDoc$$anonfun$2);
    }

    private static final String delete$$anonfun$1$$anonfun$1$$anonfun$1(DeleteResult res$1) {
        return "Deleted " + res$1.getDeletedCount() + " chunks";
    }

    private static final Task delete$$anonfun$1$$anonfun$1$$anonfun$2(UDManager manager$4, UserDB.User user$4, String category$3, String name$3) {
        return manager$4.permanentDelete(user$4, category$3, name$3);
    }

    private static final Object delete$$anonfun$1$$anonfun$2(String category$4, String name$4) {
        return "Problem with deleting upload with category name " + category$4 + "_" + name$4;
    }

    public static final Object ambience$ud$store$UDStore$$anon$2$$_$applyOrElse$$anonfun$1(Throwable ex$1) {
        return "onErrorRecover " + ex$1;
    }

    private final DataBytes read$$anonfun$1(List ids$2) {
        return DataBytes$.MODULE$.apply(this.chunkDB.read(ids$2).map((Function1 & Serializable)ch -> ch.bytes()));
    }

    private static final Object read$$anonfun$2() {
        return "ChunkIds not found";
    }

    private static final Object readToOutputStream$$anonfun$1() {
        return "ChunkIds not found";
    }

    private static final String toFileUpload$$anonfun$1() {
        return "application/octet-stream";
    }

    private static final List getChunkIdsFromDoc$$anonfun$2() {
        return package$.MODULE$.Nil();
    }
}

