/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.api.Datasets;
import ambience.datasets.DatasetsModule;
import ambience.module.UserDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import io.circe.Json$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import monix.eval.Task;
import org.bson.BsonArray;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonArray$;
import org.mongodb.scala.bson.BsonInt32$;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Updates$;
import scala.Function1;
import scala.Option$;
import scala.PartialFunction;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import sourcecode.FullName$;
import sourcecode.Line$;

public final class BuildCache$
implements LoggingHelper2,
Serializable {
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(BuildCache$.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private static final BsonArray EmptySchema;
    public static final BuildCache$ MODULE$;

    private BuildCache$() {
    }

    static {
        MODULE$ = new BuildCache$();
        EmptySchema = BsonArray$.MODULE$.fromIterable((Iterable)package$.MODULE$.Nil());
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$_m_0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BuildCache$.class);
    }

    public BsonArray EmptySchema() {
        return EmptySchema;
    }

    public Task<GravityResponse> apply(DatasetsModule module, UserDB.User user, String cache, String from) {
        return this.run(module, user, cache, from).map((Function1 & Serializable)msg -> MODULE$.asGravityResponse((LogMessage)msg)).onErrorRecover((PartialFunction)new Serializable(user, cache, from){
            private final UserDB.User user$1;
            private final String cache$1;
            private final String from$1;
            {
                this.user$1 = user$4;
                this.cache$1 = cache$4;
                this.from$1 = from$3;
            }

            public final boolean isDefinedAt(Throwable x) {
                Throwable throwable = x;
                return true;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Throwable throwable = x;
                BuildCache$.MODULE$.log().error(() -> this.applyOrElse$$anonfun$1(x), x, Line$.MODULE$.apply(22), FullName$.MODULE$.apply("ambience.datasets.BuildCache.apply"));
                String msg = (String)Option$.MODULE$.apply((Object)x.getMessage()).getOrElse(BuildCache$::ambience$datasets$BuildCache$$anon$1$$_$_$$anonfun$1);
                return Gravity$.MODULE$.BadRequestResponse(msg);
            }

            private final Object applyOrElse$$anonfun$1(Throwable x$1) {
                return "BuildCache(user=" + this.user$1.name() + " cache=" + new Datasets.Name(this.cache$1) + " from=" + new Datasets.Name(this.from$1) + ") Failed: " + x$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(java.lang.Throwable ), ambience$datasets$BuildCache$$anon$1$$_$_$$anonfun$1()}, serializedLambda);
            }
        });
    }

    public Task<LogMessage> run(DatasetsModule module, UserDB.User user, String cache, String from) {
        return this.getSchema(module, from).flatMap((Function1 & Serializable)schema -> module.datasetsAPI().buildRecords(user, from, Datasets.Parameters$.MODULE$.apply(Json$.MODULE$.obj((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0])))).toListL().flatMap((Function1 & Serializable)records -> MODULE$.updateCache(module, user, cache, (BsonValue)schema, (List<Document>)records).map((Function1 & Serializable)msg -> msg)));
    }

    public GravityResponse asGravityResponse(LogMessage msg) {
        LogMessage logMessage = msg;
        if (LogMessage.None$.MODULE$.equals(logMessage)) {
            return GravityResponse$.MODULE$.apply(GravityResponse$.MODULE$.$lessinit$greater$default$1(), GravityResponse$.MODULE$.$lessinit$greater$default$2(), GravityResponse$.MODULE$.$lessinit$greater$default$3());
        }
        if (logMessage instanceof LogMessage.Info) {
            LogMessage.Info x = (LogMessage.Info)logMessage;
            return GravityResponse$.MODULE$.text(x.msg());
        }
        LogMessage x = logMessage;
        return Gravity$.MODULE$.BadRequestResponse(x.msg());
    }

    public Task<BsonValue> getSchema(DatasetsModule module, String name) {
        Bson filters = Filters$.MODULE$.eq("name", (Object)name);
        return module.datasetManager().cltn().findO(filters).firstOptionL().map((Function1 & Serializable)opt -> (BsonArray)opt.flatMap((Function1 & Serializable)_$1 -> _$1.get("schema", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonArray.class))).getOrElse(BuildCache$::getSchema$$anonfun$1$$anonfun$2));
    }

    public Task<LogMessage> updateCache(DatasetsModule module, UserDB.User user, String name, BsonValue schema, List<Document> records) {
        this.log().info(() -> BuildCache$.updateCache$$anonfun$1(name, records), Line$.MODULE$.apply(56), FullName$.MODULE$.apply("ambience.datasets.BuildCache.updateCache"));
        Bson filters = Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{Filters$.MODULE$.eq("name", (Object)BsonString$.MODULE$.apply(name)), Filters$.MODULE$.eq("datasetType", (Object)BsonString$.MODULE$.apply("Cached"))}));
        Bson setSchema = Updates$.MODULE$.set("schema", (Object)schema);
        Bson setRecords = Updates$.MODULE$.set("records", (Object)records.map((Function1 & Serializable)_$2 -> _$2.toBsonDocument()));
        Bson setRecordCount = Updates$.MODULE$.set("recordCount", (Object)BsonInt32$.MODULE$.apply(records.length()));
        Bson setLastModified = Updates$.MODULE$.currentDate("lastModified");
        Bson setLastModifiedBy = Updates$.MODULE$.set("lastModifiedBy", (Object)BsonString$.MODULE$.apply(user.name()));
        String etag = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ISO_INSTANT);
        Bson setETag = Updates$.MODULE$.set("etag", (Object)BsonString$.MODULE$.apply(etag));
        Bson updates = Updates$.MODULE$.combine((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{setSchema, setRecords, setRecordCount, setLastModified, setLastModifiedBy, setETag}));
        return module.datasetManager().cltn().updateOneT(filters, Updates$.MODULE$.combine((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{updates}))).map((Function1 & Serializable)reply -> {
            if (reply.getMatchedCount() == 1L) {
                return LogMessage.None$.MODULE$;
            }
            return LogMessage.Warn$.MODULE$.apply("Cached dataset " + name + " not found");
        });
    }

    public static final String ambience$datasets$BuildCache$$anon$1$$_$_$$anonfun$1() {
        return "Error writing record";
    }

    private static final BsonArray getSchema$$anonfun$1$$anonfun$2() {
        return MODULE$.EmptySchema();
    }

    private static final Object updateCache$$anonfun$1(String name$1, List records$1) {
        return "Updating cache for " + name$1 + " with " + records$1.length() + " records";
    }
}

