/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.datasets.DatasetManager;
import ambience.framework.AuditedDocumentManager2;
import ambience.framework.AuditedDocumentRoute2;
import ambience.gravity.GravityHelper$;
import ambience.module.UserDB;
import com.elixirtech.gravity.Gravity;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import java.io.Serializable;
import monix.eval.Task;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class DatasetRoute
extends AuditedDocumentRoute2 {
    private final DatasetManager datasetManager;

    public DatasetRoute(DatasetManager datasetManager) {
        this.datasetManager = datasetManager;
        super((AuditedDocumentManager2)datasetManager, "mod-datasets");
    }

    public List<GravityRoute> routes(UserDB.User user) {
        GravityRoute gravityRoute = GravityRoute$.MODULE$.pathPrefix("download", this.download(user));
        return super.routes(user).$colon$colon((Object)gravityRoute);
    }

    public Task<GravityResponse> getData(UserDB.User user, GravityRequest request) {
        return this.datasetManager.get(user).map((Function1 & Serializable)j -> GravityResponse$.MODULE$.json(j));
    }

    public Function1<GravityRequest, Task<GravityResponse>> download(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)dsId -> (Function1 & Serializable)_$1 -> {
            Try try_ = Try$.MODULE$.apply(() -> DatasetRoute.download$$anonfun$1$$anonfun$1$$anonfun$1(dsId));
            if (try_ instanceof Success) {
                BsonObjectId id = (BsonObjectId)((Success)try_).value();
                return this.datasetManager.cltn().findO(Filters$.MODULE$.eq("_id", (Object)id)).firstOptionL().map((Function1 & Serializable)x$1 -> {
                    Option option = x$1;
                    if (option instanceof Some) {
                        Document doc = (Document)((Some)option).value();
                        String filename = (String)doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$2 -> _$2.getValue()).getOrElse(DatasetRoute::$anonfun$2) + ".dataset.json";
                        Gravity.Header header = GravityResponse.ContentDisposition$.MODULE$.attachment(filename);
                        return GravityResponse$.MODULE$.json(doc.toJson()).withHeader(header);
                    }
                    if (None$.MODULE$.equals(option)) {
                        return Gravity$.MODULE$.NotFoundResponse();
                    }
                    throw new MatchError((Object)option);
                });
            }
            if (try_ instanceof Failure) {
                return Gravity$.MODULE$.NotFoundResponseT();
            }
            throw new MatchError((Object)try_);
        });
    }

    private static final BsonObjectId download$$anonfun$1$$anonfun$1$$anonfun$1(Gravity.Segment dsId$2) {
        return BsonObjectId$.MODULE$.apply(dsId$2.value());
    }

    private static final String $anonfun$2() {
        return "Dataset";
    }
}

