/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.api.Datasets;
import ambience.datasets.Builder;
import ambience.datasets.CachedDataset;
import ambience.datasets.Collections$;
import ambience.datasets.Dataset;
import ambience.datasets.DatasetAccessFilter$;
import ambience.datasets.DatasetsModule;
import ambience.datasets.ETLDataset;
import ambience.datasets.ETag;
import ambience.datasets.GetDatasets$;
import ambience.datasets.MongoDBDataset;
import ambience.datasets.ObserveAggregate;
import ambience.datasets.ObserveAll;
import ambience.module.AmbienceDB$;
import ambience.module.UserDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.coredata.Data;
import com.elixirtech.mongodb.FindOptions;
import com.elixirtech.mongodb.FindOptions$;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Filters$;
import org.mongodb.scala.model.Projections$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class DatasetsAPI
implements Datasets,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(DatasetsAPI.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final DatasetsModule module;
    private final Bson NameExists;

    public DatasetsAPI(DatasetsModule module) {
        this.module = module;
        this.NameExists = Filters$.MODULE$.exists("name");
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Bson NameExists() {
        return this.NameExists;
    }

    public Task<Set<String>> getLabels() {
        return Collections$.MODULE$.datasets().distinctO("labels").toListL().map((Function1 & Serializable)values -> values.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(BsonValue x) {
                BsonValue bsonValue = x;
                if (bsonValue instanceof BsonString) {
                    BsonString bs = (BsonString)bsonValue;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(BsonValue x, Function1 function1) {
                BsonValue bsonValue = x;
                if (bsonValue instanceof BsonString) {
                    BsonString bs = (BsonString)bsonValue;
                    return bs.getValue();
                }
                return function1.apply((Object)x);
            }
        }).toSet());
    }

    public Task<List<Datasets.Name>> getDatasets(UserDB.User user) {
        List filters = (List)DatasetAccessFilter$.MODULE$.getAccessFilter(user).$plus$plus((IterableOnce)new .colon.colon((Object)this.NameExists(), (List)new .colon.colon((Object)AmbienceDB$.MODULE$.IsEnabled(), (List)Nil$.MODULE$)));
        FindOptions projections = FindOptions$.MODULE$.projections(Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"})));
        Task docs = this.module.datasetManager().cltn().findO(Filters$.MODULE$.and((Seq)filters), projections).toListL();
        return docs.map((Function1 & Serializable)_$1 -> _$1.flatMap((Function1 & Serializable)doc -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)name -> new Datasets.Name(Datasets.Name$.MODULE$.apply(name.getValue())))));
    }

    public Task<List<Datasets.Name>> getDatasetsForModule(UserDB.User user, String module) {
        return this.getLabels().flatMap((Function1 & Serializable)labels -> (labels.contains((Object)module) ? this.getDatasetsWithLabels(user, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{module})))) : this.getDatasets(user)).map((Function1 & Serializable)list -> list));
    }

    public Task<Map<Datasets.Name, Data.Schema>> getDatasetsAndSchemasForModule(UserDB.User user, String module) {
        return this.getLabels().flatMap((Function1 & Serializable)labels -> (labels.contains((Object)module) ? this.getDatasetsWithLabelsAndSchemas(user, (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{module})))) : this.getDatasetsWithSchema(user)).map((Function1 & Serializable)list -> list));
    }

    public Task<List<Datasets.Name>> getDatasetsWithLabels(UserDB.User user, Set<String> labels) {
        List filters = (List)DatasetAccessFilter$.MODULE$.getAccessFilter(user).$plus$plus((IterableOnce)new .colon.colon((Object)this.NameExists(), (List)new .colon.colon((Object)AmbienceDB$.MODULE$.IsEnabled(), (List)new .colon.colon((Object)Filters$.MODULE$.in("labels", (Seq)labels.toList().map((Function1 & Serializable)value -> BsonString$.MODULE$.apply(value))), (List)Nil$.MODULE$))));
        FindOptions projections = FindOptions$.MODULE$.projections(Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"})));
        Task docs = this.module.datasetManager().cltn().findO(Filters$.MODULE$.and((Seq)filters), projections).toListL();
        return docs.map((Function1 & Serializable)_$2 -> _$2.flatMap((Function1 & Serializable)doc -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)name -> new Datasets.Name(Datasets.Name$.MODULE$.apply(name.getValue())))));
    }

    public Task<List<Datasets.Name>> getDatasetsWithWorkgroups(UserDB.User user, Set<String> workgroupIds) {
        List filters = (List)DatasetAccessFilter$.MODULE$.getAccessFilter(user).$plus$plus((IterableOnce)new .colon.colon((Object)this.NameExists(), (List)new .colon.colon((Object)AmbienceDB$.MODULE$.IsEnabled(), (List)new .colon.colon((Object)Filters$.MODULE$.in("workgroups", (Seq)workgroupIds.toList().map((Function1 & Serializable)value -> BsonString$.MODULE$.apply(value))), (List)Nil$.MODULE$))));
        FindOptions projections = FindOptions$.MODULE$.projections(Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"})));
        Task docs = this.module.datasetManager().cltn().findO(Filters$.MODULE$.and((Seq)filters), projections).toListL();
        return docs.map((Function1 & Serializable)_$3 -> _$3.flatMap((Function1 & Serializable)doc -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)name -> new Datasets.Name(Datasets.Name$.MODULE$.apply(name.getValue())))));
    }

    public Task<Map<Datasets.Name, Data.Schema>> getDatasetsWithLabelsAndSchemas(UserDB.User user, Set<String> labels) {
        return GetDatasets$.MODULE$.withLabels(user, labels);
    }

    public Task<Map<Datasets.Name, Data.Schema>> getDatasetsWithWorkgroupsAndSchemas(UserDB.User user, Set<String> workgroupIds) {
        return GetDatasets$.MODULE$.withWorkgroups(user, workgroupIds);
    }

    public Task<List<Datasets.Name>> getDatasets(UserDB.User user, String dsType) {
        List filters = (List)DatasetAccessFilter$.MODULE$.getAccessFilter(user).$plus$plus((IterableOnce)new .colon.colon((Object)this.typeFilter(dsType), (List)new .colon.colon((Object)this.NameExists(), (List)new .colon.colon((Object)AmbienceDB$.MODULE$.IsEnabled(), (List)Nil$.MODULE$))));
        FindOptions projections = FindOptions$.MODULE$.projections(Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"})));
        Task docs = this.module.datasetManager().cltn().findO(Filters$.MODULE$.and((Seq)filters), projections).toListL();
        return docs.map((Function1 & Serializable)_$4 -> _$4.flatMap((Function1 & Serializable)doc -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)name -> new Datasets.Name(Datasets.Name$.MODULE$.apply(name.getValue())))));
    }

    public Task<List<Datasets.NameAndType>> getDatasetsWithType(UserDB.User user) {
        List filters = (List)DatasetAccessFilter$.MODULE$.getAccessFilter(user).$plus$plus((IterableOnce)new .colon.colon((Object)this.NameExists(), (List)new .colon.colon((Object)AmbienceDB$.MODULE$.IsEnabled(), (List)Nil$.MODULE$)));
        FindOptions projections = FindOptions$.MODULE$.projections(Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name", "datasetType"})));
        Task docs = this.module.datasetManager().cltn().findO(Filters$.MODULE$.and((Seq)filters), projections).toListL();
        return docs.map((Function1 & Serializable)_$5 -> _$5.flatMap((Function1 & Serializable)doc -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)name -> new Datasets.Name(Datasets.Name$.MODULE$.apply(name.getValue()))).flatMap((Function1 & Serializable)name -> DatasetsAPI.getDatasetsWithType$$anonfun$1$$anonfun$1$$anonfun$2(doc, name == null ? null : ((Datasets.Name)name).value()))));
    }

    public Task<List<Datasets.Name>> getDatasetInfo(UserDB.User user) {
        List filters = (List)DatasetAccessFilter$.MODULE$.getAccessFilter(user).$plus$plus((IterableOnce)new .colon.colon((Object)this.NameExists(), (List)new .colon.colon((Object)AmbienceDB$.MODULE$.IsEnabled(), (List)Nil$.MODULE$)));
        FindOptions projections = FindOptions$.MODULE$.projections(Projections$.MODULE$.include((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"name"})));
        Task docs = this.module.datasetManager().cltn().findO(Filters$.MODULE$.and((Seq)filters), projections).toListL();
        return docs.map((Function1 & Serializable)_$6 -> _$6.flatMap((Function1 & Serializable)doc -> doc.get("name", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)name -> new Datasets.Name(Datasets.Name$.MODULE$.apply(name.getValue())))));
    }

    public Task<Data.Schema> getSchema(UserDB.User user, String datasetName) {
        return this.module.fetchDataset(user, datasetName, (Option<ETag>)None$.MODULE$).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Dataset dataset = (Dataset)((Right)either).value();
                if (dataset instanceof MongoDBDataset) {
                    MongoDBDataset ds = (MongoDBDataset)dataset;
                    return ds.schema();
                }
                if (dataset instanceof ETLDataset) {
                    ETLDataset ds = (ETLDataset)dataset;
                    return ds.schema();
                }
                if (dataset instanceof CachedDataset) {
                    CachedDataset ds = (CachedDataset)dataset;
                    return ds.schema();
                }
            }
            if (either instanceof Left) {
                return Data.Schema$.MODULE$.apply((List)package$.MODULE$.Nil());
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<Map<Datasets.Name, Data.Schema>> getDatasetsWithSchema(UserDB.User user) {
        return GetDatasets$.MODULE$.apply(user);
    }

    public Observable<Document> buildRecords(UserDB.User user, String datasetName, Datasets.Parameters params) {
        ObserveAll observeAll = new ObserveAll(this.module);
        this.log().info(() -> DatasetsAPI.buildRecords$$anonfun$1(datasetName, params), Line$.MODULE$.apply(112), FullName$.MODULE$.apply("ambience.datasets.DatasetsAPI.buildRecords"));
        return observeAll.run(user, this.module.filterDatasetFn(user), datasetName, params.json());
    }

    public Observable<Document> buildAggregate(UserDB.User user, String datasetName, Datasets.Parameters params, List<Json> steps) {
        ObserveAggregate observeAggregate = new ObserveAggregate(this.module);
        this.log().info(() -> DatasetsAPI.buildAggregate$$anonfun$1(datasetName, params), Line$.MODULE$.apply(118), FullName$.MODULE$.apply("ambience.datasets.DatasetsAPI.buildAggregate"));
        return observeAggregate.run(user, this.module.filterDatasetFn(user), datasetName, params.json(), steps);
    }

    public Task<String> bumpETag(UserDB.User user, String datasetName) {
        return this.module.etagManager().bumpETag(user, datasetName);
    }

    public Task<Data.Schema> inferSchema(UserDB.User user, String datasetName) {
        return this.module.fetchDataset(user, datasetName, (Option<ETag>)None$.MODULE$).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Dataset dataset = (Dataset)((Right)either).value();
                if (dataset instanceof MongoDBDataset) {
                    MongoDBDataset ds = (MongoDBDataset)dataset;
                    return this.module.inferSchema(user, ds.database(), ds.collection(), ds.aggregation()).flatMap((Function1 & Serializable)s -> {
                        Data.Schema schema = this.hideMetadata((Data.Schema)s);
                        Data.Schema schema2 = ds.schema();
                        Data.Schema schema3 = schema;
                        if (schema2 == null ? schema3 != null : !schema2.equals(schema3)) {
                            return this.module.datasetManager().updateSchema(ds.id(), schema).map((Function1 & Serializable)x$1 -> {
                                Either either = x$1;
                                if (either instanceof Left) {
                                    LogMessage err = (LogMessage)((Left)either).value();
                                    this.log().error(() -> DatasetsAPI.inferSchema$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(err), Line$.MODULE$.apply(134), FullName$.MODULE$.apply("ambience.datasets.DatasetsAPI.inferSchema"));
                                    return Data.Schema$.MODULE$.apply((List)package$.MODULE$.Nil());
                                }
                                if (either instanceof Right) {
                                    return schema;
                                }
                                throw new MatchError((Object)either);
                            });
                        }
                        return Task$.MODULE$.now((Object)schema);
                    });
                }
                if (dataset instanceof ETLDataset) {
                    ETLDataset ds = (ETLDataset)dataset;
                    return this.module.inferETLSchema(user, ds.chainset(), ds.chain(), ds.aggregation()).flatMap((Function1 & Serializable)s -> {
                        Data.Schema schema = this.hideMetadata((Data.Schema)s);
                        Data.Schema schema2 = ds.schema();
                        Data.Schema schema3 = schema;
                        if (schema2 == null ? schema3 != null : !schema2.equals(schema3)) {
                            return this.module.datasetManager().updateSchema(ds.id(), schema).map((Function1 & Serializable)x$1 -> {
                                Either either = x$1;
                                if (either instanceof Left) {
                                    LogMessage err = (LogMessage)((Left)either).value();
                                    this.log().error(() -> DatasetsAPI.inferSchema$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(err), Line$.MODULE$.apply(147), FullName$.MODULE$.apply("ambience.datasets.DatasetsAPI.inferSchema"));
                                    return Data.Schema$.MODULE$.apply((List)package$.MODULE$.Nil());
                                }
                                if (either instanceof Right) {
                                    return schema;
                                }
                                throw new MatchError((Object)either);
                            });
                        }
                        return Task$.MODULE$.now((Object)schema);
                    });
                }
                if (dataset instanceof CachedDataset) {
                    CachedDataset ds = (CachedDataset)dataset;
                    return Task$.MODULE$.now((Object)ds.schema());
                }
            }
            if (either instanceof Left) {
                Builder.Response msg = (Builder.Response)((Left)either).value();
                this.log().error(() -> DatasetsAPI.inferSchema$$anonfun$1$$anonfun$3(msg), Line$.MODULE$.apply(157), FullName$.MODULE$.apply("ambience.datasets.DatasetsAPI.inferSchema"));
                return Task$.MODULE$.now((Object)Data.Schema$.MODULE$.apply((List)package$.MODULE$.Nil()));
            }
            throw new MatchError((Object)either);
        });
    }

    public Data.Schema hideMetadata(Data.Schema schema) {
        return Data.Schema$.MODULE$.apply(schema.fields().map((Function1 & Serializable)f -> {
            if (f.name().startsWith("_")) {
                Some some = Some$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
                Option option = f.properties().copy$default$1();
                Data.FieldProperties fieldProperties = f.properties().copy(option, (Option)some);
                String string = f.copy$default$1();
                Data.Type type = f.copy$default$2();
                return f.copy(string, type, fieldProperties);
            }
            return f;
        }));
    }

    public Bson typeFilter(String dsType) {
        return Filters$.MODULE$.eq("datasetType", (Object)dsType);
    }

    private static final /* synthetic */ Option getDatasetsWithType$$anonfun$1$$anonfun$1$$anonfun$2(Document doc$1, String name) {
        return doc$1.get("datasetType", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)dst -> new Datasets.Type(Datasets.Type$.MODULE$.apply(dst.getValue()))).map((Function1 & Serializable)dsType -> Datasets.NameAndType$.MODULE$.apply(name, dsType == null ? null : ((Datasets.Type)dsType).value()));
    }

    private static final Object buildRecords$$anonfun$1(String datasetName$1, Datasets.Parameters params$1) {
        return "buildRecords " + datasetName$1 + " " + params$1.json().noSpaces();
    }

    private static final Object buildAggregate$$anonfun$1(String datasetName$2, Datasets.Parameters params$2) {
        return "buildAggregate " + datasetName$2 + " " + params$2.json().noSpaces();
    }

    private static final Object inferSchema$$anonfun$1$$anonfun$1$$anonfun$1$$anonfun$1(LogMessage err$1) {
        return err$1.msg();
    }

    private static final Object inferSchema$$anonfun$1$$anonfun$2$$anonfun$1$$anonfun$1(LogMessage err$2) {
        return err$2.msg();
    }

    private static final Object inferSchema$$anonfun$1$$anonfun$3(Builder.Response msg$1) {
        return msg$1;
    }
}

