/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.api.ChainRunner;
import ambience.datasets.DatasetsModule;
import ambience.etl.BsonToTryChainSet$;
import ambience.etl.ETLChainSet;
import ambience.framework.URFilter2$;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.BsonTransform$;
import com.elixirtech.mongodb.MongoDB;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Json;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import monix.reactive.Observable$;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.mongodb.scala.bson.BsonString$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import org.mongodb.scala.model.Filters$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;

public class ETLHelper
implements LoggingHelper2 {
    public static final long OFFSET$1 = LazyVals$.MODULE$.getOffsetStatic(ETLHelper.class.getDeclaredField("log$lzy1"));
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ETLHelper.class.getDeclaredField("chainsetsCltn$lzy1"));
    private volatile Object log$lzy1;
    private final DatasetsModule datasetsModule;
    private final ChainRunner chainAPI;
    private final MongoDB mongoDB;
    private volatile Object chainsetsCltn$lzy1;

    public ETLHelper(DatasetsModule datasetsModule, ChainRunner chainAPI, MongoDB mongoDB) {
        this.datasetsModule = datasetsModule;
        this.chainAPI = chainAPI;
        this.mongoDB = mongoDB;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$1, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public DatasetsModule datasetsModule() {
        return this.datasetsModule;
    }

    public ChainRunner chainAPI() {
        return this.chainAPI;
    }

    public MongoDB mongoDB() {
        return this.mongoDB;
    }

    public RichMongoCollection chainsetsCltn() {
        Object object = this.chainsetsCltn$lzy1;
        if (object instanceof RichMongoCollection) {
            return (RichMongoCollection)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (RichMongoCollection)this.chainsetsCltn$lzyINIT1();
    }

    private Object chainsetsCltn$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.chainsetsCltn$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    RichMongoCollection richMongoCollection = null;
                    try {
                        richMongoCollection = new RichMongoCollection(this.mongoDB().database().getCollection("ChainSets", DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                        object2 = richMongoCollection == null ? LazyVals.NullValue$.MODULE$ : richMongoCollection;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.chainsetsCltn$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return richMongoCollection;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<ETLChainSet> getChainSet(UserDB.User user, String chainSetName) {
        Task tOptCS = URFilter2$.MODULE$.getAccessFilter(user).flatMap((Function1 & Serializable)filter -> this.chainsetsCltn().findO(Filters$.MODULE$.and((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Bson[]{filter, Filters$.MODULE$.eq("name", (Object)BsonString$.MODULE$.apply(chainSetName))}))).firstOptionL().map((Function1 & Serializable)optDoc -> optDoc.flatMap((Function1 & Serializable)doc -> {
            Json bson = BsonTransform$.MODULE$.toJson((BsonValue)doc.toBsonDocument());
            return BsonToTryChainSet$.MODULE$.fromJson(bson).toOption();
        })));
        return tOptCS.flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                ETLChainSet cs = (ETLChainSet)((Some)option).value();
                return Task$.MODULE$.now((Object)cs);
            }
            if (None$.MODULE$.equals(option)) {
                return Task$.MODULE$.raiseError((Throwable)new RuntimeException("Can't load chainset " + chainSetName));
            }
            throw new MatchError((Object)option);
        });
    }

    public Task<String> writeToTemp(UserDB.User user, ChainRunner.ChainSpec chainSpec, Json initJson) {
        String uuid = UUID.randomUUID().toString();
        RichMongoCollection tempCltn = new RichMongoCollection(this.mongoDB().temp().getCollection(uuid, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
        Document initDoc = Document$.MODULE$.apply(initJson.noSpaces());
        return this.chainAPI().runChain(user, chainSpec, Observable$.MODULE$.now((Object)initDoc)).bufferTumbling(1000).mapEval((Function1 & Serializable)docs -> tempCltn.insertManyT(docs)).completedL().as((Object)uuid);
    }

    public Task<BoxedUnit> dropTemp(UserDB.User user, String uuid) {
        return new RichMongoCollection(this.mongoDB().temp().getCollection(uuid, DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class))).dropT();
    }
}

