/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.datasets.ExportBuilder;
import ambience.datasets.ExportBuilder$;
import ambience.datasets.ExportColumn;
import com.elixirtech.arch.DataBytes$;
import com.elixirtech.arch.MimeTypes$;
import com.elixirtech.coredata.Data;
import com.elixirtech.mongodb.BsonUtils$;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.execution.Scheduler$;
import monix.reactive.Observable;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.bson.BsonValue;
import org.mongodb.scala.bson.collection.immutable.Document;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.java8.JFunction1;

public class ExportXLSX
implements ExportBuilder {
    private final Data.Schema schema;
    private final List<ExportColumn> cols;
    private final Scheduler scheduler;
    private final Path filePath;
    private final SXSSFWorkbook workbook;
    private final SXSSFSheet sheet;
    private int nextRow;
    private final String contentType;
    private final SXSSFRow header;

    public ExportXLSX(String sheetName, Data.Schema schema, List<ExportColumn> cols) {
        this.schema = schema;
        this.cols = cols;
        this.scheduler = Scheduler$.MODULE$.global();
        this.filePath = Files.createTempFile("export", ".xlsx", new FileAttribute[0]);
        this.workbook = new SXSSFWorkbook(10);
        this.workbook.setCompressTempFiles(true);
        this.sheet = this.workbook.createSheet(sheetName.replace(":", " "));
        this.nextRow = 0;
        this.sheet.trackAllColumnsForAutoSizing();
        this.contentType = MimeTypes$.MODULE$.XLSX().value();
        this.header = this.createRow();
        ((List)cols.map((Function1 & Serializable)_$1 -> _$1.label()).zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String f = (String)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                this.header().createCell(i).setCellValue(f);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    @Override
    public String contentType() {
        return this.contentType;
    }

    public SXSSFRow header() {
        return this.header;
    }

    @Override
    public void add(Document doc) {
        SXSSFRow row = this.createRow();
        List items = this.cols.map((Function1 & Serializable)col -> (String)BsonUtils$.MODULE$.get(doc, col.field()).map((Function1 & Serializable)bv -> ExportBuilder$.MODULE$.format((BsonValue)bv)).getOrElse(ExportXLSX::$anonfun$1$$anonfun$2));
        ((List)items.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String s = (String)tuple2._1();
                int i = BoxesRunTime.unboxToInt((Object)tuple2._2());
                row.createCell(i).setCellValue(s);
                return;
            }
            throw new MatchError((Object)tuple2);
        });
    }

    @Override
    public Observable<byte[]> buildSource() {
        this.schema.fields().indices().foreach((Function1)(JFunction1.mcVI.sp & Serializable)x$0 -> this.sheet.autoSizeColumn(x$0));
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(this.filePath.toFile()));
        this.workbook.write((OutputStream)fos);
        fos.flush();
        fos.close();
        return DataBytes$.MODULE$.apply(this.filePath.toFile()).observable().doOnComplete(Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.buildSource$$anonfun$2();
            return BoxedUnit.UNIT;
        }));
    }

    private SXSSFRow createRow() {
        SXSSFRow row = this.sheet.createRow(this.nextRow);
        ++this.nextRow;
        return row;
    }

    private static final String $anonfun$1$$anonfun$2() {
        return "";
    }

    private final void buildSource$$anonfun$2() {
        Files.delete(this.filePath);
    }
}

