/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.api.ChainRunner;
import ambience.datasets.CachedDataset;
import ambience.datasets.CachedHelper$;
import ambience.datasets.Collections$;
import ambience.datasets.Dataset;
import ambience.datasets.DatasetsModule;
import ambience.datasets.ETLDataset;
import ambience.datasets.ETLHelper;
import ambience.datasets.ETag;
import ambience.datasets.ExcludeHiddenFields$;
import ambience.datasets.FilterManager$;
import ambience.datasets.JsonParams;
import ambience.datasets.JsonParams$;
import ambience.datasets.MongoDBDataset;
import ambience.datasets.PipelinePreprocessor$;
import ambience.datasets.PipelineSubstitution$;
import ambience.datasets.RowSecurity$;
import ambience.datasets.StepSequence;
import ambience.datasets.StepSequence$;
import ambience.datasets.UserLookup$;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.BsonUtils$;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.ObservableLike$;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.model.Aggregates$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ObserveAggregate
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ObserveAggregate.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final DatasetsModule module;
    private final Scheduler scheduler;

    public ObserveAggregate(DatasetsModule module) {
        this.module = module;
        this.scheduler = module.scheduler();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Observable<Document> run(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, String datasetName, Json params, List<Json> steps) {
        this.log().info(() -> ObserveAggregate.run$$anonfun$1(datasetName), Line$.MODULE$.apply(27), FullName$.MODULE$.apply("ambience.datasets.ObserveAggregate.run"));
        JsonParams jsonParams = JsonParams$.MODULE$.apply(params);
        StepSequence stepSequence = StepSequence$.MODULE$.build(Json$.MODULE$.fromValues(steps));
        return Observable$.MODULE$.from(this.module.fetchDataset(user, datasetName, (Option<ETag>)None$.MODULE$), ObservableLike$.MODULE$.fromTask()).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Dataset dataset = (Dataset)((Right)either).value();
                if (dataset instanceof MongoDBDataset) {
                    MongoDBDataset ds = (MongoDBDataset)dataset;
                    return this.runMongo(user, filterFn, ds, jsonParams, stepSequence);
                }
                if (dataset instanceof ETLDataset) {
                    ETLDataset ds = (ETLDataset)dataset;
                    return this.runETL(user, filterFn, ds, jsonParams, stepSequence);
                }
                if (dataset instanceof CachedDataset) {
                    CachedDataset ds = (CachedDataset)dataset;
                    return this.runCached(user, filterFn, ds, jsonParams, stepSequence);
                }
            }
            if (either instanceof Left) {
                return Observable$.MODULE$.empty();
            }
            throw new MatchError((Object)either);
        });
    }

    public Observable<Document> runETL(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, ETLDataset ds, JsonParams params, StepSequence stepSequence) {
        ETLHelper etlHelper = this.module.etlHelper();
        Json initJson = stepSequence.etlInjection().deepMerge(params.json());
        return Observable$.MODULE$.from(etlHelper.getChainSet(user, ds.chainset()), ObservableLike$.MODULE$.fromTask()).flatMap((Function1 & Serializable)chainset -> Observable$.MODULE$.fromTask(etlHelper.writeToTemp(user, (ChainRunner.ChainSpec)ChainRunner.ChainIdSpec$.MODULE$.apply(chainset._id(), ds.chain()), initJson)).flatMap((Function1 & Serializable)uuid -> Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MongoDBDataset[]{ds.toMongo(this.module.tempDatabaseName(), (String)uuid)})).flatMap((Function1 & Serializable)mds -> this.runMongo(user, filterFn, (MongoDBDataset)mds, params, stepSequence).doOnComplete(etlHelper.dropTemp(user, (String)uuid)).map((Function1 & Serializable)result -> result))));
    }

    public Observable<Document> runMongo(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, MongoDBDataset ds, JsonParams params, StepSequence stepSequence) {
        this.log().info(() -> ObserveAggregate.runMongo$$anonfun$1(ds), Line$.MODULE$.apply(62), FullName$.MODULE$.apply("ambience.datasets.ObserveAggregate.runMongo"));
        this.log().debug(() -> ObserveAggregate.runMongo$$anonfun$2(stepSequence), Line$.MODULE$.apply(63), FullName$.MODULE$.apply("ambience.datasets.ObserveAggregate.runMongo"));
        return Observable$.MODULE$.from((Object)((Observable)filterFn.apply((Object)ds)).toListL(), ObservableLike$.MODULE$.fromTask()).flatMap((Function1 & Serializable)userFilters -> {
            Option option = this.module.databaseMap().get((Object)ds.database());
            if (option instanceof Some) {
                MongoDatabase database = (MongoDatabase)((Some)option).value();
                RichMongoCollection cltn = new RichMongoCollection(database.getCollection(ds.collection(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
                List<BsonDocument> steps = this.buildSteps(user, ds, (List<BsonDocument>)userFilters, params, stepSequence);
                return cltn.aggregateO(steps).onErrorRecoverWith((PartialFunction)new Serializable(steps, this){
                    private final List steps$1;
                    private final /* synthetic */ ObserveAggregate $outer;
                    {
                        this.steps$1 = steps$4;
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }

                    public final boolean isDefinedAt(Throwable x) {
                        Throwable throwable = x;
                        if (throwable instanceof Exception) {
                            Exception ex = (Exception)throwable;
                            return true;
                        }
                        return false;
                    }

                    public final Object applyOrElse(Throwable x, Function1 function1) {
                        Throwable throwable = x;
                        if (throwable instanceof Exception) {
                            Exception ex = (Exception)throwable;
                            this.$outer.log().error(() -> ObserveAggregate.ambience$datasets$ObserveAggregate$$anon$1$$_$applyOrElse$$anonfun$1(ex), Line$.MODULE$.apply(72), FullName$.MODULE$.apply("ambience.datasets.ObserveAggregate.runMongo"));
                            ((List)this.steps$1.map(ObserveAggregate::ambience$datasets$ObserveAggregate$$anon$1$$_$applyOrElse$$anonfun$2).zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                                Tuple2 tuple2 = x$1;
                                if (tuple2 != null) {
                                    String step = (String)tuple2._1();
                                    int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                                    this.$outer.log().info(() -> ObserveAggregate.ambience$datasets$ObserveAggregate$$anon$1$$_$applyOrElse$$anonfun$3$$anonfun$1(idx, step), Line$.MODULE$.apply(74), FullName$.MODULE$.apply("ambience.datasets.ObserveAggregate.runMongo"));
                                    return;
                                }
                                throw new MatchError((Object)tuple2);
                            });
                            return Observable$.MODULE$.empty();
                        }
                        return function1.apply((Object)x);
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$datasets$ObserveAggregate$$anon$1$$_$applyOrElse$$anonfun$1(java.lang.Exception ), ambience$datasets$ObserveAggregate$$anon$1$$_$applyOrElse$$anonfun$2(org.bson.BsonDocument ), applyOrElse$$anonfun$3(scala.Tuple2 ), ambience$datasets$ObserveAggregate$$anon$1$$_$applyOrElse$$anonfun$3$$anonfun$1(int java.lang.String )}, serializedLambda);
                    }
                });
            }
            if (None$.MODULE$.equals(option)) {
                this.log().info(() -> ObserveAggregate.runMongo$$anonfun$3$$anonfun$1(ds), Line$.MODULE$.apply(79), FullName$.MODULE$.apply("ambience.datasets.ObserveAggregate.runMongo"));
                return Observable$.MODULE$.empty();
            }
            throw new MatchError((Object)option);
        });
    }

    public List<BsonDocument> buildSteps(UserDB.User user, Dataset ds, List<BsonDocument> userFilters, JsonParams params, StepSequence stepSequence) {
        ListBuffer pipeline = new ListBuffer();
        pipeline.$plus$plus$eq(userFilters);
        if (ds.filters().nonEmpty()) {
            pipeline.$plus$eq((Object)BsonUtils$.MODULE$.toDocument(Aggregates$.MODULE$.match(FilterManager$.MODULE$.buildFilter(ds.filters()))));
        }
        pipeline.$plus$plus$eq((IterableOnce)ds.aggregation().map((Function1 & Serializable)j -> BsonDocument$.MODULE$.apply(j.noSpaces())));
        pipeline.$plus$plus$eq(RowSecurity$.MODULE$.apply(user, ds));
        pipeline.$plus$plus$eq((IterableOnce)stepSequence.steps().map((Function1 & Serializable)j -> BsonDocument$.MODULE$.apply(j.noSpaces())));
        pipeline.$plus$plus$eq(PipelineSubstitution$.MODULE$.paramDefinitions(params.json()));
        ExcludeHiddenFields$.MODULE$.from(ds).foreach((Function1 & Serializable)_$2 -> (ListBuffer)pipeline.$plus$eq(_$2));
        this.log().debug(() -> ObserveAggregate.buildSteps$$anonfun$4(pipeline), Line$.MODULE$.apply(100), FullName$.MODULE$.apply("ambience.datasets.ObserveAggregate.buildSteps"));
        List<BsonDocument> steps = PipelinePreprocessor$.MODULE$.bson((List<BsonValue>)pipeline.toList(), this.lookup(user));
        this.log().debug(() -> ObserveAggregate.buildSteps$$anonfun$5(steps), Line$.MODULE$.apply(102), FullName$.MODULE$.apply("ambience.datasets.ObserveAggregate.buildSteps"));
        return steps;
    }

    public PartialFunction<String, Json> lookup(UserDB.User user) {
        return UserLookup$.MODULE$.apply(user).orElse(PipelinePreprocessor$.MODULE$.ConfiguredLookup());
    }

    public Observable<Document> runCached(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, CachedDataset ds, JsonParams params, StepSequence stepSequence) {
        this.log().info(() -> ObserveAggregate.runCached$$anonfun$1(ds), Line$.MODULE$.apply(117), FullName$.MODULE$.apply("ambience.datasets.ObserveAggregate.runCached"));
        this.log().debug(() -> ObserveAggregate.runCached$$anonfun$2(stepSequence), Line$.MODULE$.apply(118), FullName$.MODULE$.apply("ambience.datasets.ObserveAggregate.runCached"));
        return Observable$.MODULE$.from((Object)((Observable)filterFn.apply((Object)ds)).toListL(), ObservableLike$.MODULE$.fromTask()).flatMap((Function1 & Serializable)userFilters -> {
            Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
            String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$match");
            Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[1];
            String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
            objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonObjectId$.MODULE$.apply(ds.id())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
            BsonDocument bsonDocument = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
            List baseSteps = CachedHelper$.MODULE$.BaseSteps().$colon$colon((Object)bsonDocument);
            List steps = this.buildSteps(user, ds, (List<BsonDocument>)userFilters, params, stepSequence).$colon$colon$colon(baseSteps);
            return Collections$.MODULE$.datasets().aggregateO((Seq)steps).onErrorRecoverWith((PartialFunction)new Serializable(steps, this){
                private final List steps$3;
                private final /* synthetic */ ObserveAggregate $outer;
                {
                    this.steps$3 = steps$5;
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }

                public final boolean isDefinedAt(Throwable x) {
                    Throwable throwable = x;
                    if (throwable instanceof Exception) {
                        Exception ex = (Exception)throwable;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(Throwable x, Function1 function1) {
                    Throwable throwable = x;
                    if (throwable instanceof Exception) {
                        Exception ex = (Exception)throwable;
                        this.$outer.log().error(() -> ObserveAggregate.ambience$datasets$ObserveAggregate$$anon$2$$_$applyOrElse$$anonfun$4(ex), Line$.MODULE$.apply(125), FullName$.MODULE$.apply("ambience.datasets.ObserveAggregate.runCached"));
                        ((List)this.steps$3.map(ObserveAggregate::ambience$datasets$ObserveAggregate$$anon$2$$_$applyOrElse$$anonfun$5).zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                String step = (String)tuple2._1();
                                int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                                this.$outer.log().info(() -> ObserveAggregate.ambience$datasets$ObserveAggregate$$anon$2$$_$applyOrElse$$anonfun$6$$anonfun$1(idx, step), Line$.MODULE$.apply(127), FullName$.MODULE$.apply("ambience.datasets.ObserveAggregate.runCached"));
                                return;
                            }
                            throw new MatchError((Object)tuple2);
                        });
                        return Observable$.MODULE$.empty();
                    }
                    return function1.apply((Object)x);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{ambience$datasets$ObserveAggregate$$anon$2$$_$applyOrElse$$anonfun$4(java.lang.Exception ), ambience$datasets$ObserveAggregate$$anon$2$$_$applyOrElse$$anonfun$5(org.bson.BsonDocument ), applyOrElse$$anonfun$6(scala.Tuple2 ), ambience$datasets$ObserveAggregate$$anon$2$$_$applyOrElse$$anonfun$6$$anonfun$1(int java.lang.String )}, serializedLambda);
                }
            });
        });
    }

    private static final Object run$$anonfun$1(String datasetName$1) {
        return "observeAggregate(" + datasetName$1 + ") starting";
    }

    private static final Object runMongo$$anonfun$1(MongoDBDataset ds$3) {
        return "observeAggregate(" + ds$3.name() + "," + ds$3.database() + "," + ds$3.collection() + ") starting";
    }

    private static final Object runMongo$$anonfun$2(StepSequence stepSequence$5) {
        return "stepSequence: " + stepSequence$5;
    }

    public static final Object ambience$datasets$ObserveAggregate$$anon$1$$_$applyOrElse$$anonfun$1(Exception ex$1) {
        return "Aggregation error: " + ex$1;
    }

    public static final /* synthetic */ String ambience$datasets$ObserveAggregate$$anon$1$$_$applyOrElse$$anonfun$2(BsonDocument _$1) {
        return _$1.toJson();
    }

    public static final Object ambience$datasets$ObserveAggregate$$anon$1$$_$applyOrElse$$anonfun$3$$anonfun$1(int idx$1, String step$1) {
        return "Step " + idx$1 + " " + step$1;
    }

    private static final Object runMongo$$anonfun$3$$anonfun$1(MongoDBDataset ds$5) {
        return "buildAggregate(" + ds$5.name() + ") database " + ds$5.database() + " not found";
    }

    private static final Object buildSteps$$anonfun$4(ListBuffer pipeline$2) {
        return "built steps:\n" + ((IterableOnceOps)pipeline$2.map((Function1 & Serializable)_$3 -> _$3.toString())).mkString("\n");
    }

    private static final Object buildSteps$$anonfun$5(List steps$2) {
        return "processed steps:\n" + steps$2.map((Function1 & Serializable)_$4 -> _$4.toString()).mkString("\n");
    }

    private static final Object runCached$$anonfun$1(CachedDataset ds$6) {
        return "observeAggregate(" + ds$6.name() + ") starting";
    }

    private static final Object runCached$$anonfun$2(StepSequence stepSequence$7) {
        return "stepSequence: " + stepSequence$7;
    }

    public static final Object ambience$datasets$ObserveAggregate$$anon$2$$_$applyOrElse$$anonfun$4(Exception ex$2) {
        return "Aggregation error: " + ex$2;
    }

    public static final /* synthetic */ String ambience$datasets$ObserveAggregate$$anon$2$$_$applyOrElse$$anonfun$5(BsonDocument _$5) {
        return _$5.toJson();
    }

    public static final Object ambience$datasets$ObserveAggregate$$anon$2$$_$applyOrElse$$anonfun$6$$anonfun$1(int idx$2, String step$2) {
        return "Step " + idx$2 + " " + step$2;
    }
}

