/*
 * Decompiled with CFR 0.152.
 */
package ambience.datasets;

import ambience.api.ChainRunner;
import ambience.datasets.AllHelper$;
import ambience.datasets.CachedDataset;
import ambience.datasets.CachedHelper$;
import ambience.datasets.Collections$;
import ambience.datasets.Dataset;
import ambience.datasets.DatasetsModule;
import ambience.datasets.ETLDataset;
import ambience.datasets.ETLHelper;
import ambience.datasets.ETag;
import ambience.datasets.JsonParams;
import ambience.datasets.JsonParams$;
import ambience.datasets.MongoDBDataset;
import ambience.etl.ETLChainSet;
import ambience.module.UserDB;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.mongodb.RichMongoCollection;
import io.circe.Json;
import java.io.Serializable;
import monix.eval.Task$;
import monix.execution.Scheduler;
import monix.reactive.Observable;
import monix.reactive.Observable$;
import monix.reactive.ObservableLike$;
import org.bson.BsonDocument;
import org.mongodb.scala.MongoDatabase;
import org.mongodb.scala.bson.BsonDocument$;
import org.mongodb.scala.bson.BsonMagnets;
import org.mongodb.scala.bson.BsonMagnets$;
import org.mongodb.scala.bson.BsonObjectId$;
import org.mongodb.scala.bson.BsonTransformer;
import org.mongodb.scala.bson.BsonTransformer$;
import org.mongodb.scala.bson.DefaultHelper;
import org.mongodb.scala.bson.collection.immutable.Document;
import org.mongodb.scala.bson.collection.immutable.Document$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class ObserveAll
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(ObserveAll.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final DatasetsModule module;
    private final Scheduler scheduler;

    public ObserveAll(DatasetsModule module) {
        this.module = module;
        this.scheduler = module.scheduler();
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public Observable<Document> run(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, String datasetName, Json params) {
        this.log().info(() -> ObserveAll.run$$anonfun$1(datasetName), Line$.MODULE$.apply(20), FullName$.MODULE$.apply("ambience.datasets.ObserveAll.run"));
        JsonParams jsonParams = JsonParams$.MODULE$.apply(params);
        return Observable$.MODULE$.from(this.module.fetchDataset(user, datasetName, (Option<ETag>)None$.MODULE$), ObservableLike$.MODULE$.fromTask()).flatMap((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Right) {
                Dataset dataset = (Dataset)((Right)either).value();
                if (dataset instanceof MongoDBDataset) {
                    MongoDBDataset ds = (MongoDBDataset)dataset;
                    return this.runMongo(user, filterFn, ds, jsonParams);
                }
                if (dataset instanceof ETLDataset) {
                    ETLDataset ds = (ETLDataset)dataset;
                    return this.runETL(user, filterFn, ds, jsonParams);
                }
                if (dataset instanceof CachedDataset) {
                    CachedDataset ds = (CachedDataset)dataset;
                    return this.runCached(user, filterFn, ds, jsonParams);
                }
            }
            if (either instanceof Left) {
                return Observable$.MODULE$.empty();
            }
            throw new MatchError((Object)either);
        });
    }

    private Observable<Document> runETL(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, ETLDataset ds, JsonParams params) {
        return Observable$.MODULE$.fromTask(((Observable)filterFn.apply((Object)ds)).toListL()).flatMap((Function1 & Serializable)userFilters -> {
            List<BsonDocument> steps = AllHelper$.MODULE$.buildPipeline(user, ds, (List<BsonDocument>)userFilters, params);
            this.log().info(() -> ObserveAll.runETL$$anonfun$1$$anonfun$1(steps), Line$.MODULE$.apply(33), FullName$.MODULE$.apply("ambience.datasets.ObserveAll.runETL"));
            if (steps.isEmpty()) {
                return this.runETLChain(user, ds, params);
            }
            return this.runETLBatch(user, ds, steps, params);
        });
    }

    private Observable<Document> runETLChain(UserDB.User user, ETLDataset ds, JsonParams params) {
        this.log().info(() -> ObserveAll.runETLChain$$anonfun$1(params), Line$.MODULE$.apply(40), FullName$.MODULE$.apply("ambience.datasets.ObserveAll.runETLChain"));
        long start = System.currentTimeMillis();
        ETLHelper etlHelper = this.module.etlHelper();
        Observable ret = Observable$.MODULE$.fromTask(etlHelper.getChainSet(user, ds.chainset())).flatMap((Function1 & Serializable)chainset -> {
            BoxedUnit[] boxedUnitArray = new BoxedUnit[1];
            this.log().info(() -> ObserveAll.$anonfun$1$$anonfun$1(chainset), Line$.MODULE$.apply(45), FullName$.MODULE$.apply("ambience.datasets.ObserveAll.ret"));
            boxedUnitArray[0] = BoxedUnit.UNIT;
            return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapUnitArray(boxedUnitArray)).flatMap((Function1 & Serializable)x$1 -> {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ChainRunner.ChainIdSpec[]{ChainRunner.ChainIdSpec$.MODULE$.apply(chainset._id(), ds.chain())})).flatMap((Function1 & Serializable)chainSpec -> etlHelper.chainAPI().runChain(user, (ChainRunner.ChainSpec)chainSpec, Observable$.MODULE$.now((Object)Document$.MODULE$.apply(params.json().noSpaces()))).map((Function1 & Serializable)result -> result));
            });
        });
        return ret.doOnComplete(Task$.MODULE$.apply((Function0 & Serializable)() -> {
            this.runETLChain$$anonfun$2(user, ds, start);
            return BoxedUnit.UNIT;
        }));
    }

    private Observable<Document> runETLBatch(UserDB.User user, ETLDataset ds, List<BsonDocument> steps, JsonParams params) {
        this.log().info(() -> ObserveAll.runETLBatch$$anonfun$1(params), Line$.MODULE$.apply(56), FullName$.MODULE$.apply("ambience.datasets.ObserveAll.runETLBatch"));
        ETLHelper etlHelper = this.module.etlHelper();
        return Observable$.MODULE$.from(etlHelper.getChainSet(user, ds.chainset()), ObservableLike$.MODULE$.fromTask()).flatMap((Function1 & Serializable)chainset -> Observable$.MODULE$.fromTask(etlHelper.writeToTemp(user, (ChainRunner.ChainSpec)ChainRunner.ChainIdSpec$.MODULE$.apply(chainset._id(), ds.chain()), params.json())).flatMap((Function1 & Serializable)uuid -> Observable$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MongoDBDataset[]{ds.toMongo(this.module.tempDatabaseName(), (String)uuid)})).flatMap((Function1 & Serializable)mds -> this.runMongo((MongoDBDataset)mds, steps).doOnComplete(etlHelper.dropTemp(user, (String)uuid)).map((Function1 & Serializable)result -> result))));
    }

    private Observable<Document> runMongo(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, MongoDBDataset ds, JsonParams params) {
        this.log().info(() -> ObserveAll.runMongo$$anonfun$1(params), Line$.MODULE$.apply(72), FullName$.MODULE$.apply("ambience.datasets.ObserveAll.runMongo"));
        return Observable$.MODULE$.fromTask(((Observable)filterFn.apply((Object)ds)).toListL()).flatMap((Function1 & Serializable)userFilters -> {
            List<BsonDocument> steps = AllHelper$.MODULE$.buildPipeline(user, ds, (List<BsonDocument>)userFilters, params);
            return this.runMongo(ds, steps);
        });
    }

    private Observable<Document> runMongo(MongoDBDataset ds, List<BsonDocument> steps) {
        Option option = this.module.databaseMap().get((Object)ds.database());
        if (option instanceof Some) {
            MongoDatabase database = (MongoDatabase)((Some)option).value();
            RichMongoCollection cltn = new RichMongoCollection(database.getCollection(ds.collection(), DefaultHelper.DefaultsTo$.MODULE$.default(), ClassTag$.MODULE$.apply(Document.class)));
            return cltn.aggregateO(steps);
        }
        if (None$.MODULE$.equals(option)) {
            this.log().info(() -> ObserveAll.runMongo$$anonfun$3(ds), Line$.MODULE$.apply(85), FullName$.MODULE$.apply("ambience.datasets.ObserveAll.runMongo"));
            return Observable$.MODULE$.empty();
        }
        throw new MatchError((Object)option);
    }

    private Observable<Document> runCached(UserDB.User user, Function1<Dataset, Observable<BsonDocument>> filterFn, CachedDataset ds, JsonParams params) {
        this.log().info(() -> ObserveAll.runCached$$anonfun$1(params), Line$.MODULE$.apply(96), FullName$.MODULE$.apply("ambience.datasets.ObserveAll.runCached"));
        Object[] objectArray = new BsonMagnets.CanBeBsonElement[1];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"$match");
        Object[] objectArray2 = new BsonMagnets.CanBeBsonElement[1];
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"_id");
        objectArray2[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)BsonObjectId$.MODULE$.apply(ds.id())), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        objectArray[0] = BsonMagnets$.MODULE$.tupleToCanBeBsonElement(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray2))), (BsonTransformer)BsonTransformer$.MODULE$.TransformBsonValue());
        BsonDocument bsonDocument = BsonDocument$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray));
        List baseSteps = CachedHelper$.MODULE$.BaseSteps().$colon$colon((Object)bsonDocument);
        List steps = AllHelper$.MODULE$.buildPipeline(user, ds, (List<BsonDocument>)package$.MODULE$.Nil(), params).$colon$colon$colon(baseSteps);
        return Collections$.MODULE$.datasets().aggregateO((Seq)steps);
    }

    private static final Object run$$anonfun$1(String datasetName$1) {
        return "observeAllRecords(" + datasetName$1 + ") starting";
    }

    private static final Object runETL$$anonfun$1$$anonfun$1(List steps$1) {
        return "runETL steps are: " + steps$1;
    }

    private static final Object runETLChain$$anonfun$1(JsonParams params$2) {
        return "runETLChain with params " + params$2.json().noSpaces();
    }

    private static final Object $anonfun$1$$anonfun$1(ETLChainSet chainset$1) {
        return "runETLChain using chainset: " + chainset$1.name();
    }

    private static final Object runETLChain$$anonfun$2$$anonfun$1(UserDB.User user$7, ETLDataset ds$5, long stop$1, long start$2) {
        return "runETLChain(" + user$7.name() + "," + ds$5.chain() + ") observable completed. Elapsed time: " + (stop$1 - start$2) + "ms";
    }

    private final void runETLChain$$anonfun$2(UserDB.User user$6, ETLDataset ds$4, long start$1) {
        long stop = System.currentTimeMillis();
        this.log().info(() -> ObserveAll.runETLChain$$anonfun$2$$anonfun$1(user$6, ds$4, stop, start$1), Line$.MODULE$.apply(51), FullName$.MODULE$.apply("ambience.datasets.ObserveAll.runETLChain"));
    }

    private static final Object runETLBatch$$anonfun$1(JsonParams params$6) {
        return "runETLBatch with params " + params$6.json().noSpaces();
    }

    private static final Object runMongo$$anonfun$1(JsonParams params$8) {
        return "runMongo with params " + params$8.json().noSpaces();
    }

    private static final Object runMongo$$anonfun$3(MongoDBDataset ds$9) {
        return "observeAllRecords(" + ds$9.name() + ") database " + ds$9.database() + " not found";
    }

    private static final Object runCached$$anonfun$1(JsonParams params$10) {
        return "runCached with params " + params$10.json().noSpaces();
    }
}

