/*
 * Decompiled with CFR 0.152.
 */
package ambience.messages;

import ambience.api.Messages;
import ambience.messages.DateLens$;
import ambience.messages.InboxDocumentRoute;
import ambience.messages.MessagesAPI$;
import ambience.messages.MessagesAPI$Module$;
import ambience.messages.MessagesAPI$User$;
import ambience.messages.MessagesModel;
import ambience.messages.MessagesModule;
import ambience.messages.Util$;
import ambience.messages.db.UserDBHelper$;
import ambience.module.UserDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import io.circe.Json;
import java.io.Serializable;
import java.util.UUID;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonString;
import org.mongodb.scala.bson.DefaultHelper;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class MessagesAPI
implements Messages,
LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(MessagesAPI.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final MessagesModule module;

    public static String ModuleIdPrefix() {
        return MessagesAPI$.MODULE$.ModuleIdPrefix();
    }

    public static boolean isModuleId(String string) {
        return MessagesAPI$.MODULE$.isModuleId(string);
    }

    public MessagesAPI(MessagesModule module) {
        this.module = module;
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public Task<Either<String, BoxedUnit>> send(UserDB.User user, Messages.Message message) {
        Set to = (Set)message.to().filterNot((Function1 & Serializable)id -> MessagesAPI$.MODULE$.isModuleId((String)id));
        Set cc = (Set)message.cc().filterNot((Function1 & Serializable)id -> MessagesAPI$.MODULE$.isModuleId((String)id));
        Set bcc = (Set)message.bcc().filterNot((Function1 & Serializable)id -> MessagesAPI$.MODULE$.isModuleId((String)id));
        return this.doSend(MessagesAPI$User$.MODULE$.apply(user), message.copy(to, cc, bcc, message.copy$default$4(), message.copy$default$5(), message.copy$default$6()));
    }

    public Task<Either<String, BoxedUnit>> send(ambience.module.Module module, Messages.Message message) {
        return this.doSend(MessagesAPI$Module$.MODULE$.apply(module), message);
    }

    public Task<Either<String, BoxedUnit>> doSend(Sender sender, Messages.Message message) {
        String id = UUID.randomUUID().toString();
        List attachments = message.attachments().map((Function1 & Serializable)a -> MessagesModel.Attachment$.MODULE$.apply(a.name(), a.bytes(), a.contentType(), Int$.MODULE$.int2long(a.bytes().length)));
        MessagesModel.Message msg = MessagesModel.Message$.MODULE$.apply(id, id, sender.id(), message.to(), message.cc(), message.bcc(), message.subject(), message.body(), attachments, (List)package$.MODULE$.Nil());
        return this.module.sender().send(msg).map((Function1 & Serializable)x$1 -> {
            LogMessage logMessage = x$1;
            if (LogMessage.None$.MODULE$.equals(logMessage)) {
                return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
            }
            if (logMessage != null) {
                LogMessage err = logMessage;
                return package$.MODULE$.Left().apply((Object)err.msg());
            }
            throw new MatchError((Object)logMessage);
        });
    }

    public Task<Object> unreadCount(UserDB.User user) {
        return this.module.inboxDB().unreadCount(user.id()).map((Function1 & Serializable)x$1 -> {
            Either either = x$1;
            if (either instanceof Left) {
                LogMessage msg = (LogMessage)((Left)either).value();
                this.log().error(() -> MessagesAPI.unreadCount$$anonfun$1$$anonfun$1(msg), Line$.MODULE$.apply(58), FullName$.MODULE$.apply("ambience.messages.MessagesAPI.unreadCount"));
                return -1L;
            }
            if (either instanceof Right) {
                long count = BoxesRunTime.unboxToLong((Object)((Right)either).value());
                return count;
            }
            throw new MatchError((Object)either);
        });
    }

    public Task<List<Messages.Summary>> unread(UserDB.User user, int topX) {
        return UserDBHelper$.MODULE$.userInfoMapT().flatMap((Function1 & Serializable)userMap -> this.module.inboxDB().unread(user.id(), topX).flatMap((Function1 & Serializable)x$1 -> {
            LogMessage logMessage;
            Either either = x$1;
            if (either instanceof Left && (logMessage = (LogMessage)((Left)either).value()) != null) {
                LogMessage err = logMessage;
                this.log().error(() -> MessagesAPI.unread$$anonfun$1$$anonfun$1$$anonfun$1(err), Line$.MODULE$.apply(68), FullName$.MODULE$.apply("ambience.messages.MessagesAPI.unread"));
                return Task$.MODULE$.now((Object)package$.MODULE$.Nil());
            }
            if (either instanceof Right) {
                Seq docs = (Seq)((Right)either).value();
                Seq fs = (Seq)docs.map((Function1 & Serializable)doc -> {
                    Tuple2 tuple2;
                    Option opt = doc.get("_id", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$1 -> _$1.getValue()).flatMap((Function1 & Serializable)id -> doc.get("messageId", DefaultHelper.DefaultsTo$.MODULE$.overrideDefault(), ClassTag$.MODULE$.apply(BsonString.class)).map((Function1 & Serializable)_$2 -> _$2.getValue()).map((Function1 & Serializable)msgId -> Tuple2$.MODULE$.apply(id, msgId)));
                    Option option = opt;
                    if (None$.MODULE$.equals(option)) {
                        this.log().error(MessagesAPI::$anonfun$5$$anonfun$1, Line$.MODULE$.apply(78), FullName$.MODULE$.apply("ambience.messages.MessagesAPI.fs"));
                        return Task$.MODULE$.now((Object)None$.MODULE$);
                    }
                    if (option instanceof Some && (tuple2 = (Tuple2)((Some)option).value()) != null) {
                        String id2 = (String)tuple2._1();
                        String msgId = (String)tuple2._2();
                        return this.module.messagesDB().load(msgId).map((Function1 & Serializable)x$1 -> {
                            LogMessage logMessage;
                            Either either = x$1;
                            if (either instanceof Left && (logMessage = (LogMessage)((Left)either).value()) != null) {
                                LogMessage err = logMessage;
                                this.log().error(() -> MessagesAPI.$anonfun$5$$anonfun$2$$anonfun$1(err), Line$.MODULE$.apply(83), FullName$.MODULE$.apply("ambience.messages.MessagesAPI.fs"));
                                return None$.MODULE$;
                            }
                            if (either instanceof Right) {
                                Tuple3 tuple3;
                                Json msgJson = (Json)((Right)either).value();
                                Option opt = Util$.MODULE$.From().getOption((Object)msgJson).flatMap((Function1 & Serializable)from -> Util$.MODULE$.Subject().getOption((Object)msgJson).flatMap((Function1 & Serializable)subject -> DateLens$.MODULE$.created().getOption((Object)msgJson).map((Function1 & Serializable)created -> this.$anonfun$8$$anonfun$1$$anonfun$1((Map)userMap, (String)from, (String)subject, BoxesRunTime.unboxToLong((Object)created)))));
                                Option option = opt;
                                if (None$.MODULE$.equals(option)) {
                                    return None$.MODULE$;
                                }
                                if (option instanceof Some && (tuple3 = (Tuple3)((Some)option).value()) != null) {
                                    String from2 = (String)tuple3._1();
                                    String subject = (String)tuple3._2();
                                    long created = BoxesRunTime.unboxToLong((Object)tuple3._3());
                                    return Some$.MODULE$.apply((Object)Messages.Summary$.MODULE$.apply(from2, subject, created, "messages/index.html?open=" + id2 + "#unread"));
                                }
                                throw new MatchError((Object)option);
                            }
                            throw new MatchError((Object)either);
                        });
                    }
                    throw new MatchError((Object)option);
                });
                return Task$.MODULE$.sequence((Iterable)fs, BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)_$3 -> ((IterableOnceOps)_$3.flatten(Predef$.MODULE$.$conforms())).toList());
            }
            throw new MatchError((Object)either);
        }));
    }

    public String lookupFrom(Map<String, InboxDocumentRoute.UserInfo> userMap, String from) {
        if (from.startsWith(MessagesAPI$.MODULE$.ModuleIdPrefix())) {
            return StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(from), MessagesAPI$.MODULE$.ModuleIdPrefix());
        }
        return (String)userMap.get((Object)from).map((Function1 & Serializable)_$4 -> _$4.name()).getOrElse(MessagesAPI::lookupFrom$$anonfun$2);
    }

    private static final Object unreadCount$$anonfun$1$$anonfun$1(LogMessage msg$1) {
        return "unreadCount failed:" + msg$1;
    }

    private static final Object unread$$anonfun$1$$anonfun$1$$anonfun$1(LogMessage err$1) {
        return "inbox db unread topX failed:" + err$1.msg();
    }

    private static final Object $anonfun$5$$anonfun$1() {
        return "problem reading _id and messageId";
    }

    private static final Object $anonfun$5$$anonfun$2$$anonfun$1(LogMessage err$2) {
        return "message db failed:" + err$2.msg();
    }

    private final /* synthetic */ Tuple3 $anonfun$8$$anonfun$1$$anonfun$1(Map userMap$6, String from$2, String subject$1, long created) {
        return Tuple3$.MODULE$.apply((Object)this.lookupFrom((Map<String, InboxDocumentRoute.UserInfo>)userMap$6, from$2), (Object)subject$1, (Object)BoxesRunTime.boxToLong((long)created));
    }

    private static final String lookupFrom$$anonfun$2() {
        return "";
    }

    public static final class Module
    implements Sender,
    Product,
    Serializable {
        private final ambience.module.Module module;

        public static Module apply(ambience.module.Module module) {
            return MessagesAPI$Module$.MODULE$.apply(module);
        }

        public static Module fromProduct(Product product) {
            return MessagesAPI$Module$.MODULE$.fromProduct(product);
        }

        public static Module unapply(Module module) {
            return MessagesAPI$Module$.MODULE$.unapply(module);
        }

        public Module(ambience.module.Module module) {
            this.module = module;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Module)) return false;
            Module module = (Module)object;
            ambience.module.Module module2 = this.module();
            ambience.module.Module module3 = module.module();
            if (module2 != null) {
                if (!module2.equals(module3)) return false;
                return true;
            }
            if (module3 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Module;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Module";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "module";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public ambience.module.Module module() {
            return this.module;
        }

        @Override
        public String id() {
            return MessagesAPI$.MODULE$.ModuleIdPrefix() + this.module().id();
        }

        public Module copy(ambience.module.Module module) {
            return new Module(module);
        }

        public ambience.module.Module copy$default$1() {
            return this.module();
        }

        public ambience.module.Module _1() {
            return this.module();
        }
    }

    public static interface Sender {
        public String id();
    }

    public static final class User
    implements Sender,
    Product,
    Serializable {
        private final UserDB.User user;

        public static User apply(UserDB.User user) {
            return MessagesAPI$User$.MODULE$.apply(user);
        }

        public static User fromProduct(Product product) {
            return MessagesAPI$User$.MODULE$.fromProduct(product);
        }

        public static User unapply(User user) {
            return MessagesAPI$User$.MODULE$.unapply(user);
        }

        public User(UserDB.User user) {
            this.user = user;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof User)) return false;
            User user = (User)object;
            UserDB.User user2 = this.user();
            UserDB.User user3 = user.user();
            if (user2 != null) {
                if (!user2.equals(user3)) return false;
                return true;
            }
            if (user3 == null) return true;
            return false;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof User;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "User";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "user";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public UserDB.User user() {
            return this.user;
        }

        @Override
        public String id() {
            return this.user().id();
        }

        public User copy(UserDB.User user) {
            return new User(user);
        }

        public UserDB.User copy$default$1() {
            return this.user();
        }

        public UserDB.User _1() {
            return this.user();
        }
    }
}

