/*
 * Decompiled with CFR 0.152.
 */
package ambience.messages;

import ambience.gravity.GravityHelper$;
import ambience.messages.DocRoute;
import ambience.messages.InboxDocumentRoute;
import ambience.messages.MessagesDocumentManager;
import ambience.messages.MessagesModule;
import ambience.messages.Util$;
import ambience.messages.db.UserDBHelper$;
import ambience.messages.store.AttachmentsStore$;
import ambience.module.UserDB;
import com.elixirtech.arch.LogMessage;
import com.elixirtech.gravity.Gravity$;
import com.elixirtech.gravity.GravityRequest;
import com.elixirtech.gravity.GravityResponse;
import com.elixirtech.gravity.GravityResponse$;
import com.elixirtech.gravity.GravityRoute;
import com.elixirtech.gravity.GravityRoute$;
import io.circe.Json;
import io.circe.Json$;
import java.io.Serializable;
import monix.eval.Task;
import monix.eval.Task$;
import org.bson.BsonString;
import org.mongodb.scala.bson.BsonString$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.BuildFrom$;
import scala.collection.Iterable;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.AbstractSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import sourcecode.FullName$;
import sourcecode.Line$;

public class MessagesDocumentRoute
extends DocRoute {
    private final MessagesDocumentManager mgr;
    private final String writeGroup;

    public MessagesDocumentRoute(MessagesModule module, MessagesDocumentManager mgr, String writeGroup) {
        this.mgr = mgr;
        this.writeGroup = writeGroup;
        super(module.mongoDB(), mgr, writeGroup);
    }

    public List<GravityRoute> routes(UserDB.User user) {
        return (List)new .colon.colon((Object)GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "data/all", (Function1 & Serializable)request -> this.getData(user, (GravityRequest)request)), (List)new .colon.colon((Object)GravityRoute$.MODULE$.path(Gravity$.MODULE$.GET(), "data/*", this.getMessage(user)), (List)new .colon.colon((Object)GravityRoute$.MODULE$.path(Gravity$.MODULE$.POST(), "data", (Function1 & Serializable)request -> this.canWrite(user, (Function1 & Serializable)user -> (Function1 & Serializable)request -> this.postData((UserDB.User)user, (GravityRequest)request), (GravityRequest)request)), (List)new .colon.colon((Object)GravityRoute$.MODULE$.pathPrefixOnly(Gravity$.MODULE$.GET(), "data-download", (Function1 & Serializable)request -> this.getDataDownload(user, (GravityRequest)request)), (List)new .colon.colon((Object)GravityRoute$.MODULE$.pathPrefixOnly(Gravity$.MODULE$.POST(), "data-delete", (Function1 & Serializable)request -> this.canDelete(user, (Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> (Function1 & Serializable)request -> this.postDataDelete((UserDB.User)user, (GravityRequest)request), (GravityRequest)request)), (List)new .colon.colon((Object)GravityRoute$.MODULE$.pathPrefixOnly(Gravity$.MODULE$.POST(), "data-undelete", (Function1 & Serializable)request -> this.canDelete(user, (Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> (Function1 & Serializable)request -> this.postDataUndelete((UserDB.User)user, (GravityRequest)request), (GravityRequest)request)), (List)new .colon.colon((Object)GravityRoute$.MODULE$.pathPrefixOnly(Gravity$.MODULE$.POST(), "data-delete-all", (Function1 & Serializable)request -> this.canDelete(user, (Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>>)(Function1 & Serializable)user -> this.deleteAll((UserDB.User)user), (GravityRequest)request)), (List)Nil$.MODULE$)))))));
    }

    public Task<GravityResponse> all(UserDB.User user) {
        return UserDBHelper$.MODULE$.userInfoMapT().flatMap((Function1 & Serializable)userInfo -> this.mgr.get(user).flatMap((Function1 & Serializable)json -> {
            List tasks = ((List)json.asArray().map((Function1 & Serializable)_$1 -> _$1.toList()).getOrElse(MessagesDocumentRoute::$anonfun$2)).map((Function1 & Serializable)_$2 -> this.buildMessageJSON((Json)_$2, (Map<String, InboxDocumentRoute.UserInfo>)userInfo));
            return Task$.MODULE$.sequence((Iterable)tasks, BuildFrom$.MODULE$.buildFromIterableOps()).map((Function1 & Serializable)vs -> GravityResponse$.MODULE$.json(Json$.MODULE$.fromValues((Iterable)vs)));
        }));
    }

    public Function1<GravityRequest, Task<GravityResponse>> getMessage(UserDB.User user) {
        return GravityHelper$.MODULE$.seg1((Function1 & Serializable)msgId -> (Function1 & Serializable)_$3 -> UserDBHelper$.MODULE$.userInfoMapT().flatMap((Function1 & Serializable)userMap -> this.mgr.get(user, msgId.value()).flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Json mJson = (Json)((Some)option).value();
                return this.buildMessageJSON(mJson, (Map<String, InboxDocumentRoute.UserInfo>)userMap).map((Function1 & Serializable)_$4 -> GravityResponse$.MODULE$.json(_$4));
            }
            if (None$.MODULE$.equals(option)) {
                return Gravity$.MODULE$.NotFoundResponseT("Message " + msgId.value() + " not found.");
            }
            throw new MatchError((Object)option);
        })));
    }

    public Task<Json> buildMessageJSON(Json mJson, Map<String, InboxDocumentRoute.UserInfo> userInfo) {
        Seq<Json> to = this.idToUserName(userInfo, (Seq<Json>)((Seq)Util$.MODULE$.TO().getOption((Object)mJson).getOrElse(MessagesDocumentRoute::$anonfun$4)), mJson);
        Seq toNames = (Seq)to.flatMap((Function1 & Serializable)_$5 -> _$5.asString());
        List attachmentIds = ((List)Util$.MODULE$.Attachments().getOption((Object)mJson).map((Function1 & Serializable)_$6 -> _$6.toList()).getOrElse(MessagesDocumentRoute::$anonfun$7)).flatMap((Function1 & Serializable)_$7 -> _$7.asString());
        Task attachmentsTask = attachmentIds.isEmpty() ? Task$.MODULE$.now((Object)package$.MODULE$.Right().apply((Object)Json$.MODULE$.fromValues((Iterable)package$.MODULE$.Nil()))) : this.loadAttachments(mJson, (List<String>)attachmentIds);
        return attachmentsTask.map((Function1 & Serializable)x$1 -> {
            LogMessage logMessage;
            Either either = x$1;
            if (either instanceof Left && (logMessage = (LogMessage)((Left)either).value()) != null) {
                LogMessage err = logMessage;
                this.log().error(() -> MessagesDocumentRoute.buildMessageJSON$$anonfun$1$$anonfun$1(err), Line$.MODULE$.apply(60), FullName$.MODULE$.apply("ambience.messages.MessagesDocumentRoute.buildMessageJSON"));
                return mJson.mapObject((Function1 & Serializable)_$8 -> _$8.add("toNames", Json$.MODULE$.fromValues((Iterable)toNames.map((Function1 & Serializable)_$9 -> Json$.MODULE$.fromString(_$9)))));
            }
            if (either instanceof Right) {
                Json attachJsonList = (Json)((Right)either).value();
                return mJson.mapObject((Function1 & Serializable)_$10 -> _$10.add("toNames", Json$.MODULE$.fromValues((Iterable)toNames.map((Function1 & Serializable)_$11 -> Json$.MODULE$.fromString(_$11)))).add("attachments", attachJsonList));
            }
            throw new MatchError((Object)either);
        });
    }

    public Function1<GravityRequest, Task<GravityResponse>> deleteAll(UserDB.User user) {
        return GravityHelper$.MODULE$.withJsonBody((Function1 & Serializable)json -> (Function1 & Serializable)_$12 -> {
            Vector ids = (Vector)((StrictOptimizedIterableOps)((StrictOptimizedIterableOps)json.asArray().getOrElse(MessagesDocumentRoute::$anonfun$9)).flatMap((Function1 & Serializable)_$13 -> _$13.asString())).map((Function1 & Serializable)_$14 -> BsonString$.MODULE$.apply(_$14));
            return this.mgr.deleteAll(user, (Set<BsonString>)ids.toSet()).map((Function1 & Serializable)msg -> GravityHelper$.MODULE$.toResponse(msg));
        });
    }

    public Task<Either<LogMessage, Json>> loadAttachments(Json json, List<String> uuids) {
        return AttachmentsStore$.MODULE$.load(AttachmentsStore$.MODULE$.getStoreInfo(json), uuids);
    }

    public Task<GravityResponse> canDelete(UserDB.User user, Function1<UserDB.User, Function1<GravityRequest, Task<GravityResponse>>> fn, GravityRequest request) {
        if (user.privileges().contains((Object)this.writeGroup) && user.privileges().contains((Object)"mod-messages-delete")) {
            return (Task)((Function1)fn.apply((Object)user)).apply((Object)request);
        }
        return Gravity$.MODULE$.ForbiddenResponseT();
    }

    private static final List $anonfun$2() {
        return package$.MODULE$.Nil();
    }

    private static final AbstractSeq $anonfun$4() {
        return package$.MODULE$.Nil();
    }

    private static final List $anonfun$7() {
        return package$.MODULE$.Nil();
    }

    private static final Object buildMessageJSON$$anonfun$1$$anonfun$1(LogMessage err$1) {
        return err$1.msg();
    }

    private static final Vector $anonfun$9() {
        return package$.MODULE$.Vector().empty();
    }
}

